/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.cli;

import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextColors;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.Text;
import dev.mosaify.core.cli.CliFunctions;
import dev.mosaify.core.exporter.generic.GenericExporterCsv;
import dev.mosaify.core.exporter.generic.GenericExporterHtml;
import dev.mosaify.core.exporter.generic.GenericExporterJson;
import dev.mosaify.core.exporter.generic.GenericExporterSarif;
import dev.mosaify.core.exporter.generic.GenericReportTableFormat;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueStatus;
import dev.mosaify.core.model.metadata.BasicProjectInfo;
import dev.mosaify.core.model.metadata.BasicProjectInfoImpl;
import dev.mosaify.core.model.metadata.ComponentInfo;
import dev.mosaify.core.model.metadata.ContainerImageInfo;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportExporter;
import dev.mosaify.core.model.sarif.Artifact;
import dev.mosaify.core.model.sarif.ArtifactRoles;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.scanner.ScanTarget;
import dev.mosaify.core.model.scanner.Scanner;
import dev.mosaify.core.model.taxonomy.TargetType;
import dev.mosaify.core.scanner.anchore.grype.ScannerAnchoreGrype;
import dev.mosaify.core.scanner.aquasecurity.trivy.ScannerAquasecurityTrivy;
import dev.mosaify.core.scanner.docker.scout.ScannerDockerScout;
import dev.mosaify.core.scanner.jfrog.xray.ScannerJfrogXray;
import dev.mosaify.core.scanner.snyk.code.ScannerSnykCode;
import dev.mosaify.core.scanner.snyk.container.ScannerSnykContainer;
import dev.mosaify.core.scanner.snyk.oss.ScannerSemgrep;
import dev.mosaify.core.scanner.snyk.oss.ScannerSnykOss;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.Extensions;
import dev.mosaify.core.util.autoparser.AutoParser;
import dev.mosaify.core.util.container.ContainerController;
import dev.mosaify.core.util.container.model.ImageMetadata;
import dev.mosaify.core.util.logging.MemoryLogger;
import dev.mosaify.core.util.normalization.CompareUtils;
import dev.mosaify.core.util.normalization.NormalizationUtils;
import dev.mosaify.core.util.platform.PlatformUtils;
import dev.mosaify.core.util.platform.ProcessRunResult;
import dev.mosaify.core.util.storage.SarifStorage;
import dev.mosaify.core.util.storage.model.ResolvedScanRecord;
import dev.mosaify.guesswork.Environment;
import dev.mosaify.guesswork.SnykOssRunner;
import io.github.oshai.kotlinlogging.KLogger;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002lmB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010&\u001a\r\u0012\u0004\u0012\u00020'0!\u00a2\u0006\u0002\b(2\u0015\u0010)\u001a\u0011\u0012\u0004\u0012\u00020'0!j\u0002`*\u00a2\u0006\u0002\b(2\u0006\u0010+\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010!H\u0002J7\u0010.\u001a\r\u0012\u0004\u0012\u00020'0!\u00a2\u0006\u0002\b(2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000!2\u0006\u0010+\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010!J)\u00101\u001a\u0011\u0012\u0004\u0012\u00020'0!j\u0002`*\u00a2\u0006\u0002\b(2\u0006\u00102\u001a\u0002032\n\b\u0002\u00104\u001a\u0004\u0018\u000105J\u001d\u00106\u001a\u0011\u0012\u0004\u0012\u00020'0!j\u0002`*\u00a2\u0006\u0002\b(2\u0006\u00107\u001a\u000200Jc\u0010.\u001a9\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020'0!\u00a2\u0006\u0002\b(\u0012$\u0012\"\u0012\u0004\u0012\u000209\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020'0!j\u0007`*\u00a2\u0006\u0002\b(\u00a2\u0006\u0002\b(0\u001f082\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090!2\u0006\u0010+\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010!J\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bJ\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020<J\u0016\u0010?\u001a\u00020\t2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bJ \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001f2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020 0!J,\u0010B\u001a\u0002HC\"\u0004\b\u0000\u0010C2\b\b\u0002\u0010D\u001a\u00020\u000b2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HC0FH\u0082\b\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\tJ\u000e\u0010K\u001a\u00020I2\u0006\u0010J\u001a\u00020\tJ\u0018\u0010L\u001a\u00020M2\u0006\u0010J\u001a\u00020\t2\b\b\u0002\u0010D\u001a\u00020\u000bJ\u000e\u0010N\u001a\u00020O2\u0006\u0010J\u001a\u00020\tJ\u000e\u0010P\u001a\u00020M2\u0006\u00102\u001a\u000203J\u0014\u0010P\u001a\u00020M2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002030!J\u000e\u0010R\u001a\u00020O2\u0006\u0010S\u001a\u000209JT\u0010T\u001a\b\u0012\u0004\u0012\u0002030!*\u00020 2\u0006\u0010U\u001a\u00020V2\u0014\b\u0002\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u001f2\b\b\u0002\u0010X\u001a\u00020I2\b\b\u0002\u0010Y\u001a\u00020I2\b\b\u0002\u0010D\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010ZJ/\u0010[\u001a\u00020M2\u0015\u0010)\u001a\u0011\u0012\u0004\u0012\u00020'0!j\u0002`*\u00a2\u0006\u0002\b(2\u0006\u0010\\\u001a\u00020\t2\b\b\u0002\u0010]\u001a\u00020^JL\u0010_\u001a,\u0012\u0004\u0012\u00020\t\u0012\"\u0012 \u0012\u0004\u0012\u00020a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0b0`0\u001f2\f\u0010c\u001a\b\u0012\u0004\u0012\u0002000!2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002000!J0\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t080b2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002000!2\u0006\u0010g\u001a\u00020\tH\u0002J\u0010\u0010h\u001a\u00020\t2\u0006\u00107\u001a\u000200H\u0002J\n\u0010i\u001a\u00020\t*\u00020jJ%\u0010k\u001a\u00020M2\u0015\u0010)\u001a\u0011\u0012\u0004\u0012\u00020'0!j\u0002`*\u00a2\u0006\u0002\b(2\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR-\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0!0\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u0006n"}, d2={"Ldev/mosaify/core/cli/CliFunctions;", "", "<init>", "()V", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "getTerminal$mosaify_cli", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "TABLE_BLANK", "", "MAX_RETRIES", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger$mosaify_cli", "()Lio/github/oshai/kotlinlogging/KLogger;", "setLogger$mosaify_cli", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "sarifStorage", "Ldev/mosaify/core/util/storage/SarifStorage;", "getSarifStorage$mosaify_cli", "()Ldev/mosaify/core/util/storage/SarifStorage;", "compareUtils", "Ldev/mosaify/core/util/normalization/CompareUtils;", "getCompareUtils", "()Ldev/mosaify/core/util/normalization/CompareUtils;", "normalizationUtils", "Ldev/mosaify/core/util/normalization/NormalizationUtils;", "getNormalizationUtils", "()Ldev/mosaify/core/util/normalization/NormalizationUtils;", "availableScanners", "", "Ldev/mosaify/core/model/scanner/Scanner;", "", "getAvailableScanners", "()Ljava/util/Map;", "availableScanners$delegate", "Lkotlin/Lazy;", "normalizeReport", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "report", "Ldev/mosaify/core/model/generic/GenericReport;", "normalizeBy", "Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "preferredScanners", "autoParseAndNormalize", "records", "Ldev/mosaify/core/util/storage/model/ResolvedScanRecord;", "autoParseRun", "run", "Ldev/mosaify/core/model/sarif/Run;", "runExtraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "autoParseRecord", "record", "Lkotlin/Pair;", "Ljava/io/File;", "paths", "calculateNormalizationRate", "", "originalSize", "normalizedSize", "normalizationPercentString", "collectScannerParameters", "scanners", "runRetrying", "R", "retries", "block", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "pullImageDockerApi", "", "image", "pullImage", "pullImageRetrying", "", "resolveImageInfo", "Ldev/mosaify/core/model/metadata/ComponentInfo;", "printAnyErrors", "runs", "resolveCodeInfo", "directory", "scanRetrying", "target", "Ldev/mosaify/core/model/scanner/ScanTarget;", "parameters", "useProcess", "debug", "(Ldev/mosaify/core/model/scanner/Scanner;Ldev/mosaify/core/model/scanner/ScanTarget;Ljava/util/Map;ZZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveReport", "path", "format", "Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "compareComponents", "Lkotlin/Triple;", "Ldev/mosaify/core/model/generic/IssueStatus;", "", "project1data", "project2data", "extractComponentVersions", "components", "name", "getDisplayVersion", "display", "Ldev/mosaify/core/model/taxonomy/TargetType;", "displayReport", "ReportFormat", "NormalizeBy", "mosaify-cli"})
@SourceDebugExtension(value={"SMAP\nCliFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliFunctions.kt\ndev/mosaify/core/cli/CliFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,668:1\n237#1,6:698\n243#1,8:705\n1374#2:669\n1460#2,5:670\n1374#2:675\n1460#2,5:676\n1285#2,2:681\n1299#2,4:683\n774#2:695\n865#2,2:696\n827#2:713\n855#2,2:714\n1563#2:716\n1634#2,3:717\n774#2:720\n865#2,2:721\n774#2:723\n865#2,2:724\n1869#2,2:726\n774#2:728\n865#2,2:729\n1869#2:731\n774#2:732\n865#2,2:733\n774#2:735\n865#2,2:736\n1869#2,2:738\n1870#2:740\n1374#2:741\n1460#2,2:742\n1563#2:744\n1634#2,3:745\n1462#2,3:748\n774#2:751\n865#2,2:752\n1563#2:754\n1634#2,3:755\n1374#2:758\n1460#2,2:759\n1563#2:761\n1634#2,3:762\n1462#2,3:765\n1563#2:768\n1634#2,3:769\n1563#2:772\n1634#2,3:773\n1669#2,8:776\n1285#2,2:784\n1299#2,2:786\n1563#2:788\n1634#2,3:789\n1563#2:792\n1634#2,3:793\n1563#2:796\n1634#2,3:797\n1563#2:800\n1634#2,3:801\n1563#2:804\n1634#2,3:805\n1302#2:808\n1669#2,8:809\n774#2:817\n865#2,2:818\n1563#2:820\n1634#2,3:821\n1056#2:824\n1617#2,9:825\n1869#2:834\n1870#2:836\n1626#2:837\n827#2:838\n855#2,2:839\n1669#2,8:841\n2746#2,3:849\n1617#2,9:852\n1869#2:861\n1870#2:863\n1626#2:864\n774#2:865\n865#2,2:866\n774#2:868\n865#2,2:869\n1869#2,2:871\n785#2:873\n796#2:874\n1878#2,2:875\n797#2,2:877\n1880#2:879\n799#2:880\n1563#2:881\n1634#2,3:882\n1563#2:885\n1634#2,3:886\n785#2:889\n796#2:890\n1878#2,2:891\n797#2,2:893\n1880#2:895\n799#2:896\n1563#2:897\n1634#2,3:898\n561#3:687\n546#3,6:688\n1#4:694\n1#4:704\n1#4:835\n1#4:862\n*S KotlinDebug\n*F\n+ 1 CliFunctions.kt\ndev/mosaify/core/cli/CliFunctions\n*L\n257#1:698,6\n257#1:705,8\n158#1:669\n158#1:670,5\n211#1:675\n211#1:676,5\n215#1:681,2\n215#1:683,4\n230#1:695\n230#1:696,2\n313#1:713\n313#1:714,2\n314#1:716\n314#1:717,3\n343#1:720\n343#1:721,2\n344#1:723\n344#1:724,2\n345#1:726,2\n355#1:728\n355#1:729,2\n355#1:731\n361#1:732\n361#1:733,2\n362#1:735\n362#1:736,2\n363#1:738,2\n355#1:740\n388#1:741\n388#1:742,2\n389#1:744\n389#1:745,3\n388#1:748,3\n407#1:751\n407#1:752,2\n408#1:754\n408#1:755,3\n435#1:758\n435#1:759,2\n436#1:761\n436#1:762,3\n435#1:765,3\n526#1:768\n526#1:769,3\n527#1:772\n527#1:773,3\n528#1:776,8\n530#1:784,2\n530#1:786,2\n540#1:788\n540#1:789,3\n541#1:792\n541#1:793,3\n541#1:796\n541#1:797,3\n548#1:800\n548#1:801,3\n549#1:804\n549#1:805,3\n530#1:808\n557#1:809,8\n563#1:817\n563#1:818,2\n564#1:820\n564#1:821,3\n570#1:824\n575#1:825,9\n575#1:834\n575#1:836\n575#1:837\n576#1:838\n576#1:839,2\n582#1:841,8\n606#1:849,3\n489#1:852,9\n489#1:861\n489#1:863\n489#1:864\n490#1:865\n490#1:866,2\n491#1:868\n491#1:869,2\n492#1:871,2\n640#1:873\n640#1:874\n640#1:875,2\n640#1:877,2\n640#1:879\n640#1:880\n641#1:881\n641#1:882,3\n645#1:885\n645#1:886,3\n648#1:889\n648#1:890\n648#1:891,2\n648#1:893,2\n648#1:895\n648#1:896\n649#1:897\n649#1:898,3\n216#1:687\n216#1:688,6\n257#1:704\n575#1:835\n489#1:862\n*E\n"})
public final class CliFunctions {
    @NotNull
    public static final CliFunctions INSTANCE = new CliFunctions();
    @NotNull
    private static final Terminal terminal = new Terminal(null, null, null, null, null, null, null, 0, null, null, 1023, null);
    @NotNull
    public static final String TABLE_BLANK = "--";
    public static final int MAX_RETRIES = 5;
    @NotNull
    private static KLogger logger = (KLogger)new MemoryLogger(null, 1, null);
    @NotNull
    private static final SarifStorage sarifStorage = new SarifStorage(null, null, 0, logger, 7, null);
    @NotNull
    private static final CompareUtils compareUtils = new CompareUtils(logger);
    @NotNull
    private static final NormalizationUtils normalizationUtils = new NormalizationUtils(logger);
    @NotNull
    private static final Lazy availableScanners$delegate = LazyKt.lazy(CliFunctions::availableScanners_delegate$lambda$0);

    private CliFunctions() {
    }

    @NotNull
    public final Terminal getTerminal$mosaify_cli() {
        return terminal;
    }

    @NotNull
    public final KLogger getLogger$mosaify_cli() {
        return logger;
    }

    public final void setLogger$mosaify_cli(@NotNull KLogger kLogger) {
        Intrinsics.checkNotNullParameter((Object)kLogger, (String)"<set-?>");
        logger = kLogger;
    }

    @NotNull
    public final SarifStorage getSarifStorage$mosaify_cli() {
        return sarifStorage;
    }

    @NotNull
    public final CompareUtils getCompareUtils() {
        return compareUtils;
    }

    @NotNull
    public final NormalizationUtils getNormalizationUtils() {
        return normalizationUtils;
    }

    @NotNull
    public final Map<Scanner, Collection<String>> getAvailableScanners() {
        Lazy lazy = availableScanners$delegate;
        return (Map)lazy.getValue();
    }

    private final Collection<Issue> normalizeReport(Collection<Issue> report, NormalizeBy normalizeBy, Collection<String> preferredScanners) {
        return switch (WhenMappings.$EnumSwitchMapping$0[normalizeBy.ordinal()]) {
            case 1 -> report;
            case 2 -> Extensions.INSTANCE.combined(normalizationUtils.normalizeByIdentifier(report, preferredScanners));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Issue> autoParseAndNormalize(@NotNull Collection<ResolvedScanRecord> records, @NotNull NormalizeBy normalizeBy, @Nullable Collection<String> preferredScanners) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)((Object)normalizeBy), (String)"normalizeBy");
        Iterable iterable = records;
        CliFunctions cliFunctions = this;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.autoParseRecord(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return cliFunctions.normalizeReport((List)destination$iv$iv, normalizeBy, preferredScanners);
    }

    @NotNull
    public final Collection<Issue> autoParseRun(@NotNull Run run2, @Nullable RunExtraInfo runExtraInfo) {
        Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
        return (Collection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Issue>>, Object>(run2, runExtraInfo, null){
            int label;
            final /* synthetic */ Run $run;
            final /* synthetic */ RunExtraInfo $runExtraInfo;
            {
                this.$run = $run;
                this.$runExtraInfo = $runExtraInfo;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$flatMapTo$iv$iv;
                        void $this$flatMap$iv;
                        void $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Set set = this.$run.getArtifacts();
                        Intrinsics.checkNotNull((Object)set);
                        Iterable $this$filter$iv = set;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo22 = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            Artifact it = (Artifact)element$iv$iv;
                            boolean bl = false;
                            Set set2 = it.getRoles();
                            Intrinsics.checkNotNull((Object)set2);
                            if (!set2.contains(ArtifactRoles.RESULT_FILE)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        RunExtraInfo runExtraInfo = this.$runExtraInfo;
                        iterable = this.$run;
                        boolean $i$f$flatMap = false;
                        void $i$f$filterTo22 = $this$flatMap$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            Artifact it = (Artifact)element$iv$iv;
                            boolean bl = false;
                            MemoryLogger memoryLogger = new MemoryLogger(null, 1, null);
                            AutoParser autoparser = new AutoParser((KLogger)memoryLogger);
                            RunExtraInfo runExtraInfo2 = runExtraInfo;
                            if (runExtraInfo2 == null) {
                                runExtraInfo2 = RunExtraInfo.Companion.fromPropertyBag(iterable.getProperties());
                            }
                            RunExtraInfo extraInfo = runExtraInfo2;
                            Iterable list$iv$iv = autoparser.autoParseToGeneric(dev.mosaify.core.util.compress.Extensions.INSTANCE.decompress(it), extraInfo);
                            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                        }
                        return (List)destination$iv$iv2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<Issue>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ Collection autoParseRun$default(CliFunctions cliFunctions, Run run2, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return cliFunctions.autoParseRun(run2, runExtraInfo);
    }

    @NotNull
    public final Collection<Issue> autoParseRecord(@NotNull ResolvedScanRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return (Collection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Issue>>, Object>(record, null){
            int label;
            final /* synthetic */ ResolvedScanRecord $record;
            {
                this.$record = $record;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        String string = this.$record.getLogInfo().getName();
                        String string2 = this.$record.getLogInfo().getVersion();
                        if (string2 == null) {
                            string2 = Extensions.INSTANCE.display(this.$record.getLogInfo().getTimestamp());
                        }
                        ComponentInfo projectInfo = ComponentInfo.Companion.create$default((ComponentInfo.Companion)ComponentInfo.Companion, (String)string, (String)string2, null, (int)4, null);
                        Iterable $this$map$iv = CliFunctions.autoParseRun$default(CliFunctions.INSTANCE, this.$record.getRun(), null, 2, null);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Issue issue = (Issue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Set set = it.getProjects();
                            if (set == null) {
                                set = SetsKt.setOf((Object)projectInfo);
                            }
                            collection.add(Issue.copy$default((Issue)it, null, null, null, null, null, null, null, null, (Set)set, null, null, null, null, null, null, (int)32511, null));
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<Issue>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final Pair<Collection<Issue>, Map<File, Collection<Issue>>> autoParseAndNormalize(@NotNull Collection<? extends File> paths, @NotNull NormalizeBy normalizeBy, @Nullable Collection<String> preferredScanners) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)((Object)normalizeBy), (String)"normalizeBy");
        return (Pair)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends Collection<? extends Issue>, ? extends Map<File, ? extends Collection<? extends Issue>>>>, Object>(paths, normalizeBy, preferredScanners, null){
            int label;
            final /* synthetic */ Collection<File> $paths;
            final /* synthetic */ NormalizeBy $normalizeBy;
            final /* synthetic */ Collection<String> $preferredScanners;
            {
                this.$paths = $paths;
                this.$normalizeBy = $normalizeBy;
                this.$preferredScanners = $preferredScanners;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$associateWithTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable $this$associateWith$iv = this.$paths;
                        boolean $i$f$associateWith = false;
                        LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                        Iterable iterable = $this$associateWith$iv;
                        Map destination$iv$iv = result$iv;
                        boolean $i$f$associateWithTo = false;
                        for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                            void it;
                            File file = (File)element$iv$iv;
                            T t = element$iv$iv;
                            Map map = destination$iv$iv;
                            boolean bl = false;
                            MemoryLogger memoryLogger = new MemoryLogger(null, 1, null);
                            AutoParser autoparser = new AutoParser((KLogger)memoryLogger);
                            CliFunctions.INSTANCE.getLogger$mosaify_cli().info(() -> autoParseAndNormalize.2.invokeSuspend$lambda$0$0((File)it));
                            Collection collection = AutoParser.autoParseToGeneric$default((AutoParser)autoparser, (byte[])FilesKt.readBytes((File)it), null, (int)2, null);
                            map.put(t, collection);
                        }
                        Map originalReports = destination$iv$iv;
                        return TuplesKt.to((Object)CliFunctions.access$normalizeReport(CliFunctions.INSTANCE, CollectionsKt.flatten((Iterable)originalReports.values()), this.$normalizeBy, this.$preferredScanners), (Object)originalReports);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends Collection<Issue>, ? extends Map<File, ? extends Collection<Issue>>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0$0(File $it) {
                return "Parsing: '" + $it + "'";
            }
        }), (int)1, null);
    }

    public final double calculateNormalizationRate(int originalSize, int normalizedSize) {
        return this.calculateNormalizationRate((double)originalSize, (double)normalizedSize);
    }

    public final double calculateNormalizationRate(double originalSize, double normalizedSize) {
        return 100.0 - normalizedSize / originalSize * 100.0;
    }

    @NotNull
    public final String normalizationPercentString(int originalSize, int normalizedSize) {
        String string = "%.2f%%";
        Object[] objectArray = new Object[]{this.calculateNormalizationRate(originalSize, normalizedSize)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> collectScannerParameters(@NotNull Collection<? extends Scanner> scanners) {
        void $this$filterTo$iv$iv;
        String it;
        Map parameterValues;
        void $this$filterNotTo$iv$iv;
        Map $this$filterNot$iv;
        void $this$associateWithTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scanners, (String)"scanners");
        Iterable $this$flatMap$iv = scanners;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Scanner it2 = (Scanner)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getParameters().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List requiredList = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Object $this$associateWith$iv = requiredList;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $i$f$flatMapTo22 = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo22 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it3;
            String string = (String)element$iv$iv;
            Object e = element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            String string2 = System.getenv((String)it3);
            map.put(e, string2);
        }
        $this$associateWith$iv = destination$iv$iv2;
        boolean $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator $i$f$associateWithTo22 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while ($i$f$associateWithTo22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it4 = element$iv$iv = $i$f$associateWithTo22.next();
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it4.getValue();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$collectScannerParameters_u24lambda_u243 = $this$filterNot$iv = (parameterValues = MapsKt.toMutableMap((Map)destination$iv$iv3));
        boolean bl = false;
        if (!$this$collectScannerParameters_u24lambda_u243.containsKey("SNYK_TOKEN")) {
            String string = Environment.INSTANCE.getSnykToken();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$collectScannerParameters_u24lambda_u243.put("SNYK_TOKEN", it);
            }
        }
        Map $this$collectScannerParameters_u24lambda_u244 = $this$filterNot$iv = parameterValues;
        boolean $i$a$-apply-CliFunctions$collectScannerParameters$32 = false;
        if (!$this$collectScannerParameters_u24lambda_u244.containsKey("SEMGREP_APP_TOKEN") && (it = PlatformUtils.INSTANCE.getEnv("SEMGREP_APP_TOKEN")) != null) {
            String it5 = it;
            boolean bl3 = false;
            $this$collectScannerParameters_u24lambda_u244.put("SEMGREP_APP_TOKEN", it5);
        }
        Iterable $this$filter$iv = requiredList;
        boolean $i$f$filter = false;
        Iterable $i$a$-apply-CliFunctions$collectScannerParameters$32 = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            String it6 = (String)((Object)element$iv$iv);
            boolean bl4 = false;
            if (!(!parameterValues.keySet().contains(it6))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List it7 = (List)destination$iv$iv3;
        boolean bl5 = false;
        if (!((Collection)it7).isEmpty()) {
            logger.warn(() -> CliFunctions.collectScannerParameters$lambda$6$0(it7));
        }
        return parameterValues;
    }

    private final <R> R runRetrying(int retries, Function0<? extends R> block) {
        boolean $i$f$runRetrying = false;
        Ref.IntRef retriesLeft = new Ref.IntRef();
        retriesLeft.element = retries;
        while (true) {
            Throwable throwable;
            Object $this$runRetrying_u24lambda_u240;
            int n = retriesLeft.element;
            retriesLeft.element = n + -1;
            if (n <= 0) break;
            Object object = this;
            try {
                $this$runRetrying_u24lambda_u240 = object;
                boolean bl = false;
                $this$runRetrying_u24lambda_u240 = Result.constructor-impl((Object)block.invoke());
            }
            catch (Throwable bl) {
                $this$runRetrying_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$runRetrying_u24lambda_u240;
            if (Result.isSuccess-impl((Object)object)) {
                Object it = object;
                boolean bl = false;
                return (R)it;
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            Throwable it = throwable;
            boolean bl = false;
            if (retriesLeft.element <= 0) {
                throw it;
            }
            INSTANCE.getLogger$mosaify_cli().error(it, (Function0)new Function0<Object>(retriesLeft){
                final /* synthetic */ Ref.IntRef $retriesLeft;
                {
                    this.$retriesLeft = $retriesLeft;
                }

                public final Object invoke() {
                    return "Error. Retries left: " + this.$retriesLeft.element;
                }
            });
        }
        throw new Error("Retry function error. Unexpected scenario");
    }

    static /* synthetic */ Object runRetrying$default(CliFunctions $this, int retries, Function0 block, int n, Object object) {
        if ((n & 1) != 0) {
            retries = 5;
        }
        boolean $i$f$runRetrying = false;
        Ref.IntRef retriesLeft = new Ref.IntRef();
        retriesLeft.element = retries;
        while (true) {
            Throwable throwable;
            Object $this$runRetrying_u24lambda_u240;
            int n2 = retriesLeft.element;
            retriesLeft.element = n2 + -1;
            if (n2 <= 0) break;
            Object object2 = $this;
            try {
                $this$runRetrying_u24lambda_u240 = object2;
                boolean bl = false;
                $this$runRetrying_u24lambda_u240 = Result.constructor-impl((Object)block.invoke());
            }
            catch (Throwable bl) {
                $this$runRetrying_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$runRetrying_u24lambda_u240;
            if (Result.isSuccess-impl((Object)object2)) {
                Object it = object2;
                boolean bl = false;
                return it;
            }
            if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
            Throwable it = throwable;
            boolean bl = false;
            if (retriesLeft.element <= 0) {
                throw it;
            }
            INSTANCE.getLogger$mosaify_cli().error(it, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
        throw new Error("Retry function error. Unexpected scenario");
    }

    public final boolean pullImageDockerApi(@NotNull String image) {
        Object object;
        block8: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            object = this;
            try {
                Object object3;
                block7: {
                    CliFunctions $this$pullImageDockerApi_u24lambda_u240 = object;
                    boolean bl = false;
                    CliFunctions $this$iv = $this$pullImageDockerApi_u24lambda_u240;
                    int retries$iv = 5;
                    boolean $i$f$runRetrying = false;
                    Ref.IntRef retriesLeft$iv = new Ref.IntRef();
                    retriesLeft$iv.element = retries$iv;
                    while (true) {
                        Object $this$runRetrying_u24lambda_u240$iv;
                        int n = retriesLeft$iv.element;
                        retriesLeft$iv.element = n + -1;
                        if (n <= 0) break;
                        object3 = $this$iv;
                        try {
                            $this$runRetrying_u24lambda_u240$iv = object3;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ContainerController.INSTANCE.pullImage(image);
                            $this$runRetrying_u24lambda_u240$iv = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable bl2) {
                            $this$runRetrying_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                        }
                        object3 = $this$runRetrying_u24lambda_u240$iv;
                        if (!Result.isSuccess-impl((Object)object3)) {
                            Throwable throwable;
                            if (Result.exceptionOrNull-impl((Object)object3) == null) continue;
                            Throwable it$iv = throwable;
                            boolean bl4 = false;
                            if (retriesLeft$iv.element <= 0) {
                                throw it$iv;
                            }
                            INSTANCE.getLogger$mosaify_cli().error(it$iv, (Function0)new /* invalid duplicate definition of identical inner class */);
                            continue;
                        }
                        break block7;
                        break;
                    }
                    throw new Error("Retry function error. Unexpected scenario");
                }
                Object it$iv = object3;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block8;
            Object it = object2 = throwable;
            boolean bl = false;
            logger.error((Throwable)it, () -> CliFunctions.pullImageDockerApi$lambda$1$0(image));
        }
        return Result.isSuccess-impl((Object)object);
    }

    public final boolean pullImage(@NotNull String image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Object[] objectArray = new String[]{"docker", "pull", image};
        ProcessRunResult result = PlatformUtils.executeProcess$default((PlatformUtils)PlatformUtils.INSTANCE, (Collection)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (result.getExitCode() != 0) {
            logger.error(() -> CliFunctions.pullImage$lambda$0(image, result));
        }
        return result.getExitCode() == 0;
    }

    public final void pullImageRetrying(@NotNull String image, int retries) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Ref.IntRef retryCount = new Ref.IntRef();
        retryCount.element = retries;
        while (true) {
            int n = retryCount.element;
            retryCount.element = n + -1;
            if (n <= 0) break;
            if (this.pullImage(image)) {
                return;
            }
            logger.error(() -> CliFunctions.pullImageRetrying$lambda$0(retryCount));
        }
        throw new Error("Failed to pull image " + image);
    }

    public static /* synthetic */ void pullImageRetrying$default(CliFunctions cliFunctions, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        cliFunctions.pullImageRetrying(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ComponentInfo resolveImageInfo(@NotNull String image) {
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        String it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ContainerImageInfo parsedImageName = CommonUtils.INSTANCE.parseContainerImageString(image);
        ImageMetadata imageMetadata = ContainerController.INSTANCE.inspectImage(image);
        if (imageMetadata == null) {
            throw new IllegalStateException("Image '" + image + "' must be successfully pulled into the container daemon cache before it can be resolved");
        }
        ImageMetadata imageMetadata2 = imageMetadata;
        Object object = new Collection[]{imageMetadata2.getRepoDigests(), parsedImageName.namesFromDigests(), parsedImageName.namesFromTags(), imageMetadata2.getRepoTags()};
        object = CollectionsKt.flatten((Iterable)SetsKt.setOfNotNull((Object[])object));
        boolean $i$f$filterNot = false;
        void var7_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.endsWith$default((String)it, (String)":latest", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ContainerImageInfo parsedImageString = CommonUtils.INSTANCE.parseContainerImageString(it);
            boolean bl2 = false;
            String string = parsedImageString.getImage();
            Object object2 = parsedImageString.getTags();
            if (object2 == null || (object2 = (String)CollectionsKt.firstOrNull((Iterable)((Iterable)object2))) == null) {
                Set set = parsedImageString.getDigests();
                object2 = set != null ? (String)CollectionsKt.firstOrNull((Iterable)set) : null;
            }
            collection.add(BasicProjectInfo.Companion.create(string, (String)object2));
        }
        $this$map$iv = (List)destination$iv$iv;
        if ($this$map$iv.isEmpty()) {
            boolean bl = false;
            throw new Error("Unexpected: no versions of the image string available after normalization of '" + image + "'");
        }
        Set aliases = CollectionsKt.toSet((Iterable)$this$map$iv);
        BasicProjectInfoImpl bestId = (BasicProjectInfoImpl)CollectionsKt.first((Iterable)aliases);
        logger.info(() -> CliFunctions.resolveImageInfo$lambda$3(image, bestId));
        String string = bestId.getVersion();
        if (!(string != null ? StringsKt.startsWith$default((String)string, (String)"sha256", (boolean)false, (int)2, null) : false)) {
            logger.warn(() -> CliFunctions.resolveImageInfo$lambda$4(image));
        }
        return ComponentInfo.Companion.create(bestId.getName(), bestId.getVersion(), aliases);
    }

    /*
     * WARNING - void declaration
     */
    public final void printAnyErrors(@NotNull Run run2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
            if (!CommonUtils.INSTANCE.hasErrors(run2)) break block5;
            RunExtraInfo runExtraInfo = RunExtraInfo.Companion.fromPropertyBag(run2.getProperties());
            if (runExtraInfo != null) {
                void $this$printAnyErrors_u24lambda_u240_u240;
                StringBuilder stringBuilder;
                RunExtraInfo runExtraInfo2 = runExtraInfo;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                Terminal terminal = CliFunctions.terminal;
                boolean bl2 = false;
                Set set = $this$printAnyErrors_u24lambda_u240_u240;
                ScanTarget scanTarget = runExtraInfo2.getTarget();
                ((StringBuilder)((Object)set)).append(TextColors.red.invoke("Scanner '" + runExtraInfo2.getScanner() + "' error running against target '" + (scanTarget != null ? scanTarget.getTarget() : null) + "'")).append('\n');
                set = run2.getArtifacts();
                if (set != null) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv2;
                    Iterable iterable = set;
                    boolean $i$f$filter22 = false;
                    void var11_12 = $this$filter$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        Artifact it = (Artifact)element$iv$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getSourceLanguage(), (Object)"PLAINTEXT")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Artifact it = (Artifact)element$iv$iv;
                        boolean bl4 = false;
                        Set set2 = it.getRoles();
                        boolean bl5 = set2 != null ? set2.contains(ArtifactRoles.STANDARD_STREAM) : false;
                        if (!bl5) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Artifact it = (Artifact)element$iv;
                        boolean bl6 = false;
                        $this$printAnyErrors_u24lambda_u240_u240.append("Output: " + dev.mosaify.core.util.compress.Extensions.INSTANCE.decompressText(it)).append('\n');
                    }
                }
                Terminal.println$default((Terminal)terminal, (Object)stringBuilder.toString(), null, null, null, null, (boolean)false, (int)62, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void printAnyErrors(@NotNull Collection<Run> runs) {
        Intrinsics.checkNotNullParameter(runs, (String)"runs");
        if (CommonUtils.INSTANCE.hasErrors(runs)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = runs;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Run it = (Run)element$iv$iv;
                boolean bl = false;
                if (!CommonUtils.INSTANCE.hasErrors(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Run run2 = (Run)element$iv;
                boolean bl = false;
                if (RunExtraInfo.Companion.fromPropertyBag(run2.getProperties()) != null) {
                    RunExtraInfo runExtraInfo;
                    void $this$printAnyErrors_u24lambda_u242_u240_u240;
                    StringBuilder stringBuilder;
                    boolean bl2 = false;
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    Terminal terminal = CliFunctions.terminal;
                    boolean bl3 = false;
                    Set set = $this$printAnyErrors_u24lambda_u242_u240_u240;
                    ScanTarget scanTarget = runExtraInfo.getTarget();
                    ((StringBuilder)((Object)set)).append(TextColors.red.invoke("Scanner '" + runExtraInfo.getScanner() + "' error running against target '" + (scanTarget != null ? scanTarget.getTarget() : null) + "'")).append('\n');
                    set = run2.getArtifacts();
                    if (set != null) {
                        void $this$forEach$iv2;
                        void $this$filterTo$iv$iv2;
                        Iterable $this$filter$iv2;
                        Object element$iv$iv2;
                        void $this$filterTo$iv$iv3;
                        void $this$filter$iv3;
                        Iterable iterable2 = set;
                        boolean $i$f$filter22 = false;
                        void var17_23 = $this$filter$iv3;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                            Artifact it = (Artifact)element$iv$iv2;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getSourceLanguage(), (Object)"PLAINTEXT")) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        Iterable $i$f$filter22 = (List)destination$iv$iv2;
                        boolean $i$f$filter3 = false;
                        destination$iv$iv2 = $this$filter$iv2;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterTo3 = false;
                        element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
                        while (element$iv$iv2.hasNext()) {
                            Object element$iv$iv3 = element$iv$iv2.next();
                            Artifact it = (Artifact)element$iv$iv3;
                            boolean bl5 = false;
                            Set set2 = it.getRoles();
                            boolean bl6 = set2 != null ? set2.contains(ArtifactRoles.STANDARD_STREAM) : false;
                            if (!bl6) continue;
                            destination$iv$iv3.add(element$iv$iv3);
                        }
                        $this$filter$iv2 = (List)destination$iv$iv3;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Artifact it = (Artifact)element$iv2;
                            boolean bl7 = false;
                            $this$printAnyErrors_u24lambda_u242_u240_u240.append("Output: " + dev.mosaify.core.util.compress.Extensions.INSTANCE.decompressText(it)).append('\n');
                        }
                    }
                    Terminal.println$default((Terminal)terminal, (Object)stringBuilder.toString(), null, null, null, null, (boolean)false, (int)62, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ComponentInfo resolveCodeInfo(@NotNull File directory) {
        void $this$flatMapTo$iv$iv;
        Object $this$resolveCodeInfo_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!(directory.exists() && directory.isDirectory())) {
            boolean $i$a$-require-CliFunctions$resolveCodeInfo$22 = false;
            String $i$a$-require-CliFunctions$resolveCodeInfo$22 = "projectDirectory must be an existing directory";
            throw new IllegalArgumentException($i$a$-require-CliFunctions$resolveCodeInfo$22.toString());
        }
        Set names = new LinkedHashSet();
        Set versions = new LinkedHashSet();
        Object object = this;
        try {
            $this$resolveCodeInfo_u24lambda_u241 = object;
            boolean bl = false;
            $this$resolveCodeInfo_u24lambda_u241 = Result.constructor-impl((Object)Git.open((File)directory));
        }
        catch (Throwable bl) {
            $this$resolveCodeInfo_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$resolveCodeInfo_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$resolveCodeInfo_u24lambda_u241 = throwable;
            boolean bl2 = false;
            logger.debug((Throwable)it, CliFunctions::resolveCodeInfo$lambda$2$0);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Object $this$resolveCodeInfo_u24lambda_u243_u246;
            Object $this$resolveCodeInfo_u24lambda_u243_u243;
            Object it;
            Collection destination$iv$iv;
            Iterable destination$iv$iv2;
            Object $this$resolveCodeInfo_u24lambda_u243_u240;
            Git git = (Git)object;
            boolean bl = false;
            Object bl2 = INSTANCE;
            try {
                void $this$flatMapTo$iv$iv2;
                void $this$flatMap$iv;
                $this$resolveCodeInfo_u24lambda_u243_u240 = bl2;
                boolean bl3 = false;
                List list = git.remoteList().call();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call(...)");
                Iterable iterable = list;
                boolean $i$f$flatMap = false;
                void var12_40 = $this$flatMap$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    void $this$mapTo$iv$iv;
                    RemoteConfig remote = (RemoteConfig)element$iv$iv;
                    boolean bl4 = false;
                    List list2 = remote.getURIs();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getURIs(...)");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void uri;
                        URIish uRIish = (URIish)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        String string = uri.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        collection.add(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)"/"), (CharSequence)".git"));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$resolveCodeInfo_u24lambda_u243_u240 = Result.constructor-impl((Object)((List)destination$iv$iv2));
            }
            catch (Throwable bl3) {
                $this$resolveCodeInfo_u24lambda_u243_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            bl2 = $this$resolveCodeInfo_u24lambda_u243_u240;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)bl2);
            if (throwable2 != null) {
                Object it2 = $this$resolveCodeInfo_u24lambda_u243_u240 = throwable2;
                boolean bl6 = false;
                logger.debug((Throwable)it2, CliFunctions::resolveCodeInfo$lambda$3$1$0);
            }
            if (Result.isSuccess-impl((Object)bl2)) {
                it = (List)bl2;
                boolean bl7 = false;
                names.addAll((Collection)it);
            }
            bl2 = INSTANCE;
            try {
                $this$resolveCodeInfo_u24lambda_u243_u243 = bl2;
                boolean bl8 = false;
                Iterable iterable = git.log().setMaxCount(1).call();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"call(...)");
                $this$resolveCodeInfo_u24lambda_u243_u243 = Result.constructor-impl((Object)((RevCommit)CollectionsKt.first((Iterable)iterable)));
            }
            catch (Throwable bl8) {
                $this$resolveCodeInfo_u24lambda_u243_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl8));
            }
            bl2 = $this$resolveCodeInfo_u24lambda_u243_u243;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)bl2);
            if (throwable3 != null) {
                Object it3 = $this$resolveCodeInfo_u24lambda_u243_u243 = throwable3;
                boolean bl9 = false;
                logger.debug((Throwable)it3, CliFunctions::resolveCodeInfo$lambda$3$4$0);
            }
            if (Result.isSuccess-impl((Object)bl2)) {
                Object $this$resolveCodeInfo_u24lambda_u243_u245_u240;
                RevCommit commit = (RevCommit)bl2;
                boolean bl10 = false;
                String string = commit.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                versions.add(string);
                Object bl9 = INSTANCE;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    $this$resolveCodeInfo_u24lambda_u243_u245_u240 = bl9;
                    boolean bl11 = false;
                    List list = git.tagList().call();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call(...)");
                    destination$iv$iv2 = list;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Ref it4 = (Ref)element$iv$iv;
                        boolean bl12 = false;
                        Repository repository = git.getRepository();
                        ObjectId objectId = it4.getPeeledObjectId();
                        if (objectId == null) {
                            objectId = it4.getObjectId();
                        }
                        if (!repository.parseCommit((AnyObjectId)objectId).equals((AnyObjectId)commit)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv3;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Ref it4 = (Ref)item$iv$iv;
                        destination$iv$iv = destination$iv$iv3;
                        boolean bl13 = false;
                        destination$iv$iv.add(Repository.shortenRefName((String)it4.getName()));
                    }
                    $this$resolveCodeInfo_u24lambda_u243_u245_u240 = Result.constructor-impl((Object)((List)destination$iv$iv3));
                }
                catch (Throwable bl11) {
                    $this$resolveCodeInfo_u24lambda_u243_u245_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl11));
                }
                bl9 = $this$resolveCodeInfo_u24lambda_u243_u245_u240;
                Throwable throwable4 = Result.exceptionOrNull-impl((Object)bl9);
                if (throwable4 != null) {
                    Object it5 = $this$resolveCodeInfo_u24lambda_u243_u245_u240 = throwable4;
                    boolean bl14 = false;
                    logger.debug((Throwable)it5, CliFunctions::resolveCodeInfo$lambda$3$5$1$0);
                }
                if (Result.isSuccess-impl((Object)bl9)) {
                    List it6 = (List)bl9;
                    boolean bl15 = false;
                    if (!((Collection)it6).isEmpty()) {
                        versions.addAll(it6);
                    }
                }
            }
            bl2 = INSTANCE;
            try {
                $this$resolveCodeInfo_u24lambda_u243_u246 = bl2;
                boolean bl16 = false;
                $this$resolveCodeInfo_u24lambda_u243_u246 = Result.constructor-impl((Object)git.getRepository().getBranch());
            }
            catch (Throwable bl16) {
                $this$resolveCodeInfo_u24lambda_u243_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl16));
            }
            bl2 = $this$resolveCodeInfo_u24lambda_u243_u246;
            Throwable throwable5 = Result.exceptionOrNull-impl((Object)bl2);
            if (throwable5 != null) {
                Object it7 = $this$resolveCodeInfo_u24lambda_u243_u246 = throwable5;
                boolean bl17 = false;
                logger.debug((Throwable)it7, CliFunctions::resolveCodeInfo$lambda$3$7$0);
            }
            if (Result.isSuccess-impl((Object)bl2)) {
                it = (String)bl2;
                boolean bl18 = false;
                Intrinsics.checkNotNull((Object)it);
                versions.add(it);
            }
        }
        if (names.isEmpty()) {
            logger.debug(CliFunctions::resolveCodeInfo$lambda$4);
            String string = directory.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            names.add(string);
        }
        String bestName = (String)CollectionsKt.first((Iterable)names);
        String bestVersion = (String)CollectionsKt.firstOrNull((Iterable)versions);
        logger.debug(() -> CliFunctions.resolveCodeInfo$lambda$5(bestName, bestVersion));
        Iterable $this$flatMap$iv = versions;
        boolean $i$f$flatMap = false;
        Iterable bl18 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String version = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = names;
            boolean $i$f$map = false;
            Iterable bl4 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void name;
                String $i$f$mapTo2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl19 = false;
                collection.add(BasicProjectInfo.Companion.create((String)name, version));
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set aliases = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return ComponentInfo.Companion.create(bestName, bestVersion, aliases);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object scanRetrying(@NotNull Scanner $this$scanRetrying, @NotNull ScanTarget target, @NotNull Map<String, ? extends Object> parameters, boolean useProcess, boolean debug, int retries, @NotNull Continuation<? super Collection<Run>> $completion) {
        block17: {
            if (!($completion instanceof scanRetrying.1)) ** GOTO lbl-1000
            var13_8 = $completion;
            if ((var13_8.label & -2147483648) != 0) {
                var13_8.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    boolean Z$0;
                    boolean Z$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ CliFunctions this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.scanRetrying(null, null, null, false, false, 0, (Continuation<? super Collection<Run>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!($this$scanRetrying instanceof ScannerSnykOss) || useProcess) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$scanRetrying);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)target);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)parameters);
                    $continuation.Z$0 = useProcess;
                    $continuation.Z$1 = debug;
                    $continuation.I$0 = retries;
                    $continuation.label = 1;
                    v0 = new SnykOssRunner(CliFunctions.logger).scan(target, parameters, false, debug != false, (Continuation)$continuation);
                    if (v0 == var14_10) {
                        return var14_10;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    retries = $continuation.I$0;
                    debug = $continuation.Z$1;
                    useProcess = $continuation.Z$0;
                    parameters = (Map)$continuation.L$2;
                    target = (ScanTarget)$continuation.L$1;
                    $this$scanRetrying = (Scanner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    return v0;
                }
            }
            retryCount = new Ref.IntRef();
            retryCount.element = retries;
            result = new Ref.ObjectRef();
lbl37:
            // 2 sources

            while (true) {
                var10_13 = retryCount.element;
                retryCount.element = var10_13 + -1;
                if (var10_13 <= 0) break block17;
                var11_14 = result;
                $continuation.L$0 = $this$scanRetrying;
                $continuation.L$1 = target;
                $continuation.L$2 = parameters;
                $continuation.L$3 = retryCount;
                $continuation.L$4 = result;
                $continuation.L$5 = var11_14;
                $continuation.Z$0 = useProcess;
                $continuation.Z$1 = debug;
                $continuation.I$0 = retries;
                $continuation.label = 2;
                v1 = $this$scanRetrying.scan(target, parameters, useProcess != false, debug != false, (Continuation)$continuation);
                if (v1 == var14_10) {
                    return var14_10;
                }
                ** GOTO lbl68
                break;
            }
            {
                case 2: {
                    retries = $continuation.I$0;
                    debug = $continuation.Z$1;
                    useProcess = $continuation.Z$0;
                    var11_14 = (Ref.ObjectRef)$continuation.L$5;
                    result = (Ref.ObjectRef)$continuation.L$4;
                    retryCount = (Ref.IntRef)$continuation.L$3;
                    parameters = (Map)$continuation.L$2;
                    target = (ScanTarget)$continuation.L$1;
                    $this$scanRetrying = (Scanner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl68:
                    // 2 sources

                    var11_14.element = CollectionsKt.listOf((Object)v1);
                    if (result.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                        v2 = null;
                    } else {
                        v2 = (Collection)result.element;
                    }
                    if (!CommonUtils.INSTANCE.hasErrors(v2)) {
                        if (result.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                            v3 = null;
                        } else {
                            v3 = (Collection)result.element;
                        }
                        return v3;
                    }
                    CliFunctions.logger.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, scanRetrying$lambda$0(dev.mosaify.core.model.scanner.Scanner dev.mosaify.core.model.scanner.ScanTarget kotlin.jvm.internal.Ref$IntRef kotlin.jvm.internal.Ref$ObjectRef ), ()Ljava/lang/Object;)((Scanner)$this$scanRetrying, (ScanTarget)target, (Ref.IntRef)retryCount, (Ref.ObjectRef)result));
                    ** continue;
                }
            }
        }
        if (result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            v4 = null;
        } else {
            v4 = (Collection)result.element;
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object scanRetrying$default(CliFunctions cliFunctions, Scanner scanner, ScanTarget scanTarget, Map map, boolean bl, boolean bl2, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 5;
        }
        return cliFunctions.scanRetrying(scanner, scanTarget, map, bl, bl2, n, (Continuation<? super Collection<Run>>)continuation);
    }

    public final void saveReport(@NotNull Collection<Issue> report, @NotNull String path, @NotNull ReportFormat format) {
        Intrinsics.checkNotNullParameter(report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        if (report.isEmpty()) {
            Terminal.println$default((Terminal)terminal, (Object)TextColors.yellow.invoke("The resulting report is empty - nothing to save"), null, null, null, null, (boolean)false, (int)62, null);
            return;
        }
        (switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1 -> (ReportExporter)GenericExporterCsv.INSTANCE;
            case 2 -> (ReportExporter)GenericExporterJson.INSTANCE;
            case 3 -> (ReportExporter)GenericExporterHtml.INSTANCE;
            case 4 -> (ReportExporter)GenericExporterSarif.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        }).export(report, path, true);
    }

    public static /* synthetic */ void saveReport$default(CliFunctions cliFunctions, Collection collection, String string, ReportFormat reportFormat, int n, Object object) {
        if ((n & 4) != 0) {
            reportFormat = ReportFormat.CSV;
        }
        cliFunctions.saveReport(collection, string, reportFormat);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Triple<IssueStatus, List<String>, List<String>>> compareComponents(@NotNull Collection<ResolvedScanRecord> project1data, @NotNull Collection<ResolvedScanRecord> project2data) {
        void $this$associateWithTo$iv$iv;
        Collection<Object> collection;
        ResolvedScanRecord it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(project1data, (String)"project1data");
        Intrinsics.checkNotNullParameter(project2data, (String)"project2data");
        Iterable $this$map$iv = project1data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ResolvedScanRecord resolvedScanRecord = (ResolvedScanRecord)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getLogInfo().getName());
        }
        $this$map$iv = project2data;
        object = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedScanRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLogInfo().getName());
        }
        Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv));
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        Iterable<Object> list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String it2 = (String)e$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$associateWith$iv = CollectionsKt.sorted((Iterable)list$iv);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        list$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Collection<String> collection2;
            String displayVersions;
            Collection collection3;
            Pair pair;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo2;
            Collection destination$iv$iv3;
            boolean $i$f$map2;
            Iterable $this$map$iv2;
            IssueStatus issueStatus;
            void componentName;
            String bl = (String)element$iv$iv;
            collection = element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            List<Pair<String, String>> versions1 = INSTANCE.extractComponentVersions(project1data, (String)componentName);
            List<Pair<String, String>> versions2 = INSTANCE.extractComponentVersions(project2data, (String)componentName);
            if (versions1.isEmpty() && versions2.isEmpty()) {
                String string = "Unexpected scenario: ghost component";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (versions1.isEmpty()) {
                issueStatus = IssueStatus.NEW;
            } else if (versions2.isEmpty()) {
                issueStatus = IssueStatus.REMOVED;
            } else {
                Collection collection4;
                String versions;
                Collection<String> collection5;
                $this$map$iv2 = versions1;
                $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    pair = (Pair)item$iv$iv;
                    collection5 = destination$iv$iv3;
                    boolean bl3 = false;
                    versions = (String)pair.component1();
                    collection5.add(versions);
                }
                $this$map$iv2 = versions2;
                collection5 = (List)destination$iv$iv3;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    pair = (Pair)item$iv$iv;
                    collection4 = destination$iv$iv3;
                    boolean bl4 = false;
                    versions = (String)pair.component1();
                    collection4.add(versions);
                }
                if (!Intrinsics.areEqual(collection5, (Object)((List)destination$iv$iv3))) {
                    issueStatus = IssueStatus.CHANGED;
                } else {
                    $this$map$iv2 = versions1;
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv2 = $this$map$iv2;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        pair = (Pair)item$iv$iv;
                        collection5 = destination$iv$iv3;
                        boolean bl5 = false;
                        versions = (String)pair.component1();
                        collection5.add(versions);
                    }
                    $this$map$iv2 = versions2;
                    collection5 = (List)destination$iv$iv3;
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv2 = $this$map$iv2;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        pair = (Pair)item$iv$iv;
                        collection4 = destination$iv$iv3;
                        boolean bl6 = false;
                        versions = (String)pair.component1();
                        collection4.add(versions);
                    }
                    if (Intrinsics.areEqual(collection5, (Object)((List)destination$iv$iv3))) {
                        issueStatus = IssueStatus.UNCHANGED;
                    } else {
                        throw new Error("Unexpected scenario comparing component versions from two projects");
                    }
                }
            }
            IssueStatus componentComparisonResult = issueStatus;
            $this$map$iv2 = versions1;
            IssueStatus issueStatus2 = componentComparisonResult;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                pair = (Pair)item$iv$iv;
                collection3 = destination$iv$iv3;
                boolean bl7 = false;
                displayVersions = (String)pair.component2();
                collection3.add(displayVersions);
            }
            $this$map$iv2 = versions2;
            collection3 = (List)destination$iv$iv3;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                pair = (Pair)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl8 = false;
                displayVersions = (String)pair.component2();
                collection2.add(displayVersions);
            }
            collection2 = (List)destination$iv$iv3;
            List list = collection2;
            Collection collection6 = collection3;
            IssueStatus issueStatus3 = issueStatus2;
            Triple triple = new Triple((Object)issueStatus3, (Object)collection6, (Object)list);
            object.put(collection, triple);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> extractComponentVersions(Collection<ResolvedScanRecord> components, String name) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$distinctBy$iv = components;
        boolean $i$f$distinctBy = false;
        Iterable<Pair> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair key$iv;
            String string;
            ResolvedScanRecord it = (ResolvedScanRecord)e$iv;
            boolean bl = false;
            String string2 = it.getLogInfo().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = it.getLogInfo().getVersion();
            if (string3 != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            if (!((HashSet)set$iv).add(key$iv = new Pair((Object)string2, (Object)string))) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$filter$iv = list$iv;
        boolean $i$f$filter = false;
        set$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contentEquals((CharSequence)it.getLogInfo().getName(), (CharSequence)name, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ResolvedScanRecord it = (ResolvedScanRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getLogInfo().getVersion();
            if (string == null) {
                string = Extensions.INSTANCE.display(it.getLogInfo().getTimestamp());
            }
            collection.add(new Pair((Object)string, (Object)INSTANCE.getDisplayVersion(it)));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                String version = (String)pair.component1();
                String string = version.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                pair = (Pair)b;
                Comparable comparable = (Comparable)((Object)string);
                bl = false;
                version = (String)pair.component1();
                String string2 = version.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String getDisplayVersion(ResolvedScanRecord record) {
        Collection collection;
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object[] $this$mapNotNull$iv = (Object[])record.getLogInfo().getAliases();
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BasicProjectInfo it = (BasicProjectInfo)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getVersion();
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = record.getLogInfo().getVersion();
            if (string != null ? StringsKt.contentEquals((CharSequence)string, (CharSequence)it, (boolean)true) : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String it = (String)e$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Collection collection2 = list$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            objectArray = new String[]{record.getLogInfo().getVersion(), record.getLogInfo().getTimestamp().toString()};
            collection = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            collection = collection2;
        }
        return (String)CollectionsKt.first((List)((List)collection));
    }

    @NotNull
    public final String display(@NotNull TargetType $this$display) {
        Intrinsics.checkNotNullParameter((Object)$this$display, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$display.ordinal()]) {
            case 1 -> "Image";
            case 2 -> "Code";
            case 3 -> "Endpoint";
            case 4 -> "Artifact";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public final void displayReport(@NotNull Collection<Issue> report, @NotNull Terminal terminal) {
        boolean bl;
        Object[] objectArray;
        GenericReportTableFormat reportTable;
        block3: {
            void $this$none$iv;
            Intrinsics.checkNotNullParameter(report, (String)"report");
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            reportTable = new GenericReportTableFormat(report, null, 2, null);
            objectArray = new Integer[9];
            Iterable iterable = report;
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Issue it = (Issue)element$iv;
                    boolean bl2 = false;
                    if (!(it.getStatus() == null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        boolean bl3 = bl;
        objectArray2[n] = bl3 ? Integer.valueOf(0) : null;
        objectArray[1] = 3;
        objectArray[2] = 4;
        objectArray[3] = 5;
        objectArray[4] = 6;
        objectArray[5] = 9;
        objectArray[6] = 10;
        objectArray[7] = 14;
        objectArray[8] = 15;
        List visibleColumns = CollectionsKt.listOfNotNull((Object[])objectArray);
        Terminal.println$default((Terminal)terminal, (Widget)((Widget)TableDslKt.table(arg_0 -> CliFunctions.displayReport$lambda$1(visibleColumns, reportTable, arg_0))), (boolean)false, (int)2, null);
    }

    private static final Map availableScanners_delegate$lambda$0() {
        Pair[] pairArray = new Pair[8];
        Object[] objectArray = new String[]{"ag", "g", "gr", "grype"};
        pairArray[0] = TuplesKt.to((Object)new ScannerAnchoreGrype(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"at", "t", "tr", "trivy"};
        pairArray[1] = TuplesKt.to((Object)new ScannerAquasecurityTrivy(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"docker", "ds", "s", "sc", "scout"};
        pairArray[2] = TuplesKt.to((Object)new ScannerDockerScout(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"jf", "jx", "x", "xr", "xray"};
        pairArray[3] = TuplesKt.to((Object)new ScannerJfrogXray(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"s", "semgrep", "sg"};
        pairArray[4] = TuplesKt.to((Object)new ScannerSemgrep(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"snyk", "s", "sc", "sn", "scd", "scod", "scode", "snyk-code", "snyk_code", "snykcode"};
        pairArray[5] = TuplesKt.to((Object)new ScannerSnykCode(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"s", "sc", "scn", "scon", "scont", "scontainer", "sct", "sn", "snyk", "snyk-container", "snyk_container", "snykcontainer"};
        pairArray[6] = TuplesKt.to((Object)new ScannerSnykContainer(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"s", "sn", "snyk", "snyk-oss", "snyk_oss", "snykoss", "soss", "sos"};
        pairArray[7] = TuplesKt.to((Object)new ScannerSnykOss(logger), (Object)CollectionsKt.listOf((Object[])objectArray));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final Object collectScannerParameters$lambda$6$0(List $it) {
        return "The following scanner parameters are not defined: " + CollectionsKt.joinToString$default((Iterable)$it, null, null, null, (int)0, null, CliFunctions::collectScannerParameters$lambda$6$0$0, (int)31, null);
    }

    private static final CharSequence collectScannerParameters$lambda$6$0$0(String p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return "'" + p + "'";
    }

    private static final Object pullImageDockerApi$lambda$1$0(String $image) {
        return "Pulling image '" + $image + "' failed.";
    }

    private static final Object pullImage$lambda$0(String $image, ProcessRunResult $result) {
        StringBuilder stringBuilder;
        StringBuilder $this$pullImage_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$pullImage_u24lambda_u240_u240.append("Pulling image '" + $image + "' failed. 'docker pull' command outputs below:").append('\n');
        StringBuilder stringBuilder2 = $this$pullImage_u24lambda_u240_u240;
        byte[] byArray = $result.getStdErr();
        stringBuilder2.append("STDERR:\n" + (byArray != null ? StringsKt.decodeToString((byte[])byArray) : null) + "\n").append('\n');
        stringBuilder2 = $this$pullImage_u24lambda_u240_u240;
        byte[] byArray2 = $result.getStdOut();
        stringBuilder2.append("STDOUT:\n" + (byArray2 != null ? StringsKt.decodeToString((byte[])byArray2) : null) + "\n").append('\n');
        return stringBuilder.toString();
    }

    private static final Object pullImageRetrying$lambda$0(Ref.IntRef $retryCount) {
        return "Retrying pulling image. Retries left: " + $retryCount.element;
    }

    private static final Object resolveImageInfo$lambda$3(String $image, BasicProjectInfoImpl $bestId) {
        return "Image '" + $image + "' will be tracked as '" + $bestId + "'";
    }

    private static final Object resolveImageInfo$lambda$4(String $image) {
        return "Could not resolve the real version (sha256) of the image '" + $image + "'";
    }

    private static final Object resolveCodeInfo$lambda$2$0() {
        return "Could not open project directory as git repository";
    }

    private static final Object resolveCodeInfo$lambda$3$1$0() {
        return "Could not get git remote";
    }

    private static final Object resolveCodeInfo$lambda$3$4$0() {
        return "Could not get git commit ID";
    }

    private static final Object resolveCodeInfo$lambda$3$5$1$0() {
        return "Could not get git commit ID";
    }

    private static final Object resolveCodeInfo$lambda$3$7$0() {
        return "Could not get git branch name";
    }

    private static final Object resolveCodeInfo$lambda$4() {
        return "Using project directory name as project name";
    }

    private static final Object resolveCodeInfo$lambda$5(String $bestName, String $bestVersion) {
        return "Guessed project name: '" + $bestName + "', version: '" + $bestVersion + "'";
    }

    /*
     * WARNING - void declaration
     */
    private static final Object scanRetrying$lambda$0(Scanner $this_scanRetrying, ScanTarget $target, Ref.IntRef $retryCount, Ref.ObjectRef $result) {
        void $this$forEach$iv;
        Artifact it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection collection;
        StringBuilder stringBuilder;
        StringBuilder $this$scanRetrying_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$scanRetrying_u24lambda_u240_u240.append("Scanner '" + $this_scanRetrying.getName() + "' failed with target '" + $target.getTarget() + "'. Retrying. Retries left: " + $retryCount.element).append('\n');
        if ($result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            collection = null;
        } else {
            collection = (Collection)$result.element;
        }
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Run it2 = (Run)element$iv$iv;
            boolean bl3 = false;
            if (it2.getArtifacts() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Artifact)element$iv$iv;
            boolean bl5 = false;
            if (!Intrinsics.areEqual((Object)it.getSourceLanguage(), (Object)"PLAINTEXT")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Artifact)element$iv$iv;
            boolean bl6 = false;
            Set set = it.getRoles();
            boolean bl7 = set != null ? set.contains(ArtifactRoles.STANDARD_STREAM) : false;
            if (!bl7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Artifact artifact = (Artifact)element$iv;
            boolean bl8 = false;
            $this$scanRetrying_u24lambda_u240_u240.append("Output: " + dev.mosaify.core.util.compress.Extensions.INSTANCE.decompressText(artifact)).append('\n');
        }
        return stringBuilder.toString();
    }

    private static final Unit displayReport$lambda$1(List $visibleColumns, GenericReportTableFormat $reportTable, TableBuilder $this$table) {
        Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
        $this$table.column(5, CliFunctions::displayReport$lambda$1$0);
        $this$table.header(arg_0 -> CliFunctions.displayReport$lambda$1$1($visibleColumns, arg_0));
        $this$table.body(arg_0 -> CliFunctions.displayReport$lambda$1$2($reportTable, $visibleColumns, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit displayReport$lambda$1$0(ColumnBuilder $this$column) {
        Intrinsics.checkNotNullParameter((Object)$this$column, (String)"$this$column");
        $this$column.setOverflowWrap(OverflowWrap.ELLIPSES);
        $this$column.setWidth(ColumnWidth.Companion.Fixed(50));
        return Unit.INSTANCE;
    }

    private static final Unit displayReport$lambda$1$1(List $visibleColumns, SectionBuilder $this$header) {
        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
        $this$header.setStyle(TextStyles.bold.getStyle());
        $this$header.row(arg_0 -> CliFunctions.displayReport$lambda$1$1$0($visibleColumns, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit displayReport$lambda$1$1$0(List $visibleColumns, RowBuilder $this$row) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Iterable $this$filterIndexed$iv = GenericReportTableFormat.Companion.getHeaders();
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv2 = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            String cfr_ignored_0 = (String)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!$visibleColumns.contains(index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String index$iv$iv$iv2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)it, null, (int)2, null);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_1 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit displayReport$lambda$1$2(GenericReportTableFormat $reportTable, List $visibleColumns, SectionBuilder $this$body) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
        Iterable $this$map$iv = CollectionsKt.take((Iterable)$reportTable.getValues(), (int)5);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void record;
            Collection collection = (Collection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            $this$body.row(arg_0 -> CliFunctions.displayReport$lambda$1$2$0$0((Collection)record, $visibleColumns, arg_0));
            collection2.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit displayReport$lambda$1$2$0$0(Collection $record, List $visibleColumns, RowBuilder $this$row) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Iterable $this$filterIndexed$iv = $record;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv2 = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            String cfr_ignored_0 = (String)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!$visibleColumns.contains(index)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String index$iv$iv$iv2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OverflowWrap overflowWrap = OverflowWrap.BREAK_WORD;
            RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)new Text((String)it, null, null, overflowWrap, Integer.valueOf(10), null, 38, null), null, (int)2, null);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_1 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Collection access$normalizeReport(CliFunctions $this, Collection report, NormalizeBy normalizeBy, Collection preferredScanners) {
        return $this.normalizeReport(report, normalizeBy, preferredScanners);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "", "<init>", "(Ljava/lang/String;I)V", "DISABLED", "ID", "mosaify-cli"})
    public static final class NormalizeBy
    extends Enum<NormalizeBy> {
        public static final /* enum */ NormalizeBy DISABLED = new NormalizeBy();
        public static final /* enum */ NormalizeBy ID = new NormalizeBy();
        private static final /* synthetic */ NormalizeBy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NormalizeBy[] values() {
            return (NormalizeBy[])$VALUES.clone();
        }

        public static NormalizeBy valueOf(String value) {
            return Enum.valueOf(NormalizeBy.class, value);
        }

        @NotNull
        public static EnumEntries<NormalizeBy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = normalizeByArray = new NormalizeBy[]{NormalizeBy.DISABLED, NormalizeBy.ID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "", "<init>", "(Ljava/lang/String;I)V", "CSV", "JSON", "HTML", "SARIF", "mosaify-cli"})
    public static final class ReportFormat
    extends Enum<ReportFormat> {
        public static final /* enum */ ReportFormat CSV = new ReportFormat();
        public static final /* enum */ ReportFormat JSON = new ReportFormat();
        public static final /* enum */ ReportFormat HTML = new ReportFormat();
        public static final /* enum */ ReportFormat SARIF = new ReportFormat();
        private static final /* synthetic */ ReportFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReportFormat[] values() {
            return (ReportFormat[])$VALUES.clone();
        }

        public static ReportFormat valueOf(String value) {
            return Enum.valueOf(ReportFormat.class, value);
        }

        @NotNull
        public static EnumEntries<ReportFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = reportFormatArray = new ReportFormat[]{ReportFormat.CSV, ReportFormat.JSON, ReportFormat.HTML, ReportFormat.SARIF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NormalizeBy.values().length];
            try {
                nArray[NormalizeBy.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NormalizeBy.ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReportFormat.values().length];
            try {
                nArray[ReportFormat.CSV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportFormat.JSON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportFormat.HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportFormat.SARIF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TargetType.values().length];
            try {
                nArray[TargetType.CONTAINER_IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetType.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetType.URL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetType.BINARY_ARTIFACT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

