/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.cli;

import com.github.ajalt.mordant.terminal.Terminal;
import dev.mosaify.core.util.Extensions;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\u0002\b\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/mosaify/core/cli/CliLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "name", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "<init>", "(Ljava/lang/String;Lcom/github/ajalt/mordant/terminal/Terminal;)V", "getName", "()Ljava/lang/String;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "mosaify-cli"})
public final class CliLogger
implements KLogger {
    @NotNull
    private final String name;
    @NotNull
    private final Terminal terminal;

    public CliLogger(@NotNull String name, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.name = name;
        this.terminal = terminal;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Instant timeStamp = Clock.System.INSTANCE.now();
        KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
        block.invoke((Object)kLoggingEventBuilder);
        KLoggingEventBuilder event = kLoggingEventBuilder;
        boolean bl = false;
        Terminal.println$default((Terminal)this.terminal, (Object)(StringsKt.padEnd$default((String)Extensions.INSTANCE.displayTime(timeStamp), (int)8, (char)'\u0000', (int)2, null) + " [" + this.getName() + "] " + StringsKt.padEnd$default((String)level.toString(), (int)5, (char)'\u0000', (int)2, null) + "  " + event.getMessage()), null, null, null, null, (boolean)false, (int)62, null);
    }

    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return true;
    }
}

