/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util;

import com.aallam.similarity.JaroWinkler;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.metadata.ContainerImageInfo;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.Invocation;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import dev.samoylenko.packageurl.PackageUrlBasic;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010(\u001a\u00020\u00142\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0$J\u0016\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fJ\u0018\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u000200J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00066"}, d2={"Ldev/mosaify/core/util/CommonUtils;", "", "<init>", "()V", "SIMILARITY_THRESHOLD", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "jaroWinkler", "Lcom/aallam/similarity/JaroWinkler;", "knownPurlTypes", "", "", "getKnownPurlTypes", "()Ljava/util/List;", "defaultJson", "Lkotlinx/serialization/json/Json;", "getDefaultJson", "()Lkotlinx/serialization/json/Json;", "isSimilar", "", "string1", "string2", "normalizePurl", "purl", "normalizeAndCheckPurl", "detectPurlType", "string", "parserSupports", "reportParser", "Ldev/mosaify/core/model/report/ReportParser;", "run", "Ldev/mosaify/core/model/sarif/Run;", "detectIssueTypeFromId", "Ldev/mosaify/core/model/generic/IssueType;", "identifiers", "", "parseContainerImageString", "Ldev/mosaify/core/model/metadata/ContainerImageInfo;", "imageString", "hasErrors", "runs", "toAliasString", "name", "version", "markdownToPlainText", "markdownText", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "processASTNode", "", "original", "node", "Lorg/intellij/markdown/ast/ASTNode;", "mosaify-util-common"})
@SourceDebugExtension(value={"SMAP\nCommonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonUtils.kt\ndev/mosaify/core/util/CommonUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n1#2:170\n1285#3,2:171\n1299#3,4:173\n1999#3,14:184\n1761#3,3:198\n1374#3:201\n1460#3,5:202\n1740#3,3:207\n1761#3,3:210\n1869#3,2:213\n827#3:215\n855#3,2:216\n827#3:218\n855#3,2:219\n504#4,7:177\n*S KotlinDebug\n*F\n+ 1 CommonUtils.kt\ndev/mosaify/core/util/CommonUtils\n*L\n58#1:171,2\n58#1:173,4\n61#1:184,14\n68#1:198,3\n73#1:201\n73#1:202,5\n122#1:207,3\n125#1:210,3\n159#1:213,2\n30#1:215\n30#1:216,2\n31#1:218\n31#1:219,2\n59#1:177,7\n*E\n"})
public final class CommonUtils {
    @NotNull
    public static final CommonUtils INSTANCE;
    private static final double SIMILARITY_THRESHOLD = 0.67;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final JaroWinkler jaroWinkler;
    @NotNull
    private static final List<String> knownPurlTypes;
    @NotNull
    private static final Json defaultJson;

    private CommonUtils() {
    }

    @NotNull
    public final List<String> getKnownPurlTypes() {
        return knownPurlTypes;
    }

    @NotNull
    public final Json getDefaultJson() {
        return defaultJson;
    }

    public final boolean isSimilar(@NotNull String string1, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string1, (String)"string1");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string2");
        return jaroWinkler.similarity(string1, string2) >= 0.67;
    }

    @NotNull
    public final String normalizePurl(@NotNull String purl) {
        Intrinsics.checkNotNullParameter((Object)purl, (String)"purl");
        return PackageUrlBasic.Companion.parse$default((PackageUrlBasic.Companion)PackageUrlBasic.Companion, (String)purl, (boolean)false, (int)2, null).toString();
    }

    @Nullable
    public final String normalizeAndCheckPurl(@NotNull String purl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)purl, (String)"purl");
        Object object2 = this;
        try {
            CommonUtils $this$normalizeAndCheckPurl_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$normalizeAndCheckPurl_u24lambda_u240.normalizePurl(purl));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String detectPurlType(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (StringsKt.startsWith((String)string, (String)"ubuntu", (boolean)true)) {
            string2 = "deb/ubuntu";
        } else if (StringsKt.startsWith((String)string, (String)"alpine", (boolean)true)) {
            string2 = "apk/alpine";
        } else {
            Object v1;
            Iterator $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = knownPurlTypes;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv = iterator.next();
                String string3 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Double d = jaroWinkler.similarity((String)it, string);
                map.put(t, d);
            }
            Map $this$filterValues$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                double it = ((Number)entry$iv.getValue()).doubleValue();
                boolean bl = false;
                if (!(it >= 0.67)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$maxByOrNull$iv = MapsKt.toList((Map)result$iv);
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Pair it = (Pair)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = ((Number)it.getSecond()).doubleValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-maxByOrNull-CommonUtils$detectPurlType$3 = false;
                        double v$iv = ((Number)it2.getSecond()).doubleValue();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Pair pair = v1;
            string2 = pair != null ? (String)pair.getFirst() : null;
        }
        return string2;
    }

    public final boolean parserSupports(@NotNull ReportParser reportParser, @NotNull Run run) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)reportParser, (String)"reportParser");
            Intrinsics.checkNotNullParameter((Object)run, (String)"run");
            Object object = RunExtraInfo.Companion.fromPropertyBag(run.getProperties());
            if (object == null || (object = object.getScanner()) == null) {
                object = run.getTool().getDriver().getName();
            }
            Object scannerName = object;
            boolean bl2 = false;
            Iterable $this$any$iv = reportParser.getAllNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.contentEquals((CharSequence)it, (CharSequence)((CharSequence)scannerName), (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IssueType detectIssueTypeFromId(@NotNull Collection<String> identifiers) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        Iterable $this$flatMap$iv = IssueTaxonomy.Companion.fromIssueId(identifiers, true).values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IssueTaxonomy it = (IssueTaxonomy)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getType();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List detectedTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return detectedTypes.size() > 1 ? null : (IssueType)CollectionsKt.firstOrNull((List)detectedTypes);
    }

    @NotNull
    public final ContainerImageInfo parseContainerImageString(@NotNull String imageString) {
        Intrinsics.checkNotNullParameter((Object)imageString, (String)"imageString");
        if (!(!StringsKt.startsWith$default((String)imageString, (String)"sha256:", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-CommonUtils$parseContainerImageString$22 = false;
            String $i$a$-require-CommonUtils$parseContainerImageString$22 = "Referring container images by ID is currently not supported";
            throw new IllegalArgumentException($i$a$-require-CommonUtils$parseContainerImageString$22.toString());
        }
        String imageStringNoPrefix = StringsKt.removePrefix((String)imageString, (CharSequence)"https://");
        String digest = StringsKt.substringAfterLast$default((String)imageStringNoPrefix, (char)'@', null, (int)2, null);
        boolean validDigest = StringsKt.startsWith((String)digest, (String)"sha256", (boolean)true);
        String tag = StringsKt.substringAfterLast((String)StringsKt.substringBefore$default((String)imageStringNoPrefix, (char)'@', null, (int)2, null), (char)':', (String)"");
        boolean validTag = !StringsKt.isBlank((CharSequence)tag) && !StringsKt.contains$default((CharSequence)tag, (char)'/', (boolean)false, (int)2, null);
        String it = StringsKt.substringBeforeLast$default((String)imageStringNoPrefix, (char)'@', null, (int)2, null);
        boolean bl = false;
        it = validTag ? StringsKt.substringBeforeLast$default((String)it, (char)':', null, (int)2, null) : it;
        boolean bl2 = false;
        String substring = StringsKt.substringBefore$default((String)it, (char)'/', null, (int)2, null);
        boolean bl3 = false;
        String image = StringsKt.contains$default((CharSequence)substring, (char)'.', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)substring, (char)':', (boolean)false, (int)2, null) ? it : (StringsKt.contains$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? "docker.io/" + it : "docker.io/library/" + it);
        return new ContainerImageInfo(image, (String)(validTag ? tag : (validDigest ? null : "latest")), validDigest ? digest : null);
    }

    public final boolean hasErrors(@NotNull Run run) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        List invocations = run.getInvocations();
        boolean bl2 = false;
        Collection collection = invocations;
        if (collection == null || collection.isEmpty()) {
            bl = true;
        } else {
            boolean bl3;
            block5: {
                Iterable $this$all$iv = invocations;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Invocation invocation = (Invocation)element$iv;
                        boolean bl4 = false;
                        if (invocation.getExecutionSuccessful()) continue;
                        bl3 = false;
                        break block5;
                    }
                    bl3 = true;
                }
            }
            bl = !bl3;
        }
        return bl;
    }

    public final boolean hasErrors(@NotNull Collection<Run> runs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(runs, (String)"runs");
            Iterable $this$any$iv = runs;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Run it = (Run)element$iv;
                    boolean bl2 = false;
                    if (!(it == null || INSTANCE.hasErrors(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String toAliasString(@NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        CharSequence charSequence = version;
        return name + "@" + (String)(new Regex("\\s").containsMatchIn(charSequence) ? "'" + version + "'" : version);
    }

    @NotNull
    public final String markdownToPlainText(@NotNull String markdownText, @NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        return ((Object)this.processASTNode(markdownText, new MarkdownParser(flavour).buildMarkdownTreeFromString(markdownText))).toString();
    }

    public static /* synthetic */ String markdownToPlainText$default(CommonUtils commonUtils, String string, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            markdownFlavourDescriptor = (MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor(false, false, 3, null);
        }
        return commonUtils.markdownToPlainText(string, markdownFlavourDescriptor);
    }

    private final CharSequence processASTNode(CharSequence original, ASTNode node) {
        CharSequence charSequence;
        StringBuilder sb = new StringBuilder();
        logger.trace(() -> CommonUtils.processASTNode$lambda$0(node));
        logger.trace(() -> CommonUtils.processASTNode$lambda$1(node, original));
        if (node.getType().getName().length() == 1) {
            return ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)original);
        }
        Object object = node.getType();
        if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            sb.append(" ");
        } else if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.EOL)) {
            sb.append('\n');
        } else if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.LIST_BULLET) || Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.TEXT)) {
            return ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)original);
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode child = (ASTNode)element$iv;
            boolean bl = false;
            sb.append(INSTANCE.processASTNode(original, child));
        }
        object = node.getType().getName();
        if (new Regex("^ATX_\\d+").matches((CharSequence)object)) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = StringsKt.removePrefix((String)string, (CharSequence)" ");
        } else {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = string;
        }
        return charSequence;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit defaultJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Object processASTNode$lambda$0(ASTNode $node) {
        return "type: -->" + $node.getType().getName() + "<--";
    }

    private static final Object processASTNode$lambda$1(ASTNode $node, CharSequence $original) {
        return "content: -->" + ASTUtilKt.getTextInNode((ASTNode)$node, (CharSequence)$original) + "<--";
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Iterable $this$filterNotTo$iv$iv;
        INSTANCE = new CommonUtils();
        logger = KotlinLogging.INSTANCE.logger(CommonUtils::logger$lambda$0);
        jaroWinkler = new JaroWinkler(0.0, 1, null);
        Iterable $this$filterNot$iv = StringsKt.lines((CharSequence)"\n#--------------------------------------------------------------------------------------------------------#\n# Maintained manually from https://raw.githubusercontent.com/package-url/purl-spec/master/PURL-TYPES.rst #\n#--------------------------------------------------------------------------------------------------------#\n\nalpm\napk\nbitbucket\nbitnami\ncocoapods\ncargo\ncomposer\nconan\nconda\ncpan\ncran\ndeb\ndocker\ngem\ngeneric\ngithub\ngolang\nhackage\nhex\nhuggingface\nluarocks\nmaven\nmlflow\nnpm\nnuget\nqpkg\noci\npub\npypi\nrpm\nswid\nswift\n\n#------------#\n# Candidates #\n#------------#\n\napache\nandroid\natom\nbower\nbrew\nbuildroot\ncarthage\nchef\nchocolatey\nclojars\ncoreos\nctan\ncrystal\ndrupal\ndtype\ndub\nelm\neclipse\ngitea\ngitlab\ngradle\nguix\nhaxe\nhelm\njulia\nmelpa\nmeteor\nnim\nnix\nopam\nopenwrt\nosgi\np2\npear\npecl\nperl6\nplatformio\nebuild\npuppet\nsourceforge\nsublime\nterraform\nvagrant\nvim\nwordpress\nyocto\n");
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        knownPurlTypes = (List)var3_3;
        defaultJson = JsonKt.Json$default(null, CommonUtils::defaultJson$lambda$0, (int)1, null);
    }
}

