/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.logging;

import dev.mosaify.core.model.sarif.Message;
import dev.mosaify.core.model.sarif.Notification;
import dev.mosaify.core.model.sarif.NotificationLevel;
import dev.mosaify.core.util.logging.MemoryLogger;
import dev.mosaify.core.util.logging.model.StoredLogEvent;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.KMarkerFactory;
import io.github.oshai.kotlinlogging.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\u0002\b\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Ldev/mosaify/core/util/logging/SarifLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "memoryLogger", "Ldev/mosaify/core/util/logging/MemoryLogger;", "getMemoryLogger", "()Ldev/mosaify/core/util/logging/MemoryLogger;", "name", "", "getName", "()Ljava/lang/String;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "getAllNotifications", "", "Ldev/mosaify/core/model/sarif/Notification;", "getConfigurationNotifications", "getExecutionNotifications", "eventToNotification", "event", "Ldev/mosaify/core/util/logging/model/StoredLogEvent;", "Companion", "Marker", "mosaify-util-common"})
@SourceDebugExtension(value={"SMAP\nSarifLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SarifLogger.kt\ndev/mosaify/core/util/logging/SarifLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1563#2:80\n1634#2,3:81\n774#2:84\n865#2,2:85\n1563#2:87\n1634#2,3:88\n827#2:91\n855#2,2:92\n1563#2:94\n1634#2,3:95\n*S KotlinDebug\n*F\n+ 1 SarifLogger.kt\ndev/mosaify/core/util/logging/SarifLogger\n*L\n51#1:80\n51#1:81,3\n54#1:84\n54#1:85,2\n55#1:87\n55#1:88,3\n59#1:91\n59#1:92,2\n60#1:94\n60#1:95,3\n*E\n"})
public final class SarifLogger
implements KLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemoryLogger memoryLogger;
    @NotNull
    private final String name;
    @NotNull
    private static final String PROPERTY_NAME_LEVEL_NAME = "log-level";
    @NotNull
    private static final String PROPERTY_NAME_LEVEL_INT = "log-level-int";

    public SarifLogger(@Nullable KLogger logger) {
        this.memoryLogger = new MemoryLogger(logger);
        Object object = logger;
        if (object == null || (object = object.getName()) == null) {
            object = "SarifLogger";
        }
        this.name = object;
    }

    public /* synthetic */ SarifLogger(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = null;
        }
        this(kLogger);
    }

    @NotNull
    public final MemoryLogger getMemoryLogger() {
        return this.memoryLogger;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void at(@NotNull Level level, @Nullable io.github.oshai.kotlinlogging.Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        io.github.oshai.kotlinlogging.Marker marker2 = marker;
        if (marker2 == null) {
            marker2 = Marker.INSTANCE.getEXECUTION();
        }
        this.memoryLogger.at(level, marker2, block);
    }

    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable io.github.oshai.kotlinlogging.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.memoryLogger.isLoggingEnabledFor(level, marker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Notification> getAllNotifications() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.memoryLogger.getAllEvents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StoredLogEvent storedLogEvent = (StoredLogEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.eventToNotification((StoredLogEvent)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Notification> getConfigurationNotifications() {
        void $this$mapTo$iv$iv;
        StoredLogEvent it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.memoryLogger.getAllEvents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StoredLogEvent)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getMarker(), (Object)Marker.INSTANCE.getCONFIGURATION())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StoredLogEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.eventToNotification(it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Notification> getExecutionNotifications() {
        void $this$mapTo$iv$iv;
        StoredLogEvent it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.memoryLogger.getAllEvents();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (StoredLogEvent)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getMarker(), (Object)Marker.INSTANCE.getCONFIGURATION())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StoredLogEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.eventToNotification(it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Notification eventToNotification(@NotNull StoredLogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Instant instant = event.getTimeStamp();
        Message message = new Message(event.getMessage(), null, null, null, null, 30, null);
        NotificationLevel notificationLevel = switch (WhenMappings.$EnumSwitchMapping$0[event.getLevel().ordinal()]) {
            case 1 -> NotificationLevel.NOTE;
            case 2 -> NotificationLevel.WARNING;
            case 3 -> NotificationLevel.ERROR;
            default -> NotificationLevel.NONE;
        };
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PROPERTY_NAME_LEVEL_NAME, (Object)JsonElementKt.JsonPrimitive((String)event.getLevel().toString())), TuplesKt.to((Object)PROPERTY_NAME_LEVEL_INT, (Object)JsonElementKt.JsonPrimitive((Number)event.getLevel().toInt()))};
        JsonObject jsonObject = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
        return new Notification(null, message, notificationLevel, null, instant, null, null, null, jsonObject, 233, null);
    }

    public SarifLogger() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/mosaify/core/util/logging/SarifLogger$Companion;", "", "<init>", "()V", "PROPERTY_NAME_LEVEL_NAME", "", "PROPERTY_NAME_LEVEL_INT", "mosaify-util-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/mosaify/core/util/logging/SarifLogger$Marker;", "", "<init>", "()V", "EXECUTION", "Lio/github/oshai/kotlinlogging/Marker;", "getEXECUTION", "()Lio/github/oshai/kotlinlogging/Marker;", "CONFIGURATION", "getCONFIGURATION", "mosaify-util-common"})
    public static final class Marker {
        @NotNull
        public static final Marker INSTANCE = new Marker();
        @NotNull
        private static final io.github.oshai.kotlinlogging.Marker EXECUTION = KMarkerFactory.INSTANCE.getMarker("EXECUTION");
        @NotNull
        private static final io.github.oshai.kotlinlogging.Marker CONFIGURATION = KMarkerFactory.INSTANCE.getMarker("CONFIGURATION");

        private Marker() {
        }

        @NotNull
        public final io.github.oshai.kotlinlogging.Marker getEXECUTION() {
            return EXECUTION;
        }

        @NotNull
        public final io.github.oshai.kotlinlogging.Marker getCONFIGURATION() {
            return CONFIGURATION;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

