/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.storage;

import dev.mosaify.core.model.metadata.BasicProjectInfo;
import dev.mosaify.core.model.metadata.LogExtraInfo;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.sarif.Invocation;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.SarifLog;
import dev.mosaify.core.model.sarif.SarifLogVersion;
import dev.mosaify.core.model.scanner.ScanTarget;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.logging.SarifLogger;
import dev.mosaify.core.util.storage.Extensions;
import dev.mosaify.core.util.storage.model.Constants;
import dev.mosaify.core.util.storage.model.ResolvedScanRecord;
import dev.mosaify.core.util.storage.model.StorageMetadataRecord;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlin.uuid.Uuid;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u001d\u0010\u0014\u001a\u0017\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0018\u00a2\u0006\u0002\b\u0017H\u0002J%\u0010\u0019\u001a\u00020\u001a2\u001b\u0010\u001b\u001a\u0017\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0018\u00a2\u0006\u0002\b\u0017H\u0002JP\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020!0\u00152\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J=\u0010'\u001a\u0017\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0018\u00a2\u0006\u0002\b\u00172\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010*\u001a\u00020+J0\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0016\u0018\u00010-2\u0006\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010*\u001a\u00020+J:\u0010.\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/0%2\u0006\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010*\u001a\u00020+J6\u00102\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010%2\u0006\u0010(\u001a\u00020\u00032\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u00104\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Ldev/mosaify/core/util/storage/SarifStorage;", "", "storageDir", "", "storageMetaFile", "maxDepth", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILio/github/oshai/kotlinlogging/KLogger;)V", "resolveMetadataFile", "Lkotlinx/io/files/Path;", "resolveReportFile", "fileName", "readSarifLog", "Ldev/mosaify/core/model/sarif/SarifLog;", "path", "readReport", "key", "readMetadata", "", "Ldev/mosaify/core/util/storage/model/StorageMetadataRecord;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/util/storage/model/StorageMetadata;", "writeMetadata", "", "metadata", "storeReport", "projectName", "projectVersion", "aliases", "", "Ldev/mosaify/core/model/metadata/BasicProjectInfo;", "components", "Ldev/mosaify/core/model/scanner/ScanTarget;", "sarifRuns", "", "Ldev/mosaify/core/model/sarif/Run;", "getAll", "name", "version", "successfulOnly", "", "getLatestRecord", "Lkotlin/Pair;", "getLatestScanRecords", "Lkotlin/Triple;", "Ldev/mosaify/core/model/metadata/LogExtraInfo;", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "resolveLatestScans", "Ldev/mosaify/core/util/storage/model/ResolvedScanRecord;", "depth", "mosaify-util-storage"})
@SourceDebugExtension(value={"SMAP\nSarifStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SarifStorage.kt\ndev/mosaify/core/util/storage/SarifStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,277:1\n1#2:278\n1#2:291\n1#2:304\n1#2:317\n1#2:370\n222#3:279\n222#3:280\n1617#4,9:281\n1869#4:290\n1870#4:292\n1626#4:293\n1617#4,9:294\n1869#4:303\n1870#4:305\n1626#4:306\n1617#4,9:307\n1869#4:316\n1870#4:318\n1626#4:319\n1563#4:344\n1634#4,3:345\n1068#4:351\n1669#4,8:352\n1374#4:373\n1460#4,2:374\n827#4:376\n855#4,2:377\n1563#4:379\n1634#4,3:380\n1462#4,3:383\n536#5:320\n521#5,6:321\n536#5:327\n521#5,6:328\n536#5:334\n521#5,6:335\n77#6:341\n97#6,2:342\n99#6,3:348\n136#6,9:360\n216#6:369\n217#6:371\n145#6:372\n*S KotlinDebug\n*F\n+ 1 SarifStorage.kt\ndev/mosaify/core/util/storage/SarifStorage\n*L\n107#1:291\n109#1:304\n139#1:317\n235#1:370\n62#1:279\n70#1:280\n107#1:281,9\n107#1:290\n107#1:292\n107#1:293\n109#1:294,9\n109#1:303\n109#1:305\n109#1:306\n139#1:307,9\n139#1:316\n139#1:318\n139#1:319\n194#1:344\n194#1:345,3\n202#1:351\n203#1:352,8\n263#1:373\n263#1:374,2\n265#1:376\n265#1:377,2\n266#1:379\n266#1:380,3\n263#1:383,3\n159#1:320\n159#1:321,6\n160#1:327\n160#1:328,6\n161#1:334\n161#1:335,6\n193#1:341\n193#1:342,2\n193#1:348,3\n235#1:360,9\n235#1:369\n235#1:371\n235#1:372\n*E\n"})
public final class SarifStorage {
    @NotNull
    private final String storageDir;
    @NotNull
    private final String storageMetaFile;
    private final int maxDepth;
    @NotNull
    private final KLogger logger;

    public SarifStorage(@NotNull String storageDir, @NotNull String storageMetaFile, int maxDepth, @NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)storageMetaFile, (String)"storageMetaFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.storageDir = storageDir;
        this.storageMetaFile = storageMetaFile;
        this.maxDepth = maxDepth;
        this.logger = logger;
    }

    public /* synthetic */ SarifStorage(String string, String string2, int n, KLogger kLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "mosaify-storage";
        }
        if ((n2 & 2) != 0) {
            string2 = "metadata.json";
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        if ((n2 & 8) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger(SarifStorage::_init_$lambda$0);
        }
        this(string, string2, n, kLogger);
    }

    private final Path resolveMetadataFile() {
        String[] stringArray = new String[]{this.storageMetaFile};
        return PathsKt.Path((String)this.storageDir, (String[])stringArray);
    }

    private final Path resolveReportFile(String fileName) {
        String[] stringArray = new String[]{fileName + ".sarif.json"};
        return PathsKt.Path((String)this.storageDir, (String[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final SarifLog readSarifLog(Path path) {
        SarifLog sarifLog;
        AutoCloseable autoCloseable = (AutoCloseable)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path));
        Throwable throwable = null;
        try {
            void this_$iv;
            Source it = (Source)autoCloseable;
            boolean bl = false;
            Json json = CommonUtils.INSTANCE.getDefaultJson();
            String string$iv = Utf8Kt.readString((Source)it);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            sarifLog = (SarifLog)this_$iv.decodeFromString((DeserializationStrategy)SarifLog.Companion.serializer(), string$iv);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return sarifLog;
    }

    private final SarifLog readReport(String key) {
        return this.readSarifLog(this.resolveReportFile(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, StorageMetadataRecord> readMetadata() {
        Map map;
        Path path = this.resolveMetadataFile();
        boolean bl = false;
        if (!FileSystemJvmKt.SystemFileSystem.exists(path)) {
            map = Constants.INSTANCE.getMETADATA_EMPTY();
        } else {
            void string$iv;
            void this_$iv;
            String string;
            Json json = CommonUtils.INSTANCE.getDefaultJson();
            Object object = (AutoCloseable)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path));
            Throwable throwable = null;
            try {
                Source it = (Source)object;
                boolean bl2 = false;
                string = Utf8Kt.readString((Source)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = string;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            map = (Map)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, StorageMetadataRecord.Companion.serializer()), (String)string$iv);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMetadata(Map<String, StorageMetadataRecord> metadata) {
        Path it;
        Path path = this.resolveMetadataFile();
        boolean bl = false;
        Path path2 = path.getParent();
        if (path2 != null) {
            it = path2;
            boolean bl2 = false;
            FileSystemJvmKt.SystemFileSystem.createDirectories(it, false);
        }
        AutoCloseable autoCloseable = (AutoCloseable)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)path, (boolean)false, (int)2, null));
        Throwable throwable = null;
        try {
            it = (Sink)autoCloseable;
            boolean bl3 = false;
            Utf8Kt.writeString$default((Sink)it, (String)CommonUtils.INSTANCE.getDefaultJson().encodeToString((SerializationStrategy)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), StorageMetadataRecord.Companion.serializer()), metadata), (int)0, (int)0, (int)6, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void storeReport(@NotNull String projectName, @Nullable String projectVersion, @NotNull Set<? extends BasicProjectInfo> aliases, @NotNull Map<ScanTarget, ? extends BasicProjectInfo> components, @NotNull Collection<Run> sarifRuns) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list;
        Map metadata;
        String scanId;
        block21: {
            block20: {
                List runTimestamps;
                Iterable iterable;
                List it$iv$iv;
                boolean bl;
                boolean bl2;
                Object element$iv$iv;
                Object element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv2;
                Iterable $this$mapNotNull$iv2;
                Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
                Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
                Intrinsics.checkNotNullParameter(components, (String)"components");
                Intrinsics.checkNotNullParameter(sarifRuns, (String)"sarifRuns");
                if (!(!sarifRuns.isEmpty() || !components.isEmpty())) {
                    boolean $i$a$-require-SarifStorage$storeReport$22 = false;
                    String $i$a$-require-SarifStorage$storeReport$22 = "Project must have whether runs or components";
                    throw new IllegalArgumentException($i$a$-require-SarifStorage$storeReport$22.toString());
                }
                scanId = Uuid.Companion.random().toString();
                metadata = MapsKt.toMutableMap(this.readMetadata());
                if (metadata.get(scanId) != null) {
                    throw new Error("Unexpected: existing UUID '" + scanId + "'");
                }
                Iterable iterable2 = sarifRuns;
                boolean $i$f$mapNotNull = false;
                void var11_13 = $this$mapNotNull$iv2;
                Iterator destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    Run run = (Run)element$iv$iv;
                    boolean bl3 = false;
                    if (run.getInvocations() == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = CollectionsKt.flatten((Iterable)((List)((Object)destination$iv$iv)));
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv2 = $this$mapNotNull$iv2;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    Invocation it = (Invocation)element$iv$iv;
                    boolean bl4 = false;
                    if (it.getEndTimeUtc() == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)((Object)destination$iv$iv);
                if ($this$mapNotNull$iv2.isEmpty()) {
                    boolean bl5 = false;
                    iterable = null;
                } else {
                    iterable = $this$mapNotNull$iv2;
                }
                if ((list = (runTimestamps = (List)iterable)) == null) break block20;
                destination$iv$iv = ((Iterable)list).iterator();
                if (!destination$iv$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Instant it = (Instant)destination$iv$iv.next();
                boolean bl6 = false;
                Comparable comparable = (Comparable)it;
                while (destination$iv$iv.hasNext()) {
                    Object it2 = (Instant)destination$iv$iv.next();
                    $i$a$-maxOf-SarifStorage$storeReport$latestTimestamp$1 = false;
                    if (comparable.compareTo(it2 = (Comparable)it2) >= 0) continue;
                    comparable = it2;
                }
                list = (Instant)comparable;
                if (list != null) break block21;
            }
            list = Clock.System.INSTANCE.now();
        }
        List latestTimestamp = list;
        LogExtraInfo projectInfo = new LogExtraInfo((Instant)latestTimestamp, projectName, projectVersion, aliases, components);
        SarifLog sarifLog = new SarifLog("https://json.schemastore.org/sarif-2.1.0.json", SarifLogVersion._2_1_0, sarifRuns, null, new JsonObject(MapsKt.mapOf((Pair)projectInfo.asJsonField())), 8, null);
        Path report = this.resolveReportFile(scanId);
        Path path = report.getParent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            FileSystemJvmKt.SystemFileSystem.createDirectories(it, false);
        }
        Object object = (AutoCloseable)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)report, (boolean)false, (int)2, null));
        Object it2 = null;
        try {
            Sink it = (Sink)object;
            boolean bl = false;
            Utf8Kt.writeString$default((Sink)it, (String)CommonUtils.INSTANCE.getDefaultJson().encodeToString((SerializationStrategy)SarifLog.Companion.serializer(), (Object)sarifLog), (int)0, (int)0, (int)6, null);
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            it2 = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)it2);
        }
        object = metadata;
        it2 = sarifRuns;
        LogExtraInfo logExtraInfo = projectInfo;
        boolean $i$f$mapNotNull = false;
        void bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RunExtraInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl7 = false;
            Run it = (Run)element$iv$iv;
            boolean bl8 = false;
            if (RunExtraInfo.Companion.fromPropertyBag(it.getProperties()) == null) continue;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        boolean bl10 = !CommonUtils.INSTANCE.hasErrors(sarifRuns);
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        LogExtraInfo logExtraInfo2 = logExtraInfo;
        StorageMetadataRecord storageMetadataRecord = new StorageMetadataRecord(logExtraInfo2, set, bl10);
        object.put(scanId, storageMetadataRecord);
        this.writeMetadata(metadata);
    }

    public static /* synthetic */ void storeReport$default(SarifStorage sarifStorage, String string, String string2, Set set, Map map, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            collection = SetsKt.emptySet();
        }
        sarifStorage.storeReport(string, string2, set, map, collection);
    }

    @NotNull
    public final Map<String, StorageMetadataRecord> getAll(@Nullable String name, @Nullable String version, boolean successfulOnly) {
        Map.Entry it;
        Map.Entry element$iv$iv;
        Map $this$filterTo$iv$iv;
        Map $this$filter$iv;
        if (!(version == null || name != null)) {
            boolean $i$a$-require-SarifStorage$getAll$22 = false;
            String $i$a$-require-SarifStorage$getAll$22 = "Name must be provided with version";
            throw new IllegalArgumentException($i$a$-require-SarifStorage$getAll$22.toString());
        }
        Map<String, StorageMetadataRecord> map = this.readMetadata();
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!successfulOnly || ((StorageMetadataRecord)it.getValue()).isSuccessful())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(name == null || StringsKt.contentEquals((CharSequence)((StorageMetadataRecord)it.getValue()).getLogExtraInfo().getName(), (CharSequence)name, (boolean)true))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(version == null || StringsKt.contentEquals((CharSequence)((StorageMetadataRecord)it.getValue()).getLogExtraInfo().getVersion(), (CharSequence)version, (boolean)true))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map getAll$default(SarifStorage sarifStorage, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return sarifStorage.getAll(string, string2, bl);
    }

    @Nullable
    public final Pair<String, StorageMetadataRecord> getLatestRecord(@NotNull String name, @Nullable String version, boolean successfulOnly) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Extensions.INSTANCE.latestOrNull(this.getAll(name, version, successfulOnly));
    }

    public static /* synthetic */ Pair getLatestRecord$default(SarifStorage sarifStorage, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return sarifStorage.getLatestRecord(string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Triple<String, LogExtraInfo, RunExtraInfo>> getLatestScanRecords(@NotNull String name, @Nullable String version, boolean successfulOnly) {
        void $this$distinctBy$iv;
        Iterable $this$sortedByDescending$iv;
        Triple element$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, StorageMetadataRecord> map = this.getAll(name, version, successfulOnly);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Triple triple = element$iv$iv = iterator.next();
            boolean bl = false;
            String id = (String)triple.getKey();
            StorageMetadataRecord metadata = (StorageMetadataRecord)triple.getValue();
            Iterable $this$map$iv = metadata.getRunExtraInfo();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void runExtraInfo;
                RunExtraInfo runExtraInfo2 = (RunExtraInfo)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new Triple((Object)id, (Object)metadata.getLogExtraInfo(), (Object)runExtraInfo));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Triple triple = (Triple)b;
                boolean bl = false;
                LogExtraInfo logExtraInfo = (LogExtraInfo)triple.component2();
                triple = (Triple)a;
                Comparable comparable = (Comparable)logExtraInfo.getTimestamp();
                bl = false;
                logExtraInfo = (LogExtraInfo)triple.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)logExtraInfo.getTimestamp()));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String string;
            element$iv$iv = (Triple)e$iv;
            boolean bl = false;
            RunExtraInfo runExtraInfo = (RunExtraInfo)element$iv$iv.component3();
            String string2 = runExtraInfo.getScanner();
            if (string2 != null) {
                String string3 = string2.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                string = null;
            }
            if (!set$iv.add(key$iv = string)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    public static /* synthetic */ Collection getLatestScanRecords$default(SarifStorage sarifStorage, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return sarifStorage.getLatestScanRecords(string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Collection<ResolvedScanRecord> resolveLatestScans(@NotNull String name, @Nullable String version, boolean successfulOnly, int depth) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (depth > this.maxDepth) {
            this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> SarifStorage.resolveLatestScans$lambda$0(depth));
            collection = null;
        } else {
            List list;
            Pair<String, StorageMetadataRecord> pair = this.getLatestRecord(name, version, successfulOnly);
            if (pair != null) {
                Pair<String, StorageMetadataRecord> pair2 = pair;
                boolean bl = false;
                StorageMetadataRecord latestMetadata = (StorageMetadataRecord)pair2.component2();
                if (!latestMetadata.getLogExtraInfo().getComponents().isEmpty()) {
                    void $this$mapNotNullTo$iv$iv;
                    this.logger.debug(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> SarifStorage.resolveLatestScans$lambda$1$0(latestMetadata));
                    Map $this$mapNotNull$iv = latestMetadata.getLogExtraInfo().getComponents();
                    boolean $i$f$mapNotNull = false;
                    Map map = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Collection<ResolvedScanRecord> it$iv$iv;
                        Map.Entry element$iv$iv$iv;
                        Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry it = element$iv$iv;
                        boolean bl3 = false;
                        Collection<ResolvedScanRecord> scans = this.resolveLatestScans(((BasicProjectInfo)it.getValue()).getName(), ((BasicProjectInfo)it.getValue()).getVersion(), successfulOnly, depth + 1);
                        if (scans == null) {
                            this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> SarifStorage.resolveLatestScans$lambda$1$1$0(name, version));
                        }
                        if (scans == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                } else {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    this.logger.debug(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> SarifStorage.resolveLatestScans$lambda$1$2(latestMetadata));
                    Iterable $this$mapNotNull$iv = this.getLatestScanRecords(latestMetadata.getLogExtraInfo().getName(), latestMetadata.getLogExtraInfo().getVersion(), successfulOnly);
                    boolean $i$f$flatMap = false;
                    void $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Run run;
                        void $this$filterNotTo$iv$iv;
                        Iterable $this$filterNot$iv;
                        Triple triple = (Triple)element$iv$iv;
                        boolean bl5 = false;
                        String id = (String)triple.component1();
                        LogExtraInfo logExtraInfo = (LogExtraInfo)triple.component2();
                        RunExtraInfo runExtraInfo = (RunExtraInfo)triple.component3();
                        Iterable bl3 = this.readReport(id).getRuns();
                        boolean $i$f$filterNot = false;
                        void it$iv$iv = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                            run = (Run)element$iv$iv2;
                            boolean bl6 = false;
                            if (CommonUtils.INSTANCE.hasErrors(run)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        $this$filterNot$iv = (List)destination$iv$iv2;
                        boolean $i$f$map = false;
                        $this$filterNotTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            run = (Run)item$iv$iv;
                            Collection collection2 = destination$iv$iv2;
                            boolean bl7 = false;
                            collection2.add(new ResolvedScanRecord(logExtraInfo, runExtraInfo, run));
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
            } else {
                list = null;
            }
            collection = list;
        }
        return collection;
    }

    public static /* synthetic */ Collection resolveLatestScans$default(SarifStorage sarifStorage, String string, String string2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return sarifStorage.resolveLatestScans(string, string2, bl, n);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object resolveLatestScans$lambda$0(int $depth) {
        return "Reached max depth of " + $depth + " while resolving project component scan results. Resolution stops here, please report this issue.";
    }

    private static final Object resolveLatestScans$lambda$1$0(StorageMetadataRecord $latestMetadata) {
        String string = $latestMetadata.getLogExtraInfo().getName();
        String string2 = $latestMetadata.getLogExtraInfo().getVersion();
        if (string2 == null) {
            string2 = $latestMetadata.getLogExtraInfo().getTimestamp();
        }
        return string + " @ " + string2 + " is a complex project. Resolving component scans starting with the latest stored metadata.";
    }

    private static final Object resolveLatestScans$lambda$1$1$0(String $name, String $version) {
        return "Could not resolve reports for project " + $name + " @ " + $version;
    }

    private static final Object resolveLatestScans$lambda$1$2(StorageMetadataRecord $latestMetadata) {
        String string = $latestMetadata.getLogExtraInfo().getName();
        String string2 = $latestMetadata.getLogExtraInfo().getVersion();
        if (string2 == null) {
            string2 = $latestMetadata.getLogExtraInfo().getTimestamp();
        }
        return string + " @ " + string2 + " is a component. Resolving sibling scans.";
    }

    public SarifStorage() {
        this(null, null, 0, null, 15, null);
    }
}

