/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.exporter.generic;

import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueLocation;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.report.ReportExporter;
import dev.mosaify.core.model.sarif.ArtifactLocation;
import dev.mosaify.core.model.sarif.Location;
import dev.mosaify.core.model.sarif.Message;
import dev.mosaify.core.model.sarif.MultiformatMessageString;
import dev.mosaify.core.model.sarif.PhysicalLocation;
import dev.mosaify.core.model.sarif.Region;
import dev.mosaify.core.model.sarif.ReportingConfiguration;
import dev.mosaify.core.model.sarif.ReportingDescriptor;
import dev.mosaify.core.model.sarif.ReportingDescriptorReference;
import dev.mosaify.core.model.sarif.Result;
import dev.mosaify.core.model.sarif.ResultBaselineState;
import dev.mosaify.core.model.sarif.ResultKind;
import dev.mosaify.core.model.sarif.ResultLevel;
import dev.mosaify.core.model.sarif.ResultProvenance;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.SarifLog;
import dev.mosaify.core.model.sarif.SarifLogVersion;
import dev.mosaify.core.model.sarif.Tool;
import dev.mosaify.core.model.sarif.ToolComponent;
import dev.mosaify.core.model.sarif.WebRequest;
import dev.mosaify.core.model.sarif.WebResponse;
import dev.mosaify.guesswork.utils.AdjustedPath;
import dev.mosaify.guesswork.utils.AdjustedPathResult;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.Sink;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\bH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J/\u0010\u0018\u001a\u00020\u00192\u0015\u0010\u001a\u001a\u0011\u0012\u0004\u0012\u00020\u001b0\fj\u0002`\u001d\u00a2\u0006\u0002\b\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001f\u0010!\u001a\u00020\"2\u0015\u0010\u001a\u001a\u0011\u0012\u0004\u0012\u00020\u001b0\fj\u0002`\u001d\u00a2\u0006\u0002\b\u001cH\u0002J7\u0010#\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0$2\u0015\u0010\u001a\u001a\u0011\u0012\u0004\u0012\u00020\u001b0\fj\u0002`\u001d\u00a2\u0006\u0002\b\u001cH\u0002J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020'0$2\u0006\u0010)\u001a\u00020\u001bH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010)\u001a\u00020\u001bH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Ldev/mosaify/core/exporter/generic/GenericExporterSarif;", "Ldev/mosaify/core/model/report/ReportExporter;", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "allNames", "", "", "PROPERTY_NAME_GENERIC_ISSUE_VALUES", "getName", "getAllNames", "", "jsonPretty", "Lkotlinx/serialization/json/Json;", "getJsonPretty", "()Lkotlinx/serialization/json/Json;", "jsonPretty$delegate", "Lkotlin/Lazy;", "json", "Lkotlinx/serialization/json/Json$Default;", "getJson", "()Lkotlinx/serialization/json/Json$Default;", "json$delegate", "export", "", "report", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "path", "prettyPrint", "", "genericToSarif", "Ldev/mosaify/core/model/sarif/SarifLog;", "reportToSarifResults", "Lkotlin/Pair;", "Ldev/mosaify/core/model/sarif/Result;", "", "Ldev/mosaify/core/model/sarif/ReportingDescriptor;", "genericIssueToSarifResult", "issue", "calculateSarifLevel", "Ldev/mosaify/core/model/sarif/ResultLevel;", "genericLocationToSarif", "Ldev/mosaify/core/model/sarif/Location;", "location", "Ldev/mosaify/core/model/generic/IssueLocation;", "mosaify-exporter-sarif"})
@SourceDebugExtension(value={"SMAP\nGenericExporterSarif.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericExporterSarif.kt\ndev/mosaify/core/exporter/generic/GenericExporterSarif\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n205#2:202\n1563#3:203\n1634#3,3:204\n1563#3:207\n1634#3,3:208\n324#4:211\n1#5:212\n*S KotlinDebug\n*F\n+ 1 GenericExporterSarif.kt\ndev/mosaify/core/exporter/generic/GenericExporterSarif\n*L\n58#1:202\n91#1:203\n91#1:204,3\n140#1:207\n140#1:208,3\n150#1:211\n*E\n"})
public final class GenericExporterSarif
implements ReportExporter {
    @NotNull
    public static final GenericExporterSarif INSTANCE = new GenericExporterSarif();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(GenericExporterSarif::logger$lambda$0);
    @NotNull
    private static final List<String> allNames = CollectionsKt.listOf((Object)"SARIF");
    @NotNull
    private static final String PROPERTY_NAME_GENERIC_ISSUE_VALUES = "mosaify-issue";
    @NotNull
    private static final Lazy jsonPretty$delegate = LazyKt.lazy(GenericExporterSarif::jsonPretty_delegate$lambda$0);
    @NotNull
    private static final Lazy json$delegate = LazyKt.lazy(GenericExporterSarif::json_delegate$lambda$0);

    private GenericExporterSarif() {
    }

    @NotNull
    public String getName() {
        return (String)CollectionsKt.first(allNames);
    }

    @NotNull
    public Collection<String> getAllNames() {
        return allNames;
    }

    private final Json getJsonPretty() {
        Lazy lazy = jsonPretty$delegate;
        return (Json)lazy.getValue();
    }

    private final Json.Default getJson() {
        Lazy lazy = json$delegate;
        return (Json.Default)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void export(@NotNull Collection<Issue> report, @NotNull String path, boolean prettyPrint) {
        Intrinsics.checkNotNullParameter(report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Json jsonEncoder = prettyPrint ? this.getJsonPretty() : (Json)this.getJson();
        AutoCloseable autoCloseable = (AutoCloseable)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)PathsJvmKt.Path((String)path), (boolean)false, (int)2, null));
        Throwable throwable = null;
        try {
            void this_$iv;
            Sink sink = (Sink)autoCloseable;
            boolean bl = false;
            Json json = jsonEncoder;
            SarifLog value$iv = INSTANCE.genericToSarif(report);
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            Utf8Kt.writeString$default((Sink)sink, (String)this_$iv.encodeToString((SerializationStrategy)SarifLog.Companion.serializer(), (Object)value$iv), (int)0, (int)0, (int)6, null);
            sink.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final SarifLog genericToSarif(Collection<Issue> report) {
        Pair<List<Result>, Set<ReportingDescriptor>> pair = this.reportToSarifResults(report);
        List results = (List)pair.component1();
        Set rules = (Set)pair.component2();
        Tool tool = new Tool(new ToolComponent(null, "Mosaify SARIF Report Exporter", null, null, null, new MultiformatMessageString("Generic Mosaify report", null, null, 6, null), null, null, null, null, null, null, null, null, null, null, rules, null, null, null, null, null, null, null, null, null, null, null, 0xFFEFFDD, null), null, null, 6, null);
        return new SarifLog("https://json.schemastore.org/sarif-2.1.0.json", SarifLogVersion._2_1_0, (Collection)CollectionsKt.listOf((Object)new Run(tool, null, null, null, null, null, null, null, null, results, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0xFFFFDFE, null)), null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Result>, Set<ReportingDescriptor>> reportToSarifResults(Collection<Issue> report) {
        void $this$mapTo$iv$iv;
        Map rules = new LinkedHashMap();
        Iterable $this$map$iv = report;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void issue;
            Issue issue2 = (Issue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<Result, ReportingDescriptor> pair = INSTANCE.genericIssueToSarifResult((Issue)issue);
            Result result = (Result)pair.component1();
            ReportingDescriptor rule = (ReportingDescriptor)pair.component2();
            if ((ReportingDescriptor)rules.get(rule.getId()) != null) {
                ReportingDescriptor existingRule;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)existingRule, (Object)rule)) {
                    logger.warn(() -> GenericExporterSarif.reportToSarifResults$lambda$0$0$0(rule));
                }
                rules.put(rule.getId(), rule);
            }
            collection.add(result);
        }
        List results = (List)destination$iv$iv;
        return new Pair((Object)results, (Object)CollectionsKt.toSet((Iterable)rules.values()));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Result, ReportingDescriptor> genericIssueToSarifResult(Issue issue) {
        void $this$encodeToJsonElement$iv;
        Collection<Location> collection;
        Collection<Location> collection2;
        void $this$mapTo$iv$iv;
        Object $this$map$iv;
        CharSequence charSequence = new StringBuilder();
        Object $this$genericIssueToSarifResult_u24lambda_u240 = charSequence;
        boolean $i$a$-buildString-GenericExporterSarif$genericIssueToSarifResult$rule$22 = false;
        ((StringBuilder)$this$genericIssueToSarifResult_u24lambda_u240).append("mosaify-export");
        if (!((Collection)issue.getDetectedBy()).isEmpty()) {
            ((StringBuilder)$this$genericIssueToSarifResult_u24lambda_u240).append("-");
            ((StringBuilder)$this$genericIssueToSarifResult_u24lambda_u240).append(CollectionsKt.joinToString$default((Iterable)issue.getDetectedBy(), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)issue.getIdentifiers()).isEmpty()) {
            ((StringBuilder)$this$genericIssueToSarifResult_u24lambda_u240).append("-");
            ((StringBuilder)$this$genericIssueToSarifResult_u24lambda_u240).append(CollectionsKt.joinToString$default((Iterable)issue.getIdentifiers(), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null));
        }
        charSequence = charSequence.toString();
        $this$genericIssueToSarifResult_u24lambda_u240 = new Regex("\\s+");
        String $i$a$-buildString-GenericExporterSarif$genericIssueToSarifResult$rule$22 = "-";
        String string = $this$genericIssueToSarifResult_u24lambda_u240.replace(charSequence, $i$a$-buildString-GenericExporterSarif$genericIssueToSarifResult$rule$22);
        MultiformatMessageString multiformatMessageString = new MultiformatMessageString(issue.getSummary(), null, null, 6, null);
        String string2 = issue.getDescription();
        if (string2 == null) {
            string2 = "No additional details provided";
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 14142;
        JsonObject jsonObject = null;
        Set set = null;
        MultiformatMessageString multiformatMessageString2 = new MultiformatMessageString("TODO: THIS IS PUT NEXT TO THE RESULT IN THE UI", null, null, 6, null);
        String string3 = null;
        ReportingConfiguration reportingConfiguration = null;
        Map map = null;
        MultiformatMessageString multiformatMessageString3 = new MultiformatMessageString(string2, null, null, 6, null);
        MultiformatMessageString multiformatMessageString4 = multiformatMessageString;
        Set set2 = null;
        String string4 = null;
        Set set3 = null;
        String string5 = null;
        Set set4 = null;
        String string6 = string;
        ReportingDescriptor rule = new ReportingDescriptor(string6, set4, string5, set3, string4, set2, multiformatMessageString4, multiformatMessageString3, map, reportingConfiguration, string3, multiformatMessageString2, set, jsonObject, n, defaultConstructorMarker);
        $this$genericIssueToSarifResult_u24lambda_u240 = issue.getLocations();
        ArtifactLocation artifactLocation = null;
        Message message = new Message(issue.getSummary(), null, null, null, null, 30, null);
        ResultLevel resultLevel = this.calculateSarifLevel(issue);
        ResultKind resultKind = null;
        ReportingDescriptorReference reportingDescriptorReference = null;
        Integer n2 = null;
        String string7 = rule.getId();
        boolean $i$f$map = false;
        void var6_32 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IssueLocation issueLocation = (IssueLocation)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(INSTANCE.genericLocationToSarif((IssueLocation)it));
        }
        collection2 = (List)destination$iv$iv;
        String string8 = string7;
        Integer n3 = n2;
        ReportingDescriptorReference reportingDescriptorReference2 = reportingDescriptorReference;
        ResultKind resultKind2 = resultKind;
        ResultLevel resultLevel2 = resultLevel;
        Message message2 = message;
        ArtifactLocation artifactLocation2 = artifactLocation;
        $this$map$iv = collection2;
        if ($this$map$iv.isEmpty()) {
            artifactLocation = artifactLocation2;
            message = message2;
            resultLevel = resultLevel2;
            resultKind = resultKind2;
            reportingDescriptorReference = reportingDescriptorReference2;
            n2 = n3;
            string7 = string8;
            boolean bl = false;
            collection2 = CollectionsKt.listOf((Object)INSTANCE.genericLocationToSarif(new IssueLocation("file://package.json", null, 2, null)));
            string8 = string7;
            n3 = n2;
            reportingDescriptorReference2 = reportingDescriptorReference;
            resultKind2 = resultKind;
            resultLevel2 = resultLevel;
            message2 = message;
            artifactLocation2 = artifactLocation;
            collection = collection2;
        } else {
            collection = $this$map$iv;
        }
        List list = (List)collection;
        $this$map$iv = (Json)Json.Default;
        Issue value$iv = issue;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n4 = 536870734;
        JsonObject jsonObject2 = new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)PROPERTY_NAME_GENERIC_ISSUE_VALUES, (Object)$this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)Issue.Companion.serializer(), (Object)value$iv))));
        WebResponse webResponse = null;
        WebRequest webRequest = null;
        Set set5 = null;
        Set set6 = null;
        ResultProvenance resultProvenance = null;
        Set set7 = null;
        String string9 = null;
        Set set8 = null;
        Double d = null;
        ResultBaselineState resultBaselineState = null;
        Set set9 = null;
        Set set10 = null;
        Set set11 = null;
        Set set12 = null;
        List list2 = null;
        Set set13 = null;
        Map map2 = null;
        Map map3 = null;
        Integer n5 = null;
        String string10 = null;
        String string11 = null;
        List list3 = list;
        ArtifactLocation artifactLocation3 = artifactLocation2;
        Message message3 = message2;
        ResultLevel resultLevel3 = resultLevel2;
        ResultKind resultKind3 = resultKind2;
        ReportingDescriptorReference reportingDescriptorReference3 = reportingDescriptorReference2;
        Integer n6 = n3;
        String string12 = string8;
        Result result = new Result(string12, n6, reportingDescriptorReference3, resultKind3, resultLevel3, message3, artifactLocation3, list3, string11, string10, n5, map3, map2, set13, list2, set12, set11, set10, set9, resultBaselineState, d, set8, string9, set7, resultProvenance, set6, set5, webRequest, webResponse, jsonObject2, n4, defaultConstructorMarker2);
        return TuplesKt.to((Object)result, (Object)rule);
    }

    private final ResultLevel calculateSarifLevel(Issue issue) {
        IssueSeverity severity;
        IssueSeverity issueSeverity = issue.getSeverity();
        if (issueSeverity == null) {
            CvssInfo cvssInfo = issue.getCvssInfo();
            if (cvssInfo != null) {
                double it = cvssInfo.getCvssScore();
                boolean bl = false;
                issueSeverity = IssueSeverity.Companion.fromCvssScore(it);
            } else {
                issueSeverity = null;
            }
        }
        IssueSeverity issueSeverity2 = severity = issueSeverity;
        return switch (issueSeverity2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[issueSeverity2.ordinal()]) {
            case -1 -> ResultLevel.WARNING;
            case 1 -> ResultLevel.NONE;
            case 2 -> ResultLevel.NOTE;
            case 3 -> ResultLevel.WARNING;
            case 4, 5 -> ResultLevel.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Location genericLocationToSarif(IssueLocation location) {
        String newLocation;
        AdjustedPathResult adjustedPathResult = AdjustedPath.of$default((AdjustedPath)new AdjustedPath(logger), (String)location.getPath(), null, (int)2, null);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)adjustedPathResult.isWindows(), (Object)true)) {
            Collection collection = adjustedPathResult.getSegments();
            Intrinsics.checkNotNull((Object)collection);
            v1 = "file://" + CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        } else {
            v1 = newLocation = adjustedPathResult.getAdjustedPath();
        }
        if (StringsKt.startsWith$default((String)newLocation, (String)"http", (boolean)false, (int)2, null)) {
            newLocation = "package.json";
        }
        Integer n = location.getLineNumber();
        Integer n2 = location.getLineNumber();
        return new Location(null, new PhysicalLocation(null, new ArtifactLocation(newLocation, null, null, null, null, 30, null), new Region(Integer.valueOf(n != null ? n : 1), Integer.valueOf(1), Integer.valueOf(n2 != null ? n2 : 1), Integer.valueOf(1), null, null, null, null, null, null, null, null, 4080, null), null, null, 25, null), null, null, null, null, null, 125, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Json jsonPretty_delegate$lambda$0() {
        return JsonKt.Json$default(null, GenericExporterSarif::jsonPretty_delegate$lambda$0$0, (int)1, null);
    }

    private static final Unit jsonPretty_delegate$lambda$0$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Json.Default json_delegate$lambda$0() {
        return Json.Default;
    }

    private static final Object reportToSarifResults$lambda$0$0$0(ReportingDescriptor $rule) {
        return "Overwriting rule '" + $rule.getId() + "' with new data";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IssueSeverity.values().length];
            try {
                nArray[IssueSeverity.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSeverity.LOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSeverity.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSeverity.CRITICAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueSeverity.HIGH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

