/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.container;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.mosaify.core.model.RunLog;
import dev.mosaify.core.util.container.ContainerController;
import dev.mosaify.core.util.container.ContainerController_jvmKt;
import dev.mosaify.core.util.container.model.ImageMetadata;
import dev.mosaify.core.util.logging.SarifLogger;
import dev.mosaify.core.util.platform.TempPath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a`\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0000\u001a \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a \u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a \u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0000\u001a\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\bH\u0000\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\bH\u0000\u001a\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\bH\u0000\u001a$\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020)H\u0000\u001a\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0000\u001a*\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020!0-0\u000e2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0000\u001a\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"dockerConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "kotlin.jvm.PlatformType", "dockerClient", "Lcom/github/dockerjava/api/DockerClient;", "pullImageImpl", "", "imageName", "", "inspectImageImpl", "Ldev/mosaify/core/util/container/model/ImageMetadata;", "createContainerImpl", "image", "environment", "", "command", "networkMode", "binds", "", "user", "createDirectoriesInContainerImpl", "containerId", "absolutePaths", "addTarArchiveToContainerImpl", "remotePath", "tarInputStream", "Ljava/io/InputStream;", "addTarGzArchiveToContainerImpl", "path", "pathToBytes", "Lkotlinx/io/files/Path;", "createFileInContainerImpl", "bytes", "", "startContainerImpl", "waitContainerImpl", "", "removeContainerImpl", "logContainerImpl", "Ldev/mosaify/core/model/RunLog;", "withStdOut", "", "withStdErr", "copyArchiveFromContainer", "getFilesFromContainerImpl", "Lkotlin/Pair;", "removeImageImpl", "mosaify-util-container"})
@SourceDebugExtension(value={"SMAP\nContainerController.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerController.jvm.kt\ndev/mosaify/core/util/container/ContainerController_jvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n1#2:366\n126#3:367\n153#3,3:368\n1869#4,2:371\n*S KotlinDebug\n*F\n+ 1 ContainerController.jvm.kt\ndev/mosaify/core/util/container/ContainerController_jvmKt\n*L\n82#1:367\n82#1:368,3\n107#1:371,2\n*E\n"})
public final class ContainerController_jvmKt {
    private static final DefaultDockerClientConfig dockerConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    @NotNull
    private static final DockerClient dockerClient;

    public static final void pullImageImpl(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        dockerClient.pullImageCmd(imageName).start().awaitCompletion();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ImageMetadata inspectImageImpl(@NotNull String imageName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        try {
            Instant instant;
            boolean bl = false;
            InspectImageResponse $this$inspectImageImpl_u24lambda_u240_u240 = dockerClient.inspectImageCmd(imageName).exec();
            boolean bl2 = false;
            String string = $this$inspectImageImpl_u24lambda_u240_u240.getId();
            Collection collection = $this$inspectImageImpl_u24lambda_u240_u240.getRepoTags();
            Collection collection2 = $this$inspectImageImpl_u24lambda_u240_u240.getRepoDigests();
            String string2 = $this$inspectImageImpl_u24lambda_u240_u240.getCreated();
            if (string2 != null) {
                void it;
                String string3 = string2;
                Collection collection3 = collection2;
                Collection collection4 = collection;
                String string4 = string;
                boolean bl3 = false;
                Instant instant2 = Instant.Companion.parse((CharSequence)it);
                string = string4;
                collection = collection4;
                collection2 = collection3;
                instant = instant2;
            } else {
                instant = null;
            }
            Long l = $this$inspectImageImpl_u24lambda_u240_u240.getSize();
            String string5 = $this$inspectImageImpl_u24lambda_u240_u240.getOs();
            String string6 = $this$inspectImageImpl_u24lambda_u240_u240.getArch();
            Instant instant3 = instant;
            Collection collection5 = collection2;
            Collection collection6 = collection;
            String string7 = string;
            object = Result.constructor-impl((Object)new ImageMetadata(string7, collection6, collection5, instant3, string6, string5, l));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (ImageMetadata)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createContainerImpl(@NotNull String image, @NotNull Collection<String> environment, @NotNull Collection<String> command, @Nullable String networkMode, @Nullable Map<String, String> binds, @Nullable String user) {
        HostConfig hostConfig;
        Object it;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        HostConfig $this$createContainerImpl_u24lambda_u240 = HostConfig.newHostConfig();
        boolean bl = false;
        String string = networkMode;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$createContainerImpl_u24lambda_u240.withNetworkMode((String)it);
        }
        Map<String, String> map = binds;
        if (map != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            it = map;
            boolean bl3 = false;
            Object object = it;
            HostConfig hostConfig2 = $this$createContainerImpl_u24lambda_u240;
            boolean $i$f$map = false;
            void var14_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                collection.add(new Bind(k, new Volume(v)));
            }
            hostConfig = hostConfig2.withBinds((List)destination$iv$iv);
        } else {
            hostConfig = null;
        }
        HostConfig hostConfig3 = hostConfig;
        CreateContainerCmd $this$createContainerImpl_u24lambda_u241 = dockerClient.createContainerCmd(image);
        boolean bl5 = false;
        $this$createContainerImpl_u24lambda_u241.withHostConfig(hostConfig3);
        String string2 = user;
        if (string2 != null) {
            String user2 = string2;
            boolean bl6 = false;
            $this$createContainerImpl_u24lambda_u241.withUser(user2);
        }
        $this$createContainerImpl_u24lambda_u241.withEnv(CollectionsKt.toList((Iterable)environment));
        $this$createContainerImpl_u24lambda_u241.withCmd(CollectionsKt.toList((Iterable)command));
        String string3 = $this$createContainerImpl_u24lambda_u241.exec().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"run(...)");
        return string3;
    }

    public static /* synthetic */ String createContainerImpl$default(String string, Collection collection, Collection collection2, String string2, Map map, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            string2 = "host";
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/run/docker.sock", (Object)"/var/run/docker.sock"));
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return ContainerController_jvmKt.createContainerImpl(string, collection, collection2, string2, map, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createDirectoriesInContainerImpl(@NotNull String containerId, @NotNull Collection<String> absolutePaths) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter(absolutePaths, (String)"absolutePaths");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveOutputStream((OutputStream)byteArrayOutputStream);
            Throwable throwable2 = null;
            try {
                TarArchiveOutputStream tarArchiveOutputStream = (TarArchiveOutputStream)closeable2;
                boolean bl2 = false;
                tarArchiveOutputStream.setLongFileMode(3);
                Iterable $this$forEach$iv = absolutePaths;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String directory = (String)element$iv;
                    boolean bl3 = false;
                    tarArchiveOutputStream.putArchiveEntry(new TarArchiveEntry((String)(StringsKt.endsWith$default((CharSequence)directory, (char)'/', (boolean)false, (int)2, null) ? directory : directory + "/")));
                    tarArchiveOutputStream.closeArchiveEntry();
                }
                tarArchiveOutputStream.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            ContainerController_jvmKt.addTarArchiveToContainerImpl(containerId, "/", new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addTarArchiveToContainerImpl(@NotNull String containerId, @NotNull String remotePath, @NotNull InputStream tarInputStream) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)tarInputStream, (String)"tarInputStream");
        Closeable closeable = tarInputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Void void_ = dockerClient.copyArchiveToContainerCmd(containerId).withRemotePath(remotePath).withTarInputStream(it).exec();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addTarGzArchiveToContainerImpl(@NotNull String containerId, @NotNull String path, @NotNull Path pathToBytes) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathToBytes, (String)"pathToBytes");
        Closeable closeable = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(pathToBytes)));
        Throwable throwable = null;
        try {
            InputStream tarGzInputStream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorInputStream(tarGzInputStream);
            Throwable throwable2 = null;
            try {
                GzipCompressorInputStream it = (GzipCompressorInputStream)closeable2;
                boolean bl2 = false;
                ContainerController_jvmKt.addTarArchiveToContainerImpl(containerId, path, (InputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void createFileInContainerImpl(@NotNull String containerId, @NotNull String path, @NotNull Path pathToBytes) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathToBytes, (String)"pathToBytes");
        FileMetadata fileMetadata = FileSystemJvmKt.SystemFileSystem.metadataOrNull(pathToBytes);
        if (!(fileMetadata != null && fileMetadata.isRegularFile())) {
            boolean bl = false;
            String string = "'" + pathToBytes + "' must be a regular file";
            throw new IllegalArgumentException(string.toString());
        }
        TempPath tempFile = new TempPath(null, null, false, 7, null);
        Closeable closeable = SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)tempFile.getPath(), (boolean)false, (int)2, null)));
        Throwable throwable = null;
        try {
            OutputStream outputStream = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveOutputStream(outputStream);
            Throwable throwable2 = null;
            try {
                void $this$createFileInContainerImpl_u24lambda_u241_u240_u241;
                Object object;
                TarArchiveOutputStream tarArchiveOutputStream = (TarArchiveOutputStream)closeable2;
                boolean bl2 = false;
                tarArchiveOutputStream.setLongFileMode(3);
                ContainerController.INSTANCE.getLogger$mosaify_util_container().trace(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ContainerController_jvmKt.createFileInContainerImpl$lambda$1$0$0(pathToBytes));
                Path parentDirectory = PathsJvmKt.Path((String)path).getParent();
                if (parentDirectory != null) {
                    tarArchiveOutputStream.putArchiveEntry(new TarArchiveEntry(parentDirectory + "/"));
                    tarArchiveOutputStream.closeArchiveEntry();
                }
                Object object2 = object = new TarArchiveEntry(path);
                TarArchiveOutputStream tarArchiveOutputStream2 = tarArchiveOutputStream;
                boolean bl3 = false;
                $this$createFileInContainerImpl_u24lambda_u241_u240_u241.setSize(fileMetadata.getSize());
                tarArchiveOutputStream2.putArchiveEntry(object);
                object = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(pathToBytes)));
                object2 = null;
                try {
                    InputStream it = (InputStream)object;
                    boolean bl4 = false;
                    long l = it.transferTo((OutputStream)tarArchiveOutputStream);
                }
                catch (Throwable throwable3) {
                    object2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                tarArchiveOutputStream.closeArchiveEntry();
                tarArchiveOutputStream.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            outputStream = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(tempFile.getPath())));
        throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            ContainerController_jvmKt.addTarArchiveToContainerImpl(containerId, "/", inputStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void createFileInContainerImpl(@NotNull String containerId, @NotNull String path, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveOutputStream((OutputStream)byteArrayOutputStream);
            Throwable throwable2 = null;
            try {
                void $this$createFileInContainerImpl_u24lambda_u243_u240_u240;
                TarArchiveEntry tarArchiveEntry;
                TarArchiveOutputStream tarArchiveOutputStream = (TarArchiveOutputStream)closeable2;
                boolean bl2 = false;
                tarArchiveOutputStream.setLongFileMode(3);
                Path parentDirectory = PathsJvmKt.Path((String)path).getParent();
                if (parentDirectory != null) {
                    tarArchiveOutputStream.putArchiveEntry(new TarArchiveEntry(parentDirectory + "/"));
                    tarArchiveOutputStream.closeArchiveEntry();
                }
                TarArchiveEntry tarArchiveEntry2 = tarArchiveEntry = new TarArchiveEntry(path);
                TarArchiveOutputStream tarArchiveOutputStream2 = tarArchiveOutputStream;
                boolean bl3 = false;
                $this$createFileInContainerImpl_u24lambda_u243_u240_u240.setSize((long)bytes.length);
                tarArchiveOutputStream2.putArchiveEntry(tarArchiveEntry);
                tarArchiveOutputStream.write(bytes);
                tarArchiveOutputStream.closeArchiveEntry();
                tarArchiveOutputStream.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            ContainerController_jvmKt.addTarArchiveToContainerImpl(containerId, "/", new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void startContainerImpl(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        dockerClient.startContainerCmd(containerId).exec();
    }

    public static final int waitContainerImpl(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Integer n = dockerClient.waitContainerCmd(containerId).start().awaitStatusCode();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"awaitStatusCode(...)");
        return ((Number)n).intValue();
    }

    public static final void removeContainerImpl(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        dockerClient.removeContainerCmd(containerId).exec();
    }

    @NotNull
    public static final RunLog logContainerImpl(@NotNull String containerId, boolean withStdOut, boolean withStdErr) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Ref.ObjectRef stdOut = new Ref.ObjectRef();
        stdOut.element = new byte[0];
        Ref.ObjectRef stdErr = new Ref.ObjectRef();
        stdErr.element = new byte[0];
        (dockerClient.logContainerCmd(containerId).withStdOut(Boolean.valueOf(withStdOut)).withStdErr(Boolean.valueOf(withStdErr)).withTailAll().exec((ResultCallback)new ResultCallback.Adapter<Frame>((Ref.ObjectRef<byte[]>)stdOut, (Ref.ObjectRef<byte[]>)stdErr){
            final /* synthetic */ Ref.ObjectRef<byte[]> $stdOut;
            final /* synthetic */ Ref.ObjectRef<byte[]> $stdErr;
            {
                this.$stdOut = $stdOut;
                this.$stdErr = $stdErr;
            }

            public void onNext(Frame frame) {
                Object object = frame;
                if (object != null) {
                    byte[] byArray = object.getPayload();
                    object = byArray;
                    if (byArray != null) {
                        Object object2 = object;
                        Ref.ObjectRef<byte[]> objectRef = this.$stdOut;
                        Ref.ObjectRef<byte[]> objectRef2 = this.$stdErr;
                        Object it = object2;
                        boolean bl = false;
                        StreamType streamType = frame.getStreamType();
                        switch (streamType == null ? -1 : logContainerImpl.WhenMappings.$EnumSwitchMapping$0[streamType.ordinal()]) {
                            case 1: {
                                objectRef.element = ArraysKt.plus((byte[])((byte[])objectRef.element), (byte[])it);
                                break;
                            }
                            case 2: {
                                objectRef2.element = ArraysKt.plus((byte[])((byte[])objectRef2.element), (byte[])it);
                                break;
                            }
                            default: {
                                ContainerController.INSTANCE.getLogger$mosaify_util_container().warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> logContainerImpl.1.onNext$lambda$0$0(frame));
                            }
                        }
                    }
                }
                super.onNext((Object)frame);
            }

            private static final Object onNext$lambda$0$0(Frame $frame) {
                return "Received unexpected frame type while getting container log: " + $frame.getStreamType();
            }
        })).awaitCompletion();
        return new RunLog((Ref.ObjectRef<byte[]>)stdErr, (Ref.ObjectRef<byte[]>)stdOut){
            private final byte[] stdErr;
            private final byte[] stdOut;
            {
                this.stdErr = !(((byte[])$stdErr.element).length == 0) ? (byte[])$stdErr.element : null;
                this.stdOut = !(((byte[])$stdOut.element).length == 0) ? (byte[])$stdOut.element : null;
            }

            public byte[] getStdErr() {
                return this.stdErr;
            }

            public byte[] getStdOut() {
                return this.stdOut;
            }
        };
    }

    public static /* synthetic */ RunLog logContainerImpl$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return ContainerController_jvmKt.logContainerImpl(string, bl, bl2);
    }

    @NotNull
    public static final InputStream copyArchiveFromContainer(@NotNull String containerId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = dockerClient.copyArchiveFromContainerCmd(containerId, path).exec();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"exec(...)");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Collection<Pair<String, byte[]>> getFilesFromContainerImpl(@NotNull String containerId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List fileContent = new ArrayList();
        Closeable closeable = (Closeable)new TarArchiveInputStream(ContainerController_jvmKt.copyArchiveFromContainer(containerId, path));
        Throwable throwable = null;
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream tarArchiveInputStream = (TarArchiveInputStream)closeable;
            boolean bl = false;
            do {
                if ((entry = tarArchiveInputStream.getNextEntry()) == null) continue;
                ContainerController.INSTANCE.getLogger$mosaify_util_container().trace(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ContainerController_jvmKt.getFilesFromContainerImpl$lambda$0$0(entry));
                if (entry.isFile()) {
                    ((Collection)fileContent).add(TuplesKt.to((Object)entry.getName(), (Object)ByteStreamsKt.readBytes((InputStream)((InputStream)tarArchiveInputStream))));
                    continue;
                }
                ContainerController.INSTANCE.getLogger$mosaify_util_container().trace(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ContainerController_jvmKt.getFilesFromContainerImpl$lambda$0$1(entry));
            } while (entry != null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return fileContent;
    }

    public static final void removeImageImpl(@NotNull String imageName) {
        block3: {
            Throwable throwable;
            Object object;
            Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)dockerClient.removeImageCmd(imageName).exec());
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block3;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            if (!(it instanceof NotFoundException)) {
                ContainerController.INSTANCE.getLogger$mosaify_util_container().warn(it, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ContainerController_jvmKt.removeImageImpl$lambda$1$0(imageName));
            }
        }
    }

    private static final Object createFileInContainerImpl$lambda$1$0$0(Path $pathToBytes) {
        return "Adding to tar: '" + $pathToBytes + "'";
    }

    private static final Object getFilesFromContainerImpl$lambda$0$0(TarArchiveEntry $entry) {
        return "Incoming tar entry: '" + $entry.getName() + "'";
    }

    private static final Object getFilesFromContainerImpl$lambda$0$1(TarArchiveEntry $entry) {
        return "Tar entry '" + $entry.getName() + "' is not a file, skipping...";
    }

    private static final Object removeImageImpl$lambda$1$0(String $imageName) {
        return "Failed to remove image: '" + $imageName + "'";
    }

    static {
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)((DockerClientConfig)dockerConfig), (DockerHttpClient)((DockerHttpClient)new ApacheDockerHttpClient.Builder().dockerHost(dockerConfig.getDockerHost()).sslConfig((SSLConfig)dockerConfig.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L)).build()));
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"getInstance(...)");
        ContainerController_jvmKt.dockerClient = dockerClient;
    }
}

