/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/aallam/similarity/DamerauLevenshtein;", "", "()V", "distance", "", "first", "", "second", "string-similarity"})
public final class DamerauLevenshtein {
    public final int distance(@NotNull CharSequence first, @NotNull CharSequence second) {
        int i;
        int n;
        int index;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        int n2 = first.length();
        int m = second.length();
        int infinity = n2 + m;
        Map charsRowIndex = new LinkedHashMap();
        int n3 = first.length();
        for (index = 0; index < n3; ++index) {
            charsRowIndex.put(Character.valueOf(first.charAt(index)), 0);
        }
        for (index = 0; index < second.length(); ++index) {
            n = second.charAt(index);
            charsRowIndex.put(Character.valueOf((char)n), 0);
        }
        n = 0;
        int n4 = n2 + 2;
        int[][] nArrayArray = new int[n4][];
        while (n < n4) {
            int n5 = n++;
            nArrayArray[n5] = new int[m + 2];
        }
        int[][] distanceMatrix = nArrayArray;
        n4 = first.length();
        for (i = 0; i < n4; ++i) {
            distanceMatrix[i + 1][0] = infinity;
            distanceMatrix[i + 1][1] = i;
        }
        n4 = second.length();
        for (int j = 0; j < n4; ++j) {
            distanceMatrix[0][j + 1] = infinity;
            distanceMatrix[1][j + 1] = j;
        }
        i = 1;
        if (i <= n2) {
            while (true) {
                int lastMatch = 0;
                int j = 1;
                if (j <= m) {
                    while (true) {
                        int lastRowIndex = ((Number)MapsKt.getValue((Map)charsRowIndex, (Object)Character.valueOf(second.charAt(j - 1)))).intValue();
                        int previousMatch = lastMatch;
                        int cost = 0;
                        if (first.charAt(i - 1) == second.charAt(j - 1)) {
                            cost = 0;
                            lastMatch = j;
                        } else {
                            cost = 1;
                        }
                        int substitution = distanceMatrix[i][j] + cost;
                        int insertion = distanceMatrix[i + 1][j] + 1;
                        int deletion = distanceMatrix[i][j + 1] + 1;
                        int transposition = distanceMatrix[lastRowIndex][previousMatch] + (i - lastRowIndex - 1) + 1 + (j - previousMatch - 1);
                        int[] nArray = new int[]{insertion, deletion, transposition};
                        distanceMatrix[i + 1][j + 1] = ComparisonsKt.minOf((int)substitution, (int[])nArray);
                        if (j == m) break;
                        ++j;
                    }
                }
                Integer n6 = i;
                charsRowIndex.put(Character.valueOf(first.charAt(i - 1)), n6);
                if (i == n2) break;
                ++i;
            }
        }
        return distanceMatrix[n2 + 1][m + 1];
    }
}

