/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/aallam/similarity/Levenshtein;", "", "()V", "distance", "", "first", "", "second", "limit", "string-similarity"})
public final class Levenshtein {
    public final int distance(@NotNull CharSequence first, @NotNull CharSequence second, int limit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0;
        }
        if (first.length() == 0) {
            return second.length();
        }
        if (second.length() == 0) {
            return first.length();
        }
        int n = 0;
        int n2 = first.length() + 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        int[] cost = nArray;
        int[] newCost = new int[first.length() + 1];
        int i = 1;
        int n4 = second.length();
        if (i <= n4) {
            do {
                newCost[0] = ++i;
                int minCost = i;
                int j = 1;
                int n5 = first.length();
                if (j <= n5) {
                    while (true) {
                        int edit = first.charAt(j - 1) == second.charAt(i - 1) ? 0 : 1;
                        int replace = cost[j - 1] + edit;
                        int insert = cost[j] + 1;
                        int delete = newCost[j - 1] + 1;
                        newCost[j] = Math.min(insert, Math.min(delete, replace));
                        minCost = Math.min(minCost, newCost[j]);
                        if (j == n5) break;
                        ++j;
                    }
                }
                if (minCost >= limit) {
                    return limit;
                }
                int[] swap = cost;
                cost = newCost;
                newCost = swap;
            } while (i != n4);
        }
        return ArraysKt.last((int[])cost);
    }

    public static /* synthetic */ int distance$default(Levenshtein levenshtein, CharSequence charSequence, CharSequence charSequence2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return levenshtein.distance(charSequence, charSequence2, n);
    }
}

