/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.LongestCommonSubsequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/aallam/similarity/MetricLCS;", "", "()V", "lcs", "Lcom/aallam/similarity/LongestCommonSubsequence;", "distance", "", "first", "", "second", "string-similarity"})
public final class MetricLCS {
    @NotNull
    private final LongestCommonSubsequence lcs = new LongestCommonSubsequence();

    public final double distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0.0;
        }
        int m = Math.max(first.length(), second.length());
        if (m == 0) {
            return 0.0;
        }
        return 1.0 - (double)this.lcs.length(first, second) / (double)m;
    }
}

