/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/aallam/similarity/NGram;", "", "n", "", "(I)V", "distance", "", "first", "", "second", "string-similarity"})
public final class NGram {
    private final int n;

    public NGram(int n) {
        this.n = n;
    }

    public /* synthetic */ NGram(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    public final double distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0.0;
        }
        int sl = first.length();
        int tl = second.length();
        if (sl == 0 || tl == 0) {
            return 1.0;
        }
        char special = '\n';
        int cost = 0;
        if (sl < this.n || tl < this.n) {
            int i = 0;
            int ni = Math.min(sl, tl);
            if (i <= ni) {
                while (true) {
                    if (first.charAt(i) == second.charAt(i)) {
                        ++cost;
                    }
                    if (i == ni) break;
                    ++i;
                }
            }
            return (double)cost / (double)Math.max(sl, tl);
        }
        int n = sl + this.n - 1;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            cArray[n2] = n2 < this.n - 1 ? special : (char)first.charAt(n2 - this.n + 1);
        }
        char[] sa = cArray;
        n = 0;
        int n3 = sl + 1;
        double[] dArray = new double[n3];
        while (n < n3) {
            int n4 = n++;
            dArray[n4] = n4;
        }
        double[] p = dArray;
        double[] d = new double[sl + 1];
        char[] tj = new char[this.n];
        int j = 1;
        if (j <= tl) {
            while (true) {
                if (j < this.n) {
                    int n5;
                    IntRange intRange = RangesKt.until((int)0, (int)(this.n - j));
                    int ti = intRange.getFirst();
                    if (ti <= (n5 = intRange.getLast())) {
                        while (true) {
                            tj[ti] = special;
                            if (ti == n5) break;
                            ++ti;
                        }
                    }
                    if ((ti = (intRange = RangesKt.until((int)(this.n - j), (int)this.n)).getFirst()) <= (n5 = intRange.getLast())) {
                        while (true) {
                            tj[ti] = second.charAt(ti - (this.n - j));
                            if (ti != n5) {
                                ++ti;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    String string = second.substring(j - this.n, j);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toCharArray(), (String)"this as java.lang.String).toCharArray()");
                }
                d[0] = j;
                int i = 1;
                if (i <= sl) {
                    while (true) {
                        int n6;
                        cost = 0;
                        int tn = this.n;
                        IntRange intRange = RangesKt.until((int)0, (int)this.n);
                        int ni = intRange.getFirst();
                        if (ni <= (n6 = intRange.getLast())) {
                            while (true) {
                                if (sa[i - 1 + ni] != tj[ni]) {
                                    ++cost;
                                } else if (sa[i - 1 + ni] == special) {
                                    --tn;
                                }
                                if (ni == n6) break;
                                ++ni;
                            }
                        }
                        double ec = (double)cost / (double)tn;
                        d[i] = Math.min(d[i - 1] + 1.0, Math.min(p[i] + 1.0, p[i - 1] + ec));
                        if (i == sl) break;
                        ++i;
                    }
                }
                double[] swap = p;
                p = d;
                d = swap;
                if (j == tl) break;
                ++j;
            }
        }
        return p[sl] / (double)Math.max(tl, sl);
    }

    public NGram() {
        this(0, 1, null);
    }
}

