/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.platform;

import dev.mosaify.core.util.platform.Extensions;
import dev.mosaify.core.util.platform.OperatingSystem;
import dev.mosaify.core.util.platform.Platform;
import dev.mosaify.core.util.platform.PlatformUtils;
import dev.mosaify.core.util.platform.PlatformUtils_jvmKt;
import dev.mosaify.core.util.platform.ProcessRunResult;
import dev.mosaify.core.util.platform.TempPath;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0011J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJY\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001021\u0010 \u001a-\b\u0001\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\"\u0012\b\b\u0019\u0012\u0004\b\b(#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0$\u0012\u0006\u0012\u0004\u0018\u00010\u00010!H\u0086@\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010'\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u00a8\u0006)"}, d2={"Ldev/mosaify/core/util/platform/PlatformUtils;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "isWindows", "", "()Z", "getCurrentPlatform", "Ldev/mosaify/core/util/platform/Platform;", "getCurrentOs", "Ldev/mosaify/core/util/platform/OperatingSystem;", "executeProcess", "Ldev/mosaify/core/util/platform/ProcessRunResult;", "command", "", "", "environment", "", "createTempPath", "Ldev/mosaify/core/util/platform/TempPath;", "prefix", "suffix", "getEnv", "name", "deleteRecursively", "", "path", "Lkotlinx/io/files/Path;", "walkRecursively", "exclude", "processOne", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "file", "Lkotlin/coroutines/Continuation;", "(Lkotlinx/io/files/Path;Ljava/util/Collection;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fixFileName", "relativizePath", "base", "mosaify-util-platform"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.kt\ndev/mosaify/core/util/platform/PlatformUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1869#2,2:78\n2746#2,3:80\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.kt\ndev/mosaify/core/util/platform/PlatformUtils\n*L\n37#1:78,2\n49#1:80,3\n54#1:83,2\n*E\n"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(PlatformUtils::logger$lambda$0);
    private static final boolean isWindows = INSTANCE.getCurrentOs() == OperatingSystem.WINDOWS;

    private PlatformUtils() {
    }

    public final boolean isWindows() {
        return isWindows;
    }

    @NotNull
    public final Platform getCurrentPlatform() {
        return PlatformUtils_jvmKt.getCurrentPlatformImpl();
    }

    @NotNull
    public final OperatingSystem getCurrentOs() {
        return PlatformUtils_jvmKt.getCurrentOsImpl();
    }

    @NotNull
    public final ProcessRunResult executeProcess(@NotNull Collection<String> command, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        return PlatformUtils_jvmKt.executeProcessImpl(command, environment);
    }

    public static /* synthetic */ ProcessRunResult executeProcess$default(PlatformUtils platformUtils, Collection collection, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return platformUtils.executeProcess(collection, map);
    }

    @NotNull
    public final TempPath createTempPath(@NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new TempPath(prefix, suffix, false, 4, null);
    }

    public static /* synthetic */ TempPath createTempPath$default(PlatformUtils platformUtils, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        return platformUtils.createTempPath(string, string2);
    }

    @Nullable
    public final String getEnv(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return PlatformUtils_jvmKt.getEnvImpl(name);
    }

    public final void deleteRecursively(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        logger.debug(() -> PlatformUtils.deleteRecursively$lambda$0(path));
        FileMetadata fileMetadata = FileSystemJvmKt.SystemFileSystem.metadataOrNull(path);
        boolean bl = fileMetadata != null ? fileMetadata.isDirectory() : false;
        if (bl) {
            Iterable $this$forEach$iv = FileSystemJvmKt.SystemFileSystem.list(path);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                INSTANCE.deleteRecursively(it);
            }
        } else {
            FileSystemJvmKt.SystemFileSystem.delete(path, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object walkRecursively(@NotNull Path path, @NotNull Collection<String> exclude, @NotNull Function2<? super Path, ? super Continuation<? super Unit>, ? extends Object> processOne, @NotNull Continuation<? super Unit> $completion) {
        block11: {
            block12: {
                block13: {
                    if (!($completion instanceof walkRecursively.1)) ** GOTO lbl-1000
                    var17_5 = $completion;
                    if ((var17_5.label & -2147483648) != 0) {
                        var17_5.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            Object L$7;
                            int I$0;
                            int I$1;
                            int I$2;
                            /* synthetic */ Object result;
                            final /* synthetic */ PlatformUtils this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.walkRecursively(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$none$iv = exclude;
                            $i$f$none = false;
                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl17
                            v0 = true;
                            ** GOTO lbl24
lbl17:
                            // 2 sources

                            for (T element$iv : $this$none$iv) {
                                it = (String)element$iv;
                                $i$a$-none-PlatformUtils$walkRecursively$2 = false;
                                if (!Extensions.INSTANCE.nameEquals(path, it)) continue;
                                v0 = false;
                                ** GOTO lbl24
                            }
                            v0 = true;
lbl24:
                            // 3 sources

                            if (!v0) break block11;
                            v1 = FileSystemJvmKt.SystemFileSystem.metadataOrNull(path);
                            if (v1 == null) break block12;
                            pathMetadata = v1;
                            $i$a$-let-PlatformUtils$walkRecursively$3 = 0;
                            if (!pathMetadata.isRegularFile()) break;
                            $continuation.L$0 = path;
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)exclude);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)processOne);
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)pathMetadata);
                            $continuation.I$0 = $i$a$-let-PlatformUtils$walkRecursively$3;
                            $continuation.label = 1;
                            v2 = processOne.invoke((Object)path, (Object)$continuation);
                            if (v2 == var18_7) {
                                return var18_7;
                            }
                            break block11;
                        }
                        case 1: {
                            $i$a$-let-PlatformUtils$walkRecursively$3 = $continuation.I$0;
                            pathMetadata = (FileMetadata)$continuation.L$3;
                            processOne = (Function2)$continuation.L$2;
                            exclude = (Collection)$continuation.L$1;
                            path = (Path)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block11;
                        }
                    }
                    if (!pathMetadata.isDirectory()) break block13;
                    $i$a$-none-PlatformUtils$walkRecursively$2 = FileSystemJvmKt.SystemFileSystem.list(path);
                    $i$f$forEach = 0;
                    var12_19 = $this$forEach$iv.iterator();
lbl55:
                    // 3 sources

                    while (var12_19.hasNext()) {
                        element$iv = var12_19.next();
                        it = (Path)element$iv;
                        $i$a$-forEach-PlatformUtils$walkRecursively$3$1 = 0;
                        $continuation.L$0 = path;
                        $continuation.L$1 = exclude;
                        $continuation.L$2 = processOne;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)pathMetadata);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                        $continuation.L$5 = var12_19;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$a$-let-PlatformUtils$walkRecursively$3;
                        $continuation.I$1 = $i$f$forEach;
                        $continuation.I$2 = $i$a$-forEach-PlatformUtils$walkRecursively$3$1;
                        $continuation.label = 2;
                        v3 = PlatformUtils.INSTANCE.walkRecursively(it, exclude, (Function2<? super Path, ? super Continuation<? super Unit>, ? extends Object>)processOne, (Continuation<? super Unit>)$continuation);
                        if (v3 == var18_7) {
                            return var18_7;
                        }
                    }
                    {
                        break block11;
                        case 2: {
                            $i$a$-forEach-PlatformUtils$walkRecursively$3$1 = $continuation.I$2;
                            $i$f$forEach = $continuation.I$1;
                            $i$a$-let-PlatformUtils$walkRecursively$3 = $continuation.I$0;
                            it = (Path)$continuation.L$7;
                            element$iv = $continuation.L$6;
                            var12_19 = (Iterator<T>)$continuation.L$5;
                            $this$forEach$iv = (Iterable)$continuation.L$4;
                            pathMetadata = (FileMetadata)$continuation.L$3;
                            processOne = (Function2)$continuation.L$2;
                            exclude = (Collection)$continuation.L$1;
                            path = (Path)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl55
                        }
                    }
                }
                PlatformUtils.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, walkRecursively$lambda$1$1(kotlinx.io.files.Path ), ()Ljava/lang/Object;)((Path)path));
                break block11;
            }
            PlatformUtils.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, walkRecursively$lambda$2(kotlinx.io.files.Path ), ()Ljava/lang/Object;)((Path)path));
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object walkRecursively$default(PlatformUtils platformUtils, Path path, Collection collection, Function2 function2, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return platformUtils.walkRecursively(path, collection, (Function2<? super Path, ? super Continuation<? super Unit>, ? extends Object>)function2, (Continuation<? super Unit>)continuation);
    }

    @NotNull
    public final String fixFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.replace$default((String)name, (String)":", (String)"-", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String relativizePath(@NotNull Path path, @NotNull Path base) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return Intrinsics.areEqual((Object)path, (Object)base) ? path.getName() : PlatformUtils_jvmKt.relativizePathImpl(path, base);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object deleteRecursively$lambda$0(Path $path) {
        return "Deleting " + $path;
    }

    private static final Object walkRecursively$lambda$1$1(Path $path) {
        return "Neither directory nor regular file: " + $path;
    }

    private static final Object walkRecursively$lambda$2(Path $path) {
        return "Could not get metadata for path: " + $path;
    }
}

