/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.platform;

import dev.mosaify.core.util.platform.OperatingSystem;
import dev.mosaify.core.util.platform.Platform;
import dev.mosaify.core.util.platform.ProcessRunResult;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0000\u001a\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a8\u0006\u0011"}, d2={"getCurrentPlatformImpl", "Ldev/mosaify/core/util/platform/Platform;", "getCurrentOsImpl", "Ldev/mosaify/core/util/platform/OperatingSystem;", "executeProcessImpl", "Ldev/mosaify/core/util/platform/ProcessRunResult;", "command", "", "", "environment", "", "getEnvImpl", "name", "relativizePathImpl", "path", "Lkotlinx/io/files/Path;", "base", "mosaify-util-platform"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.jvm.kt\ndev/mosaify/core/util/platform/PlatformUtils_jvmKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,49:1\n37#2,2:50\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.jvm.kt\ndev/mosaify/core/util/platform/PlatformUtils_jvmKt\n*L\n20#1:50,2\n*E\n"})
public final class PlatformUtils_jvmKt {
    @NotNull
    public static final Platform getCurrentPlatformImpl() {
        return Platform.JVM;
    }

    @NotNull
    public static final OperatingSystem getCurrentOsImpl() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return StringsKt.startsWith((String)string, (String)"Win", (boolean)true) ? OperatingSystem.WINDOWS : OperatingSystem.POSIX;
    }

    @NotNull
    public static final ProcessRunResult executeProcessImpl(@NotNull Collection<String> command, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Collection<String> $this$toTypedArray$iv = command;
        boolean $i$f$toTypedArray22 = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ProcessBuilder pb = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length));
        Map<String, String> map = pb.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        map.putAll(environment);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        $this$toTypedArray$iv = null;
        java.nio.file.Path path = Files.createTempFile($this$toTypedArray$iv, null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        java.nio.file.Path errorOutput = path;
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        String $i$f$toTypedArray22 = null;
        java.nio.file.Path path2 = Files.createTempFile($i$f$toTypedArray22, null, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(...)");
        java.nio.file.Path standardOutput = path2;
        int exitCode = pb.redirectError(errorOutput.toFile()).redirectOutput(standardOutput.toFile()).start().waitFor();
        byte[] byArray = Files.readAllBytes(errorOutput);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = Files.readAllBytes(standardOutput);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
        return new ProcessRunResult(exitCode, byArray, byArray2);
    }

    @Nullable
    public static final String getEnvImpl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return System.getenv(name);
    }

    @NotNull
    public static final String relativizePathImpl(@NotNull Path path, @NotNull Path base) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        java.nio.file.Path jvmPath = java.nio.file.Path.of(FileSystemJvmKt.SystemFileSystem.resolve(path).toString(), new String[0]);
        java.nio.file.Path jvmBase = java.nio.file.Path.of(FileSystemJvmKt.SystemFileSystem.resolve(base).toString(), new String[0]);
        Intrinsics.checkNotNull((Object)jvmPath);
        Intrinsics.checkNotNull((Object)jvmBase);
        return ((Object)PathsKt.relativeToOrSelf((java.nio.file.Path)jvmPath, (java.nio.file.Path)jvmBase)).toString();
    }
}

