/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.parser.sarif;

import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueLocation;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.generic.ReportKt;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.Location;
import dev.mosaify.core.model.sarif.MultiformatMessageString;
import dev.mosaify.core.model.sarif.PhysicalLocation;
import dev.mosaify.core.model.sarif.Region;
import dev.mosaify.core.model.sarif.ReportingDescriptor;
import dev.mosaify.core.model.sarif.Result;
import dev.mosaify.core.model.sarif.ResultLevel;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.SarifLog;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.Extensions;
import dev.mosaify.core.util.logging.MemoryLogger;
import dev.mosaify.guesswork.GuessworkCommon;
import io.github.oshai.kotlinlogging.KLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J)\u0010\u000e\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\tj\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J)\u0010\u0016\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\tj\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010(\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010(\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010(\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001c\u0010+\u001a\u0004\u0018\u00010\u00192\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/mosaify/core/parser/sarif/ParserSarifGeneric;", "Ldev/mosaify/core/model/report/ReportParser;", "<init>", "()V", "allNames", "", "", "getName", "getAllNames", "", "parseToOriginal", "", "originalReport", "", "sarifToGeneric", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "run", "Ldev/mosaify/core/model/sarif/Run;", "extraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "originalToGeneric", "getLocations", "", "Ldev/mosaify/core/model/generic/IssueLocation;", "result", "Ldev/mosaify/core/model/sarif/Result;", "getSummary", "sarifRule", "Ldev/mosaify/core/model/sarif/ReportingDescriptor;", "getDescription", "attemptDetectTypeByScannerName", "Ldev/mosaify/core/model/generic/IssueType;", "sarifRun", "sarifLevelToSeverity", "Ldev/mosaify/core/model/generic/IssueSeverity;", "sarifLevel", "Ldev/mosaify/core/model/sarif/ResultLevel;", "getReferences", "sarifResult", "getIdentifiers", "getRuleId", "getGenericLocation", "physicalLocation", "Ldev/mosaify/core/model/sarif/PhysicalLocation;", "mosaify-parser-sarif-generic"})
@SourceDebugExtension(value={"SMAP\nParserSarifGeneric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserSarifGeneric.kt\ndev/mosaify/core/parser/sarif/ParserSarifGeneric\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,126:1\n222#2:127\n1563#3:128\n1634#3,2:129\n1636#3:132\n1374#3:133\n1460#3,5:134\n1617#3,9:139\n1869#3:148\n1870#3:150\n1626#3:151\n1#4:131\n1#4:149\n216#5,2:152\n*S KotlinDebug\n*F\n+ 1 ParserSarifGeneric.kt\ndev/mosaify/core/parser/sarif/ParserSarifGeneric\n*L\n26#1:127\n38#1:128\n38#1:129,2\n38#1:132\n58#1:133\n58#1:134,5\n61#1:139,9\n61#1:148\n61#1:150\n61#1:151\n61#1:149\n84#1:152,2\n*E\n"})
public final class ParserSarifGeneric
implements ReportParser {
    @NotNull
    public static final ParserSarifGeneric INSTANCE = new ParserSarifGeneric();
    @NotNull
    private static final List<String> allNames;

    private ParserSarifGeneric() {
    }

    @NotNull
    public String getName() {
        return (String)CollectionsKt.first(allNames);
    }

    @NotNull
    public Collection<String> getAllNames() {
        return allNames;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object parseToOriginal(@NotNull byte[] originalReport) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        Json json = (Json)Json.Default;
        String string$iv = StringsKt.decodeToString((byte[])originalReport);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return this_$iv.decodeFromString((DeserializationStrategy)SarifLog.Companion.serializer(), string$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Not intended to use directly. Suppress explicitly with justification when using this method.", replaceWith=@ReplaceWith(expression="BespokeToolParser.sarifToGeneric()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public Collection<Issue> sarifToGeneric(@NotNull Run run, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        List list = run.getResults();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ReportingDescriptor reportingDescriptor;
                void sarifResult;
                Object object2;
                Iterable iterable2;
                Result result = (Result)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Set set = run.getTool().getDriver().getRules();
                if (set != null) {
                    Object v2;
                    block8: {
                        iterable2 = set;
                        for (Object object2 : iterable2) {
                            ReportingDescriptor it = (ReportingDescriptor)object2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)sarifResult.getRuleId())) continue;
                            v2 = object2;
                            break block8;
                        }
                        v2 = null;
                    }
                    reportingDescriptor = v2;
                } else {
                    reportingDescriptor = null;
                }
                ReportingDescriptor sarifRule = reportingDescriptor;
                Set<String> identifiers = INSTANCE.getIdentifiers((Result)sarifResult, sarifRule);
                IssueType issueType = INSTANCE.attemptDetectTypeByScannerName(run);
                if (issueType == null) {
                    issueType = CommonUtils.INSTANCE.detectIssueTypeFromId((Collection)identifiers);
                }
                IssueType type = issueType;
                iterable2 = SetsKt.setOf((Object)run.getTool().getDriver().getName());
                String string = INSTANCE.getSummary((Result)sarifResult, sarifRule);
                object2 = INSTANCE.getDescription((Result)sarifResult, sarifRule);
                Object object3 = sarifResult.getLevel();
                if (object3 == null) {
                    ReportingDescriptor reportingDescriptor2 = sarifRule;
                    object3 = reportingDescriptor2 != null && (reportingDescriptor2 = reportingDescriptor2.getDefaultConfiguration()) != null ? reportingDescriptor2.getLevel() : null;
                }
                IssueSeverity issueSeverity = INSTANCE.sarifLevelToSeverity((ResultLevel)object3);
                Set<String> set2 = INSTANCE.getReferences((Result)sarifResult, sarifRule);
                Set<IssueLocation> set3 = INSTANCE.getLocations((Result)sarifResult, extraInfo);
                collection2.add(new Issue(string, (Set)iterable2, null, object2, type, issueSeverity, null, null, null, identifiers, set2, null, set3, null, null, 27076, null));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = ReportKt.getEMPTY_REPORT();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Issue> originalToGeneric(@NotNull Object originalReport, @Nullable RunExtraInfo extraInfo) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        Iterable $this$flatMap$iv = ((SarifLog)originalReport).getRuns();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Run it = (Run)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.sarifToGeneric(it, extraInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<IssueLocation> getLocations(@NotNull Result result, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        block4: {
            block3: {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                collection = result.getLocations();
                if (collection == null) break block3;
                Iterable $this$mapNotNull$iv = collection;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    IssueLocation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Location it = (Location)element$iv$iv;
                    boolean bl2 = false;
                    if (INSTANCE.getGenericLocation(it.getPhysicalLocation(), extraInfo) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (collection != null) break block4;
            }
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public final String getSummary(@NotNull Result result, @Nullable ReportingDescriptor sarifRule) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = Extensions.INSTANCE.getPlainText(result.getMessage());
        if (string == null) {
            String string2 = "Impossible scenario: Message with both text and markdown fields blank or null";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return string;
    }

    @Nullable
    public final String getDescription(@NotNull Result result, @Nullable ReportingDescriptor sarifRule) {
        ReportingDescriptor reportingDescriptor;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = sarifRule;
        if ((object == null || (object = object.getHelp()) == null || (object = Extensions.INSTANCE.getPlainText((MultiformatMessageString)object)) == null) && ((reportingDescriptor = sarifRule) != null && (reportingDescriptor = reportingDescriptor.getFullDescription()) != null ? Extensions.INSTANCE.getPlainText((MultiformatMessageString)reportingDescriptor) : (object = null)) == null) {
            ReportingDescriptor reportingDescriptor2 = sarifRule;
            object = reportingDescriptor2 != null && (reportingDescriptor2 = reportingDescriptor2.getShortDescription()) != null ? Extensions.INSTANCE.getPlainText((MultiformatMessageString)reportingDescriptor2) : null;
        }
        return object;
    }

    private final IssueType attemptDetectTypeByScannerName(Run sarifRun) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Docker Scout", (Object)IssueType.COMPONENT_VULNERABILITY), TuplesKt.to((Object)"Grype", (Object)IssueType.COMPONENT_VULNERABILITY), TuplesKt.to((Object)"JFrog Xray SCA", (Object)IssueType.COMPONENT_VULNERABILITY), TuplesKt.to((Object)"Semgrep OSS", (Object)IssueType.CODE_VULNERABILITY), TuplesKt.to((Object)"Snyk Container", (Object)IssueType.COMPONENT_VULNERABILITY), TuplesKt.to((Object)"Snyk Open Source", (Object)IssueType.COMPONENT_VULNERABILITY), TuplesKt.to((Object)"SnykCode", (Object)IssueType.CODE_VULNERABILITY), TuplesKt.to((Object)"Trivy", (Object)IssueType.COMPONENT_VULNERABILITY)};
        Map $this$forEach$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String scannerName = (String)entry.getKey();
            IssueType type = (IssueType)entry.getValue();
            if (!StringsKt.contains((CharSequence)sarifRun.getTool().getDriver().getName(), (CharSequence)scannerName, (boolean)true)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public final IssueSeverity sarifLevelToSeverity(@Nullable ResultLevel sarifLevel) {
        ResultLevel resultLevel = sarifLevel;
        return switch (resultLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resultLevel.ordinal()]) {
            case 1 -> IssueSeverity.HIGH;
            case 2 -> IssueSeverity.MEDIUM;
            case 3 -> IssueSeverity.LOW;
            case 4 -> null;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Set<String> getReferences(@NotNull Result sarifResult, @Nullable ReportingDescriptor sarifRule) {
        Intrinsics.checkNotNullParameter((Object)sarifResult, (String)"sarifResult");
        ReportingDescriptor reportingDescriptor = sarifRule;
        return SetsKt.setOfNotNull((Object)(reportingDescriptor != null ? reportingDescriptor.getHelpUri() : null));
    }

    @NotNull
    public final Set<String> getIdentifiers(@NotNull Result sarifResult, @Nullable ReportingDescriptor sarifRule) {
        Intrinsics.checkNotNullParameter((Object)sarifResult, (String)"sarifResult");
        Object[] objectArray = new Set[3];
        objectArray[0] = this.getRuleId(sarifResult, sarifRule);
        objectArray[1] = IssueTaxonomy.Companion.processJsonObjectForIds(sarifResult.getProperties());
        ReportingDescriptor reportingDescriptor = sarifRule;
        objectArray[2] = IssueTaxonomy.Companion.processJsonObjectForIds((JsonObject)(reportingDescriptor != null ? reportingDescriptor.getProperties() : null));
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)SetsKt.setOfNotNull((Object[])objectArray)));
    }

    @NotNull
    public final Set<String> getRuleId(@NotNull Result sarifResult, @Nullable ReportingDescriptor sarifRule) {
        Intrinsics.checkNotNullParameter((Object)sarifResult, (String)"sarifResult");
        String string = sarifResult.getRuleId();
        if (string == null) {
            ReportingDescriptor reportingDescriptor = sarifRule;
            string = reportingDescriptor != null ? reportingDescriptor.getId() : null;
        }
        return SetsKt.setOfNotNull((Object)string);
    }

    @Nullable
    public final IssueLocation getGenericLocation(@Nullable PhysicalLocation physicalLocation, @Nullable RunExtraInfo extraInfo) {
        IssueLocation issueLocation;
        Object object = physicalLocation;
        if (object != null && (object = object.getArtifactLocation()) != null && (object = object.getUri()) != null) {
            Object it = object;
            boolean bl = false;
            Region region = physicalLocation.getRegion();
            issueLocation = new IssueLocation(new GuessworkCommon((KLogger)new MemoryLogger(null, 1, null)).attemptRelativePath((String)it, extraInfo), region != null ? region.getStartLine() : null);
        } else {
            issueLocation = null;
        }
        return issueLocation;
    }

    static {
        Object[] objectArray = new String[]{"Generic SARIF", "SARIF"};
        allNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResultLevel.values().length];
            try {
                nArray[ResultLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultLevel.NOTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultLevel.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

