/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.config;

import com.charleskorn.kaml.IncorrectTypeException;
import com.charleskorn.kaml.Yaml;
import com.charleskorn.kaml.YamlList;
import com.charleskorn.kaml.YamlMap;
import com.charleskorn.kaml.YamlNode;
import com.charleskorn.kaml.YamlNodeKt;
import com.charleskorn.kaml.YamlScalar;
import dev.mosaify.core.util.config.model.ProjectConfig;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/mosaify/core/util/config/ConfigFile;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "parseYamlImageList", "", "", "path", "Lkotlinx/io/files/Path;", "readImagesFromFile", "readProjectConfig", "Ldev/mosaify/core/util/config/model/ProjectConfig;", "mosaify-util-configfile"})
@SourceDebugExtension(value={"SMAP\nConfigFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigFile.kt\ndev/mosaify/core/util/config/ConfigFile\n+ 2 YamlNode.kt\ncom/charleskorn/kaml/YamlMap\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n227#2,2:54\n229#2,6:58\n295#3,2:56\n1563#3:65\n1634#3,3:66\n827#3:69\n855#3,2:70\n774#3:72\n865#3,2:73\n1669#3,8:75\n1#4:64\n*S KotlinDebug\n*F\n+ 1 ConfigFile.kt\ndev/mosaify/core/util/config/ConfigFile\n*L\n24#1:54,2\n24#1:58,6\n24#1:56,2\n43#1:65\n43#1:66,3\n44#1:69\n44#1:70,2\n45#1:72\n45#1:73,2\n46#1:75,8\n*E\n"})
public final class ConfigFile {
    @NotNull
    public static final ConfigFile INSTANCE = new ConfigFile();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ConfigFile::logger$lambda$0);

    private ConfigFile() {
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> parseYamlImageList(Path path) {
        YamlNode yamlNode;
        YamlNode node = Yaml.Companion.getDefault().parseToYamlNode(Utf8Kt.readString((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path))));
        YamlList yamlList = node instanceof YamlList ? (YamlList)node : null;
        if (yamlList != null) {
            yamlNode = (YamlNode)yamlList;
        } else {
            Iterable iterable;
            Object v2;
            Iterable iterable2;
            block8: {
                void $this$firstOrNull$iv$iv;
                void this_$iv;
                YamlMap yamlMap = YamlNodeKt.getYamlMap((YamlNode)node);
                String key$iv = "images";
                boolean $i$f$get = false;
                iterable2 = this_$iv.getEntries().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Map.Entry it$iv = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((YamlScalar)it$iv.getKey()).getContent(), (Object)key$iv)) continue;
                    v2 = element$iv$iv;
                    break block8;
                }
                v2 = null;
            }
            Map.Entry entry = v2;
            if (entry == null || (iterable2 = (YamlNode)entry.getValue()) == null) {
                iterable = null;
            } else {
                Iterable node$iv = iterable2;
                Iterable iterable3 = node$iv;
                if (!(iterable3 instanceof YamlNode)) {
                    iterable3 = iterable = null;
                }
                if (iterable3 == null) {
                    throw new IncorrectTypeException("Expected element to be " + Reflection.getOrCreateKotlinClass(YamlNode.class).getSimpleName() + " but is " + Reflection.getOrCreateKotlinClass(node$iv.getClass()).getSimpleName(), node$iv.getPath());
                }
            }
            yamlNode = iterable;
            if (iterable == null) {
                throw new Error("Image list should be in the root of the file, or in the 'images:' property");
            }
        }
        YamlNode imagesNode = yamlNode;
        return (Collection)Yaml.Companion.getDefault().decodeFromYamlNode((DeserializationStrategy)BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)), imagesNode);
    }

    @NotNull
    public final Collection<String> readImagesFromFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readImagesFromFile(PathsJvmKt.Path((String)path));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> readImagesFromFile(@NotNull Path path) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.endsWith((String)path.getName(), (String)".yaml", (boolean)true) || StringsKt.endsWith((String)path.getName(), (String)".yml", (boolean)true)) {
            Object object;
            Object $this$readImagesFromFile_u24lambda_u240;
            var2_2 = this;
            try {
                $this$readImagesFromFile_u24lambda_u240 = var2_2;
                boolean bl = false;
                $this$readImagesFromFile_u24lambda_u240 = Result.constructor-impl(super.parseYamlImageList(path));
            }
            catch (Throwable bl) {
                $this$readImagesFromFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            var2_2 = $this$readImagesFromFile_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)var2_2);
            if (throwable != null) {
                Object it2 = $this$readImagesFromFile_u24lambda_u240 = throwable;
                boolean bl = false;
                logger.warn((Throwable)it2, () -> ConfigFile.readImagesFromFile$lambda$1$0(path));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)var2_2);
            if (throwable2 == null) {
                object = var2_2;
            } else {
                Throwable it3 = throwable2;
                boolean bl = false;
                object = CollectionsKt.emptyList();
            }
            collection = (Collection)object;
        } else {
            var2_2 = new String[]{"\n"};
            collection = StringsKt.split$default((CharSequence)Utf8Kt.readString((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path))), (String[])var2_2, (boolean)false, (int)0, (int)6, null);
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (!Character.isLetterOrDigit(StringsKt.first((CharSequence)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String it4 = (String)e$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it4.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @NotNull
    public final ProjectConfig readProjectConfig(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw new NotImplementedError(null, 1, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readImagesFromFile$lambda$1$0(Path $path) {
        return "Could not get image list from file " + $path;
    }
}

