/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.compress;

import dev.mosaify.core.util.compress.CompressUtils_jvmKt;
import dev.mosaify.core.util.platform.TempPath;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Ldev/mosaify/core/util/compress/CompressUtils;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger$mosaify_util_compress", "()Lio/github/oshai/kotlinlogging/KLogger;", "compressAndEncode", "", "contents", "", "decodeAndDecompress", "compressedEncoded", "compressDirectory", "Ldev/mosaify/core/util/platform/TempPath;", "directory", "Lkotlinx/io/files/Path;", "unZipTo", "", "zipFile", "destinationDir", "unTgzTo", "tgzFile", "readGzText", "gzFile", "mosaify-util-compress"})
public final class CompressUtils {
    @NotNull
    public static final CompressUtils INSTANCE = new CompressUtils();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(CompressUtils::logger$lambda$0);

    private CompressUtils() {
    }

    @NotNull
    public final KLogger getLogger$mosaify_util_compress() {
        return logger;
    }

    @NotNull
    public final String compressAndEncode(@NotNull byte[] contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        return CompressUtils_jvmKt.compressAndEncodeImpl(contents);
    }

    @NotNull
    public final byte[] decodeAndDecompress(@NotNull String compressedEncoded) {
        Intrinsics.checkNotNullParameter((Object)compressedEncoded, (String)"compressedEncoded");
        return CompressUtils_jvmKt.decodeAndDecompressImpl(compressedEncoded);
    }

    @NotNull
    public final TempPath compressDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return CompressUtils_jvmKt.compressDirectoryImpl(directory);
    }

    public final void unZipTo(@NotNull Path zipFile, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        CompressUtils_jvmKt.unZipToImpl(zipFile, destinationDir);
    }

    public final void unTgzTo(@NotNull Path tgzFile, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)tgzFile, (String)"tgzFile");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        CompressUtils_jvmKt.unTgzToImpl(tgzFile, destinationDir);
    }

    @NotNull
    public final String readGzText(@NotNull Path gzFile) {
        Intrinsics.checkNotNullParameter((Object)gzFile, (String)"gzFile");
        return CompressUtils_jvmKt.readGzTextImpl(gzFile);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }
}

