/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.normalization;

import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueFlag;
import dev.mosaify.core.model.generic.IssueStatus;
import dev.mosaify.core.model.metadata.BasicProjectInfo;
import dev.mosaify.core.model.taxonomy.Extensions;
import dev.mosaify.core.util.normalization.NormalizationUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JU\u0010\n\u001a\u0011\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u000e\u00a2\u0006\u0002\b\r2\u0015\u0010\u000f\u001a\u0011\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u000e\u00a2\u0006\u0002\b\r2\u0015\u0010\u0010\u001a\u0011\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u000e\u00a2\u0006\u0002\b\r2\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Ldev/mosaify/core/util/normalization/CompareUtils;", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "normalizationUtils", "Ldev/mosaify/core/util/normalization/NormalizationUtils;", "getNormalizationUtils", "()Ldev/mosaify/core/util/normalization/NormalizationUtils;", "compareReports", "", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "first", "second", "preferredScanners", "", "mosaify-util-normalization"})
@SourceDebugExtension(value={"SMAP\nCompareUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareUtils.kt\ndev/mosaify/core/util/normalization/CompareUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,88:1\n1761#2,3:89\n1761#2,3:92\n1761#2,3:95\n1491#2:98\n1516#2,3:99\n1519#2,3:109\n2783#2,7:116\n1491#2:123\n1516#2,3:124\n1519#2,3:134\n2783#2,7:141\n1491#2:148\n1516#2,2:149\n1563#2:151\n1634#2,3:152\n1563#2:155\n1634#2,3:156\n1518#2:159\n1519#2,3:167\n1491#2:170\n1516#2,2:171\n1563#2:173\n1634#2,3:174\n1563#2:177\n1634#2,3:178\n1518#2:181\n1519#2,3:189\n1374#2:192\n1460#2,2:193\n1563#2:195\n1634#2,3:196\n1563#2:199\n1634#2,3:200\n1563#2:203\n1634#2,3:204\n1563#2:207\n1634#2,3:208\n1462#2,3:211\n382#3,7:102\n382#3,7:127\n382#3,7:160\n382#3,7:182\n126#4:112\n153#4,3:113\n126#4:137\n153#4,3:138\n*S KotlinDebug\n*F\n+ 1 CompareUtils.kt\ndev/mosaify/core/util/normalization/CompareUtils\n*L\n24#1:89,3\n25#1:92,3\n26#1:95,3\n38#1:98\n38#1:99,3\n38#1:109,3\n40#1:116,7\n42#1:123\n42#1:124,3\n42#1:134,3\n44#1:141,7\n49#1:148\n49#1:149,2\n51#1:151\n51#1:152,3\n52#1:155\n52#1:156,3\n49#1:159\n49#1:167,3\n55#1:170\n55#1:171,2\n57#1:173\n57#1:174,3\n58#1:177\n58#1:178,3\n55#1:181\n55#1:189,3\n64#1:192\n64#1:193,2\n72#1:195\n72#1:196,3\n73#1:199\n73#1:200,3\n78#1:203\n78#1:204,3\n80#1:207\n80#1:208,3\n64#1:211,3\n38#1:102,7\n42#1:127,7\n49#1:160,7\n55#1:182,7\n39#1:112\n39#1:113,3\n43#1:137\n43#1:138,3\n*E\n"})
public final class CompareUtils {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final NormalizationUtils normalizationUtils;

    public CompareUtils(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.normalizationUtils = new NormalizationUtils(this.logger);
    }

    public /* synthetic */ CompareUtils(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger(CompareUtils::_init_$lambda$0);
        }
        this(kLogger);
    }

    @NotNull
    public final NormalizationUtils getNormalizationUtils() {
        return this.normalizationUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Issue> compareReports(@NotNull Collection<Issue> first, @NotNull Collection<Issue> second, @Nullable Collection<String> preferredScanners) {
        void $this$flatMapTo$iv$iv;
        Collection collection;
        Object key$iv$iv$iv;
        Iterable iterable;
        Iterable iterable2;
        Object item$iv$iv;
        String $this$mapTo$iv$iv;
        Object object;
        void $this$groupByTo$iv$iv2;
        Object sum;
        void var11_23;
        void $this$reduce$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Object list$iv$iv;
        Issue it;
        void $this$groupByTo$iv$iv3;
        Object sum2;
        void $this$reduce$iv2;
        Object object2;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv2;
        Object list$iv$iv2;
        Object value$iv$iv$iv;
        boolean bl;
        void $this$groupByTo$iv$iv4;
        Object element$iv2;
        block81: {
            block80: {
                boolean bl2;
                block75: {
                    boolean bl3;
                    Issue it2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block74: {
                        block79: {
                            block78: {
                                boolean bl4;
                                block73: {
                                    boolean bl5;
                                    block72: {
                                        block77: {
                                            block76: {
                                                boolean bl6;
                                                block71: {
                                                    boolean bl7;
                                                    block70: {
                                                        Intrinsics.checkNotNullParameter(first, (String)"first");
                                                        Intrinsics.checkNotNullParameter(second, (String)"second");
                                                        $this$any$iv = first;
                                                        $i$f$any = false;
                                                        if (((Collection)$this$any$iv).isEmpty()) {
                                                            bl7 = false;
                                                        } else {
                                                            for (Object element$iv2 : $this$any$iv) {
                                                                Issue it3 = (Issue)element$iv2;
                                                                boolean bl72 = false;
                                                                if (!(it3.getStatus() != null)) continue;
                                                                bl7 = true;
                                                                break block70;
                                                            }
                                                            bl7 = false;
                                                        }
                                                    }
                                                    if (bl7) break block76;
                                                    $this$any$iv = second;
                                                    $i$f$any = false;
                                                    if (((Collection)$this$any$iv).isEmpty()) {
                                                        bl6 = false;
                                                    } else {
                                                        for (Object element$iv2 : $this$any$iv) {
                                                            it2 = (Issue)element$iv2;
                                                            boolean bl8 = false;
                                                            if (!(it2.getStatus() != null)) continue;
                                                            bl6 = true;
                                                            break block71;
                                                        }
                                                        bl6 = false;
                                                    }
                                                }
                                                if (!bl6) break block77;
                                            }
                                            this.logger.warn(CompareUtils::compareReports$lambda$2);
                                        }
                                        $this$any$iv = first;
                                        $i$f$any = false;
                                        if (((Collection)$this$any$iv).isEmpty()) {
                                            bl5 = false;
                                        } else {
                                            for (Object element$iv2 : $this$any$iv) {
                                                it2 = (Issue)element$iv2;
                                                boolean bl9 = false;
                                                if (!(it2.getProjects() == null)) continue;
                                                bl5 = true;
                                                break block72;
                                            }
                                            bl5 = false;
                                        }
                                    }
                                    if (bl5) break block78;
                                    $this$any$iv = second;
                                    $i$f$any = false;
                                    if (((Collection)$this$any$iv).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv2 : $this$any$iv) {
                                            it2 = (Issue)element$iv2;
                                            boolean bl10 = false;
                                            if (!(it2.getProjects() == null)) continue;
                                            bl4 = true;
                                            break block73;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) break block79;
                            }
                            this.logger.warn(CompareUtils::compareReports$lambda$5);
                        }
                        $this$any$iv = first;
                        $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it2 = (Issue)element$iv2;
                                boolean bl11 = false;
                                if (!it2.getFlags().contains(IssueFlag.NORMALIZED)) continue;
                                bl3 = true;
                                break block74;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) break block80;
                    $this$any$iv = second;
                    $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (Issue)element$iv2;
                            boolean bl12 = false;
                            if (!it2.getFlags().contains(IssueFlag.NORMALIZED)) continue;
                            bl2 = true;
                            break block75;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break block81;
            }
            this.logger.warn(CompareUtils::compareReports$lambda$8);
        }
        this.logger.warn(CompareUtils::compareReports$lambda$9);
        Object $this$groupBy$iv = first;
        boolean $i$f$groupBy = false;
        element$iv2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv4) {
            Object object3;
            void $this$getOrPut$iv$iv$iv;
            Issue it2 = (Issue)t;
            bl = false;
            Set set = it2.getProjects();
            Map map = destination$iv$iv;
            Set key$iv$iv$iv2 = set;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv2);
            if (value$iv$iv$iv == null) {
                boolean bl13 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv2, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv2 = (List)object3;
            list$iv$iv2.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv4 = $this$map$iv2;
        destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry entry : $this$mapTo$iv$iv3.entrySet()) {
            void it3;
            list$iv$iv2 = entry;
            object2 = destination$iv$iv;
            bl = false;
            object2.add(this.normalizationUtils.normalizeByIdentifier((Collection)it3.getValue(), preferredScanners));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void element;
            Pair $i$f$mapTo22 = (Pair)iterator$iv.next();
            sum2 = (Pair)accumulator$iv;
            boolean bl8 = false;
            accumulator$iv = new Pair((Object)CollectionsKt.plus((Collection)((Collection)sum2.getFirst()), (Iterable)((Iterable)element.getFirst())), (Object)CollectionsKt.plus((Collection)((Collection)sum2.getSecond()), (Iterable)((Iterable)element.getSecond())));
        }
        Pair pair = (Pair)accumulator$iv;
        Collection firstNormalized = (Collection)pair.component1();
        Collection firstUnprocessed = (Collection)pair.component2();
        Object $this$groupBy$iv2 = second;
        boolean $i$f$groupBy2 = false;
        sum2 = $this$groupBy$iv2;
        Map map = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object t : $this$groupByTo$iv$iv3) {
            Object object4;
            void $this$getOrPut$iv$iv$iv;
            it = (Issue)t;
            boolean bl9 = false;
            Set key$iv$iv = it.getProjects();
            value$iv$iv$iv = map;
            Set key$iv$iv$iv3 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv3);
            if (value$iv$iv$iv2 == null) {
                boolean bl14 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv3, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv2;
            }
            list$iv$iv = (List)object4;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv2 = map;
        boolean $i$f$map2 = false;
        $this$groupByTo$iv$iv3 = $this$map$iv;
        Collection collection2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo322 = false;
        for (Map.Entry entry : $this$mapTo$iv$iv2.entrySet()) {
            list$iv$iv = entry;
            object2 = collection2;
            boolean bl10 = false;
            object2.add(this.normalizationUtils.normalizeByIdentifier((Collection)it.getValue(), preferredScanners));
        }
        $this$map$iv = (List)collection2;
        boolean $i$f$reduce2 = false;
        Iterator iterator$iv2 = $this$reduce$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object t = iterator$iv2.next();
        while (iterator$iv2.hasNext()) {
            void element;
            Pair $i$f$mapTo322 = (Pair)iterator$iv2.next();
            sum = (Pair)var11_23;
            boolean bl11 = false;
            Pair pair2 = new Pair((Object)CollectionsKt.plus((Collection)((Collection)sum.getFirst()), (Iterable)((Iterable)element.getFirst())), (Object)CollectionsKt.plus((Collection)((Collection)sum.getSecond()), (Iterable)((Iterable)element.getSecond())));
        }
        Pair pair2 = (Pair)var11_23;
        Collection secondNormalized = (Collection)pair2.component1();
        Collection secondUnprocessed = (Collection)pair2.component2();
        if (!firstUnprocessed.isEmpty() || !secondUnprocessed.isEmpty()) {
            this.logger.warn(() -> CompareUtils.compareReports$lambda$16(firstUnprocessed, secondUnprocessed));
        }
        Iterable iterable3 = firstNormalized;
        boolean $i$f$groupBy3 = false;
        sum = iterable3;
        Map map2 = new LinkedHashMap();
        boolean $i$f$groupByTo3 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object5;
            void $this$getOrPut$iv$iv$iv;
            void $this$mapTo$iv$iv4;
            void $this$map$iv3;
            List list;
            Collection<String> collection3;
            Issue issue = (Issue)element$iv$iv;
            boolean bl12 = false;
            Set set = issue.getProjects();
            if (set != null) {
                Iterable $this$map$iv4 = set;
                boolean $i$f$map3 = false;
                object = $this$map$iv4;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo4 = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void project;
                    item$iv$iv = iterator.next();
                    BasicProjectInfo basicProjectInfo = (BasicProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv4;
                    boolean bl152 = false;
                    String string = project.getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    collection3.add(string);
                }
                list = (List)destination$iv$iv4;
            } else {
                list = null;
            }
            iterable2 = CollectionsKt.sorted((Iterable)Extensions.INSTANCE.getPrimaryId(issue));
            collection3 = list;
            boolean $i$f$map4 = false;
            void $i$f$map3 = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                Iterator it4;
                item$iv$iv = (String)item$iv$iv4;
                iterable = destination$iv$iv5;
                boolean bl16 = false;
                String string = ((String)((Object)it4)).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                iterable.add(string);
            }
            List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv5));
            Collection<String> collection4 = collection3;
            Pair key$iv$iv = new Pair(collection4, (Object)list2);
            Map map3 = map2;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv3 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv3 == null) {
                boolean bl17 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv3;
            }
            List list$iv$iv3 = (List)object5;
            list$iv$iv3.add(element$iv$iv);
        }
        Map firstGrouped = map2;
        Iterable $this$groupBy$iv4 = secondNormalized;
        boolean $i$f$groupBy4 = false;
        Iterable iterable4 = $this$groupBy$iv4;
        Object destination$iv$iv6 = new LinkedHashMap();
        boolean $i$f$groupByTo4 = false;
        for (Object element$iv$iv : iterable4) {
            Object object6;
            void $this$getOrPut$iv$iv$iv;
            void $this$map$iv5;
            List list;
            Collection<String> bl152;
            Issue issue = (Issue)element$iv$iv;
            boolean bl13 = false;
            Set set = issue.getProjects();
            if (set != null) {
                void $this$mapTo$iv$iv5;
                Iterable $this$map$iv6 = set;
                boolean $i$f$map5 = false;
                Iterable $i$f$mapTo5 = $this$map$iv6;
                Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                boolean $i$f$mapTo6 = false;
                for (Object item$iv$iv5 : $this$mapTo$iv$iv5) {
                    void project;
                    BasicProjectInfo basicProjectInfo = (BasicProjectInfo)item$iv$iv5;
                    bl152 = destination$iv$iv7;
                    boolean bl18 = false;
                    String string = project.getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    bl152.add(string);
                }
                list = (List)destination$iv$iv7;
            } else {
                list = null;
            }
            iterable = CollectionsKt.sorted((Iterable)Extensions.INSTANCE.getPrimaryId(issue));
            bl152 = list;
            boolean $i$f$map6 = false;
            void $i$f$map5 = $this$map$iv5;
            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo7 = false;
            Iterator $i$f$mapTo6 = $this$mapTo$iv$iv.iterator();
            while ($i$f$mapTo6.hasNext()) {
                void it5;
                Object item$iv$iv5;
                item$iv$iv = $i$f$mapTo6.next();
                item$iv$iv5 = (String)item$iv$iv;
                collection = destination$iv$iv8;
                boolean bl19 = false;
                String string = it5.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                collection.add(string);
            }
            List list3 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv8));
            Collection<String> collection5 = bl152;
            Pair key$iv$iv = new Pair(collection5, (Object)list3);
            key$iv$iv$iv = destination$iv$iv6;
            Pair key$iv$iv$iv4 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv4 = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv4);
            if (value$iv$iv$iv4 == null) {
                boolean bl20 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv4, answer$iv$iv$iv);
                object6 = answer$iv$iv$iv;
            } else {
                object6 = value$iv$iv$iv4;
            }
            List list$iv$iv4 = (List)object6;
            list$iv$iv4.add(element$iv$iv);
        }
        Map map4 = destination$iv$iv6;
        List uniqueKeys = CollectionsKt.distinct((Iterable)SetsKt.plus(firstGrouped.keySet(), (Iterable)map4.keySet()));
        Iterable $this$flatMap$iv = uniqueKeys;
        boolean bl14 = false;
        destination$iv$iv6 = $this$flatMap$iv;
        Collection destination$iv$iv9 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Pair key = (Pair)element$iv$iv;
            boolean bl15 = false;
            List issuesInFirst = (List)firstGrouped.get(key);
            List issuesInSecond = (List)map4.get(key);
            if (issuesInFirst == null && issuesInSecond == null) {
                $this$mapTo$iv$iv = "Unexpected: both reports didn't contain issues with keys generated from these two reports";
                throw new NotImplementedError("An operation is not implemented: " + $this$mapTo$iv$iv);
            }
            if (issuesInFirst == null && issuesInSecond != null) {
                $this$map$iv = issuesInSecond;
                $i$f$map = false;
                Iterable $i$f$mapTo7 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var29_99 = $this$mapTo$iv$iv.iterator();
                while (var29_99.hasNext()) {
                    item$iv$iv = var29_99.next();
                    Issue bl152 = (Issue)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl21 = false;
                    iterable2.add(Issue.copy$default((Issue)it, null, null, (IssueStatus)IssueStatus.NEW, null, null, null, null, null, null, null, null, null, null, null, null, (int)32763, null));
                }
                list = (List)destination$iv$iv;
            } else if (issuesInFirst != null && issuesInSecond == null) {
                $this$map$iv = issuesInFirst;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var29_99 = $this$mapTo$iv$iv.iterator();
                while (var29_99.hasNext()) {
                    item$iv$iv = var29_99.next();
                    it = (Issue)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl22 = false;
                    iterable2.add(Issue.copy$default((Issue)it, null, null, (IssueStatus)IssueStatus.REMOVED, null, null, null, null, null, null, null, null, null, null, null, null, (int)32763, null));
                }
                list = (List)destination$iv$iv;
            } else if (issuesInFirst != null && issuesInSecond != null) {
                if (issuesInFirst.size() != issuesInSecond.size()) {
                    $this$map$iv = "Unexpected scenario: unchanged issue count differs between compared reports";
                    throw new NotImplementedError("An operation is not implemented: " + (String)$this$map$iv);
                }
                $this$map$iv = issuesInSecond;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var29_99 = $this$mapTo$iv$iv.iterator();
                while (var29_99.hasNext()) {
                    item$iv$iv = var29_99.next();
                    it = (Issue)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl23 = false;
                    iterable2.add(Issue.copy$default((Issue)it, null, null, (IssueStatus)IssueStatus.UNCHANGED, null, null, null, null, null, null, null, null, null, null, null, null, (int)32763, null));
                }
                $this$map$iv = CollectionsKt.plus((Collection)firstUnprocessed, (Iterable)secondUnprocessed);
                iterable2 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var29_99 = $this$mapTo$iv$iv.iterator();
                while (var29_99.hasNext()) {
                    item$iv$iv = var29_99.next();
                    it = (Issue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl24 = false;
                    collection.add(Issue.copy$default((Issue)it, null, null, (IssueStatus)IssueStatus.UNKNOWN, null, null, null, null, null, null, null, null, null, null, null, null, (int)32763, null));
                }
                list = CollectionsKt.plus((Collection)iterable2, (Iterable)((List)destination$iv$iv));
            } else {
                object = "An unexpected scenario while comparing reports";
                throw new NotImplementedError("An operation is not implemented: " + (String)object);
            }
            Iterable list$iv$iv5 = list;
            CollectionsKt.addAll((Collection)destination$iv$iv9, (Iterable)list$iv$iv5);
        }
        return (List)destination$iv$iv9;
    }

    public static /* synthetic */ Collection compareReports$default(CompareUtils compareUtils, Collection collection, Collection collection2, Collection collection3, int n, Object object) {
        if ((n & 4) != 0) {
            collection3 = null;
        }
        return compareUtils.compareReports(collection, collection2, collection3);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object compareReports$lambda$2() {
        return "Compared reports already contain results of a previous comparison, this information will be overwritten by the new comparison";
    }

    private static final Object compareReports$lambda$5() {
        return "Compared reports contain issues without project information. Comparison may be incorrect";
    }

    private static final Object compareReports$lambda$8() {
        return "Avoid using normalized reports with this function - this may produce inconsistent results";
    }

    private static final Object compareReports$lambda$9() {
        return "\n >> Report comparison functionality is currently EXPERIMENTAL.\n >> We only support comparing reports normalized by primary issue identifier (CVE, GHSA, OSV, etc). Both reports will be normalized before comparison\n       ";
    }

    private static final Object compareReports$lambda$16(Collection $firstUnprocessed, Collection $secondUnprocessed) {
        return "There were " + ($firstUnprocessed.size() + $secondUnprocessed.size()) + " issues that we could not normalize by identifier. They will be marked as '" + IssueStatus.UNKNOWN.getDisplayName() + "'";
    }

    public CompareUtils() {
        this(null, 1, null);
    }
}

