/*
 * Decompiled with CFR 0.152.
 */
package io.konform.validation.constraints;

import io.konform.validation.Constraint;
import io.konform.validation.ValidationBuilder;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0004\n\u0002\b\u0002\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0006\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\b\u001a%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u000b\u001a%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\f\u001a%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u000f\u001a%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u000e\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0010\u001a%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0013\u001a%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u0014\u001a(\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0001\"\b\b\u0000\u0010\u0016*\u00020\u0017*\b\u0012\u0004\u0012\u0002H\u00160\u00032\u0006\u0010\u0018\u001a\u00020\u0017\u00a8\u0006\u0019"}, d2={"exclusiveMaximum", "Lio/konform/validation/Constraint;", "", "Lio/konform/validation/ValidationBuilder;", "maximumExclusive", "", "exclusiveMaximumDouble", "", "exclusiveMaximumFloat", "exclusiveMinimum", "minimumExclusive", "exclusiveMinimumDouble", "exclusiveMinimumFloat", "maximum", "maximumInclusive", "maximumDouble", "maximumFloat", "minimum", "minimumInclusive", "minimumDouble", "minimumFloat", "multipleOf", "T", "", "factor", "konform"})
@SourceDebugExtension(value={"SMAP\nNumberConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberConstraints.kt\nio/konform/validation/constraints/NumberConstraintsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class NumberConstraintsKt {
    @NotNull
    public static final <T extends Number> Constraint<T> multipleOf(@NotNull ValidationBuilder<T> $this$multipleOf, @NotNull Number factor) {
        Intrinsics.checkNotNullParameter($this$multipleOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)factor, (String)"factor");
        double factorAsDouble = factor.doubleValue();
        if (!(factorAsDouble > 0.0)) {
            boolean bl = false;
            String string = "multipleOf requires the factor to be strictly larger than 0";
            throw new IllegalArgumentException(string.toString());
        }
        String[] stringArray = new String[]{factor.toString()};
        return $this$multipleOf.addConstraint("must be a multiple of '{0}'", stringArray, (Function1)new Function1<T, Boolean>(factorAsDouble){
            final /* synthetic */ double $factorAsDouble;
            {
                this.$factorAsDouble = $factorAsDouble;
                super(1);
            }

            public final Boolean invoke(T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                double division = ((Number)it).doubleValue() / this.$factorAsDouble;
                return Double.compare(division, MathKt.roundToInt((double)division)) == 0;
            }
        });
    }

    @JvmName(name="maximumFloat")
    @NotNull
    public static final Constraint<Float> maximumFloat(@NotNull ValidationBuilder<Float> $this$maximum, int maximumInclusive) {
        Intrinsics.checkNotNullParameter($this$maximum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$maximum, "must be at most '" + maximumInclusive + '\'', null, null, (Function1)new Function1<Float, Boolean>(maximumInclusive){
            final /* synthetic */ int $maximumInclusive;
            {
                this.$maximumInclusive = $maximumInclusive;
                super(1);
            }

            public final Boolean invoke(float it) {
                return it <= (float)this.$maximumInclusive;
            }
        }, 6, null);
    }

    @JvmName(name="maximumDouble")
    @NotNull
    public static final Constraint<Double> maximumDouble(@NotNull ValidationBuilder<Double> $this$maximum, int maximumInclusive) {
        Intrinsics.checkNotNullParameter($this$maximum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$maximum, "must be at most '" + maximumInclusive + '\'', null, null, (Function1)new Function1<Double, Boolean>(maximumInclusive){
            final /* synthetic */ int $maximumInclusive;
            {
                this.$maximumInclusive = $maximumInclusive;
                super(1);
            }

            public final Boolean invoke(double it) {
                return it <= (double)this.$maximumInclusive;
            }
        }, 6, null);
    }

    @JvmName(name="exclusiveMaximumFloat")
    @NotNull
    public static final Constraint<Float> exclusiveMaximumFloat(@NotNull ValidationBuilder<Float> $this$exclusiveMaximum, int maximumExclusive) {
        Intrinsics.checkNotNullParameter($this$exclusiveMaximum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$exclusiveMaximum, "must be at most '" + maximumExclusive + '\'', null, null, (Function1)new Function1<Float, Boolean>(maximumExclusive){
            final /* synthetic */ int $maximumExclusive;
            {
                this.$maximumExclusive = $maximumExclusive;
                super(1);
            }

            public final Boolean invoke(float it) {
                return it < (float)this.$maximumExclusive;
            }
        }, 6, null);
    }

    @JvmName(name="exclusiveMaximumDouble")
    @NotNull
    public static final Constraint<Double> exclusiveMaximumDouble(@NotNull ValidationBuilder<Double> $this$exclusiveMaximum, int maximumExclusive) {
        Intrinsics.checkNotNullParameter($this$exclusiveMaximum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$exclusiveMaximum, "must be at most '" + maximumExclusive + '\'', null, null, (Function1)new Function1<Double, Boolean>(maximumExclusive){
            final /* synthetic */ int $maximumExclusive;
            {
                this.$maximumExclusive = $maximumExclusive;
                super(1);
            }

            public final Boolean invoke(double it) {
                return it < (double)this.$maximumExclusive;
            }
        }, 6, null);
    }

    @JvmName(name="minimumFloat")
    @NotNull
    public static final Constraint<Float> minimumFloat(@NotNull ValidationBuilder<Float> $this$minimum, int minimumInclusive) {
        Intrinsics.checkNotNullParameter($this$minimum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$minimum, "must be at most '" + minimumInclusive + '\'', null, null, (Function1)new Function1<Float, Boolean>(minimumInclusive){
            final /* synthetic */ int $minimumInclusive;
            {
                this.$minimumInclusive = $minimumInclusive;
                super(1);
            }

            public final Boolean invoke(float it) {
                return it >= (float)this.$minimumInclusive;
            }
        }, 6, null);
    }

    @JvmName(name="minimumDouble")
    @NotNull
    public static final Constraint<Double> minimumDouble(@NotNull ValidationBuilder<Double> $this$minimum, int minimumInclusive) {
        Intrinsics.checkNotNullParameter($this$minimum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$minimum, "must be at most '" + minimumInclusive + '\'', null, null, (Function1)new Function1<Double, Boolean>(minimumInclusive){
            final /* synthetic */ int $minimumInclusive;
            {
                this.$minimumInclusive = $minimumInclusive;
                super(1);
            }

            public final Boolean invoke(double it) {
                return it >= (double)this.$minimumInclusive;
            }
        }, 6, null);
    }

    @JvmName(name="exclusiveMinimumFloat")
    @NotNull
    public static final Constraint<Float> exclusiveMinimumFloat(@NotNull ValidationBuilder<Float> $this$exclusiveMinimum, int minimumExclusive) {
        Intrinsics.checkNotNullParameter($this$exclusiveMinimum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$exclusiveMinimum, "must be at most '" + minimumExclusive + '\'', null, null, (Function1)new Function1<Float, Boolean>(minimumExclusive){
            final /* synthetic */ int $minimumExclusive;
            {
                this.$minimumExclusive = $minimumExclusive;
                super(1);
            }

            public final Boolean invoke(float it) {
                return it > (float)this.$minimumExclusive;
            }
        }, 6, null);
    }

    @JvmName(name="exclusiveMinimumDouble")
    @NotNull
    public static final Constraint<Double> exclusiveMinimumDouble(@NotNull ValidationBuilder<Double> $this$exclusiveMinimum, int minimumExclusive) {
        Intrinsics.checkNotNullParameter($this$exclusiveMinimum, (String)"<this>");
        return ValidationBuilder.constrain$default($this$exclusiveMinimum, "must be at most '" + minimumExclusive + '\'', null, null, (Function1)new Function1<Double, Boolean>(minimumExclusive){
            final /* synthetic */ int $minimumExclusive;
            {
                this.$minimumExclusive = $minimumExclusive;
                super(1);
            }

            public final Boolean invoke(double it) {
                return it > (double)this.$minimumExclusive;
            }
        }, 6, null);
    }
}

