/*
 * Decompiled with CFR 0.152.
 */
package io.konform.validation.constraints;

import io.konform.validation.Constraint;
import io.konform.validation.ValidationBuilder;
import io.konform.validation.constraints.StringConstraintsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a8\u0006\f"}, d2={"containsPattern", "Lio/konform/validation/Constraint;", "", "Lio/konform/validation/ValidationBuilder;", "pattern", "Lkotlin/text/Regex;", "maxLength", "length", "", "minLength", "notBlank", "uuid", "konform"})
@SourceDebugExtension(value={"SMAP\nStringConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringConstraints.kt\nio/konform/validation/constraints/StringConstraintsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class StringConstraintsKt {
    @NotNull
    public static final Constraint<String> notBlank(@NotNull ValidationBuilder<String> $this$notBlank) {
        Intrinsics.checkNotNullParameter($this$notBlank, (String)"<this>");
        return ValidationBuilder.constrain$default($this$notBlank, "must not be blank", null, null, notBlank.1.INSTANCE, 6, null);
    }

    @NotNull
    public static final Constraint<String> minLength(@NotNull ValidationBuilder<String> $this$minLength, int length) {
        Intrinsics.checkNotNullParameter($this$minLength, (String)"<this>");
        if (!(length >= 0)) {
            boolean bl = false;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("minLength requires the length to be >= 0");
            throw new IllegalArgumentException(((Object)illegalArgumentException).toString());
        }
        return ValidationBuilder.constrain$default($this$minLength, "must have at least " + length + " characters", null, null, (Function1)new Function1<String, Boolean>(length){
            final /* synthetic */ int $length;
            {
                this.$length = $length;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.length() >= this.$length;
            }
        }, 6, null);
    }

    @NotNull
    public static final Constraint<String> maxLength(@NotNull ValidationBuilder<String> $this$maxLength, int length) {
        Intrinsics.checkNotNullParameter($this$maxLength, (String)"<this>");
        if (!(length >= 0)) {
            boolean bl = false;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("maxLength requires the length to be >= 0");
            throw new IllegalArgumentException(((Object)illegalArgumentException).toString());
        }
        return ValidationBuilder.constrain$default($this$maxLength, "must have at most " + length + " characters", null, null, (Function1)new Function1<String, Boolean>(length){
            final /* synthetic */ int $length;
            {
                this.$length = $length;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.length() <= this.$length;
            }
        }, 6, null);
    }

    @NotNull
    public static final Constraint<String> uuid(@NotNull ValidationBuilder<String> $this$uuid) {
        Intrinsics.checkNotNullParameter($this$uuid, (String)"<this>");
        return $this$uuid.hint(StringConstraintsKt.pattern($this$uuid, "^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$"), "must be a valid UUID string");
    }

    @NotNull
    public static final Constraint<String> pattern(@NotNull ValidationBuilder<String> $this$pattern, @NotNull String pattern2) {
        Intrinsics.checkNotNullParameter($this$pattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return StringConstraintsKt.pattern($this$pattern, new Regex(pattern2));
    }

    @NotNull
    public static final Constraint<String> pattern(@NotNull ValidationBuilder<String> $this$pattern, @NotNull Regex pattern2) {
        Intrinsics.checkNotNullParameter($this$pattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return ValidationBuilder.constrain$default($this$pattern, "must match pattern '" + pattern2 + '\'', null, null, (Function1)new Function1<String, Boolean>(pattern2){
            final /* synthetic */ Regex $pattern;
            {
                this.$pattern = $pattern;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = it;
                return this.$pattern.matches(charSequence);
            }
        }, 6, null);
    }

    @NotNull
    public static final Constraint<String> containsPattern(@NotNull ValidationBuilder<String> $this$containsPattern, @NotNull Regex pattern2) {
        Intrinsics.checkNotNullParameter($this$containsPattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return ValidationBuilder.constrain$default($this$containsPattern, "must include pattern '" + pattern2 + '\'', null, null, (Function1)new Function1<String, Boolean>(pattern2){
            final /* synthetic */ Regex $pattern;
            {
                this.$pattern = $pattern;
                super(1);
            }

            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = it;
                return this.$pattern.containsMatchIn(charSequence);
            }
        }, 6, null);
    }

    @NotNull
    public static final Constraint<String> containsPattern(@NotNull ValidationBuilder<String> $this$containsPattern, @NotNull String pattern2) {
        Intrinsics.checkNotNullParameter($this$containsPattern, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return StringConstraintsKt.containsPattern($this$containsPattern, new Regex(pattern2));
    }
}

