/*
 * Decompiled with CFR 0.152.
 */
package io.konform.validation.types;

import io.konform.validation.Invalid;
import io.konform.validation.Valid;
import io.konform.validation.Validation;
import io.konform.validation.ValidationResult;
import io.konform.validation.path.PathSegment;
import io.konform.validation.path.ValidationPath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B1\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\tB1\u0012\b\b\u0002\u0010\u0004\u001a\u00020\n\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/konform/validation/types/CallableValidation;", "T", "R", "Lio/konform/validation/Validation;", "path", "", "callable", "Lkotlin/Function1;", "validation", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lio/konform/validation/Validation;)V", "Lio/konform/validation/path/ValidationPath;", "(Lio/konform/validation/path/ValidationPath;Lkotlin/jvm/functions/Function1;Lio/konform/validation/Validation;)V", "toString", "", "validate", "Lio/konform/validation/ValidationResult;", "value", "(Ljava/lang/Object;)Lio/konform/validation/ValidationResult;", "konform"})
public final class CallableValidation<T, R>
implements Validation<T> {
    @NotNull
    private final ValidationPath path;
    @NotNull
    private final Function1<T, R> callable;
    @NotNull
    private final Validation<R> validation;

    public CallableValidation(@NotNull ValidationPath path, @NotNull Function1<? super T, ? extends R> callable, @NotNull Validation<? super R> validation) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter(validation, (String)"validation");
        this.path = path;
        this.callable = callable;
        this.validation = validation;
    }

    public /* synthetic */ CallableValidation(ValidationPath validationPath, Function1 function1, Validation validation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            validationPath = ValidationPath.Companion.getEMPTY();
        }
        this(validationPath, function1, validation);
    }

    public CallableValidation(@NotNull Object path, @NotNull Function1<? super T, ? extends R> callable, @NotNull Validation<? super R> validation) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter(validation, (String)"validation");
        Object[] objectArray = new Object[]{path};
        this(ValidationPath.Companion.of(objectArray), callable, validation);
    }

    @Override
    @NotNull
    public ValidationResult<T> validate(T value) {
        ValidationResult validationResult;
        Object toValidate = this.callable.invoke(value);
        ValidationResult<Object> callableResult = this.validation.invoke(toValidate);
        if (callableResult instanceof Valid) {
            validationResult = new Valid<T>(value);
        } else if (callableResult instanceof Invalid) {
            validationResult = ((Invalid)callableResult).prependPath(this.path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validationResult;
    }

    @NotNull
    public String toString() {
        return "CallableValidation(path=" + this.path + ", callable=" + this.callable + ", validation=" + this.validation + ')';
    }

    @Override
    @NotNull
    public ValidationResult<T> invoke(T value) {
        return Validation.DefaultImpls.invoke(this, value);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull ValidationPath path) {
        return Validation.DefaultImpls.prependPath(this, path);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull PathSegment pathSegment) {
        return Validation.DefaultImpls.prependPath(this, pathSegment);
    }
}

