/*
 * Decompiled with CFR 0.152.
 */
package io.konform.validation.types;

import io.konform.validation.Invalid;
import io.konform.validation.Validation;
import io.konform.validation.ValidationResult;
import io.konform.validation.ValidationResultKt;
import io.konform.validation.path.PathSegment;
import io.konform.validation.path.ValidationPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/konform/validation/types/ValidateAll;", "T", "Lio/konform/validation/Validation;", "validations", "", "(Ljava/util/List;)V", "toString", "", "validate", "Lio/konform/validation/ValidationResult;", "value", "(Ljava/lang/Object;)Lio/konform/validation/ValidationResult;", "konform"})
public final class ValidateAll<T>
implements Validation<T> {
    @NotNull
    private final List<Validation<T>> validations;

    public ValidateAll(@NotNull List<? extends Validation<? super T>> validations) {
        Intrinsics.checkNotNullParameter(validations, (String)"validations");
        this.validations = validations;
    }

    @Override
    @NotNull
    public ValidationResult<T> validate(T value) {
        List errors = new ArrayList();
        for (Validation<T> validation : this.validations) {
            ValidationResult<T> result = validation.validate(value);
            if (!(result instanceof Invalid)) continue;
            ((Collection)errors).add(result);
        }
        return ValidationResultKt.flattenOrValidInvalidList(errors, value);
    }

    @NotNull
    public String toString() {
        return "ValidateAll(validation=" + this.validations + ')';
    }

    @Override
    @NotNull
    public ValidationResult<T> invoke(T value) {
        return Validation.DefaultImpls.invoke(this, value);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull ValidationPath path) {
        return Validation.DefaultImpls.prependPath(this, path);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull PathSegment pathSegment) {
        return Validation.DefaultImpls.prependPath(this, pathSegment);
    }
}

