/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.model.taxonomy;

import dev.mosaify.core.model.generic.IssueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0081\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001#B1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"\u00a8\u0006$"}, d2={"Ldev/mosaify/core/model/taxonomy/IssueTaxonomy;", "", "regex", "Lkotlin/text/Regex;", "isScanner", "", "rank", "", "type", "", "Ldev/mosaify/core/model/generic/IssueType;", "<init>", "(Ljava/lang/String;ILkotlin/text/Regex;ZILjava/util/Collection;)V", "getRegex", "()Lkotlin/text/Regex;", "()Z", "getRank", "()I", "getType", "()Ljava/util/Collection;", "CWE", "CVE", "GHSA", "OSV", "GO", "CGA", "SNYK", "XRAY", "SEMGREP_SCA", "BLACKDUCK", "GMS", "PVE", "SONATYPE", "DLA", "OTHER", "Companion", "mosaify-model"})
public final class IssueTaxonomy
extends Enum<IssueTaxonomy> {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Regex regex;
    private final boolean isScanner;
    private final int rank;
    @NotNull
    private final Collection<IssueType> type;
    @NotNull
    private static final Sequence<IssueTaxonomy> primaryEntries;
    public static final /* enum */ IssueTaxonomy CWE;
    public static final /* enum */ IssueTaxonomy CVE;
    public static final /* enum */ IssueTaxonomy GHSA;
    public static final /* enum */ IssueTaxonomy OSV;
    public static final /* enum */ IssueTaxonomy GO;
    public static final /* enum */ IssueTaxonomy CGA;
    public static final /* enum */ IssueTaxonomy SNYK;
    public static final /* enum */ IssueTaxonomy XRAY;
    public static final /* enum */ IssueTaxonomy SEMGREP_SCA;
    public static final /* enum */ IssueTaxonomy BLACKDUCK;
    public static final /* enum */ IssueTaxonomy GMS;
    public static final /* enum */ IssueTaxonomy PVE;
    public static final /* enum */ IssueTaxonomy SONATYPE;
    public static final /* enum */ IssueTaxonomy DLA;
    public static final /* enum */ IssueTaxonomy OTHER;
    private static final /* synthetic */ IssueTaxonomy[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private IssueTaxonomy(Regex regex, boolean isScanner, int rank, Collection<? extends IssueType> type) {
        this.regex = regex;
        this.isScanner = isScanner;
        this.rank = rank;
        this.type = type;
    }

    @Nullable
    public final Regex getRegex() {
        return this.regex;
    }

    public final boolean isScanner() {
        return this.isScanner;
    }

    public final int getRank() {
        return this.rank;
    }

    @NotNull
    public final Collection<IssueType> getType() {
        return this.type;
    }

    public static IssueTaxonomy[] values() {
        return (IssueTaxonomy[])$VALUES.clone();
    }

    public static IssueTaxonomy valueOf(String value) {
        return Enum.valueOf(IssueTaxonomy.class, value);
    }

    @NotNull
    public static EnumEntries<IssueTaxonomy> getEntries() {
        return $ENTRIES;
    }

    private static final boolean primaryEntries$lambda$0(IssueTaxonomy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.rank >= 0;
    }

    static {
        CWE = new IssueTaxonomy(new Regex("\\b(CWE-\\d+)\\b", RegexOption.IGNORE_CASE), false, -50, CollectionsKt.listOf((Object)((Object)IssueType.CODE_VULNERABILITY)));
        CVE = new IssueTaxonomy(new Regex("\\b(CVE(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 100, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        GHSA = new IssueTaxonomy(new Regex("\\b(GHSA(?:-[23456789cfghjmpqrvwx]{4}){3})\\b", RegexOption.IGNORE_CASE), false, 500, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        OSV = new IssueTaxonomy(new Regex("\\b(OSV(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 1000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        GO = new IssueTaxonomy(new Regex("\\b(GO(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 2000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        CGA = new IssueTaxonomy(new Regex("\\b(CGA(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 20000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        SNYK = new IssueTaxonomy(new Regex("\\b(SNYK(?:-\\w+)+)\\b", RegexOption.IGNORE_CASE), true, 30000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        XRAY = new IssueTaxonomy(new Regex("\\b(XRAY-\\d+)\\b", RegexOption.IGNORE_CASE), true, 40000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        SEMGREP_SCA = new IssueTaxonomy(new Regex("\\b(ssc(?:-\\w+){5})\\b", RegexOption.IGNORE_CASE), true, 50000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        BLACKDUCK = new IssueTaxonomy(new Regex("\\b(BDSA(?:-\\d+)+)\\b", RegexOption.IGNORE_CASE), true, 60000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        GMS = new IssueTaxonomy(new Regex("\\b(GMS(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 100000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        PVE = new IssueTaxonomy(new Regex("\\b(GMS(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 150000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        SONATYPE = new IssueTaxonomy(new Regex("\\b(sonatype(?:-\\d+){2})\\b", RegexOption.IGNORE_CASE), false, 200000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        DLA = new IssueTaxonomy(new Regex("\\b(DLA(?:-\\d+){2})\\b\\b", RegexOption.IGNORE_CASE), false, 250000, CollectionsKt.listOf((Object)((Object)IssueType.COMPONENT_VULNERABILITY)));
        OTHER = new IssueTaxonomy(null, false, Integer.MIN_VALUE, CollectionsKt.emptyList());
        $VALUES = issueTaxonomyArray = new IssueTaxonomy[]{IssueTaxonomy.CWE, IssueTaxonomy.CVE, IssueTaxonomy.GHSA, IssueTaxonomy.OSV, IssueTaxonomy.GO, IssueTaxonomy.CGA, IssueTaxonomy.SNYK, IssueTaxonomy.XRAY, IssueTaxonomy.SEMGREP_SCA, IssueTaxonomy.BLACKDUCK, IssueTaxonomy.GMS, IssueTaxonomy.PVE, IssueTaxonomy.SONATYPE, IssueTaxonomy.DLA, IssueTaxonomy.OTHER};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        primaryEntries = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)IssueTaxonomy.getEntries())), IssueTaxonomy::primaryEntries$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000bJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Ldev/mosaify/core/model/taxonomy/IssueTaxonomy$Companion;", "", "<init>", "()V", "primaryEntries", "Lkotlin/sequences/Sequence;", "Ldev/mosaify/core/model/taxonomy/IssueTaxonomy;", "getPrimaryEntries", "()Lkotlin/sequences/Sequence;", "fromIssueId", "", "", "strings", "", "primaryOnly", "", "id", "extractKnownIds", "", "string", "processJsonArrayForIds", "a", "Lkotlinx/serialization/json/JsonArray;", "processJsonObjectForIds", "o", "Lkotlinx/serialization/json/JsonObject;", "mosaify-model"})
    @SourceDebugExtension(value={"SMAP\nIssueTaxonomy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueTaxonomy.kt\ndev/mosaify/core/model/taxonomy/IssueTaxonomy$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,219:1\n1285#2,2:220\n1299#2,4:222\n1374#2:235\n1460#2,5:236\n1374#2:241\n1460#2,5:242\n1374#2:247\n1460#2,5:248\n1374#2:253\n1460#2,5:254\n536#3:226\n521#3,6:227\n1321#4,2:233\n*S KotlinDebug\n*F\n+ 1 IssueTaxonomy.kt\ndev/mosaify/core/model/taxonomy/IssueTaxonomy$Companion\n*L\n166#1:220,2\n166#1:222,4\n179#1:235\n179#1:236,5\n197#1:241\n197#1:242,5\n207#1:247\n207#1:248,5\n208#1:253\n208#1:254,5\n167#1:226\n167#1:227,6\n172#1:233,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sequence<IssueTaxonomy> getPrimaryEntries() {
            return primaryEntries;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, IssueTaxonomy> fromIssueId(@NotNull Collection<String> strings, boolean primaryOnly) {
            void $this$filterTo$iv$iv;
            void $this$associateWithTo$iv$iv;
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            Iterable $this$associateWith$iv = CollectionsKt.distinct((Iterable)strings);
            boolean $i$f$associateWith = false;
            Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                IssueTaxonomy issueTaxonomy = Companion.fromIssueId((String)it);
                map.put(t, issueTaxonomy);
            }
            Map $this$filter$iv = destination$iv$iv;
            boolean $i$f$filter = false;
            result$iv = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!(!primaryOnly || SequencesKt.contains(Companion.getPrimaryEntries(), it.getValue()))) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv2;
        }

        public static /* synthetic */ Map fromIssueId$default(Companion companion, Collection collection, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromIssueId(collection, bl);
        }

        @NotNull
        public final IssueTaxonomy fromIssueId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)((Iterable)IssueTaxonomy.getEntries()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IssueTaxonomy it = (IssueTaxonomy)((Object)element$iv);
                boolean bl = false;
                if (it.getRegex() == null || !it.getRegex().containsMatchIn((CharSequence)id)) continue;
                return it;
            }
            return OTHER;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> extractKnownIds(@NotNull Collection<String> strings, boolean primaryOnly) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            Iterable $this$flatMap$iv = strings;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = Companion.extractKnownIds(it, primaryOnly);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public static /* synthetic */ Set extractKnownIds$default(Companion companion, Collection collection, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.extractKnownIds(collection, bl);
        }

        @NotNull
        public final Set<String> extractKnownIds(@NotNull String string, boolean primaryOnly) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)(primaryOnly ? this.getPrimaryEntries() : CollectionsKt.asSequence((Iterable)((Iterable)IssueTaxonomy.getEntries()))), Companion::extractKnownIds$lambda$1), arg_0 -> Companion.extractKnownIds$lambda$2(string, arg_0))));
        }

        public static /* synthetic */ Set extractKnownIds$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.extractKnownIds(string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> processJsonArrayForIds(@NotNull JsonArray a) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Iterable $this$flatMap$iv = (Iterable)a;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set<String> set;
                JsonElement arrayMemeber = (JsonElement)element$iv$iv;
                boolean bl = false;
                JsonElement jsonElement = arrayMemeber;
                if (jsonElement instanceof JsonPrimitive) {
                    set = dev.mosaify.core.model.taxonomy.IssueTaxonomy$Companion.extractKnownIds$default(Companion, ((JsonPrimitive)arrayMemeber).getContent(), false, 2, null);
                } else if (jsonElement instanceof JsonArray) {
                    set = Companion.processJsonArrayForIds((JsonArray)arrayMemeber);
                } else if (jsonElement instanceof JsonObject) {
                    set = Companion.processJsonObjectForIds((JsonObject)arrayMemeber);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Iterable list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final Set<String> processJsonObjectForIds(@Nullable JsonObject o) {
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            if (o == null) {
                return SetsKt.emptySet();
            }
            Iterable $this$flatMap$iv = o.keySet();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String key = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = dev.mosaify.core.model.taxonomy.IssueTaxonomy$Companion.extractKnownIds$default(Companion, key, false, 2, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = o.values();
            Set set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set<String> set2;
                JsonElement value = (JsonElement)element$iv$iv;
                boolean bl = false;
                JsonElement jsonElement = value;
                if (jsonElement instanceof JsonPrimitive) {
                    set2 = dev.mosaify.core.model.taxonomy.IssueTaxonomy$Companion.extractKnownIds$default(Companion, ((JsonPrimitive)value).getContent(), false, 2, null);
                } else if (jsonElement instanceof JsonArray) {
                    set2 = Companion.processJsonArrayForIds((JsonArray)value);
                } else if (jsonElement instanceof JsonObject) {
                    set2 = Companion.processJsonObjectForIds((JsonObject)value);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv)));
        }

        private static final Regex extractKnownIds$lambda$1(IssueTaxonomy it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.getRegex();
        }

        private static final Sequence extractKnownIds$lambda$2(String $string, Regex regex) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            return SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)$string, (int)0, (int)2, null), Companion::extractKnownIds$lambda$2$0);
        }

        private static final List extractKnownIds$lambda$2$0(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getDestructured().toList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

