/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util;

import com.aallam.similarity.JaroWinkler;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.metadata.ContainerImageInfo;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.Invocation;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import dev.samoylenko.packageurl.PackageUrlBasic;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.konform.validation.Validation;
import io.konform.validation.ValidationBuilder;
import io.konform.validation.constraints.StringConstraintsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\b\b\u0002\u0010(\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fJ\u000e\u0010-\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010.\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010.\u001a\u00020\u00142\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0$J\u0016\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\fJ\u0018\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\f2\b\b\u0002\u00105\u001a\u000206J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006<"}, d2={"Ldev/mosaify/core/util/CommonUtils;", "", "<init>", "()V", "SIMILARITY_THRESHOLD", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "jaroWinkler", "Lcom/aallam/similarity/JaroWinkler;", "knownPurlTypes", "", "", "getKnownPurlTypes", "()Ljava/util/List;", "defaultJson", "Lkotlinx/serialization/json/Json;", "getDefaultJson", "()Lkotlinx/serialization/json/Json;", "isSimilar", "", "string1", "string2", "normalizePurl", "purl", "normalizeAndCheckPurl", "detectPurlType", "string", "parserSupports", "reportParser", "Ldev/mosaify/core/model/report/ReportParser;", "run", "Ldev/mosaify/core/model/sarif/Run;", "detectIssueTypeFromId", "Ldev/mosaify/core/model/generic/IssueType;", "identifiers", "", "parseContainerImageString", "Ldev/mosaify/core/model/metadata/ContainerImageInfo;", "imageString", "normalize", "isValidImageRepository", "repository", "isValidDomainName", "checkUpdateRepo", "isContainerImageString", "hasErrors", "runs", "toAliasString", "name", "version", "markdownToPlainText", "markdownText", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "processASTNode", "", "original", "node", "Lorg/intellij/markdown/ast/ASTNode;", "mosaify-util-common"})
@SourceDebugExtension(value={"SMAP\nCommonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonUtils.kt\ndev/mosaify/core/util/CommonUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,247:1\n1#2:248\n1285#3,2:249\n1299#3,4:251\n1999#3,14:262\n1761#3,3:276\n1374#3:279\n1460#3,5:280\n1740#3,3:285\n1740#3,3:288\n1740#3,3:293\n1761#3,3:296\n1869#3,2:299\n827#3:301\n855#3,2:302\n827#3:304\n855#3,2:305\n504#4,7:255\n1088#5,2:291\n*S KotlinDebug\n*F\n+ 1 CommonUtils.kt\ndev/mosaify/core/util/CommonUtils\n*L\n61#1:249,2\n61#1:251,4\n64#1:262,14\n71#1:276,3\n76#1:279\n76#1:280,5\n161#1:285,3\n180#1:288,3\n200#1:293,3\n203#1:296,3\n237#1:299,2\n33#1:301\n33#1:302,2\n34#1:304\n34#1:305,2\n62#1:255,7\n188#1:291,2\n*E\n"})
public final class CommonUtils {
    @NotNull
    public static final CommonUtils INSTANCE;
    private static final double SIMILARITY_THRESHOLD = 0.67;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final JaroWinkler jaroWinkler;
    @NotNull
    private static final List<String> knownPurlTypes;
    @NotNull
    private static final Json defaultJson;

    private CommonUtils() {
    }

    @NotNull
    public final List<String> getKnownPurlTypes() {
        return knownPurlTypes;
    }

    @NotNull
    public final Json getDefaultJson() {
        return defaultJson;
    }

    public final boolean isSimilar(@NotNull String string1, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string1, (String)"string1");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string2");
        return jaroWinkler.similarity(string1, string2) >= 0.67;
    }

    @NotNull
    public final String normalizePurl(@NotNull String purl) {
        Intrinsics.checkNotNullParameter((Object)purl, (String)"purl");
        return PackageUrlBasic.Companion.parse$default((PackageUrlBasic.Companion)PackageUrlBasic.Companion, (String)purl, (boolean)false, (int)2, null).toString();
    }

    @Nullable
    public final String normalizeAndCheckPurl(@NotNull String purl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)purl, (String)"purl");
        Object object2 = this;
        try {
            CommonUtils $this$normalizeAndCheckPurl_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$normalizeAndCheckPurl_u24lambda_u240.normalizePurl(purl));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String detectPurlType(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (StringsKt.startsWith((String)string, (String)"ubuntu", (boolean)true)) {
            string2 = "deb/ubuntu";
        } else if (StringsKt.startsWith((String)string, (String)"alpine", (boolean)true)) {
            string2 = "apk/alpine";
        } else {
            Object v1;
            Iterator $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = knownPurlTypes;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object element$iv$iv = iterator.next();
                String string3 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Double d = jaroWinkler.similarity((String)it, string);
                map.put(t, d);
            }
            Map $this$filterValues$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                double it = ((Number)entry$iv.getValue()).doubleValue();
                boolean bl = false;
                if (!(it >= 0.67)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$maxByOrNull$iv = MapsKt.toList((Map)result$iv);
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Pair it = (Pair)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = ((Number)it.getSecond()).doubleValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-maxByOrNull-CommonUtils$detectPurlType$3 = false;
                        double v$iv = ((Number)it2.getSecond()).doubleValue();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Pair pair = v1;
            string2 = pair != null ? (String)pair.getFirst() : null;
        }
        return string2;
    }

    public final boolean parserSupports(@NotNull ReportParser reportParser, @NotNull Run run) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)reportParser, (String)"reportParser");
            Intrinsics.checkNotNullParameter((Object)run, (String)"run");
            Object object = RunExtraInfo.Companion.fromPropertyBag(run.getProperties());
            if (object == null || (object = object.getScanner()) == null) {
                object = run.getTool().getDriver().getName();
            }
            Object scannerName = object;
            boolean bl2 = false;
            Iterable $this$any$iv = reportParser.getAllNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.contentEquals((CharSequence)it, (CharSequence)((CharSequence)scannerName), (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IssueType detectIssueTypeFromId(@NotNull Collection<String> identifiers) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        Iterable $this$flatMap$iv = IssueTaxonomy.Companion.fromIssueId(identifiers, true).values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IssueTaxonomy it = (IssueTaxonomy)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getType();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List detectedTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return detectedTypes.size() > 1 ? null : (IssueType)CollectionsKt.firstOrNull((List)detectedTypes);
    }

    @NotNull
    public final ContainerImageInfo parseContainerImageString(@NotNull String imageString, boolean normalize) {
        Intrinsics.checkNotNullParameter((Object)imageString, (String)"imageString");
        if (!(!StringsKt.startsWith$default((String)imageString, (String)"sha256:", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-CommonUtils$parseContainerImageString$22 = false;
            String $i$a$-require-CommonUtils$parseContainerImageString$22 = "Referring container images by ID is currently not supported";
            throw new IllegalArgumentException($i$a$-require-CommonUtils$parseContainerImageString$22.toString());
        }
        Validation imageDigestValidation = Validation.Companion.invoke(CommonUtils::parseContainerImageString$lambda$1);
        Validation imageTagValidation = Validation.Companion.invoke(CommonUtils::parseContainerImageString$lambda$2);
        String repository = StringsKt.startsWith((String)imageString, (String)"https://", (boolean)true) ? StringsKt.drop((String)imageString, (int)8) : imageString;
        String digest = StringsKt.substringAfterLast$default((String)repository, (char)'@', null, (int)2, null);
        boolean validDigest = imageDigestValidation.validate((Object)digest).isValid();
        String tag = StringsKt.substringAfterLast((String)(repository = StringsKt.substringBeforeLast$default((String)repository, (char)'@', null, (int)2, null)), (char)':', (String)"");
        boolean validTag = imageTagValidation.invoke((Object)tag).isValid();
        if (validTag) {
            repository = StringsKt.substringBeforeLast$default((String)repository, (char)':', null, (int)2, null);
        }
        repository = normalize ? this.checkUpdateRepo(StringsKt.substringBeforeLast$default((String)repository, (char)'@', null, (int)2, null)) : repository;
        return new ContainerImageInfo(repository, (String)(validTag ? tag : (validDigest ? null : (normalize ? "latest" : null))), validDigest ? digest : null);
    }

    public static /* synthetic */ ContainerImageInfo parseContainerImageString$default(CommonUtils commonUtils, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return commonUtils.parseContainerImageString(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidImageRepository(@NotNull String repository) {
        boolean bl;
        block4: {
            void $this$all$iv;
            boolean firstSegmentPossibleDomain;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Validation imagePathSegmentValidation = Validation.Companion.invoke(CommonUtils::isValidImageRepository$lambda$0);
            char[] cArray = new char[]{'/'};
            List segments = StringsKt.split$default((CharSequence)repository, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = firstSegmentPossibleDomain = !imagePathSegmentValidation.validate(segments.get(0)).isValid();
            if (firstSegmentPossibleDomain && !this.isValidDomainName((String)segments.get(0))) {
                return false;
            }
            Iterable iterable = CollectionsKt.drop((Iterable)segments, (int)(firstSegmentPossibleDomain ? 1 : 0));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (imagePathSegmentValidation.invoke((Object)it).isValid()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidDomainName(@NotNull String string) {
        boolean bl;
        block6: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Validation portValidation = Validation.Companion.invoke(CommonUtils::isValidDomainName$lambda$0);
            Validation domainComponentValidation = Validation.Companion.invoke(CommonUtils::isValidDomainName$lambda$1);
            String port = StringsKt.substringAfter((String)string, (char)':', (String)"");
            if (((CharSequence)port).length() > 0) {
                if (!StringsKt.endsWith$default((String)string, (String)port, (boolean)false, (int)2, null)) {
                    return false;
                }
                if (portValidation.invoke((Object)port).isValid()) {
                    return false;
                }
            }
            Object object = new char[]{'.'};
            object = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)string, (char)':', null, (int)2, null), (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (domainComponentValidation.validate((Object)it).isValid()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final String checkUpdateRepo(@NotNull String repository) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            if (!StringsKt.contains$default((CharSequence)repository, (CharSequence)"/", (boolean)false, (int)2, null)) {
                return "docker.io/library/" + repository;
            }
            String firstPathSegment = StringsKt.substringBefore$default((String)repository, (String)"/", null, (int)2, null);
            CharSequence $this$any$iv = firstPathSegment;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '.' || it == ':')) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return repository;
        }
        return "docker.io/" + repository;
    }

    public final boolean isContainerImageString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ContainerImageInfo imageInfo = this.parseContainerImageString(string, false);
        boolean bl = false;
        Collection collection = imageInfo.getTags();
        return !((collection == null || collection.isEmpty()) && ((collection = (Collection)imageInfo.getDigests()) == null || collection.isEmpty()) || !INSTANCE.isValidImageRepository(imageInfo.getRepository()));
    }

    public final boolean hasErrors(@NotNull Run run) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        List invocations = run.getInvocations();
        boolean bl2 = false;
        Collection collection = invocations;
        if (collection == null || collection.isEmpty()) {
            bl = true;
        } else {
            boolean bl3;
            block5: {
                Iterable $this$all$iv = invocations;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Invocation invocation = (Invocation)element$iv;
                        boolean bl4 = false;
                        if (invocation.getExecutionSuccessful()) continue;
                        bl3 = false;
                        break block5;
                    }
                    bl3 = true;
                }
            }
            bl = !bl3;
        }
        return bl;
    }

    public final boolean hasErrors(@NotNull Collection<Run> runs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(runs, (String)"runs");
            Iterable $this$any$iv = runs;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Run it = (Run)element$iv;
                    boolean bl2 = false;
                    if (!(it == null || INSTANCE.hasErrors(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String toAliasString(@NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        CharSequence charSequence = version;
        return name + "@" + (String)(new Regex("\\s").containsMatchIn(charSequence) ? "'" + version + "'" : version);
    }

    @NotNull
    public final String markdownToPlainText(@NotNull String markdownText, @NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        return ((Object)this.processASTNode(markdownText, new MarkdownParser(flavour).buildMarkdownTreeFromString(markdownText))).toString();
    }

    public static /* synthetic */ String markdownToPlainText$default(CommonUtils commonUtils, String string, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            markdownFlavourDescriptor = (MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor(false, false, 3, null);
        }
        return commonUtils.markdownToPlainText(string, markdownFlavourDescriptor);
    }

    private final CharSequence processASTNode(CharSequence original, ASTNode node) {
        CharSequence charSequence;
        StringBuilder sb = new StringBuilder();
        logger.trace(() -> CommonUtils.processASTNode$lambda$0(node));
        logger.trace(() -> CommonUtils.processASTNode$lambda$1(node, original));
        if (node.getType().getName().length() == 1) {
            return ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)original);
        }
        Object object = node.getType();
        if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            sb.append(" ");
        } else if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.EOL)) {
            sb.append('\n');
        } else if (Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.LIST_BULLET) || Intrinsics.areEqual((Object)object, (Object)MarkdownTokenTypes.TEXT)) {
            return ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)original);
        }
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode child = (ASTNode)element$iv;
            boolean bl = false;
            sb.append(INSTANCE.processASTNode(original, child));
        }
        object = node.getType().getName();
        if (new Regex("^ATX_\\d+").matches((CharSequence)object)) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = StringsKt.removePrefix((String)string, (CharSequence)" ");
        } else {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            charSequence = string;
        }
        return charSequence;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit defaultJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Unit parseContainerImageString$lambda$1(ValidationBuilder $this$Validation) {
        Intrinsics.checkNotNullParameter((Object)$this$Validation, (String)"$this$Validation");
        StringConstraintsKt.pattern((ValidationBuilder)$this$Validation, (Regex)new Regex("^sha256:[0-9a-fA-F]{32,}$"));
        return Unit.INSTANCE;
    }

    private static final Unit parseContainerImageString$lambda$2(ValidationBuilder $this$Validation) {
        Intrinsics.checkNotNullParameter((Object)$this$Validation, (String)"$this$Validation");
        StringConstraintsKt.pattern((ValidationBuilder)$this$Validation, (Regex)new Regex("^\\w[\\w.-]{0,127}$"));
        return Unit.INSTANCE;
    }

    private static final Unit isValidImageRepository$lambda$0(ValidationBuilder $this$Validation) {
        Intrinsics.checkNotNullParameter((Object)$this$Validation, (String)"$this$Validation");
        StringConstraintsKt.pattern((ValidationBuilder)$this$Validation, (Regex)new Regex("^[a-zA-Z0-9-]+$"));
        return Unit.INSTANCE;
    }

    private static final Unit isValidDomainName$lambda$0(ValidationBuilder $this$Validation) {
        Intrinsics.checkNotNullParameter((Object)$this$Validation, (String)"$this$Validation");
        StringConstraintsKt.pattern((ValidationBuilder)$this$Validation, (Regex)new Regex("^[0-9]+$"));
        return Unit.INSTANCE;
    }

    private static final Unit isValidDomainName$lambda$1(ValidationBuilder $this$Validation) {
        Intrinsics.checkNotNullParameter((Object)$this$Validation, (String)"$this$Validation");
        StringConstraintsKt.pattern((ValidationBuilder)$this$Validation, (Regex)new Regex("^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])$"));
        return Unit.INSTANCE;
    }

    private static final Object processASTNode$lambda$0(ASTNode $node) {
        return "type: -->" + $node.getType().getName() + "<--";
    }

    private static final Object processASTNode$lambda$1(ASTNode $node, CharSequence $original) {
        return "content: -->" + ASTUtilKt.getTextInNode((ASTNode)$node, (CharSequence)$original) + "<--";
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Iterable $this$filterNotTo$iv$iv;
        INSTANCE = new CommonUtils();
        logger = KotlinLogging.INSTANCE.logger(CommonUtils::logger$lambda$0);
        jaroWinkler = new JaroWinkler(0.0, 1, null);
        Iterable $this$filterNot$iv = StringsKt.lines((CharSequence)"\n#--------------------------------------------------------------------------------------------------------#\n# Maintained manually from https://raw.githubusercontent.com/package-url/purl-spec/master/PURL-TYPES.rst #\n#--------------------------------------------------------------------------------------------------------#\n\nalpm\napk\nbitbucket\nbitnami\ncocoapods\ncargo\ncomposer\nconan\nconda\ncpan\ncran\ndeb\ndocker\ngem\ngeneric\ngithub\ngolang\nhackage\nhex\nhuggingface\nluarocks\nmaven\nmlflow\nnpm\nnuget\nqpkg\noci\npub\npypi\nrpm\nswid\nswift\n\n#------------#\n# Candidates #\n#------------#\n\napache\nandroid\natom\nbower\nbrew\nbuildroot\ncarthage\nchef\nchocolatey\nclojars\ncoreos\nctan\ncrystal\ndrupal\ndtype\ndub\nelm\neclipse\ngitea\ngitlab\ngradle\nguix\nhaxe\nhelm\njulia\nmelpa\nmeteor\nnim\nnix\nopam\nopenwrt\nosgi\np2\npear\npecl\nperl6\nplatformio\nebuild\npuppet\nsourceforge\nsublime\nterraform\nvagrant\nvim\nwordpress\nyocto\n");
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        knownPurlTypes = (List)var3_3;
        defaultJson = JsonKt.Json$default(null, CommonUtils::defaultJson$lambda$0, (int)1, null);
    }
}

