/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util;

import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.Message;
import dev.mosaify.core.model.sarif.MultiformatMessageString;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.scanner.Scanner;
import dev.mosaify.core.model.taxonomy.TargetType;
import dev.mosaify.core.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.LocalTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bJ\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J-\u0010\u0015\u001a\u0011\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0019\u00a2\u0006\u0002\b\u0018*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\n\u0010\u001e\u001a\u00020\u000e*\u00020\u001bJ.\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!*\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00160\"J/\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!*\u0014\u0012\u0004\u0012\u0002H!\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00160\"H\u0007\u00a2\u0006\u0002\b#J\n\u0010$\u001a\u00020\n*\u00020%J\n\u0010&\u001a\u00020\n*\u00020%J\n\u0010'\u001a\u00020\u000e*\u00020\nJ\n\u0010(\u001a\u00020\u000e*\u00020\nJ\n\u0010)\u001a\u00020\u000e*\u00020\nJ\n\u0010*\u001a\u00020\u000e*\u00020\nJ\u0010\u0010+\u001a\u00020,*\b\u0012\u0004\u0012\u00020\n0\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ldev/mosaify/core/util/Extensions;", "", "<init>", "()V", "localDateTimeDisplayFormat", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "localTimeDisplayFormat", "Lkotlinx/datetime/LocalTime;", "getPlainText", "", "Ldev/mosaify/core/model/sarif/MultiformatMessageString;", "Ldev/mosaify/core/model/sarif/Message;", "supports", "", "Ldev/mosaify/core/model/report/ReportParser;", "run", "Ldev/mosaify/core/model/sarif/Run;", "Ldev/mosaify/core/model/scanner/Scanner;", "type", "Ldev/mosaify/core/model/taxonomy/TargetType;", "parseToGeneric", "", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "originalReport", "", "extraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "isBlank", "combined", "", "T", "Lkotlin/Pair;", "combinedWithMain", "display", "Lkotlin/time/Instant;", "displayTime", "isHexString", "isSha256", "isSha1", "isCommitId", "toJsonArray", "Lkotlinx/serialization/json/JsonArray;", "mosaify-util-common"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ndev/mosaify/core/util/Extensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1563#3:85\n1634#3,3:86\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ndev/mosaify/core/util/Extensions\n*L\n81#1:85\n81#1:86,3\n*E\n"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();
    @NotNull
    private static final DateTimeFormat<LocalDateTime> localDateTimeDisplayFormat = LocalDateTime.Companion.Format(Extensions::localDateTimeDisplayFormat$lambda$0);
    @NotNull
    private static final DateTimeFormat<LocalTime> localTimeDisplayFormat = LocalTime.Companion.Format(Extensions::localTimeDisplayFormat$lambda$0);

    private Extensions() {
    }

    @Nullable
    public final String getPlainText(@NotNull MultiformatMessageString $this$getPlainText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getPlainText, (String)"<this>");
        if (!StringsKt.isBlank((CharSequence)$this$getPlainText.getText())) {
            string = $this$getPlainText.getText();
        } else {
            String string2 = $this$getPlainText.getMarkdown();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = StringsKt.isBlank((CharSequence)it) ? null : CommonUtils.markdownToPlainText$default(CommonUtils.INSTANCE, it, null, 2, null);
            } else {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    public final String getPlainText(@NotNull Message $this$getPlainText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getPlainText, (String)"<this>");
        CharSequence charSequence = $this$getPlainText.getText();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            string = $this$getPlainText.getText();
        } else {
            String string2 = $this$getPlainText.getMarkdown();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = StringsKt.isBlank((CharSequence)it) ? null : CommonUtils.markdownToPlainText$default(CommonUtils.INSTANCE, it, null, 2, null);
            } else {
                string = null;
            }
        }
        return string;
    }

    public final boolean supports(@NotNull ReportParser $this$supports, @NotNull Run run) {
        Intrinsics.checkNotNullParameter((Object)$this$supports, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        return CommonUtils.INSTANCE.parserSupports($this$supports, run);
    }

    public final boolean supports(@NotNull Scanner $this$supports, @NotNull TargetType type) {
        Intrinsics.checkNotNullParameter((Object)$this$supports, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return $this$supports.getSupportedTargets().contains(type);
    }

    @NotNull
    public final Collection<Issue> parseToGeneric(@NotNull ReportParser $this$parseToGeneric, @NotNull byte[] originalReport, @Nullable RunExtraInfo extraInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$parseToGeneric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        return $this$parseToGeneric.originalToGeneric($this$parseToGeneric.parseToOriginal(originalReport), extraInfo);
    }

    public static /* synthetic */ Collection parseToGeneric$default(Extensions extensions, ReportParser reportParser, byte[] byArray, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return extensions.parseToGeneric(reportParser, byArray, runExtraInfo);
    }

    public final boolean isBlank(@NotNull byte[] $this$isBlank) {
        Intrinsics.checkNotNullParameter((Object)$this$isBlank, (String)"<this>");
        return StringsKt.isBlank((CharSequence)StringsKt.decodeToString((byte[])$this$isBlank));
    }

    @NotNull
    public final <T> List<T> combined(@NotNull Pair<? extends Collection<? extends T>, ? extends Collection<? extends T>> $this$combined) {
        Intrinsics.checkNotNullParameter($this$combined, (String)"<this>");
        return CollectionsKt.plus((Collection)((Collection)$this$combined.getFirst()), (Iterable)((Iterable)$this$combined.getSecond()));
    }

    @JvmName(name="combinedWithMain")
    @NotNull
    public final <T> List<T> combinedWithMain(@NotNull Pair<? extends T, ? extends Collection<? extends T>> $this$combined) {
        Intrinsics.checkNotNullParameter($this$combined, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$this$combined.getFirst()), (Iterable)((Iterable)$this$combined.getSecond()));
    }

    @NotNull
    public final String display(@NotNull Instant $this$display) {
        Intrinsics.checkNotNullParameter((Object)$this$display, (String)"<this>");
        return LocalDateTimeKt.format((LocalDateTime)TimeZoneKt.toLocalDateTime((Instant)$this$display, (TimeZone)TimeZone.Companion.currentSystemDefault()), localDateTimeDisplayFormat);
    }

    @NotNull
    public final String displayTime(@NotNull Instant $this$displayTime) {
        Intrinsics.checkNotNullParameter((Object)$this$displayTime, (String)"<this>");
        return LocalTimeKt.format((LocalTime)TimeZoneKt.toLocalDateTime((Instant)$this$displayTime, (TimeZone)TimeZone.Companion.currentSystemDefault()).getTime(), localTimeDisplayFormat);
    }

    public final boolean isHexString(@NotNull String $this$isHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$isHexString, (String)"<this>");
        CharSequence charSequence = $this$isHexString;
        return new Regex("^(0[xX])?[A-Fa-f0-9]+$").matches(charSequence);
    }

    public final boolean isSha256(@NotNull String $this$isSha256) {
        Intrinsics.checkNotNullParameter((Object)$this$isSha256, (String)"<this>");
        return $this$isSha256.length() == 64 && this.isHexString($this$isSha256);
    }

    public final boolean isSha1(@NotNull String $this$isSha1) {
        Intrinsics.checkNotNullParameter((Object)$this$isSha1, (String)"<this>");
        return $this$isSha1.length() == 40 && this.isHexString($this$isSha1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCommitId(@NotNull String $this$isCommitId) {
        Intrinsics.checkNotNullParameter((Object)$this$isCommitId, (String)"<this>");
        if (this.isSha1($this$isCommitId)) return true;
        int n = $this$isCommitId.length();
        if (7 > n) return false;
        if (n >= 40) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!this.isHexString($this$isCommitId)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonArray toJsonArray(@NotNull Collection<String> $this$toJsonArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toJsonArray, (String)"<this>");
        Iterable $this$map$iv = $this$toJsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonElementKt.JsonPrimitive((String)it));
        }
        List list = (List)destination$iv$iv;
        return new JsonArray(list);
    }

    private static final Unit localDateTimeDisplayFormat$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        DateTimeFormatBuilder.WithYearMonth.year$default((DateTimeFormatBuilder.WithYearMonth)((DateTimeFormatBuilder.WithYearMonth)$this$Format), null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'-');
        DateTimeFormatBuilder.WithYearMonth.monthNumber$default((DateTimeFormatBuilder.WithYearMonth)((DateTimeFormatBuilder.WithYearMonth)$this$Format), null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'-');
        DateTimeFormatBuilder.WithDate.day$default((DateTimeFormatBuilder.WithDate)((DateTimeFormatBuilder.WithDate)$this$Format), null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)' ');
        DateTimeFormatBuilder.WithTime.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.second$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit localTimeDisplayFormat$lambda$0(DateTimeFormatBuilder.WithTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        DateTimeFormatBuilder.WithTime.hour$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.minute$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        DateTimeFormatBuilder.WithTime.second$default((DateTimeFormatBuilder.WithTime)$this$Format, null, (int)1, null);
        return Unit.INSTANCE;
    }
}

