/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.logging;

import dev.mosaify.core.util.logging.model.StoredLogEvent;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J3\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\u0002\b\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Ldev/mosaify/core/util/logging/MemoryLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "name", "", "getName", "()Ljava/lang/String;", "logEventStorage", "", "Ldev/mosaify/core/util/logging/model/StoredLogEvent;", "getLogEventStorage", "()Ljava/util/List;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "isLoggingEnabledFor", "", "getAllEvents", "", "mosaify-util-common"})
@SourceDebugExtension(value={"SMAP\nMemoryLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryLogger.kt\ndev/mosaify/core/util/logging/MemoryLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1056#2:55\n774#2:56\n865#2,2:57\n*S KotlinDebug\n*F\n+ 1 MemoryLogger.kt\ndev/mosaify/core/util/logging/MemoryLogger\n*L\n51#1:55\n52#1:56\n52#1:57,2\n*E\n"})
public final class MemoryLogger
implements KLogger {
    @Nullable
    private final KLogger logger;
    @NotNull
    private final String name;
    @NotNull
    private final List<StoredLogEvent> logEventStorage;

    public MemoryLogger(@Nullable KLogger logger) {
        this.logger = logger;
        Object object = this.logger;
        if (object == null || (object = object.getName()) == null) {
            object = "MemoryLogger";
        }
        this.name = object;
        this.logEventStorage = new ArrayList();
    }

    public /* synthetic */ MemoryLogger(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = null;
        }
        this(kLogger);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final List<StoredLogEvent> getLogEventStorage() {
        return this.logEventStorage;
    }

    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Instant timeStamp = Clock.System.INSTANCE.now();
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder event = kLoggingEventBuilder;
            boolean bl = false;
            String string = event.getMessage();
            if (string != null) {
                String message = string;
                boolean bl2 = false;
                this.logEventStorage.add(new StoredLogEvent(timeStamp, message, level, marker));
            }
            KLogger kLogger = this.logger;
            if (kLogger == null) break block1;
            kLogger.at(level, marker, block);
        }
    }

    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        KLogger kLogger = this.logger;
        return kLogger != null ? kLogger.isLoggingEnabledFor(level, marker) : true;
    }

    @NotNull
    public final List<StoredLogEvent> getAllEvents() {
        Iterable $this$sortedBy$iv = this.logEventStorage;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StoredLogEvent it = (StoredLogEvent)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTimeStamp();
                it = (StoredLogEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTimeStamp()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StoredLogEvent> getAllEvents(@NotNull Level level) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Iterable $this$filter$iv = this.getAllEvents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StoredLogEvent it = (StoredLogEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getLevel().toInt() <= level.toInt())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public MemoryLogger() {
        this(null, 1, null);
    }
}

