/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.guesswork.utils;

import dev.mosaify.guesswork.utils.AdjustedPathResult;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mosaify/guesswork/utils/AdjustedPath;", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "detectPathSeparator", "", "path", "", "(Ljava/lang/String;)Ljava/lang/Character;", "of", "Ldev/mosaify/guesswork/utils/AdjustedPathResult;", "separator", "(Ljava/lang/String;Ljava/lang/Character;)Ldev/mosaify/guesswork/utils/AdjustedPathResult;", "displayPath", "adjustedPath", "originalPath", "filterPaths", "", "paths", "", "Companion", "mosaify-guesswork-common"})
@SourceDebugExtension(value={"SMAP\nAdjustedPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdjustedPath.kt\ndev/mosaify/guesswork/utils/AdjustedPath\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1104#2,3:159\n1104#2,3:162\n389#2,4:167\n413#2,4:171\n216#3,2:165\n774#4:175\n865#4,2:176\n*S KotlinDebug\n*F\n+ 1 AdjustedPath.kt\ndev/mosaify/guesswork/utils/AdjustedPath\n*L\n41#1:159,3\n42#1:162,3\n126#1:167,4\n129#1:171,4\n86#1:165,2\n154#1:175\n154#1:176,2\n*E\n"})
public final class AdjustedPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger;
    private static final char PATH_SEPARATOR_POSIX = '/';
    private static final char PATH_SEPARATOR_WINDOWS = '\\';
    @NotNull
    private static final Regex startsWithWindowsDriveLetter = new Regex("^[A-Za-z]:.*");
    @NotNull
    private static final Map<String, Boolean> removableLocationPrefix;
    @NotNull
    private static final List<String> pathTraversals;

    public AdjustedPath(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public /* synthetic */ AdjustedPath(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger(AdjustedPath::_init_$lambda$0);
        }
        this(kLogger);
    }

    @Nullable
    public final Character detectPathSeparator(@NotNull String path) {
        Character c;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (((CharSequence)path).length() == 0) {
            return null;
        }
        CharSequence $this$count$iv = path;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\\')) continue;
            ++count$iv;
        }
        int wintelSeparatorCount = count$iv;
        CharSequence $this$count$iv2 = path;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        for (int i = 0; i < $this$count$iv2.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv2.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv2;
        }
        int posixSeparatorCount = count$iv2;
        if (wintelSeparatorCount > 0 && posixSeparatorCount == 0) {
            c = Character.valueOf('\\');
        } else if (wintelSeparatorCount == 0 && posixSeparatorCount > 0) {
            c = Character.valueOf('/');
        } else if (StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) && wintelSeparatorCount > 0 && posixSeparatorCount == 1) {
            c = Character.valueOf('\\');
        } else {
            CharSequence charSequence = path;
            if (startsWithWindowsDriveLetter.matches(charSequence) && path.length() > 2 && (path.charAt(2) == '\\' || path.charAt(2) == '/')) {
                c = Character.valueOf(path.charAt(2));
            } else if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)path, (char)'\\', (boolean)false, (int)2, null)) {
                c = Character.valueOf(StringsKt.last((CharSequence)path));
            } else if (StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)path, (char)'\\', (boolean)false, (int)2, null)) {
                c = Character.valueOf(StringsKt.first((CharSequence)path));
            } else {
                this.logger.warn(() -> AdjustedPath.detectPathSeparator$lambda$2(path));
                c = null;
            }
        }
        return c;
    }

    @NotNull
    public final AdjustedPathResult of(@NotNull String path, @Nullable Character separator) {
        CharSequence $i$f$dropWhile22;
        int index$iv;
        Ref.ObjectRef objectRef;
        List<String> segments;
        Boolean isWindows;
        Ref.ObjectRef adjustedPath;
        block15: {
            Object object;
            CharSequence charSequence;
            Character finalSeparator;
            int prefixSeparator;
            block19: {
                block18: {
                    char c;
                    block17: {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        adjustedPath = new Ref.ObjectRef();
                        adjustedPath.element = path;
                        isWindows = null;
                        Ref.ObjectRef detectedSeparator = new Ref.ObjectRef();
                        detectedSeparator.element = this.detectPathSeparator(path);
                        Map<String, Boolean> $this$forEach$iv = removableLocationPrefix;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, Boolean>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Boolean> entry;
                            Map.Entry<String, Boolean> entry2 = entry = iterator.next();
                            boolean bl = false;
                            String prefix = entry2.getKey();
                            boolean isWindowsPrefix = entry2.getValue();
                            if (!StringsKt.startsWith((String)((String)adjustedPath.element), (String)prefix, (boolean)true)) continue;
                            adjustedPath.element = StringsKt.drop((String)((String)adjustedPath.element), (int)prefix.length());
                            prefixSeparator = isWindowsPrefix ? 92 : 47;
                            isWindows = isWindowsPrefix;
                            if (detectedSeparator.element != null) {
                                Character c2 = (Character)detectedSeparator.element;
                                int n = prefixSeparator;
                                if (c2 == null || c2.charValue() != n) {
                                    this.logger.debug(AdjustedPath::of$lambda$0$0);
                                }
                            }
                            detectedSeparator.element = Character.valueOf((char)prefixSeparator);
                        }
                        Character adjustedSeparator = this.detectPathSeparator((String)adjustedPath.element);
                        if (detectedSeparator.element != null && !Intrinsics.areEqual((Object)detectedSeparator.element, (Object)adjustedSeparator)) {
                            this.logger.debug(AdjustedPath::of$lambda$1);
                        }
                        detectedSeparator.element = adjustedSeparator;
                        if (separator != null && !Intrinsics.areEqual((Object)separator, (Object)detectedSeparator.element)) {
                            this.logger.warn(() -> AdjustedPath.of$lambda$2(detectedSeparator, separator));
                            v1 = separator;
                        } else {
                            v1 = finalSeparator = (Character)detectedSeparator.element;
                        }
                        if (finalSeparator == null) {
                            this.logger.warn(() -> AdjustedPath.of$lambda$3(this, adjustedPath, path));
                            return new AdjustedPathResult((String)adjustedPath.element, null, null, null, null, 30, null);
                        }
                        if (!Intrinsics.areEqual(isWindows, (Object)true)) break block17;
                        c = '/';
                        if (finalSeparator.charValue() == c) break block18;
                    }
                    if (!Intrinsics.areEqual(isWindows, (Object)false)) break block19;
                    c = '\\';
                    if (finalSeparator.charValue() != c) break block19;
                }
                this.logger.warn(() -> AdjustedPath.of$lambda$4(finalSeparator, separator));
            }
            char[] cArray = new char[]{finalSeparator.charValue()};
            segments = this.filterPaths(StringsKt.split$default((CharSequence)((CharSequence)adjustedPath.element), (char[])cArray, (boolean)false, (int)0, (int)6, null));
            char c = '\\';
            isWindows = finalSeparator.charValue() == c || !((Collection)segments).isEmpty() && startsWithWindowsDriveLetter.matches(charSequence = (CharSequence)CollectionsKt.first(segments));
            if (isWindows.booleanValue()) {
                char[] cArray2 = new char[]{'/', '\\'};
                segments = this.filterPaths(StringsKt.split$default((CharSequence)((CharSequence)adjustedPath.element), (char[])cArray2, (boolean)false, (int)0, (int)6, null));
            }
            String string = (String)adjustedPath.element;
            objectRef = adjustedPath;
            boolean $i$f$dropLastWhile = false;
            for (index$iv = StringsKt.getLastIndex((CharSequence)string); -1 < index$iv; --index$iv) {
                char it = string.charAt(index$iv);
                int n = 0;
                Character c3 = finalSeparator;
                if (c3 != null && it == c3.charValue()) continue;
                String string2 = string;
                n = 0;
                prefixSeparator = index$iv + 1;
                String string3 = string2.substring(n, prefixSeparator);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block15;
            }
            object = objectRef.element = "";
        }
        if (isWindows.booleanValue()) {
            String string;
            block16: {
                String string4 = (String)adjustedPath.element;
                objectRef = adjustedPath;
                boolean $i$f$dropWhile22 = false;
                int n = ((CharSequence)string4).length();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    char it = string4.charAt(index$iv);
                    boolean bl = false;
                    if (it == '/') continue;
                    String string5 = string4.substring(index$iv);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    break block16;
                }
                string = "";
            }
            objectRef.element = string;
        }
        boolean bl = StringsKt.startsWith$default((CharSequence)((CharSequence)adjustedPath.element), (char)'/', (boolean)false, (int)2, null) || startsWithWindowsDriveLetter.matches($i$f$dropWhile22 = (CharSequence)adjustedPath.element);
        char returnedSeparator = isWindows != false ? (char)'\\' : '/';
        String reconstructedPath = CollectionsKt.joinToString$default((Iterable)segments, (CharSequence)String.valueOf(returnedSeparator), null, null, (int)0, null, null, (int)62, null);
        adjustedPath.element = bl && isWindows == false ? "/" + reconstructedPath : reconstructedPath;
        String string = (String)adjustedPath.element;
        List<String> list = segments;
        boolean bl2 = isWindows;
        return new AdjustedPathResult(string, (Collection<String>)list, Character.valueOf(returnedSeparator), bl, bl2);
    }

    public static /* synthetic */ AdjustedPathResult of$default(AdjustedPath adjustedPath, String string, Character c, int n, Object object) {
        if ((n & 2) != 0) {
            c = null;
        }
        return adjustedPath.of(string, c);
    }

    @NotNull
    public final String displayPath(@NotNull String adjustedPath, @NotNull String originalPath) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)adjustedPath, (String)"adjustedPath");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        StringBuilder $this$displayPath_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$displayPath_u24lambda_u240.append("'" + adjustedPath + "'");
        if (!adjustedPath.contentEquals(originalPath)) {
            $this$displayPath_u24lambda_u240.append(" (adjusted from '" + originalPath + "')");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> filterPaths(Collection<String> paths) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = paths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0 && !pathTraversals.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object detectPathSeparator$lambda$2(String $path) {
        return "Could not determine a file path separator for path '" + $path + "'";
    }

    private static final Object of$lambda$0$0() {
        return "Updating detected separator after removing prefix";
    }

    private static final Object of$lambda$1() {
        return "Detected separator updated after rescanning the adjusted path";
    }

    private static final Object of$lambda$2(Ref.ObjectRef $detectedSeparator, Character $separator) {
        return "Overriding the detected separator '" + $detectedSeparator.element + "' with '" + $separator + "'";
    }

    private static final Object of$lambda$3(AdjustedPath this$0, Ref.ObjectRef $adjustedPath, String $path) {
        return "Could not detect path segment separator for path " + this$0.displayPath((String)$adjustedPath.element, $path);
    }

    private static final Object of$lambda$4(Character $finalSeparator, Character $separator) {
        Character c = $finalSeparator;
        char c2 = '\\';
        return "Forcing isWindows = " + (c != null && c.charValue() == c2) + " for separator '" + $separator + "'";
    }

    public AdjustedPath() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"fs://", (Object)false), TuplesKt.to((Object)"file://", (Object)false), TuplesKt.to((Object)"\\\\?\\", (Object)true), TuplesKt.to((Object)"\\\\.\\", (Object)true)};
        removableLocationPrefix = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"..", "."};
        pathTraversals = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/mosaify/guesswork/utils/AdjustedPath$Companion;", "", "<init>", "()V", "PATH_SEPARATOR_POSIX", "", "PATH_SEPARATOR_WINDOWS", "startsWithWindowsDriveLetter", "Lkotlin/text/Regex;", "removableLocationPrefix", "", "", "", "pathTraversals", "", "mosaify-guesswork-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

