/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.parser.docker.scout;

import dev.mosaify.core.model.Named;
import dev.mosaify.core.model.generic.Component;
import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueFlag;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.generic.ReportKt;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.ReportingDescriptor;
import dev.mosaify.core.model.sarif.Result;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.SarifLog;
import dev.mosaify.core.parser.sarif.Extensions;
import dev.mosaify.core.parser.sarif.ParserSarifGeneric;
import dev.mosaify.core.parser.scout.model.sarif.ScoutSarifPropertyBag;
import dev.mosaify.core.util.CommonUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\r\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J)\u0010\u0014\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0096\u0001J\t\u0010\u0019\u001a\u00020\u0018H\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Ldev/mosaify/core/parser/docker/scout/ParserDockerScout;", "Ldev/mosaify/core/model/report/ReportParser;", "Ldev/mosaify/core/model/Named;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "parseToOriginal", "", "originalReport", "", "originalToGeneric", "", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "extraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "sarifToGeneric", "run", "Ldev/mosaify/core/model/sarif/Run;", "getAllNames", "", "getName", "Companion", "mosaify-parser-docker-scout"})
@SourceDebugExtension(value={"SMAP\nParserDockerScout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserDockerScout.kt\ndev/mosaify/core/parser/docker/scout/ParserDockerScout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,93:1\n1374#2:94\n1460#2,5:95\n1563#2:100\n1634#2,2:101\n1563#2:105\n1634#2,3:106\n1636#2:109\n1#3:103\n335#4:104\n*S KotlinDebug\n*F\n+ 1 ParserDockerScout.kt\ndev/mosaify/core/parser/docker/scout/ParserDockerScout\n*L\n36#1:94\n36#1:95,5\n39#1:100\n39#1:101,2\n79#1:105\n79#1:106,3\n39#1:109\n47#1:104\n*E\n"})
public final class ParserDockerScout
implements ReportParser,
Named {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ Companion $$delegate_0;
    @NotNull
    private final KLogger logger;
    @NotNull
    private static final List<String> scannerNames;

    public ParserDockerScout(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.$$delegate_0 = Companion;
        this.logger = logger;
    }

    public /* synthetic */ ParserDockerScout(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger("Parser for '" + CollectionsKt.first(scannerNames) + "'");
        }
        this(kLogger);
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public Object parseToOriginal(@NotNull byte[] originalReport) {
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        return Extensions.INSTANCE.fromBytes(SarifLog.Companion, originalReport);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Issue> originalToGeneric(@NotNull Object originalReport, @Nullable RunExtraInfo extraInfo) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        Iterable $this$flatMap$iv = ((SarifLog)originalReport).getRuns();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Run it = (Run)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.sarifToGeneric(it, extraInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Issue> sarifToGeneric(@NotNull Run run, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        block37: {
            block32: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)run, (String)"run");
                List list = run.getResults();
                if (list == null) break block32;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Collection collection2;
                    IssueFlag issueFlag;
                    Object object;
                    Set set;
                    Set set2;
                    CvssInfo cvssInfo;
                    IssueType issueType;
                    String string;
                    String string2;
                    Set set3;
                    Set fixVersions;
                    Object object2;
                    Object object3;
                    RunExtraInfo runExtraInfo;
                    Collection collection3;
                    block36: {
                        Object object4;
                        block35: {
                            void $this$mapTo$iv$iv2;
                            CvssInfo cvssInfo2;
                            Set set4;
                            Object object5;
                            Object severity;
                            Object cvssScore;
                            ScoutSarifPropertyBag propertyBag;
                            ReportingDescriptor sarifRule;
                            void sarifResult;
                            block34: {
                                String string3;
                                Object object6;
                                block33: {
                                    Object object7;
                                    ScoutSarifPropertyBag scoutSarifPropertyBag;
                                    RunExtraInfo runExtraInfo2;
                                    Iterable iterable2;
                                    Result result = (Result)item$iv$iv;
                                    collection3 = destination$iv$iv;
                                    boolean bl = false;
                                    Set set5 = run.getTool().getDriver().getRules();
                                    if (set5 != null) {
                                        Object v2;
                                        block31: {
                                            iterable2 = set5;
                                            for (Object t : iterable2) {
                                                ReportingDescriptor it = (ReportingDescriptor)t;
                                                boolean bl2 = false;
                                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)sarifResult.getRuleId())) continue;
                                                v2 = t;
                                                break block31;
                                            }
                                            v2 = null;
                                        }
                                        v3 = v2;
                                    } else {
                                        v3 = sarifRule = null;
                                    }
                                    if ((runExtraInfo2 = extraInfo) == null) {
                                        runExtraInfo2 = runExtraInfo = RunExtraInfo.Companion.fromPropertyBag(run.getProperties());
                                    }
                                    if (sarifRule != null && (iterable2 = sarifRule.getProperties()) != null) {
                                        void $this$decodeFromJsonElement$iv;
                                        Iterable it = iterable2;
                                        boolean bl3 = false;
                                        Json bl2 = CommonUtils.INSTANCE.getDefaultJson();
                                        JsonElement json$iv = (JsonElement)it;
                                        boolean $i$f$decodeFromJsonElement = false;
                                        $this$decodeFromJsonElement$iv.getSerializersModule();
                                        scoutSarifPropertyBag = (ScoutSarifPropertyBag)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.getNullable(ScoutSarifPropertyBag.Companion.serializer()), json$iv);
                                    } else {
                                        scoutSarifPropertyBag = null;
                                    }
                                    if ((object7 = (propertyBag = scoutSarifPropertyBag)) == null || (object7 = ((ScoutSarifPropertyBag)object7).getSecuritySeverity()) == null || (object7 = StringsKt.toDoubleOrNull((String)object7)) == null) {
                                        Object object8 = propertyBag;
                                        object7 = object8 != null && (object8 = ((ScoutSarifPropertyBag)object8).getCvssV3()) != null ? StringsKt.toDoubleOrNull((String)object8) : null;
                                    }
                                    if ((object6 = (cvssScore = object7)) == null) break block33;
                                    double it = ((Number)object6).doubleValue();
                                    boolean bl4 = false;
                                    IssueSeverity issueSeverity = IssueSeverity.Companion.fromCvssScore(it);
                                    object6 = issueSeverity;
                                    if (issueSeverity != null) break block34;
                                }
                                if (propertyBag != null && (string3 = propertyBag.getCvssv3Severity()) != null) {
                                    String it = string3;
                                    boolean bl = false;
                                    object3 = this;
                                    try {
                                        ParserDockerScout $this$sarifToGeneric_u24lambda_u240_u243_u240 = object3;
                                        boolean bl5 = false;
                                        object2 = kotlin.Result.constructor-impl((Object)IssueSeverity.valueOf((String)it));
                                    }
                                    catch (Throwable throwable) {
                                        object2 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                    }
                                    object3 = object2;
                                    object6 = (IssueSeverity)(kotlin.Result.isFailure-impl((Object)object3) ? null : object3);
                                } else {
                                    object6 = severity = null;
                                }
                            }
                            if ((object5 = propertyBag) != null && (object5 = ((ScoutSarifPropertyBag)object5).getFixedVersion()) != null) {
                                Object fixedVersion = object5;
                                boolean bl = false;
                                set4 = !StringsKt.contentEquals((CharSequence)((CharSequence)fixedVersion), (CharSequence)"not fixed", (boolean)true) ? SetsKt.setOf((Object)fixedVersion) : null;
                            } else {
                                set4 = null;
                            }
                            fixVersions = set4;
                            set3 = SetsKt.setOf((Object)this.getName());
                            String string4 = ParserSarifGeneric.INSTANCE.getDescription((Result)sarifResult, sarifRule);
                            if (string4 == null) {
                                string4 = ParserSarifGeneric.INSTANCE.getSummary((Result)sarifResult, sarifRule);
                            }
                            string2 = CommonUtils.markdownToPlainText$default((CommonUtils)CommonUtils.INSTANCE, (String)string4, null, (int)2, null);
                            string = CommonUtils.markdownToPlainText$default((CommonUtils)CommonUtils.INSTANCE, (String)ParserSarifGeneric.INSTANCE.getSummary((Result)sarifResult, sarifRule), null, (int)2, null);
                            issueType = IssueType.COMPONENT_VULNERABILITY;
                            Object object9 = severity;
                            if (object9 == null && (object9 = ParserSarifGeneric.INSTANCE.sarifLevelToSeverity(sarifResult.getLevel())) == null) {
                                ReportingDescriptor reportingDescriptor = sarifRule;
                                object9 = ParserSarifGeneric.INSTANCE.sarifLevelToSeverity(reportingDescriptor != null && (reportingDescriptor = reportingDescriptor.getDefaultConfiguration()) != null ? reportingDescriptor.getLevel() : null);
                            }
                            object3 = object9;
                            ReportingDescriptor reportingDescriptor = sarifRule;
                            object2 = SetsKt.setOfNotNull((Object)(reportingDescriptor != null ? reportingDescriptor.getId() : null));
                            Object object10 = cvssScore;
                            if (object10 != null) {
                                double it = ((Number)object10).doubleValue();
                                boolean bl = false;
                                ScoutSarifPropertyBag scoutSarifPropertyBag = propertyBag;
                                cvssInfo2 = new CvssInfo(it, scoutSarifPropertyBag != null ? scoutSarifPropertyBag.getCvssv3Vector() : null);
                            } else {
                                cvssInfo2 = null;
                            }
                            cvssInfo = cvssInfo2;
                            set2 = ParserSarifGeneric.INSTANCE.getReferences((Result)sarifResult, sarifRule);
                            set = ParserSarifGeneric.INSTANCE.getLocations((Result)sarifResult, extraInfo);
                            object4 = propertyBag;
                            if (object4 == null || (object4 = ((ScoutSarifPropertyBag)object4).getPurls()) == null) break block35;
                            Iterable $this$map$iv2 = (Iterable)object4;
                            boolean $i$f$map2 = false;
                            Iterable iterable3 = $this$map$iv2;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                Object object11;
                                void purl;
                                String string5 = (String)item$iv$iv2;
                                Collection collection4 = destination$iv$iv2;
                                boolean bl = false;
                                Object object12 = this;
                                void var43_50 = purl;
                                try {
                                    ParserDockerScout $this$sarifToGeneric_u24lambda_u240_u246_u240 = object12;
                                    boolean bl6 = false;
                                    object11 = kotlin.Result.constructor-impl((Object)CommonUtils.INSTANCE.normalizePurl((String)purl));
                                }
                                catch (Throwable throwable) {
                                    object11 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                object12 = object11;
                                Set set6 = fixVersions;
                                String string6 = (String)(kotlin.Result.isFailure-impl((Object)object12) ? null : object12);
                                void var51_59 = var43_50;
                                collection4.add(new Component((String)var51_59, string6, set6));
                            }
                            object4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                            if (object4 != null) break block36;
                        }
                        object4 = object = SetsKt.emptySet();
                    }
                    if (fixVersions != null) {
                        boolean bl = false;
                        issueFlag = IssueFlag.FIXABLE;
                    } else {
                        issueFlag = null;
                    }
                    Set set7 = SetsKt.setOfNotNull(issueFlag);
                    RunExtraInfo runExtraInfo3 = runExtraInfo;
                    Collection collection5 = SetsKt.setOfNotNull((Object)(runExtraInfo3 != null ? runExtraInfo3.getTarget() : null));
                    if (collection5.isEmpty()) {
                        boolean bl = false;
                        collection2 = null;
                    } else {
                        collection2 = collection5;
                    }
                    Set set8 = (Set)collection2;
                    collection3.add(new Issue(string2, set3, null, string, issueType, (IssueSeverity)object3, cvssInfo, set8, null, (Set)object2, set2, set7, set, (Set)object, null, 16644, null));
                }
                collection = (List)destination$iv$iv;
                break block37;
            }
            collection = ReportKt.getEMPTY_REPORT();
        }
        return collection;
    }

    @NotNull
    public String getName() {
        return this.$$delegate_0.getName();
    }

    @NotNull
    public Collection<String> getAllNames() {
        return this.$$delegate_0.getAllNames();
    }

    public ParserDockerScout() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"Docker Scout", "Scout"};
        scannerNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/mosaify/core/parser/docker/scout/ParserDockerScout$Companion;", "Ldev/mosaify/core/model/Named;", "<init>", "()V", "scannerNames", "", "", "getName", "getAllNames", "mosaify-parser-docker-scout"})
    public static final class Companion
    implements Named {
        private Companion() {
        }

        @NotNull
        public String getName() {
            return (String)CollectionsKt.first((List)scannerNames);
        }

        @NotNull
        public List<String> getAllNames() {
            return scannerNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

