/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.cli;

import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.BaseCliktCommandKt;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.core.MordantContextKt;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.ProgramResult;
import com.github.ajalt.clikt.output.MordantHelpFormatter;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.groups.OptionGroup;
import com.github.ajalt.clikt.parameters.groups.ParameterGroupKt;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.ChoiceKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import com.github.ajalt.mordant.animation.progress.BlockingAnimator;
import com.github.ajalt.mordant.animation.progress.ProgressBarAnimationKt;
import com.github.ajalt.mordant.animation.progress.ProgressTask;
import com.github.ajalt.mordant.animation.progress.ProgressTaskUpdateScope;
import com.github.ajalt.mordant.animation.progress.ThreadAnimatorKt;
import com.github.ajalt.mordant.animation.progress.ThreadProgressTaskAnimator;
import com.github.ajalt.mordant.rendering.TextColors;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.GridBuilder;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.RowHolderBuilder;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.DefinitionListBuilder;
import com.github.ajalt.mordant.widgets.DefinitionListKt;
import com.github.ajalt.mordant.widgets.Spinner;
import com.github.ajalt.mordant.widgets.progress.MultiProgressBarWidgetMaker;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressBarMakerRow;
import com.github.ajalt.mordant.widgets.progress.ProgressBarWidgetMaker;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutCellsKt;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScope;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScopeKt;
import com.github.ajalt.mordant.widgets.progress.ProgressState;
import dev.mosaify.core.cli.CliFunctions;
import dev.mosaify.core.cli.CliLogger;
import dev.mosaify.core.cli.CommonOptions;
import dev.mosaify.core.cli.MosaifyCli;
import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.generic.IssueStatus;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.metadata.BasicProjectInfo;
import dev.mosaify.core.model.metadata.ComponentInfo;
import dev.mosaify.core.model.metadata.LogExtraInfo;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.scanner.ScanTarget;
import dev.mosaify.core.model.scanner.Scanner;
import dev.mosaify.core.model.scanner.ScannerParameterAttributes;
import dev.mosaify.core.model.taxonomy.TargetType;
import dev.mosaify.core.scanner.docker.scout.ScannerDockerScout;
import dev.mosaify.core.scanner.jfrog.xray.ScannerJfrogXray;
import dev.mosaify.core.scanner.snyk.oss.ScannerSnykOss;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.config.ConfigFile;
import dev.mosaify.core.util.storage.Extensions;
import dev.mosaify.core.util.storage.SarifStorage;
import dev.mosaify.core.util.storage.model.ResolvedScanRecord;
import dev.mosaify.core.util.storage.model.StorageMetadataRecord;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Ldev/mosaify/core/cli/MosaifyCli;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "run", "", "Report", "Scan", "mosaify-cli"})
public final class MosaifyCli
extends CliktCommand {
    public MosaifyCli() {
        super(null, 1, null);
        System.setProperty("slf4j.internal.verbosity", "WARN");
        BaseCliktCommandKt.context((BaseCliktCommand)((BaseCliktCommand)this), MosaifyCli::_init_$lambda$0);
    }

    @NotNull
    public String help(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return "Mosaify CLI - visit us at " + TextStyles.Companion.hyperlink("https://mosaify.dev").invoke("https://mosaify.dev");
    }

    public void run() {
        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)StringsKt.trimMargin((String)("\n            |\n            |\n            |Thank you for your interest in our products! Can't wait to hear from you at " + TextStyles.Companion.hyperlink("mailto:hello@mosaify.dev").invoke("hello@mosaify.dev") + " \ud83d\udce7\n            |\n            |\ud83d\udea7 Please note that this is an " + TextColors.yellow.plus(TextStyles.italic).invoke("experimental") + " version of our software \ud83d\udea7\n            |\n            |" + TextColors.yellow.plus(TextStyles.bold).invoke("UNDER NO CIRCUMSTANCE SHALL WE HAVE ANY LIABILITY TO YOU FOR ANY LOSS OR DAMAGE OF ANY KIND INCURRED AS A RESULT OF THE USE OF THIS SOFTWARE. YOUR USE OF THIS SOFTWARE IS SOLELY AT YOUR OWN RISK") + "\n            |\n        "), (String)"|"), null, null, null, null, (boolean)false, (int)62, null);
    }

    private static final Unit _init_$lambda$0(Context.Builder $this$context) {
        Intrinsics.checkNotNullParameter((Object)$this$context, (String)"$this$context");
        $this$context.setHelpFormatter(MosaifyCli::lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final MordantHelpFormatter lambda$0$0(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MordantHelpFormatter(it, null, true, true, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "run", "", "Compare", "Create", "Convert", "Show", "List", "mosaify-cli"})
    public static final class Report
    extends CliktCommand {
        public Report() {
            super(null, 1, null);
        }

        @NotNull
        public String help(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return "Report file operations (has subcommands)";
        }

        public void run() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001d\u0010\u001aR\u001b\u0010\u001f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b \u0010\u001aR\u001b\u0010\"\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\r\u001a\u0004\b#\u0010\u001aR!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\r\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report$Compare;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "to", "Ljava/io/File;", "getTo", "()Ljava/io/File;", "to$delegate", "format", "Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "getFormat", "()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "format$delegate", "project1", "getProject1", "()Ljava/lang/String;", "project1$delegate", "version1", "getVersion1", "version1$delegate", "project2", "getProject2", "project2$delegate", "version2", "getVersion2", "version2$delegate", "prefer", "", "getPrefer", "()Ljava/util/List;", "prefer$delegate", "run", "", "mosaify-cli"})
        @SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Compare\n+ 2 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt$enum$3\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,932:1\n45#2,5:933\n8634#3,2:938\n8894#3,2:940\n8897#3:943\n47#4:942\n1374#5:944\n1460#5,5:945\n1374#5:950\n1460#5,5:951\n1563#5:956\n1634#5,3:957\n1669#5,8:960\n1563#5:968\n1634#5,3:969\n1669#5,8:972\n1869#5:980\n1870#5:996\n536#6:981\n521#6,6:982\n126#7:988\n153#7,3:989\n126#7:992\n153#7,3:993\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Compare\n*L\n124#1:933,5\n124#1:938,2\n124#1:940,2\n124#1:943\n124#1:942\n157#1:944\n157#1:945,5\n158#1:950\n158#1:951,5\n216#1:956\n216#1:957,3\n216#1:960,8\n217#1:968\n217#1:969,3\n217#1:972,8\n178#1:980\n178#1:996\n180#1:981\n180#1:982,6\n193#1:988\n193#1:989,3\n200#1:992\n200#1:993,3\n*E\n"})
        public static final class Compare
        extends CliktCommand {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadOnlyProperty commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[0]);
            @NotNull
            private final ReadOnlyProperty to$delegate = OptionWithValuesKt.help((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)63, null), (String)"Target report file name (required for detailed comparison output)").provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadOnlyProperty format$delegate;
            @NotNull
            private final ReadOnlyProperty project1$delegate;
            @NotNull
            private final ReadOnlyProperty version1$delegate;
            @NotNull
            private final ReadOnlyProperty project2$delegate;
            @NotNull
            private final ReadOnlyProperty version2$delegate;
            @NotNull
            private final ReadOnlyProperty prefer$delegate;

            /*
             * WARNING - void declaration
             */
            public Compare() {
                super(null, 1, null);
                void var9_10;
                void $this$associateByTo$iv$iv$iv;
                void $this$associateBy$iv$iv;
                void $this$enum_u24default$iv;
                OptionWithValues optionWithValues = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null);
                Compare compare = this;
                boolean ignoreCase$iv = true;
                boolean $i$f$enum = false;
                CliFunctions.ReportFormat[] reportFormatArray = CliFunctions.ReportFormat.values();
                void var5_6 = $this$enum_u24default$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv$iv).length), (int)16);
                void var8_9 = $this$associateBy$iv$iv;
                Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
                boolean $i$f$associateByTo = false;
                for (void element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv;
                    Enum enum_ = (Enum)element$iv$iv$iv;
                    Map map = destination$iv$iv$iv;
                    boolean bl = false;
                    void var17_18 = it$iv;
                    boolean bl2 = false;
                    void it = var17_18;
                    map.put(it.name(), element$iv$iv$iv);
                }
                compare.format$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)ChoiceKt.choice$default((OptionWithValues)var5_6, (Map)var9_10, null, (boolean)ignoreCase$iv, (int)2, null), (Object)((Object)CliFunctions.ReportFormat.CSV), null, (int)2, null), (String)"Report file format").provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
                this.project1$delegate = (ReadOnlyProperty)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, (String)"Project 1 name", null, null, (int)13, null).provideDelegate((Object)this, $$delegatedProperties[3]);
                this.version1$delegate = (ReadOnlyProperty)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, (String)"Project 2 version", null, null, (int)13, null).provideDelegate((Object)this, $$delegatedProperties[4]);
                this.project2$delegate = (ReadOnlyProperty)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, (String)"Project 2 name", null, null, (int)13, null).provideDelegate((Object)this, $$delegatedProperties[5]);
                this.version2$delegate = (ReadOnlyProperty)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, (String)"Project 2 version", null, null, (int)13, null).provideDelegate((Object)this, $$delegatedProperties[6]);
                this.prefer$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), null, (boolean)false, (int)1, null), (String)"Preferred scanner(s) in order of preference to override default reduce functions").provideDelegate((ParameterHolder)this, $$delegatedProperties[7]);
            }

            @NotNull
            public String help(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return "Compare reports on two stored projects or components";
            }

            private final CommonOptions getCommonOptions() {
                return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[0]));
            }

            private final File getTo() {
                return (File)this.to$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            private final CliFunctions.ReportFormat getFormat() {
                return (CliFunctions.ReportFormat)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[2]));
            }

            private final String getProject1() {
                return (String)this.project1$delegate.getValue((Object)this, $$delegatedProperties[3]);
            }

            private final String getVersion1() {
                return (String)this.version1$delegate.getValue((Object)this, $$delegatedProperties[4]);
            }

            private final String getProject2() {
                return (String)this.project2$delegate.getValue((Object)this, $$delegatedProperties[5]);
            }

            private final String getVersion2() {
                return (String)this.version2$delegate.getValue((Object)this, $$delegatedProperties[6]);
            }

            private final java.util.List<String> getPrefer() {
                return (java.util.List)this.prefer$delegate.getValue((Object)this, $$delegatedProperties[7]);
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$distinctBy$iv;
                void $this$mapTo$iv$iv;
                void $this$distinctBy$iv2;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable report2;
                if (this.getCommonOptions().getVerbose()) {
                    CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this))));
                }
                Collection collection2 = SarifStorage.resolveLatestScans$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)this.getProject1(), (String)this.getVersion1(), (boolean)false, (int)0, (int)12, null);
                if (collection2 == null) {
                    Compare $this$run_u24lambda_u240 = this;
                    boolean bl = false;
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)$this$run_u24lambda_u240)), (Object)TextColors.red.invoke("No records found for project '" + $this$run_u24lambda_u240.getProject1() + "' version '" + $this$run_u24lambda_u240.getVersion1() + "'"), null, null, null, null, (boolean)false, (int)62, null);
                    throw new ProgramResult(1);
                }
                Collection project1data = collection2;
                Collection collection3 = SarifStorage.resolveLatestScans$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)this.getProject2(), (String)this.getVersion2(), (boolean)false, (int)0, (int)12, null);
                if (collection3 == null) {
                    Compare $this$run_u24lambda_u241 = this;
                    boolean bl = false;
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)$this$run_u24lambda_u241)), (Object)TextColors.red.invoke("No records found for project '" + $this$run_u24lambda_u241.getProject2() + "' version '" + $this$run_u24lambda_u241.getVersion2() + "'"), null, null, null, null, (boolean)false, (int)62, null);
                    throw new ProgramResult(1);
                }
                Collection project2data = collection3;
                if (project1data.isEmpty() || project2data.isEmpty()) {
                    String string = "Unexpected: empty storage query result";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                File file = this.getTo();
                if (file != null) {
                    Iterator $this$flatMapTo$iv$iv;
                    Object element$iv$iv2;
                    void $this$flatMapTo$iv$iv2;
                    File toFile = file;
                    boolean bl = false;
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)TextStyles.bold.invoke("Generating detailed vulnerability comparison report..."), null, null, null, null, (boolean)false, (int)62, null);
                    Iterable $this$flatMap$iv = project1data;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv2;
                        boolean bl2 = false;
                        Iterable list$iv$iv = CliFunctions.INSTANCE.autoParseRecord(it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    java.util.List report1 = (java.util.List)destination$iv$iv;
                    Iterable $this$flatMap$iv2 = project2data;
                    boolean $i$f$flatMap2 = false;
                    destination$iv$iv = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    element$iv$iv2 = $this$flatMapTo$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        Object element$iv$iv3 = element$iv$iv2.next();
                        ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv3;
                        boolean bl3 = false;
                        Iterable list$iv$iv = CliFunctions.INSTANCE.autoParseRecord(it);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    report2 = (java.util.List)destination$iv$iv2;
                    Collection comparedReport = CliFunctions.INSTANCE.getCompareUtils().compareReports((Collection)report1, (Collection)report2, (Collection)this.getPrefer());
                    String string = toFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    CliFunctions.INSTANCE.saveReport(comparedReport, string, this.getFormat());
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)TextStyles.bold.plus((TextStyle)TextColors.green).invoke("\ud83d\udcbe Vulnerability comparison report saved to " + toFile + "\n"), null, null, null, null, (boolean)false, (int)62, null);
                }
                Map<String, Triple<IssueStatus, java.util.List<String>, java.util.List<String>>> componentComparisonResult = CliFunctions.INSTANCE.compareComponents(project1data, project2data);
                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Widget)TableDslKt.grid(arg_0 -> Compare.run$lambda$3(componentComparisonResult, arg_0)), (boolean)false, (int)2, null);
                Iterable $this$map$iv = project1data;
                boolean $i$f$map = false;
                report2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    ResolvedScanRecord $i$f$flatMapTo2 = (ResolvedScanRecord)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLogInfo().getName());
                }
                $this$map$iv = (java.util.List)destination$iv$iv;
                boolean $i$f$distinctBy = false;
                HashSet<String> set$iv = new HashSet<String>();
                Iterable list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv2) {
                    Object key$iv;
                    String it = (String)e$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
                    if (!set$iv.add((String)key$iv)) continue;
                    ((ArrayList)list$iv).add(e$iv);
                }
                int componentCount1 = ((java.util.List)list$iv).size();
                Iterable $this$map$iv2 = project2data;
                boolean $i$f$map2 = false;
                list$iv = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResolvedScanRecord bl = (ResolvedScanRecord)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl4 = false;
                    collection.add(it.getLogInfo().getName());
                }
                $this$map$iv2 = (java.util.List)destination$iv$iv3;
                boolean $i$f$distinctBy2 = false;
                HashSet<String> set$iv2 = new HashSet<String>();
                ArrayList list$iv2 = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    String key$iv;
                    String it = (String)e$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
                    if (!set$iv2.add(key$iv)) continue;
                    list$iv2.add(e$iv);
                }
                int componentCount2 = ((java.util.List)list$iv2).size();
                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)("Total component count: " + componentCount1 + " -> " + componentCount2 + "\n"), null, null, null, null, (boolean)false, (int)62, null);
                if (this.getTo() == null) {
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)("\ud83d\udca1 To generate a detailed comparison report, add the " + TextStyles.bold.invoke("--to <filename>") + " parameter \ud83d\udca1\n"), null, null, null, null, (boolean)false, (int)62, null);
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit run$lambda$3(Map $componentComparisonResult, GridBuilder $this$grid) {
                Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
                Object[] objectArray = new Object[]{TextStyles.bold.invoke("Component comparison:")};
                RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$grid), (Object[])objectArray, null, (int)2, null);
                RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$grid), (Object[])new Object[0], null, (int)2, null);
                objectArray = new IssueStatus[]{IssueStatus.REMOVED, IssueStatus.NEW, IssueStatus.CHANGED, IssueStatus.UNCHANGED};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$filterTo$iv$iv;
                    IssueStatus status = (IssueStatus)element$iv;
                    boolean bl = false;
                    Map $this$filter$iv = $componentComparisonResult;
                    boolean $i$f$filter = false;
                    Object object = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$filterTo2 = false;
                    Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(((Triple)it.getValue()).getFirst() == status)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Map componentGroup = destination$iv$iv;
                    if (!(!componentGroup.isEmpty())) continue;
                    $this$grid.row(arg_0 -> Compare.run$lambda$3$0$1(status, componentGroup, arg_0));
                    switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            Triple v;
                            String k;
                            Collection collection;
                            Map.Entry entry;
                            Map $this$mapTo$iv$iv;
                            Map $this$map$iv = componentGroup;
                            boolean $i$f$map = false;
                            Map $i$f$filterTo2 = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry item$iv$iv;
                                entry = item$iv$iv = iterator2.next();
                                collection = destination$iv$iv2;
                                boolean bl3 = false;
                                k = (String)entry.getKey();
                                v = (Triple)entry.getValue();
                                $this$grid.row(arg_0 -> Compare.run$lambda$3$0$2$0(k, v, arg_0));
                                collection.add(Unit.INSTANCE);
                            }
                            java.util.List list = (java.util.List)destination$iv$iv2;
                            break;
                        }
                        case 4: {
                            Triple v;
                            String k;
                            Collection collection;
                            Map.Entry entry;
                            Map $this$map$iv = componentGroup;
                            boolean $i$f$map = false;
                            Map $this$mapTo$iv$iv = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                                entry = item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl4 = false;
                                k = (String)entry.getKey();
                                v = (Triple)entry.getValue();
                                $this$grid.row(arg_0 -> Compare.run$lambda$3$0$3$0(k, v, arg_0));
                                collection.add(Unit.INSTANCE);
                            }
                            java.util.List list = (java.util.List)destination$iv$iv2;
                            break;
                        }
                        case 5: {
                            object = "Unexpected: Unknown status when comparing components";
                            throw new NotImplementedError("An operation is not implemented: " + (String)object);
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    $this$grid.row(Compare::run$lambda$3$0$4);
                }
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$3$0$1(IssueStatus $status, Map $componentGroup, RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.setStyle(TextStyles.bold.getStyle());
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)($status.getDisplayName() + " x " + $componentGroup.size()), null, (int)2, null);
                if ($status == IssueStatus.CHANGED) {
                    RowBuilder.DefaultImpls.cells$default((RowBuilder)$this$row, (Object)"From", (Object)"To", (Object[])new Object[0], null, (int)8, null);
                }
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$3$0$2$0(String $k, Triple $v, RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$k, null, (int)2, null);
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)((Collection)$v.getSecond()), (Iterable)((Iterable)$v.getThird())))), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$3$0$3$0(String $k, Triple $v, RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$k, null, (int)2, null);
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)$v.getSecond()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)$v.getThird()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$3$0$4(RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                return Unit.INSTANCE;
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "to", "getTo()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "format", "getFormat()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "project1", "getProject1()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "version1", "getVersion1()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "project2", "getProject2()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "version2", "getVersion2()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Compare.class, "prefer", "getPrefer()Ljava/util/List;", 0)))};
                $$delegatedProperties = kPropertyArray;
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IssueStatus.values().length];
                    try {
                        nArray[IssueStatus.REMOVED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IssueStatus.NEW.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IssueStatus.UNCHANGED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IssueStatus.CHANGED.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IssueStatus.UNKNOWN.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\r\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b\u001f\u0010 R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\r\u001a\u0004\b#\u0010\u0012R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\r\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report$Convert;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "from", "", "Ljava/io/File;", "getFrom", "()Ljava/util/List;", "from$delegate", "to", "getTo", "()Ljava/io/File;", "to$delegate", "format", "Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "getFormat", "()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "format$delegate", "normalizeBy", "Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "getNormalizeBy", "()Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "normalizeBy$delegate", "prefer", "getPrefer", "prefer$delegate", "display", "", "getDisplay", "()Z", "display$delegate", "run", "", "mosaify-cli"})
        @SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Convert\n+ 2 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt$enum$3\n*L\n1#1,932:1\n45#2,5:933\n45#2,5:944\n8634#3,2:938\n8894#3,2:940\n8897#3:943\n8634#3,2:949\n8894#3,2:951\n8897#3:954\n47#4:942\n47#4:953\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Convert\n*L\n324#1:933,5\n328#1:944,5\n324#1:938,2\n324#1:940,2\n324#1:943\n328#1:949,2\n328#1:951,2\n328#1:954\n324#1:942\n328#1:953\n*E\n"})
        public static final class Convert
        extends CliktCommand {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadOnlyProperty commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[0]);
            @NotNull
            private final ReadOnlyProperty from$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.multiple$default((ProcessedArgument)FileKt.file$default((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)42, null), (boolean)false, null, (int)3, null), (String)"Original report file(s)").provideDelegate((Object)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadOnlyProperty to$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.required((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)63, null)), (String)"New (converted) report file name").provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
            @NotNull
            private final ReadOnlyProperty format$delegate;
            @NotNull
            private final ReadOnlyProperty normalizeBy$delegate;
            @NotNull
            private final ReadOnlyProperty prefer$delegate;
            @NotNull
            private final ReadOnlyProperty display$delegate;

            /*
             * WARNING - void declaration
             */
            public Convert() {
                super(null, 1, null);
                void var9_10;
                Enum it;
                boolean bl;
                Enum it$iv;
                boolean bl2;
                Map map;
                CliFunctions.NormalizeBy[] $this$associateByTo$iv$iv$iv;
                CliFunctions.NormalizeBy[] $this$associateBy$iv$iv;
                OptionWithValues $this$enum_u24default$iv;
                OptionWithValues optionWithValues = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null);
                Convert convert = this;
                boolean ignoreCase$iv = true;
                boolean $i$f$enum = false;
                CliFunctions.ReportFormat[] reportFormatArray = CliFunctions.ReportFormat.values();
                OptionWithValues optionWithValues2 = $this$enum_u24default$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv$iv.length), (int)16);
                void var8_9 = $this$associateBy$iv$iv;
                Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
                boolean $i$f$associateByTo = false;
                for (CliFunctions.NormalizeBy element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Enum enum_ = element$iv$iv$iv;
                    map = destination$iv$iv$iv;
                    bl2 = false;
                    void var17_18 = it$iv;
                    bl = false;
                    it = var17_18;
                    map.put(it.name(), element$iv$iv$iv);
                }
                convert.format$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)ChoiceKt.choice$default((OptionWithValues)optionWithValues2, (Map)destination$iv$iv$iv, null, (boolean)ignoreCase$iv, (int)2, null), (Object)((Object)CliFunctions.ReportFormat.CSV), null, (int)2, null), (String)"Report file format").provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
                $this$enum_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null);
                convert = this;
                ignoreCase$iv = true;
                $i$f$enum = false;
                $this$associateBy$iv$iv = CliFunctions.NormalizeBy.values();
                optionWithValues2 = $this$enum_u24default$iv;
                $i$f$associateBy = false;
                capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv$iv.length), (int)16);
                $this$associateByTo$iv$iv$iv = $this$associateBy$iv$iv;
                destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
                $i$f$associateByTo = false;
                for (CliFunctions.NormalizeBy element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it$iv = element$iv$iv$iv;
                    map = destination$iv$iv$iv;
                    bl2 = false;
                    it = it$iv;
                    bl = false;
                    map.put(it.name(), element$iv$iv$iv);
                }
                convert.normalizeBy$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)ChoiceKt.choice$default((OptionWithValues)optionWithValues2, (Map)var9_10, null, (boolean)ignoreCase$iv, (int)2, null), (Object)((Object)CliFunctions.NormalizeBy.DISABLED), null, (int)2, null), (String)"Duplicate issue processing logic").provideDelegate((ParameterHolder)this, $$delegatedProperties[4]);
                this.prefer$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), null, (boolean)false, (int)1, null), (String)"Preferred scanner(s) in order of preference to override the default normalization process").provideDelegate((ParameterHolder)this, $$delegatedProperties[5]);
                this.display$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"Display the report in terminal").provideDelegate((ParameterHolder)this, $$delegatedProperties[6]);
            }

            @NotNull
            public String help(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return "Convert previously created reports from to generic format";
            }

            private final CommonOptions getCommonOptions() {
                return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[0]));
            }

            private final java.util.List<File> getFrom() {
                return (java.util.List)this.from$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            private final File getTo() {
                return (File)this.to$delegate.getValue((Object)this, $$delegatedProperties[2]);
            }

            private final CliFunctions.ReportFormat getFormat() {
                return (CliFunctions.ReportFormat)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[3]));
            }

            private final CliFunctions.NormalizeBy getNormalizeBy() {
                return (CliFunctions.NormalizeBy)((Object)this.normalizeBy$delegate.getValue((Object)this, $$delegatedProperties[4]));
            }

            private final java.util.List<String> getPrefer() {
                return (java.util.List)this.prefer$delegate.getValue((Object)this, $$delegatedProperties[5]);
            }

            private final boolean getDisplay() {
                return (Boolean)this.display$delegate.getValue((Object)this, $$delegatedProperties[6]);
            }

            public void run() {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ Convert this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$filterTo$iv$iv;
                                Map.Entry<K, V> it;
                                Map.Entry<K, V> element$iv$iv;
                                void $this$filterNotTo$iv$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                if (Convert.access$getCommonOptions(this.this$0).getVerbose()) {
                                    CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0))));
                                }
                                if (!(!((Collection)Convert.access$getFrom(this.this$0)).isEmpty())) {
                                    boolean $i$a$-require-MosaifyCli$Report$Convert$run$1$22 = false;
                                    String $i$a$-require-MosaifyCli$Report$Convert$run$1$22 = "This function requires at least one report file as a parameter";
                                    throw new IllegalArgumentException($i$a$-require-MosaifyCli$Report$Convert$run$1$22.toString());
                                }
                                Pair<Collection<Issue>, Map<File, Collection<Issue>>> pair = CliFunctions.INSTANCE.autoParseAndNormalize(Convert.access$getFrom(this.this$0), Convert.access$getNormalizeBy(this.this$0), (Collection<String>)Convert.access$getPrefer(this.this$0));
                                Collection combined = (Collection)pair.component1();
                                Map original = (Map)pair.component2();
                                Object object = original.values();
                                int n = 0;
                                Object object2 = object.iterator();
                                while (object2.hasNext()) {
                                    void it2;
                                    T t = object2.next();
                                    Collection collection = (Collection)t;
                                    int n2 = n;
                                    boolean bl = false;
                                    int n3 = it2.size();
                                    n = n2 + n3;
                                }
                                int originalSize = n;
                                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)("Collected " + originalSize + " findings total"), null, null, null, null, (boolean)false, (int)62, null);
                                if (Convert.access$getNormalizeBy(this.this$0) != CliFunctions.NormalizeBy.DISABLED) {
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)("Normalized size: " + combined.size() + " findings (" + CliFunctions.INSTANCE.normalizationPercentString(originalSize, combined.size()) + " size reduction)"), null, null, null, null, (boolean)false, (int)62, null);
                                }
                                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)("Writing report to: '" + Convert.access$getTo(this.this$0).getPath() + "'"), null, null, null, null, (boolean)false, (int)62, null);
                                String string = Convert.access$getTo(this.this$0).getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                CliFunctions.INSTANCE.saveReport(combined, string, Convert.access$getFormat(this.this$0));
                                if (Convert.access$getDisplay(this.this$0)) {
                                    CliFunctions.INSTANCE.displayReport(combined, MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)));
                                }
                                Map $this$filterNot$iv = original;
                                boolean $i$f$filterNot22 = false;
                                object2 = $this$filterNot$iv;
                                Map destination$iv$iv = new LinkedHashMap<K, V>();
                                boolean $i$f$filterNotTo = false;
                                Iterator<Map.Entry<K, V>> iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    it = element$iv$iv = iterator.next();
                                    boolean bl = false;
                                    if (((Collection)it.getValue()).isEmpty()) continue;
                                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                }
                                $this$filterNot$iv = destination$iv$iv;
                                Convert $i$f$filterNot22 = this.this$0;
                                Map notempty = $this$filterNot$iv;
                                boolean bl = false;
                                if (!notempty.isEmpty()) {
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)$i$f$filterNot22)), (Widget)((Widget)TableDslKt.table(arg_0 -> run.1.invokeSuspend$lambda$3$0(notempty, arg_0))), (boolean)false, (int)2, null);
                                }
                                Map $this$filter$iv = original;
                                boolean $i$f$filter = false;
                                notempty = $this$filter$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>();
                                boolean $i$f$filterTo = false;
                                iterator = $this$filterTo$iv$iv.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    it = element$iv$iv = iterator.next();
                                    boolean bl2 = false;
                                    if (!((Collection)it.getValue()).isEmpty()) continue;
                                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                }
                                object = destination$iv$iv;
                                Convert convert = this.this$0;
                                Object empty = object;
                                boolean bl3 = false;
                                if (!empty.isEmpty()) {
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)convert)), (Widget)((Widget)TableDslKt.table(arg_0 -> run.1.invokeSuspend$lambda$5$0((Map)empty, arg_0))), (boolean)false, (int)2, null);
                                }
                                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.brightGreen.invoke("Done!"), null, null, null, null, (boolean)false, (int)62, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$3$0(Map $notempty, TableBuilder $this$table) {
                        $this$table.header(run.1::invokeSuspend$lambda$3$0$0);
                        $this$table.body(arg_0 -> run.1.invokeSuspend$lambda$3$0$1($notempty, arg_0));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$3$0$0(SectionBuilder $this$header) {
                        $this$header.setStyle(TextColors.brightGreen.plus(TextStyles.bold));
                        Object[] objectArray = new Object[]{"File", "Scanner(s)", "Original issue count"};
                        RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$header), (Object[])objectArray, null, (int)2, null);
                        return Unit.INSTANCE;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final Unit invokeSuspend$lambda$3$0$1(Map $notempty, SectionBuilder $this$body) {
                        Map $this$forEach$iv = $notempty;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void $this$flatMapTo$iv$iv;
                            void $this$flatMap$iv;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> it = element$iv = iterator.next();
                            boolean bl = false;
                            Object[] objectArray = new Object[3];
                            objectArray[0] = ((File)it.getKey()).getPath();
                            Iterable iterable = (Iterable)it.getValue();
                            int n = 1;
                            Object[] objectArray2 = objectArray;
                            RowHolderBuilder rowHolderBuilder = (RowHolderBuilder)$this$body;
                            boolean $i$f$flatMap = false;
                            void var14_14 = $this$flatMap$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$flatMapTo = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                Issue issue = (Issue)element$iv$iv;
                                boolean bl2 = false;
                                Iterable list$iv$iv = issue.getDetectedBy();
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            java.util.List list = (java.util.List)destination$iv$iv;
                            objectArray2[n] = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)list)), null, null, null, (int)0, null, null, (int)63, null);
                            objectArray[2] = ((Collection)it.getValue()).size();
                            RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)rowHolderBuilder, (Object[])objectArray, null, (int)2, null);
                        }
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$5$0(Map $empty, TableBuilder $this$table) {
                        $this$table.header(run.1::invokeSuspend$lambda$5$0$0);
                        $this$table.body(arg_0 -> run.1.invokeSuspend$lambda$5$0$1($empty, arg_0));
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$5$0$0(SectionBuilder $this$header) {
                        $this$header.setStyle(TextColors.brightYellow.plus(TextStyles.bold));
                        Object[] objectArray = new Object[]{"Files were not recognized (or contained no findings)"};
                        RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$header), (Object[])objectArray, null, (int)2, null);
                        return Unit.INSTANCE;
                    }

                    private static final Unit invokeSuspend$lambda$5$0$1(Map $empty, SectionBuilder $this$body) {
                        Iterable $this$forEach$iv = $empty.keySet();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            File it = (File)element$iv;
                            boolean bl = false;
                            Object[] objectArray = new Object[]{it.getPath()};
                            RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$body), (Object[])objectArray, null, (int)2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }), (int)1, null);
            }

            public static final /* synthetic */ CommonOptions access$getCommonOptions(Convert $this) {
                return $this.getCommonOptions();
            }

            public static final /* synthetic */ java.util.List access$getFrom(Convert $this) {
                return $this.getFrom();
            }

            public static final /* synthetic */ CliFunctions.NormalizeBy access$getNormalizeBy(Convert $this) {
                return $this.getNormalizeBy();
            }

            public static final /* synthetic */ java.util.List access$getPrefer(Convert $this) {
                return $this.getPrefer();
            }

            public static final /* synthetic */ File access$getTo(Convert $this) {
                return $this.getTo();
            }

            public static final /* synthetic */ CliFunctions.ReportFormat access$getFormat(Convert $this) {
                return $this.getFormat();
            }

            public static final /* synthetic */ boolean access$getDisplay(Convert $this) {
                return $this.getDisplay();
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "from", "getFrom()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "to", "getTo()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "format", "getFormat()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "normalizeBy", "getNormalizeBy()Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "prefer", "getPrefer()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Convert.class, "display", "getDisplay()Z", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u000202H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\r\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b\u001f\u0010 R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\r\u001a\u0004\b#\u0010\u0012R\u001b\u0010%\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\r\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\r\u001a\u0004\b+\u0010,R\u001d\u0010.\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\r\u001a\u0004\b/\u0010'\u00a8\u00063"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report$Create;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "Lkotlin/properties/ReadOnlyProperty;", "filter", "", "Ljava/io/File;", "getFilter", "()Ljava/util/List;", "filter$delegate", "to", "getTo", "()Ljava/io/File;", "to$delegate", "format", "Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "getFormat", "()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", "format$delegate", "normalizeBy", "Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "getNormalizeBy", "()Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", "normalizeBy$delegate", "prefer", "getPrefer", "prefer$delegate", "name", "getName", "()Ljava/lang/String;", "name$delegate", "display", "", "getDisplay", "()Z", "display$delegate", "version", "getVersion", "version$delegate", "run", "", "mosaify-cli"})
        @SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Create\n+ 2 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 enum.kt\ncom/github/ajalt/clikt/parameters/types/EnumKt$enum$3\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,932:1\n45#2,5:933\n45#2,5:944\n8634#3,2:938\n8894#3,2:940\n8897#3:943\n8634#3,2:949\n8894#3,2:951\n8897#3:954\n47#4:942\n47#4:953\n1491#5:955\n1516#5,3:956\n1519#5,3:966\n1563#5:978\n1634#5,2:979\n1617#5,9:981\n1869#5:990\n1870#5:992\n1626#5:993\n1563#5:994\n1634#5,3:995\n1669#5,8:998\n1636#5:1006\n382#6,7:959\n767#7,2:969\n783#7,4:971\n77#8:975\n97#8,2:976\n99#8,3:1007\n1#9:991\n1#9:1010\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Create\n*L\n247#1:933,5\n251#1:944,5\n247#1:938,2\n247#1:940,2\n247#1:943\n251#1:949,2\n251#1:951,2\n251#1:954\n247#1:942\n251#1:953\n276#1:955\n276#1:956,3\n276#1:966,3\n283#1:978\n283#1:979,2\n286#1:981,9\n286#1:990\n286#1:992\n286#1:993\n288#1:994\n288#1:995,3\n289#1:998,8\n283#1:1006\n276#1:959,7\n278#1:969,2\n278#1:971,4\n282#1:975\n282#1:976,2\n282#1:1007,3\n286#1:991\n*E\n"})
        public static final class Create
        extends CliktCommand {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadOnlyProperty commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[0]);
            @NotNull
            private final ReadOnlyProperty filter$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)42, null), null, (boolean)false, (int)3, null), (String)"File(s) containing the list of targets to filter out from processing").provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadOnlyProperty to$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.required((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)63, null)), (String)"New report file name").provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
            @NotNull
            private final ReadOnlyProperty format$delegate;
            @NotNull
            private final ReadOnlyProperty normalizeBy$delegate;
            @NotNull
            private final ReadOnlyProperty prefer$delegate;
            @NotNull
            private final ReadOnlyProperty name$delegate;
            @NotNull
            private final ReadOnlyProperty display$delegate;
            @NotNull
            private final ReadOnlyProperty version$delegate;

            /*
             * WARNING - void declaration
             */
            public Create() {
                super(null, 1, null);
                void var9_10;
                Enum it;
                boolean bl;
                Enum it$iv;
                boolean bl2;
                Map map;
                CliFunctions.NormalizeBy[] $this$associateByTo$iv$iv$iv;
                CliFunctions.NormalizeBy[] $this$associateBy$iv$iv;
                OptionWithValues $this$enum_u24default$iv;
                OptionWithValues optionWithValues = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null);
                Create create = this;
                boolean ignoreCase$iv = true;
                boolean $i$f$enum = false;
                CliFunctions.ReportFormat[] reportFormatArray = CliFunctions.ReportFormat.values();
                OptionWithValues optionWithValues2 = $this$enum_u24default$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv$iv.length), (int)16);
                void var8_9 = $this$associateBy$iv$iv;
                Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
                boolean $i$f$associateByTo = false;
                for (CliFunctions.NormalizeBy element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Enum enum_ = element$iv$iv$iv;
                    map = destination$iv$iv$iv;
                    bl2 = false;
                    void var17_18 = it$iv;
                    bl = false;
                    it = var17_18;
                    map.put(it.name(), element$iv$iv$iv);
                }
                create.format$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)ChoiceKt.choice$default((OptionWithValues)optionWithValues2, (Map)destination$iv$iv$iv, null, (boolean)ignoreCase$iv, (int)2, null), (Object)((Object)CliFunctions.ReportFormat.CSV), null, (int)2, null), (String)"Report file format").provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
                $this$enum_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null);
                create = this;
                ignoreCase$iv = true;
                $i$f$enum = false;
                $this$associateBy$iv$iv = CliFunctions.NormalizeBy.values();
                optionWithValues2 = $this$enum_u24default$iv;
                $i$f$associateBy = false;
                capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv$iv.length), (int)16);
                $this$associateByTo$iv$iv$iv = $this$associateBy$iv$iv;
                destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
                $i$f$associateByTo = false;
                for (CliFunctions.NormalizeBy element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it$iv = element$iv$iv$iv;
                    map = destination$iv$iv$iv;
                    bl2 = false;
                    it = it$iv;
                    bl = false;
                    map.put(it.name(), element$iv$iv$iv);
                }
                create.normalizeBy$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)ChoiceKt.choice$default((OptionWithValues)optionWithValues2, (Map)var9_10, null, (boolean)ignoreCase$iv, (int)2, null), (Object)((Object)CliFunctions.NormalizeBy.ID), null, (int)2, null), (String)"Duplicate issue processing logic").provideDelegate((ParameterHolder)this, $$delegatedProperties[4]);
                this.prefer$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), null, (boolean)false, (int)1, null), (String)"Preferred scanner(s) in order of preference (overrides criticality/score)").provideDelegate((ParameterHolder)this, $$delegatedProperties[5]);
                this.name$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null), (String)"Project or component name").provideDelegate((Object)this, $$delegatedProperties[6]);
                this.display$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"Display the report in terminal").provideDelegate((ParameterHolder)this, $$delegatedProperties[7]);
                this.version$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.optional((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null)), (String)"Version (latest if not specified)").provideDelegate((Object)this, $$delegatedProperties[8]);
            }

            @NotNull
            public String help(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return "Create a generic report from stored scan results";
            }

            private final CommonOptions getCommonOptions() {
                return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[0]));
            }

            private final java.util.List<File> getFilter() {
                return (java.util.List)this.filter$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            private final File getTo() {
                return (File)this.to$delegate.getValue((Object)this, $$delegatedProperties[2]);
            }

            private final CliFunctions.ReportFormat getFormat() {
                return (CliFunctions.ReportFormat)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[3]));
            }

            private final CliFunctions.NormalizeBy getNormalizeBy() {
                return (CliFunctions.NormalizeBy)((Object)this.normalizeBy$delegate.getValue((Object)this, $$delegatedProperties[4]));
            }

            private final java.util.List<String> getPrefer() {
                return (java.util.List)this.prefer$delegate.getValue((Object)this, $$delegatedProperties[5]);
            }

            private final String getName() {
                return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[6]);
            }

            private final boolean getDisplay() {
                return (Boolean)this.display$delegate.getValue((Object)this, $$delegatedProperties[7]);
            }

            private final String getVersion() {
                return (String)this.version$delegate.getValue((Object)this, $$delegatedProperties[8]);
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                if (this.getCommonOptions().getVerbose()) {
                    CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this))));
                }
                if (this.getVersion() == null) {
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)TextColors.yellow.invoke("No version provided - using the latest one"), null, null, null, null, (boolean)false, (int)62, null);
                }
                Collection collection = SarifStorage.resolveLatestScans$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)this.getName(), (String)this.getVersion(), (boolean)false, (int)0, (int)12, null);
                if (collection != null) {
                    void $this$flatMapTo$iv$iv;
                    Map normalizedReportData;
                    Object element$iv$iv;
                    Map $this$associateWithTo$iv$iv;
                    Object element$iv$iv22;
                    void $this$groupByTo$iv$iv;
                    Collection latestScans = collection;
                    boolean bl = false;
                    Iterable $this$groupBy$iv = latestScans;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv22 : $this$groupByTo$iv$iv) {
                        Object object;
                        void $this$getOrPut$iv$iv$iv;
                        String string;
                        ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv22;
                        boolean bl2 = false;
                        String string2 = it.getLogInfo().getName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        String string3 = it.getLogInfo().getVersion();
                        if (string3 != null) {
                            String string4 = string3.toLowerCase(Locale.ROOT);
                            string = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        Pair key$iv$iv = new Pair((Object)string2, (Object)string);
                        Map map = destination$iv$iv;
                        Pair key$iv$iv$iv = key$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl3 = false;
                            java.util.List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        java.util.List list$iv$iv = (java.util.List)object;
                        list$iv$iv.add(element$iv$iv22);
                    }
                    Sequence $this$associateWith$iv = MapsKt.asSequence((Map)destination$iv$iv);
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    destination$iv$iv = $this$associateWith$iv;
                    Object destination$iv$iv2 = result$iv;
                    boolean $i$f$associateWithTo = false;
                    element$iv$iv22 = $this$associateWithTo$iv$iv.iterator();
                    while (element$iv$iv22.hasNext()) {
                        element$iv$iv = element$iv$iv22.next();
                        Map.Entry bl2 = (Map.Entry)element$iv$iv;
                        Object e = element$iv$iv;
                        Map map = destination$iv$iv2;
                        boolean bl4 = false;
                        java.util.List projectScans = (java.util.List)bl2.getValue();
                        Collection<Issue> collection2 = CliFunctions.INSTANCE.autoParseAndNormalize(projectScans, this.getNormalizeBy(), (Collection<String>)this.getPrefer());
                        map.put(e, collection2);
                    }
                    Map $this$flatMap$iv = normalizedReportData = destination$iv$iv2;
                    boolean $i$f$flatMap = false;
                    $this$associateWithTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    element$iv$iv22 = $this$flatMapTo$iv$iv.entrySet().iterator();
                    while (element$iv$iv22.hasNext()) {
                        void $this$mapTo$iv$iv;
                        Object report = element$iv$iv = (Map.Entry)element$iv$iv22.next();
                        boolean bl5 = false;
                        Iterable $this$map$iv = (Iterable)report.getValue();
                        boolean $i$f$map = false;
                        Iterable $i$f$getOrPut = $this$map$iv;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void $this$distinctBy$iv;
                            Collection<LogExtraInfo> collection3;
                            void $this$mapTo$iv$iv2;
                            Iterable $this$map$iv2;
                            void $this$mapNotNullTo$iv$iv;
                            Iterable $this$mapNotNull$iv;
                            void issue;
                            Issue issue2 = (Issue)item$iv$iv;
                            Collection collection4 = destination$iv$iv3;
                            boolean bl6 = false;
                            Iterable iterable2 = (Iterable)((Map.Entry)report.getKey()).getValue();
                            CvssInfo cvssInfo = null;
                            IssueSeverity issueSeverity = null;
                            IssueType issueType = null;
                            String string = null;
                            IssueStatus issueStatus = null;
                            Set set = null;
                            String string5 = null;
                            void var35_57 = issue;
                            boolean $i$f$mapNotNull = false;
                            void var37_59 = $this$mapNotNull$iv;
                            Collection destination$iv$iv4 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            ResolvedScanRecord resolvedScanRecord = $this$forEach$iv$iv$iv.iterator();
                            while (resolvedScanRecord.hasNext()) {
                                ScanTarget it$iv$iv;
                                Object element$iv$iv$iv;
                                Object element$iv$iv3 = element$iv$iv$iv = resolvedScanRecord.next();
                                boolean bl7 = false;
                                ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv3;
                                boolean bl8 = false;
                                if (it.getRunInfo().getTarget() == null) continue;
                                boolean bl9 = false;
                                destination$iv$iv4.add(it$iv$iv);
                            }
                            Collection collection5 = (java.util.List)destination$iv$iv4;
                            $this$mapNotNull$iv = (Iterable)((Map.Entry)report.getKey()).getValue();
                            collection5 = CollectionsKt.toSet((Iterable)collection5);
                            boolean $i$f$map2 = false;
                            $this$mapNotNullTo$iv$iv = $this$map$iv2;
                            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                void it;
                                resolvedScanRecord = (ResolvedScanRecord)item$iv$iv2;
                                collection3 = destination$iv$iv4;
                                boolean bl10 = false;
                                collection3.add(it.getLogInfo());
                            }
                            collection3 = (java.util.List)destination$iv$iv4;
                            $this$map$iv2 = collection3;
                            boolean $i$f$distinctBy = false;
                            HashSet<Pair> set$iv = new HashSet<Pair>();
                            ArrayList list$iv = new ArrayList();
                            for (Object e$iv : $this$distinctBy$iv) {
                                Pair key$iv;
                                String string6;
                                LogExtraInfo it = (LogExtraInfo)e$iv;
                                boolean bl11 = false;
                                String string7 = it.getName().toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                                String string8 = it.getVersion();
                                if (string8 != null) {
                                    String string9 = string8.toLowerCase(Locale.ROOT);
                                    string6 = string9;
                                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                                } else {
                                    string6 = null;
                                }
                                if (!set$iv.add(key$iv = new Pair((Object)string7, (Object)string6))) continue;
                                list$iv.add(e$iv);
                            }
                            collection3 = list$iv;
                            collection4.add(Issue.copy$default((Issue)var35_57, string5, set, issueStatus, string, issueType, issueSeverity, cvssInfo, (Set)collection5, (Set)CollectionsKt.toSet((Iterable)collection3), null, null, null, null, null, null, (int)32383, null));
                        }
                        Iterable list$iv$iv = (java.util.List)destination$iv$iv3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    java.util.List finalReport = (java.util.List)destination$iv$iv2;
                    Collection collection6 = finalReport;
                    String string = this.getTo().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    CliFunctions.INSTANCE.saveReport(collection6, string, this.getFormat());
                    if (this.getDisplay()) {
                        CliFunctions.INSTANCE.displayReport(finalReport, MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)));
                    }
                } else {
                    void $this$run_u24lambda_u241_u240;
                    StringBuilder stringBuilder;
                    Create $this$run_u24lambda_u241 = this;
                    boolean bl = false;
                    StringBuilder $this$flatMap$iv = stringBuilder = new StringBuilder();
                    TextColors textColors = TextColors.red;
                    Terminal terminal = MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)$this$run_u24lambda_u241));
                    boolean bl12 = false;
                    $this$run_u24lambda_u241_u240.append("No records found for '" + $this$run_u24lambda_u241.getName() + "'");
                    String string = $this$run_u24lambda_u241.getVersion();
                    if (string != null) {
                        String it = string;
                        boolean bl13 = false;
                        $this$run_u24lambda_u241_u240.append(" version '" + it + "'");
                    }
                    Unit unit = Unit.INSTANCE;
                    Terminal.println$default((Terminal)terminal, (Object)textColors.invoke(stringBuilder.toString()), null, null, null, null, (boolean)false, (int)62, null);
                    throw new ProgramResult(1);
                }
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "filter", "getFilter()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "to", "getTo()Ljava/io/File;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "format", "getFormat()Ldev/mosaify/core/cli/CliFunctions$ReportFormat;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "normalizeBy", "getNormalizeBy()Ldev/mosaify/core/cli/CliFunctions$NormalizeBy;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "prefer", "getPrefer()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "name", "getName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "display", "getDisplay()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Create.class, "version", "getVersion()Ljava/lang/String;", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report$List;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "complex", "", "getComplex", "()Z", "complex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "all", "getAll", "all$delegate", "search", "getSearch", "()Ljava/lang/String;", "search$delegate", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "run", "", "mosaify-cli"})
        @SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$List\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,932:1\n774#2:933\n865#2,2:934\n774#2:936\n865#2:937\n1563#2:938\n1634#2,3:939\n1617#2,9:942\n1869#2:951\n1870#2:953\n1626#2:954\n1761#2,3:955\n866#2:958\n1056#2:959\n1056#2:960\n1056#2:961\n1056#2:962\n1869#2,2:963\n1#3:952\n1#3:965\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$List\n*L\n486#1:933\n486#1:934,2\n487#1:936\n487#1:937\n491#1:938\n491#1:939,3\n492#1:942,9\n492#1:951\n492#1:953\n492#1:954\n496#1:955,3\n487#1:958\n508#1:959\n509#1:960\n510#1:961\n511#1:962\n512#1:963,2\n492#1:952\n*E\n"})
        public static final class List
        extends CliktCommand {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadOnlyProperty complex$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"Only include projects that have more than one component").provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
            @NotNull
            private final ReadOnlyProperty all$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"Show all stored results, not just latest").provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadOnlyProperty search$delegate = (ReadOnlyProperty)ArgumentKt.optional((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null)).provideDelegate((Object)this, $$delegatedProperties[2]);
            @NotNull
            private final ReadOnlyProperty commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[3]);

            public List() {
                super(null, 1, null);
            }

            @NotNull
            public String help(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return "List currently stored results";
            }

            private final boolean getComplex() {
                return (Boolean)this.complex$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            private final boolean getAll() {
                return (Boolean)this.all$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            private final String getSearch() {
                return (String)this.search$delegate.getValue((Object)this, $$delegatedProperties[2]);
            }

            private final CommonOptions getCommonOptions() {
                return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[3]));
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                StorageMetadataRecord it;
                Iterable $this$filterTo$iv$iv;
                if (this.getCommonOptions().getVerbose()) {
                    CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this))));
                }
                Iterable $this$filter$iv = SarifStorage.getAll$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), null, null, (boolean)false, (int)7, null).values();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (StorageMetadataRecord)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.getComplex() || !it.getLogExtraInfo().getComponents().isEmpty())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (java.util.List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block12: {
                        it = (StorageMetadataRecord)element$iv$iv;
                        boolean bl2 = false;
                        if (this.getSearch() != null) {
                            void $this$any$iv;
                            void $this$mapNotNullTo$iv$iv;
                            Object $this$mapNotNull$iv;
                            Collection collection;
                            Object object;
                            void $this$mapTo$iv$iv;
                            boolean bl3 = false;
                            Iterable $this$map$iv = it.getLogExtraInfo().getAliases();
                            boolean $i$f$map = false;
                            Iterable iterable2 = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void info;
                                object = (BasicProjectInfo)item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl4 = false;
                                collection.add(info.getName() + "@" + info.getVersion());
                            }
                            $this$map$iv = it.getRunExtraInfo();
                            collection = (java.util.List)destination$iv$iv2;
                            boolean $i$f$mapNotNull = false;
                            $this$mapTo$iv$iv = $this$mapNotNull$iv;
                            destination$iv$iv2 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            object = $this$forEach$iv$iv$iv.iterator();
                            while (object.hasNext()) {
                                String it$iv$iv;
                                Object element$iv$iv$iv;
                                Object element$iv$iv2 = element$iv$iv$iv = object.next();
                                boolean bl5 = false;
                                RunExtraInfo run2 = (RunExtraInfo)element$iv$iv2;
                                boolean bl6 = false;
                                ScanTarget scanTarget = run2.getTarget();
                                if ((scanTarget != null ? scanTarget.getTarget() : null) == null) continue;
                                it$iv$iv = it$iv$iv;
                                boolean bl7 = false;
                                destination$iv$iv2.add(it$iv$iv);
                            }
                            $this$mapNotNull$iv = new String[]{it.getLogExtraInfo().getName(), it.getLogExtraInfo().getVersion()};
                            $this$mapNotNull$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((java.util.List)destination$iv$iv2)), (Iterable)SetsKt.setOfNotNull((Object[])$this$mapNotNull$iv));
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String searchString;
                                    String alias = (String)element$iv;
                                    boolean bl8 = false;
                                    if (!StringsKt.contains((CharSequence)alias, (CharSequence)searchString, (boolean)true)) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        } else {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                java.util.List componentList = (java.util.List)destination$iv$iv;
                if (!((Collection)componentList).isEmpty()) {
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Widget)((Widget)TableDslKt.table(arg_0 -> List.run$lambda$2(this, componentList, arg_0))), (boolean)false, (int)2, null);
                } else {
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)TextColors.brightYellow.invoke("No records returned from the storage query."), null, null, null, null, (boolean)false, (int)62, null);
                }
            }

            private static final Unit run$lambda$2(List this$0, java.util.List $componentList, TableBuilder $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
                $this$table.header(List::run$lambda$2$0);
                $this$table.body(arg_0 -> List.run$lambda$2$1(this$0, $componentList, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$2$0(SectionBuilder $this$header) {
                Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
                $this$header.setStyle(TextColors.brightGreen.plus(TextStyles.bold));
                Object[] objectArray = new Object[]{"Name", "Version", "Aliases", "Components", "Timestamp"};
                RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$header), (Object[])objectArray, null, (int)2, null);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$2$1(List this$0, java.util.List $componentList, SectionBuilder $this$body) {
                Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
                Iterable $this$sortedBy$iv = this$0.getAll() ? (Collection)$componentList : Extensions.INSTANCE.uniqueLatestVersions((Collection)$componentList);
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        StorageMetadataRecord it = (StorageMetadataRecord)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getLogExtraInfo().getTimestamp();
                        it = (StorageMetadataRecord)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getLogExtraInfo().getTimestamp()));
                    }
                });
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        StorageMetadataRecord it = (StorageMetadataRecord)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getLogExtraInfo().getVersion());
                        it = (StorageMetadataRecord)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLogExtraInfo().getVersion())));
                    }
                });
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        StorageMetadataRecord it = (StorageMetadataRecord)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getLogExtraInfo().getName());
                        it = (StorageMetadataRecord)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLogExtraInfo().getName())));
                    }
                });
                $i$f$sortedBy = false;
                Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        StorageMetadataRecord it = (StorageMetadataRecord)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(it.getLogExtraInfo().getComponents().isEmpty());
                        it = (StorageMetadataRecord)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getLogExtraInfo().getComponents().isEmpty()));
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StorageMetadataRecord it = (StorageMetadataRecord)element$iv;
                    boolean bl = false;
                    $this$body.row(arg_0 -> List.run$lambda$2$1$4$0(it, arg_0));
                }
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$2$1$4$0(StorageMetadataRecord $it, RowBuilder $this$row) {
                CharSequence charSequence;
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.setStyle(!$it.getLogExtraInfo().getComponents().isEmpty() ? TextStyles.italic.plus(TextStyles.bold) : null);
                RowBuilder rowBuilder = $this$row;
                String string = $it.getLogExtraInfo().getName();
                Object object = $it.getLogExtraInfo().getVersion();
                if (object == null) {
                    object = "-- (" + dev.mosaify.core.util.Extensions.INSTANCE.display($it.getLogExtraInfo().getTimestamp()) + ")";
                }
                Object[] objectArray2 = objectArray = new Object[3];
                int n = 0;
                CharSequence charSequence2 = CollectionsKt.joinToString$default((Iterable)$it.getLogExtraInfo().getAliases(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                if (charSequence2.length() == 0) {
                    int n2 = n;
                    Object[] objectArray3 = objectArray2;
                    Object object2 = object;
                    String string2 = string;
                    RowBuilder rowBuilder2 = rowBuilder;
                    boolean bl = false;
                    String string3 = "--";
                    rowBuilder = rowBuilder2;
                    string = string2;
                    object = object2;
                    objectArray2 = objectArray3;
                    n = n2;
                    charSequence = string3;
                } else {
                    charSequence = charSequence2;
                }
                objectArray2[n] = charSequence;
                objectArray[1] = !$it.getLogExtraInfo().getComponents().isEmpty() ? Integer.valueOf($it.getLogExtraInfo().getComponents().size()) : "--";
                objectArray[2] = dev.mosaify.core.util.Extensions.INSTANCE.display($it.getLogExtraInfo().getTimestamp());
                RowBuilder.DefaultImpls.cells$default((RowBuilder)rowBuilder, (Object)string, (Object)object, (Object[])objectArray, null, (int)8, null);
                return Unit.INSTANCE;
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(List.class, "complex", "getComplex()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(List.class, "all", "getAll()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(List.class, "search", "getSearch()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(List.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001b\u0010\b\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001d\u0010\r\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Report$Show;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "name", "getName", "()Ljava/lang/String;", "name$delegate", "Lkotlin/properties/ReadOnlyProperty;", "version", "getVersion", "version$delegate", "toDisplayString", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "run", "", "mosaify-cli"})
        @SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Show\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,932:1\n1491#2:933\n1516#2,3:934\n1519#2,3:944\n1056#2:950\n1869#2,2:951\n382#3,7:937\n216#4,2:947\n1#5:949\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ndev/mosaify/core/cli/MosaifyCli$Report$Show\n*L\n432#1:933\n432#1:934,3\n432#1:944,3\n446#1:950\n447#1:951,2\n432#1:937,7\n433#1:947,2\n*E\n"})
        public static final class Show
        extends CliktCommand {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadOnlyProperty name$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null), (String)"Project or component name").provideDelegate((Object)this, $$delegatedProperties[0]);
            @NotNull
            private final ReadOnlyProperty version$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.optional((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null)), (String)"Version (if known)").provideDelegate((Object)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadOnlyProperty commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[2]);

            public Show() {
                super(null, 1, null);
            }

            @NotNull
            public String help(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return "Show information on a stored project";
            }

            private final String getName() {
                return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            private final String getVersion() {
                return (String)this.version$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            private final String toDisplayString(String name, String version) {
                return version != null ? CommonUtils.INSTANCE.toAliasString(name, version) : name + " (version not provided)";
            }

            private final CommonOptions getCommonOptions() {
                return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[2]));
            }

            public void run() {
                Collection scanRecords;
                if (this.getCommonOptions().getVerbose()) {
                    CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this))));
                }
                if ((scanRecords = SarifStorage.resolveLatestScans$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)this.getName(), (String)this.getVersion(), (boolean)false, (int)0, (int)12, null)) == null) {
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Object)TextColors.brightRed.invoke("Could not find any records for " + this.toDisplayString(this.getName(), this.getVersion())), null, null, null, null, (boolean)false, (int)62, null);
                    throw new ProgramResult(1);
                }
                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this)), (Widget)((Widget)TableDslKt.table(arg_0 -> Show.run$lambda$0(scanRecords, arg_0))), (boolean)false, (int)2, null);
            }

            private static final Unit run$lambda$0(Collection $scanRecords, TableBuilder $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
                $this$table.header(Show::run$lambda$0$0);
                $this$table.body(arg_0 -> Show.run$lambda$0$1($scanRecords, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$0$0(SectionBuilder $this$header) {
                Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
                $this$header.setStyle(TextColors.brightGreen.plus(TextStyles.bold));
                Object[] objectArray = new Object[]{"Component", "Type", "Scans"};
                RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$header), (Object[])objectArray, null, (int)2, null);
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit run$lambda$0$1(Collection $scanRecords, SectionBuilder $this$body) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
                Iterable $this$groupBy$iv = $scanRecords;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv$iv;
                    String string;
                    ResolvedScanRecord it = (ResolvedScanRecord)element$iv$iv;
                    boolean bl = false;
                    String string2 = it.getLogInfo().getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    String string3 = it.getLogInfo().getVersion();
                    if (string3 != null) {
                        String string4 = string3.toUpperCase(Locale.ROOT);
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                    } else {
                        string = null;
                    }
                    Pair key$iv$iv = new Pair((Object)string2, (Object)string);
                    Map map = destination$iv$iv;
                    Pair key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        java.util.List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    java.util.List list$iv$iv = (java.util.List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    java.util.List group = (java.util.List)entry.getValue();
                    if (group.isEmpty()) {
                        String string = "Empty group";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    $this$body.row(arg_0 -> Show.run$lambda$0$1$1$0(group, arg_0));
                }
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$0$1$1$0(java.util.List $group, RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.setStyle(null);
                Object object = ((ResolvedScanRecord)CollectionsKt.first((java.util.List)$group)).getRunInfo().getTarget();
                if (object == null || (object = object.getTarget()) == null) {
                    String string = "Unexpected error: a scan result without a target";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                Object[] objectArray = new Object[]{TableDslKt.grid(arg_0 -> Show.run$lambda$0$1$1$0$0($group, arg_0))};
                ScanTarget scanTarget = ((ResolvedScanRecord)CollectionsKt.first((java.util.List)$group)).getRunInfo().getTarget();
                RowBuilder.DefaultImpls.cells$default((RowBuilder)$this$row, (Object)object, (Object)(scanTarget != null && (scanTarget = scanTarget.getType()) != null ? CliFunctions.INSTANCE.display((TargetType)scanTarget) : null), (Object[])objectArray, null, (int)8, null);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$0$1$1$0$0(java.util.List $group, GridBuilder $this$grid) {
                Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
                Iterator iterator = ((Iterable)$group).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                ResolvedScanRecord it = (ResolvedScanRecord)iterator.next();
                boolean bl = false;
                Object object = (Comparable)it.getLogInfo().getTimestamp();
                while (iterator.hasNext()) {
                    Object it2 = (ResolvedScanRecord)iterator.next();
                    $i$a$-maxOf-MosaifyCli$Report$Show$run$1$2$2$1$1$mostRecentScan$1 = false;
                    if (object.compareTo(it2 = (Comparable)it2.getLogInfo().getTimestamp()) >= 0) continue;
                    object = it2;
                }
                Instant mostRecentScan = (Instant)object;
                Iterable $this$sortedBy$iv = $group;
                boolean $i$f$sortedBy = false;
                Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        String string;
                        String string2;
                        ResolvedScanRecord it = (ResolvedScanRecord)a;
                        boolean bl = false;
                        String string3 = it.getRunInfo().getScanner();
                        if (string3 != null) {
                            String string4 = string3.toUpperCase(Locale.ROOT);
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                        } else {
                            string2 = null;
                        }
                        it = (ResolvedScanRecord)b;
                        Comparable comparable = (Comparable)((Object)string2);
                        bl = false;
                        String string5 = it.getRunInfo().getScanner();
                        if (string5 != null) {
                            String string6 = string5.toUpperCase(Locale.ROOT);
                            string = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                        } else {
                            string = null;
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolvedScanRecord it3 = (ResolvedScanRecord)element$iv;
                    boolean bl2 = false;
                    $this$grid.row(arg_0 -> Show.run$lambda$0$1$1$0$0$2$0(it3, mostRecentScan, arg_0));
                }
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$0$1$1$0$0$2$0(ResolvedScanRecord $it, Instant $mostRecentScan, RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.setStyle($it.getLogInfo().getTimestamp().compareTo($mostRecentScan.minus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS))) < 0 ? (TextStyle)TextColors.yellow : null);
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$it.getRunInfo().getScanner(), null, (int)2, null);
                RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)dev.mosaify.core.util.Extensions.INSTANCE.display($it.getLogInfo().getTimestamp()), null, (int)2, null);
                return Unit.INSTANCE;
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Show.class, "name", "getName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Show.class, "version", "getVersion()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Show.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001BB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020:H\u0016J\b\u0010@\u001a\u00020AH\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\bR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0014\u0010\u0011R#\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\n\u001a\u0004\b\u0017\u0010\bR!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\n\u001a\u0004\b\u001a\u0010\bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\n\u001a\u0004\b\u001e\u0010\u001fR!\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b\"\u0010\bR!\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\n\u001a\u0004\b%\u0010\bR!\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\n\u001a\u0004\b(\u0010\bR\u001b\u0010*\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\n\u001a\u0004\b+\u0010\u0011R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\n\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\n\u001a\u0004\b3\u0010\u001fR\u001b\u00105\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\n\u001a\u0004\b6\u00100R\u001b\u0010;\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\n\u001a\u0004\b=\u0010>\u00a8\u0006C"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Scan;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "image", "", "", "getImage", "()Ljava/util/List;", "image$delegate", "Lkotlin/properties/ReadOnlyProperty;", "code", "Ljava/io/File;", "getCode", "code$delegate", "name", "getName", "()Ljava/lang/String;", "name$delegate", "version", "getVersion", "version$delegate", "fromFile", "getFromFile", "fromFile$delegate", "filter", "getFilter", "filter$delegate", "jobs", "", "getJobs", "()I", "jobs$delegate", "enable", "getEnable", "enable$delegate", "only", "getOnly", "only$delegate", "disable", "getDisable", "disable$delegate", "ttl", "getTtl", "ttl$delegate", "dontPull", "", "getDontPull", "()Z", "dontPull$delegate", "retries", "getRetries", "retries$delegate", "snykOssContainer", "getSnykOssContainer", "snykOssContainer$delegate", "help", "context", "Lcom/github/ajalt/clikt/core/Context;", "commonOptions", "Ldev/mosaify/core/cli/CommonOptions;", "getCommonOptions", "()Ldev/mosaify/core/cli/CommonOptions;", "commonOptions$delegate", "run", "", "VerticalProgressBarMaker", "mosaify-cli"})
    public static final class Scan
    extends CliktCommand {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadOnlyProperty image$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), null, (boolean)false, (int)3, null), (String)"Include image scan (can be multiple)").provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadOnlyProperty code$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)true, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (int)56, null), null, (boolean)false, (int)3, null), (String)"Include code scan of a directory (can be multiple)").provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadOnlyProperty name$delegate;
        @NotNull
        private final ReadOnlyProperty version$delegate;
        @NotNull
        private final ReadOnlyProperty fromFile$delegate;
        @NotNull
        private final ReadOnlyProperty filter$delegate;
        @NotNull
        private final ReadOnlyProperty jobs$delegate;
        @NotNull
        private final ReadOnlyProperty enable$delegate;
        @NotNull
        private final ReadOnlyProperty only$delegate;
        @NotNull
        private final ReadOnlyProperty disable$delegate;
        @NotNull
        private final ReadOnlyProperty ttl$delegate;
        @NotNull
        private final ReadOnlyProperty dontPull$delegate;
        @NotNull
        private final ReadOnlyProperty retries$delegate;
        @NotNull
        private final ReadOnlyProperty snykOssContainer$delegate;
        @NotNull
        private final ReadOnlyProperty commonOptions$delegate;

        public Scan() {
            super(null, 1, null);
            String[] stringArray = new String[]{"--as", "--name", "--project"};
            this.name$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String)"Project name").provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
            this.version$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String)"Project version (if not set and required, we'll use a timestamp)").provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
            this.fromFile$delegate = (ReadOnlyProperty)ArgumentKt.help((ProcessedArgument)ArgumentKt.optional((ProcessedArgument)ArgumentKt.multiple$default((ProcessedArgument)FileKt.file$default((ProcessedArgument)ArgumentKt.argument$default((BaseCliktCommand)((BaseCliktCommand)this), null, null, null, null, (int)15, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)42, null), (boolean)false, null, (int)3, null)), (String)"File(s) containing the list of targets (text or YAML)").provideDelegate((Object)this, $$delegatedProperties[4]);
            this.filter$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.multiple$default((OptionWithValues)FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (int)42, null), null, (boolean)false, (int)3, null), (String)"File(s) containing the list of targets to filter out from processing").provideDelegate((ParameterHolder)this, $$delegatedProperties[5]);
            this.jobs$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)IntKt.int$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)false, (int)1, null), (Object)3, null, (int)2, null), (String)"Maximum parallel jobs").provideDelegate((ParameterHolder)this, $$delegatedProperties[6]);
            stringArray = new String[]{","};
            this.enable$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.split$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Object)CollectionsKt.emptyList(), null, (int)2, null), (String)"Enable specific scanner(s)").provideDelegate((ParameterHolder)this, $$delegatedProperties[7]);
            stringArray = new String[]{","};
            this.only$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.split$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Object)CollectionsKt.emptyList(), null, (int)2, null), (String)"Enable only specific scanner(s) (will disable the rest)").provideDelegate((ParameterHolder)this, $$delegatedProperties[8]);
            stringArray = new String[]{","};
            this.disable$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.split$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Object)CollectionsKt.emptyList(), null, (int)2, null), (String)"Disable specific scanner(s)").provideDelegate((ParameterHolder)this, $$delegatedProperties[9]);
            this.ttl$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (Object)"24h", null, (int)2, null), (String)"Scan cache TTL. Example: '3d 1h 30m'. Use '--ttl=0' to disable. Please note that weeks, months and years are not currently supported.").provideDelegate((ParameterHolder)this, $$delegatedProperties[10]);
            this.dontPull$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"Don't try to pull images (may cause scanning to fail)").provideDelegate((ParameterHolder)this, $$delegatedProperties[11]);
            this.retries$delegate = OptionWithValuesKt.help((OptionWithValues)OptionWithValuesKt.default$default((OptionWithValues)IntKt.int$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (boolean)false, (int)1, null), (Object)5, null, (int)2, null), (String)"Max retries").provideDelegate((ParameterHolder)this, $$delegatedProperties[12]);
            this.snykOssContainer$delegate = OptionWithValuesKt.help((OptionWithValues)FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], null, null, (boolean)false, null, null, null, null, (boolean)false, (int)510, null), (String[])new String[0], (boolean)false, null, (int)4, null), (String)"EXPERIMENTAL: Use container-based Snyk Open Source scanner").provideDelegate((ParameterHolder)this, $$delegatedProperties[13]);
            this.commonOptions$delegate = ParameterGroupKt.provideDelegate((OptionGroup)new CommonOptions(), (BaseCliktCommand)((BaseCliktCommand)this), $$delegatedProperties[14]);
        }

        private final List<String> getImage() {
            return (List)this.image$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final List<File> getCode() {
            return (List)this.code$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final String getName() {
            return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final String getVersion() {
            return (String)this.version$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        private final List<File> getFromFile() {
            return (List)this.fromFile$delegate.getValue((Object)this, $$delegatedProperties[4]);
        }

        private final List<File> getFilter() {
            return (List)this.filter$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        private final int getJobs() {
            return ((Number)this.jobs$delegate.getValue((Object)this, $$delegatedProperties[6])).intValue();
        }

        private final List<String> getEnable() {
            return (List)this.enable$delegate.getValue((Object)this, $$delegatedProperties[7]);
        }

        private final List<String> getOnly() {
            return (List)this.only$delegate.getValue((Object)this, $$delegatedProperties[8]);
        }

        private final List<String> getDisable() {
            return (List)this.disable$delegate.getValue((Object)this, $$delegatedProperties[9]);
        }

        private final String getTtl() {
            return (String)this.ttl$delegate.getValue((Object)this, $$delegatedProperties[10]);
        }

        private final boolean getDontPull() {
            return (Boolean)this.dontPull$delegate.getValue((Object)this, $$delegatedProperties[11]);
        }

        private final int getRetries() {
            return ((Number)this.retries$delegate.getValue((Object)this, $$delegatedProperties[12])).intValue();
        }

        private final boolean getSnykOssContainer() {
            return (Boolean)this.snykOssContainer$delegate.getValue((Object)this, $$delegatedProperties[13]);
        }

        @NotNull
        public String help(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return "Scan a target(s) and store results in internal storage";
        }

        private final CommonOptions getCommonOptions() {
            return (CommonOptions)((Object)this.commonOptions$delegate.getValue((Object)this, $$delegatedProperties[14]));
        }

        public void run() {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getIO(), (int)this.getJobs(), null, (int)2, null)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                Object L$16;
                Object L$17;
                Object L$18;
                Object L$19;
                Object L$20;
                Object L$21;
                Object L$22;
                Object L$23;
                Object L$24;
                Object L$25;
                long J$0;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Scan this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final Object invokeSuspend(Object $result) {
                    block72: {
                        block73: {
                            var2_2 = (CoroutineScope)this.L$0;
                            var59_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (Scan.access$getCommonOptions(this.this$0).getVerbose()) {
                                        CliFunctions.INSTANCE.setLogger$mosaify_cli(new CliLogger("Mosaify", MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0))));
                                    }
                                    if (Intrinsics.areEqual((Object)Scan.access$getTtl(this.this$0), (Object)"0")) {
                                        v0 = Duration.Companion.getZERO-UwyO8pc();
                                    } else {
                                        var5_4 = $this$runBlocking;
                                        var6_5 = this.this$0;
                                        try {
                                            $this$invokeSuspend_u24lambda_u240 = var5_4;
                                            $i$a$-runCatching-MosaifyCli$Scan$run$1$ttlDuration$1 = false;
                                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Duration.box-impl((long)Duration.Companion.parse-UwyO8pc(Scan.access$getTtl(var6_5))));
                                        }
                                        catch (Throwable $i$a$-runCatching-MosaifyCli$Scan$run$1$ttlDuration$1) {
                                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-MosaifyCli$Scan$run$1$ttlDuration$1));
                                        }
                                        var5_4 = $this$invokeSuspend_u24lambda_u240;
                                        var6_5 = this.this$0;
                                        v1 = Result.exceptionOrNull-impl((Object)var5_4);
                                        if (v1 != null) {
                                            it = v1;
                                            $i$a$-getOrElse-MosaifyCli$Scan$run$1$ttlDuration$2 = false;
                                            Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var6_5)), (Object)TextColors.red.invoke("ERROR: Cannot parse TTL value '" + Scan.access$getTtl(var6_5) + "'"), null, null, null, null, (boolean)false, (int)62, null);
                                            throw new ProgramResult(1);
                                        }
                                        v0 = ((Duration)var5_4).unbox-impl();
                                    }
                                    ttlDuration = v0;
                                    cacheCutoffTime = Clock.System.INSTANCE.now().minus-LRDsOJo(ttlDuration);
                                    scannerParameters = CliFunctions.INSTANCE.collectScannerParameters((Collection<? extends Scanner>)CliFunctions.INSTANCE.getAvailableScanners().keySet());
                                    abbrList /* !! */  = $i$a$-getOrElse-MosaifyCli$Scan$run$1$ttlDuration$2 = CollectionsKt.flatten((Iterable)CliFunctions.INSTANCE.getAvailableScanners().values());
                                    $i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1 = false;
                                    $this$associateWith$iv = CollectionsKt.distinct((Iterable)abbrList /* !! */ );
                                    $i$f$associateWith = false;
                                    result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                                    var14_21 = $this$associateWith$iv;
                                    destination$iv$iv = result$iv;
                                    $i$f$associateWithTo = false;
                                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                                        var19_47 = (String)element$iv$iv /* !! */ ;
                                        var20_57 /* !! */  = element$iv$iv /* !! */ ;
                                        var21_58 = destination$iv$iv;
                                        $i$a$-associateWith-MosaifyCli$Scan$run$1$abbrCounts$1$1 = false;
                                        $this$count$iv = abbrList /* !! */ ;
                                        $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            v2 = 0;
                                        } else {
                                            count$iv = 0;
                                            for (Object element$iv : $this$count$iv) {
                                                it = (String)element$iv;
                                                $i$a$-count-MosaifyCli$Scan$run$1$abbrCounts$1$1$1 = false;
                                                if (!Intrinsics.areEqual((Object)it, (Object)abbr) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            v2 = count$iv;
                                        }
                                        var30_155 /* !! */  = Boxing.boxInt((int)v2);
                                        var21_58.put(var20_57 /* !! */ , var30_155 /* !! */ );
                                    }
                                    abbrCounts = destination$iv$iv;
                                    abbrList /* !! */  = CliFunctions.INSTANCE.getAvailableScanners().keySet();
                                    $i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1 = this.this$0;
                                    $i$f$associateWith = false;
                                    result$iv /* !! */  = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                                    result$iv = $this$associateWith$iv;
                                    destination$iv$iv = result$iv /* !! */ ;
                                    $i$f$associateWithTo = false;
                                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                                        element$iv$iv /* !! */  = (Scanner)element$iv$iv;
                                        var57_164 = element$iv$iv;
                                        var56_163 = destination$iv$iv;
                                        $i$a$-associateWith-MosaifyCli$Scan$run$1$scannerStatus$1 = false;
                                        $this$filter$iv = scanner.getParameters();
                                        $i$f$filter = false;
                                        $i$a$-associateWith-MosaifyCli$Scan$run$1$abbrCounts$1$1 = $this$filter$iv;
                                        destination$iv$iv = new LinkedHashMap<K, V>();
                                        $i$f$filterTo = false;
                                        for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                                            element$iv = element$iv$iv;
                                            $i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$1 = false;
                                            v = (ScannerParameterAttributes)element$iv.getValue();
                                            if (!v.getRequired()) continue;
                                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                        }
                                        $this$filter$iv = destination$iv$iv;
                                        $i$f$any = false;
                                        if (!$this$any$iv.isEmpty()) ** GOTO lbl99
                                        v3 = false;
                                        ** GOTO lbl108
lbl99:
                                        // 1 sources

                                        $this$filterTo$iv$iv = $this$any$iv.entrySet().iterator();
                                        while ($this$filterTo$iv$iv.hasNext()) {
                                            element$iv = $this$filterTo$iv$iv.next();
                                            it = element$iv;
                                            $i$a$-any-MosaifyCli$Scan$run$1$scannerStatus$1$2 = false;
                                            if (!(scannerParameters.containsKey(it.getKey()) == false)) continue;
                                            v3 = true;
                                            ** GOTO lbl108
                                        }
                                        v3 = false;
lbl108:
                                        // 3 sources

                                        if (!v3) ** GOTO lbl134
                                        $this$any$iv = new StringBuilder();
                                        $i$f$any = $this$any$iv;
                                        var30_155 /* !! */  = Boxing.boxBoolean((boolean)false);
                                        $i$a$-buildString-MosaifyCli$Scan$run$1$scannerStatus$1$3 = false;
                                        $this$invokeSuspend_u24lambda_u243_u242.append("Missing parameters:\n");
                                        element$iv = scanner.getParameters();
                                        it = $this$invokeSuspend_u24lambda_u243_u242;
                                        $i$f$filter = false;
                                        element$iv$iv = $this$filter$iv;
                                        destination$iv$iv = new LinkedHashMap<K, V>();
                                        $i$f$filterTo = false;
                                        v = $this$filterTo$iv$iv.entrySet().iterator();
                                        while (v.hasNext()) {
                                            it = element$iv$iv = (Map.Entry)v.next();
                                            $i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 = false;
                                            if (!(scannerParameters.containsKey(it.getKey()) == false)) continue;
                                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                        }
                                        it.append(CollectionsKt.joinToString$default((Iterable)destination$iv$iv.keySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$3$2$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/CharSequence;)(), (int)30, null));
                                        v4 = TuplesKt.to((Object)var30_155 /* !! */ , (Object)$this$any$iv.toString());
                                        ** GOTO lbl182
lbl134:
                                        // 1 sources

                                        if (!CollectionsKt.plus((Collection)Scan.access$getEnable($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1), (Iterable)Scan.access$getOnly($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1)).contains(scanner.getName())) ** GOTO lbl137
                                        v4 = TuplesKt.to((Object)Boxing.boxBoolean((boolean)true), (Object)"Enabled explicitly");
                                        ** GOTO lbl182
lbl137:
                                        // 1 sources

                                        v5 = CliFunctions.INSTANCE.getAvailableScanners().get(scanner);
                                        if (v5 == null) ** GOTO lbl155
                                        $this$any$iv = v5;
                                        $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl144
                                        v6 = false;
                                        ** GOTO lbl153
lbl144:
                                        // 1 sources

                                        $this$filter$iv = $this$any$iv.iterator();
                                        while ($this$filter$iv.hasNext()) {
                                            element$iv = $this$filter$iv.next();
                                            abbreviation = (String)element$iv;
                                            $i$a$-any-MosaifyCli$Scan$run$1$scannerStatus$1$4 = false;
                                            if (!CollectionsKt.plus((Collection)Scan.access$getEnable($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1), (Iterable)Scan.access$getOnly($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1)).contains(abbreviation)) continue;
                                            v6 = true;
                                            ** GOTO lbl153
                                        }
                                        v6 = false;
lbl153:
                                        // 3 sources

                                        v7 = v6;
                                        ** GOTO lbl156
lbl155:
                                        // 1 sources

                                        v7 = false;
lbl156:
                                        // 2 sources

                                        if (!v7) ** GOTO lbl159
                                        v4 = TuplesKt.to((Object)Boxing.boxBoolean((boolean)true), (Object)"Enabled explicitly");
                                        ** GOTO lbl182
lbl159:
                                        // 1 sources

                                        if (!Scan.access$getDisable($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1).contains(scanner.getName())) ** GOTO lbl162
                                        v4 = TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)"Disabled explicitly");
                                        ** GOTO lbl182
lbl162:
                                        // 1 sources

                                        v8 = CliFunctions.INSTANCE.getAvailableScanners().get(scanner);
                                        if (v8 == null) ** GOTO lbl180
                                        $this$any$iv = v8;
                                        $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl169
                                        v9 = false;
                                        ** GOTO lbl178
lbl169:
                                        // 1 sources

                                        $this$filter$iv = $this$any$iv.iterator();
                                        while ($this$filter$iv.hasNext()) {
                                            element$iv = $this$filter$iv.next();
                                            abbreviation = (String)element$iv;
                                            $i$a$-any-MosaifyCli$Scan$run$1$scannerStatus$1$5 = false;
                                            if (!Scan.access$getDisable($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1).contains(abbreviation)) continue;
                                            v9 = true;
                                            ** GOTO lbl178
                                        }
                                        v9 = false;
lbl178:
                                        // 3 sources

                                        v10 = v9;
                                        ** GOTO lbl181
lbl180:
                                        // 1 sources

                                        v10 = false;
lbl181:
                                        // 2 sources

                                        v4 = v10 ? TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)"Disabled explicitly") : (scanner instanceof ScannerJfrogXray || scanner instanceof ScannerSnykOss ? TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)"Disabled by default") : (((Collection)Scan.access$getOnly($i$a$-let-MosaifyCli$Scan$run$1$abbrCounts$1)).isEmpty() == false ? TuplesKt.to((Object)Boxing.boxBoolean((boolean)false), (Object)"Not on the 'only' list") : TuplesKt.to((Object)Boxing.boxBoolean((boolean)true), (Object)"Enabled by default")));
lbl182:
                                        // 5 sources

                                        var58_165 /* !! */  = v4;
                                        var56_163.put(var57_164, var58_165 /* !! */ );
                                    }
                                    $this$filter$iv = scannerStatus = destination$iv$iv;
                                    $i$f$filter = false;
                                    result$iv /* !! */  = $this$filter$iv;
                                    destination$iv$iv = new LinkedHashMap<K, V>();
                                    $i$f$filterTo = false;
                                    for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                                        element$iv$iv = element$iv$iv;
                                        $i$a$-filter-MosaifyCli$Scan$run$1$enabledScanners$1 = false;
                                        status = (Pair)element$iv$iv.getValue();
                                        if (!((Boolean)status.getFirst()).booleanValue()) continue;
                                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                    }
                                    enabledScanners = destination$iv$iv.keySet();
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextStyles.bold.invoke("Available scanners:"), null, null, null, null, (boolean)false, (int)62, null);
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Widget)((Widget)TableDslKt.table((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$5(java.util.Map java.util.Map com.github.ajalt.mordant.table.TableBuilder ), (Lcom/github/ajalt/mordant/table/TableBuilder;)Lkotlin/Unit;)((Map)scannerStatus, (Map)abbrCounts))), (boolean)false, (int)2, null);
                                    $this$any$iv = abbrCounts;
                                    $i$f$any = false;
                                    if (!$this$any$iv.isEmpty()) ** GOTO lbl207
                                    v11 = false;
                                    ** GOTO lbl215
lbl207:
                                    // 1 sources

                                    $this$filterTo$iv$iv = $this$any$iv.entrySet().iterator();
                                    while ($this$filterTo$iv$iv.hasNext()) {
                                        it = element$iv = $this$filterTo$iv$iv.next();
                                        $i$a$-any-MosaifyCli$Scan$run$1$2 = false;
                                        if (!(((Number)it.getValue()).intValue() > 1)) continue;
                                        v11 = true;
                                        ** GOTO lbl215
                                    }
                                    v11 = false;
lbl215:
                                    // 3 sources

                                    if (v11) {
                                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.brightYellow.invoke("* - Please note that scanner abbreviations may include multiple scanners\n"), null, null, null, null, (boolean)false, (int)62, null);
                                    }
                                    if (($i$f$any = Scan.access$getFromFile(this.this$0)) == null) ** GOTO lbl-1000
                                    element$iv = $i$f$any;
                                    $i$f$map = false;
                                    $i$a$-any-MosaifyCli$Scan$run$1$2 = $this$map$iv;
                                    destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        $this$any$iv = (File)item$iv$iv;
                                        var56_163 = destination$iv$iv /* !! */ ;
                                        $i$a$-map-MosaifyCli$Scan$run$1$imagesFromFile$1 = false;
                                        v12 = it.getAbsolutePath();
                                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getAbsolutePath(...)");
                                        var57_164 = ConfigFile.INSTANCE.readImagesFromFile(v12);
                                        var56_163.add(var57_164);
                                    }
                                    $this$filterTo$iv$iv = (List)destination$iv$iv /* !! */ ;
                                    $this$map$iv = CollectionsKt.flatten((Iterable)((Iterable)$this$filterTo$iv$iv));
                                    if ($this$map$iv != null) {
                                        v13 = $this$map$iv;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v13 = CollectionsKt.emptyList();
                                    }
                                    imagesFromFile = v13;
                                    combinedImages = CollectionsKt.plus((Collection)Scan.access$getImage(this.this$0), (Iterable)imagesFromFile);
                                    componentCount = Scan.access$getCode(this.this$0).size() + combinedImages.size();
                                    if (componentCount > 1 && Scan.access$getName(this.this$0) == null) {
                                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.yellow.invoke("Multiple items will be scanned. If you want to save them as components of a project, please set project name and version (parameters '--name' and '--version')"), null, null, null, null, (boolean)false, (int)62, null);
                                    }
                                    $this$filter$iv = enabledScanners;
                                    $i$f$filter = false;
                                    destination$iv$iv /* !! */  = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (Scanner)element$iv$iv;
                                        $i$a$-filter-MosaifyCli$Scan$run$1$imageScanners$1 = false;
                                        if (!dev.mosaify.core.util.Extensions.INSTANCE.supports(it, TargetType.CONTAINER_IMAGE)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    imageScanners = (List)destination$iv$iv;
                                    $this$filter$iv = enabledScanners;
                                    $i$f$filter = false;
                                    destination$iv$iv = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (E element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (Scanner)element$iv$iv;
                                        $i$a$-filter-MosaifyCli$Scan$run$1$codeScanners$1 = false;
                                        if (!dev.mosaify.core.util.Extensions.INSTANCE.supports(it, TargetType.DIRECTORY)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    codeScanners = (List)destination$iv$iv;
                                    storageMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
                                    $this$filterTo$iv$iv = Scan.access$getFilter(this.this$0);
                                    $i$f$flatMap = false;
                                    $i$f$filterTo = $this$flatMap$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$flatMapTo = false;
                                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                        it = (File)element$iv$iv;
                                        $i$a$-flatMap-MosaifyCli$Scan$run$1$targetsFilter$1 = false;
                                        list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
                                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                    }
                                    $this$flatMap$iv = (List)destination$iv$iv;
                                    $i$f$filterNot = false;
                                    $this$flatMapTo$iv$iv = $this$filterNot$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterNotTo = false;
                                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                        it = (String)element$iv$iv;
                                        $i$a$-filterNot-MosaifyCli$Scan$run$1$targetsFilter$2 = false;
                                        if (((CharSequence)it).length() == 0 != false || StringsKt.isBlank((CharSequence)it) != false) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filterNot$iv = (List)destination$iv$iv;
                                    $i$f$filter = false;
                                    $this$filterNotTo$iv$iv = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (String)element$iv$iv;
                                        $i$a$-filter-MosaifyCli$Scan$run$1$targetsFilter$3 = false;
                                        if (!Character.isLetterOrDigit(StringsKt.first((CharSequence)it))) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    $i$f$distinctBy = false;
                                    set$iv = new HashSet<String>();
                                    list$iv = new ArrayList<Object>();
                                    for (Object e$iv : $this$distinctBy$iv) {
                                        it = (String)e$iv;
                                        $i$a$-distinctBy-MosaifyCli$Scan$run$1$targetsFilter$4 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)it.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                                        if (!set$iv.add(key$iv)) continue;
                                        list$iv.add(e$iv);
                                    }
                                    targetsFilter = CollectionsKt.sorted((Iterable)list$iv);
                                    $this$distinctBy$iv = combinedImages;
                                    $i$f$distinctBy = false;
                                    set$iv = new HashSet<String>();
                                    list$iv = new ArrayList<E>();
                                    for (E e$iv : $this$distinctBy$iv) {
                                        it = (String)e$iv;
                                        $i$a$-distinctBy-MosaifyCli$Scan$run$1$combinedTargets$1 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)it.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                                        if (!set$iv.add(key$iv)) continue;
                                        list$iv.add(e$iv);
                                    }
                                    $this$distinctBy$iv = list$iv;
                                    $i$f$map = false;
                                    set$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        $i$a$-distinctBy-MosaifyCli$Scan$run$1$combinedTargets$1 = (String)item$iv$iv;
                                        var56_163 = destination$iv$iv;
                                        $i$a$-map-MosaifyCli$Scan$run$1$combinedTargets$2 = false;
                                        var57_164 = new ScanTarget((String)it, TargetType.CONTAINER_IMAGE);
                                        var56_163.add(var57_164);
                                    }
                                    $this$map$iv = CollectionsKt.distinct((Iterable)Scan.access$getCode(this.this$0));
                                    var56_163 = (List)destination$iv$iv;
                                    $i$f$map = false;
                                    $this$mapTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        it = (File)item$iv$iv;
                                        var57_164 = destination$iv$iv;
                                        $i$a$-map-MosaifyCli$Scan$run$1$combinedTargets$3 = false;
                                        v14 = FilesKt.normalize((File)it).getAbsolutePath();
                                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getAbsolutePath(...)");
                                        var58_165 /* !! */  = new ScanTarget(v14, TargetType.DIRECTORY);
                                        var57_164.add(var58_165 /* !! */ );
                                    }
                                    var57_164 = (List)destination$iv$iv;
                                    $this$map$iv = CollectionsKt.plus((Collection)var56_163, (Iterable)((Iterable)var57_164));
                                    $i$f$filter = false;
                                    $this$mapTo$iv$iv = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv /* !! */ ) {
                                        it = (ScanTarget)element$iv$iv;
                                        $i$a$-filter-MosaifyCli$Scan$run$1$combinedTargets$4 = false;
                                        if (targetsFilter.isEmpty()) ** GOTO lbl-1000
                                        $this$any$iv = targetsFilter;
                                        $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl386
                                        v15 = false;
                                        ** GOTO lbl393
lbl386:
                                        // 2 sources

                                        for (T element$iv : $this$any$iv) {
                                            filter = (String)element$iv;
                                            $i$a$-any-MosaifyCli$Scan$run$1$combinedTargets$4$1 = false;
                                            if (!StringsKt.contains((CharSequence)it.getTarget(), (CharSequence)filter, (boolean)true)) continue;
                                            v15 = true;
                                            ** GOTO lbl393
                                        }
                                        v15 = false;
lbl393:
                                        // 3 sources

                                        if (v15) lbl-1000:
                                        // 2 sources

                                        {
                                            v16 = true;
                                        } else {
                                            v16 = false;
                                        }
                                        if (!v16) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    combinedTargets = (List)destination$iv$iv;
                                    if (combinedTargets.isEmpty()) {
                                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.brightYellow.invoke("Nothing to scan (no targets)"), null, null, null, null, (boolean)false, (int)62, null);
                                        throw new ProgramResult(1);
                                    }
                                    $this$any$iv = combinedTargets;
                                    $i$f$any = false;
                                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl410
                                    v17 = false;
                                    ** GOTO lbl417
lbl410:
                                    // 2 sources

                                    for (T element$iv : $this$any$iv) {
                                        it = (ScanTarget)element$iv /* !! */ ;
                                        $i$a$-any-MosaifyCli$Scan$run$1$3 = false;
                                        if (!(it.getType() == TargetType.DIRECTORY)) continue;
                                        v17 = true;
                                        ** GOTO lbl417
                                    }
                                    v17 = false;
lbl417:
                                    // 3 sources

                                    if (v17) {
                                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.yellow.plus(TextStyles.italic).invoke("Please note: to work properly, most scanners that support scanning code directories require code to be built and contain build artifacts, not just source code"), null, null, null, null, (boolean)false, (int)62, null);
                                    }
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)"Targets:", null, null, null, null, (boolean)false, (int)62, null);
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Widget)((Widget)TableDslKt.table((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$19(java.util.List com.github.ajalt.mordant.table.TableBuilder ), (Lcom/github/ajalt/mordant/table/TableBuilder;)Lkotlin/Unit;)((List)combinedTargets))), (boolean)false, (int)2, null);
                                    if (!(((Collection)combinedImages).isEmpty() == false)) break block72;
                                    if (Scan.access$getDontPull(this.this$0)) break;
                                    $i$f$any = ProgressLayoutScopeKt.progressBarContextLayout$default((int)0, (boolean)false, (int)0, (int)0, null, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$20(com.github.ajalt.mordant.widgets.progress.ProgressLayoutScope ), (Lcom/github/ajalt/mordant/widgets/progress/ProgressLayoutScope;)Lkotlin/Unit;)(), (int)63, null);
                                    $this$filterTo$iv$iv /* !! */  = MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0));
                                    element$iv /* !! */  = VerticalProgressBarMaker.INSTANCE;
                                    it = (String)CollectionsKt.first((List)combinedImages);
                                    $i$a$-any-MosaifyCli$Scan$run$1$3 = combinedImages.size();
                                    progress = ThreadAnimatorKt.animateOnThread-TNmY5B4$default((ProgressBarDefinition)$i$f$any, (Terminal)$this$filterTo$iv$iv /* !! */ , (Object)it, (Long)Boxing.boxLong((long)$i$a$-any-MosaifyCli$Scan$run$1$3), (long)0L, (boolean)false, (boolean)false, (boolean)false, (long)0L, null, (ProgressBarWidgetMaker)((ProgressBarWidgetMaker)element$iv /* !! */ ), (int)496, null);
                                    BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((ThreadProgressTaskAnimator<String>)progress, null){
                                        int label;
                                        final /* synthetic */ ThreadProgressTaskAnimator<String> $progress;
                                        {
                                            this.$progress = $progress;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    ThreadAnimatorKt.execute$default((BlockingAnimator)((BlockingAnimator)this.$progress), null, (int)1, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                    $this$filterTo$iv$iv /* !! */  = combinedImages;
                                    element$iv /* !! */  = this.this$0;
                                    $i$f$map = false;
                                    $i$a$-any-MosaifyCli$Scan$run$1$3 /* !! */  = $this$map$iv /* !! */ ;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        $i$f$any = (String)item$iv$iv;
                                        var56_163 = destination$iv$iv;
                                        $i$a$-map-MosaifyCli$Scan$run$1$pullImageJobs$1 = false;
                                        var57_164 = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((ThreadProgressTaskAnimator<String>)progress, (String)it, element$iv /* !! */ , null){
                                            int label;
                                            final /* synthetic */ ThreadProgressTaskAnimator<String> $progress;
                                            final /* synthetic */ String $it;
                                            final /* synthetic */ Scan this$0;
                                            {
                                                this.$progress = $progress;
                                                this.$it = $it;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.$progress.update(arg_0 -> run.pullImageJobs.1.1.invokeSuspend$lambda$0(this.$it, arg_0));
                                                        CliFunctions.INSTANCE.pullImageRetrying(this.$it, Scan.access$getRetries(this.this$0));
                                                        ProgressBarAnimationKt.advance$default((ProgressTask)((ProgressTask)this.$progress), (long)0L, (int)1, null);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }

                                            private static final Unit invokeSuspend$lambda$0(String $it, ProgressTaskUpdateScope $this$update) {
                                                $this$update.setContext((Object)$it);
                                                return Unit.INSTANCE;
                                            }
                                        }), (int)3, null);
                                        var56_163.add(var57_164);
                                    }
                                    pullImageJobs = (List)destination$iv$iv;
                                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.gray.invoke("Awaiting " + pullImageJobs.size() + " pulls to finish..."), null, null, null, null, (boolean)false, (int)62, null);
                                    this.L$0 = $this$runBlocking;
                                    this.L$1 = cacheCutoffTime;
                                    this.L$2 = scannerParameters;
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)abbrCounts);
                                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)scannerStatus);
                                    this.L$5 = SpillingKt.nullOutSpilledVariable(enabledScanners);
                                    this.L$6 = SpillingKt.nullOutSpilledVariable((Object)imagesFromFile);
                                    this.L$7 = combinedImages;
                                    this.L$8 = imageScanners;
                                    this.L$9 = codeScanners;
                                    this.L$10 = storageMutex;
                                    this.L$11 = SpillingKt.nullOutSpilledVariable((Object)targetsFilter);
                                    this.L$12 = combinedTargets;
                                    this.L$13 = SpillingKt.nullOutSpilledVariable((Object)progress);
                                    this.L$14 = SpillingKt.nullOutSpilledVariable((Object)pullImageJobs);
                                    this.J$0 = ttlDuration;
                                    this.I$0 = componentCount;
                                    this.label = 1;
                                    v18 = AwaitKt.awaitAll((Collection)pullImageJobs, (Continuation)((Continuation)this));
                                    if (v18 == var59_3) {
                                        return var59_3;
                                    }
                                    break block73;
                                }
                                case 1: {
                                    componentCount = this.I$0;
                                    ttlDuration = this.J$0;
                                    pullImageJobs = (List)this.L$14;
                                    progress = (ThreadProgressTaskAnimator)this.L$13;
                                    combinedTargets = (List)this.L$12;
                                    targetsFilter = (List)this.L$11;
                                    storageMutex = (Mutex)this.L$10;
                                    codeScanners = (List)this.L$9;
                                    imageScanners = (List)this.L$8;
                                    combinedImages = (List)this.L$7;
                                    imagesFromFile = (List)this.L$6;
                                    enabledScanners = (Set<K>)this.L$5;
                                    scannerStatus = (Map)this.L$4;
                                    abbrCounts = (Map)this.L$3;
                                    scannerParameters = (Map)this.L$2;
                                    cacheCutoffTime = (Instant)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v18 = $result;
                                    break block73;
                                }
                            }
                            Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.yellow.invoke("Image pull skipped. This may cause scan issues"), null, null, null, null, (boolean)false, (int)62, null);
                            v18 = Unit.INSTANCE;
                        }
                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.green.invoke("Image pull complete (" + combinedImages.size() + " total)"), null, null, null, null, (boolean)false, (int)62, null);
                    }
                    pullImageJobs = combinedTargets;
                    $this$map$iv /* !! */  = this.this$0;
                    $i$f$associateWith = false;
                    result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    $this$mapTo$iv$iv = $this$associateWith$iv;
                    destination$iv$iv = result$iv;
                    $i$f$associateWithTo = false;
                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                        it = (ScanTarget)element$iv$iv;
                        var57_164 = element$iv$iv;
                        var56_163 = destination$iv$iv;
                        $i$a$-associateWith-MosaifyCli$Scan$run$1$resolvedComponents$1 = false;
                        v19 = it.getType();
                        switch (v19 == null ? -1 : run.WhenMappings.$EnumSwitchMapping$0[v19.ordinal()]) {
                            case 1: {
                                v20 = CliFunctions.INSTANCE.resolveImageInfo(it.getTarget());
                                break;
                            }
                            case 2: {
                                v20 = CliFunctions.INSTANCE.resolveCodeInfo(new File(it.getTarget()));
                                break;
                            }
                            default: {
                                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)$this$map$iv /* !! */ )), (Object)TextColors.red.invoke("ERROR: Target type not supported: " + it.getType()), null, null, null, null, (boolean)false, (int)62, null);
                                throw new ProgramResult(1);
                            }
                        }
                        var58_165 /* !! */  = v20;
                        var56_163.put(var57_164, var58_165 /* !! */ );
                    }
                    resolvedComponents = destination$iv$iv;
                    $this$map$iv /* !! */  = MapsKt.toList((Map)resolvedComponents);
                    var21_69 /* !! */  = this.this$0;
                    $i$f$associateWith = 0;
                    result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    destination$iv$iv = $this$associateWith$iv;
                    destination$iv$iv = result$iv;
                    $i$f$associateWithTo = 0;
                    var27_142 = $this$associateWithTo$iv$iv.iterator();
lbl532:
                    // 2 sources

                    while (var27_142.hasNext()) {
                        element$iv$iv = var27_142.next();
                        var29_154 = (Pair)element$iv$iv;
                        var57_164 = element$iv$iv;
                        var56_163 = destination$iv$iv;
                        $i$a$-associateWith-MosaifyCli$Scan$run$1$componentScans$1 = 0;
                        target = (ScanTarget)var29_154.component1();
                        componentInfo = (ComponentInfo)var29_154.component2();
                        if (Duration.equals-impl0((long)ttlDuration, (long)Duration.Companion.getZERO-UwyO8pc())) {
                            v21 = CollectionsKt.emptyList();
                        } else if (componentInfo.getVersion() == null) {
                            Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var21_69 /* !! */ )), (Object)TextColors.yellow.invoke("Skipping previous scan check for '" + target.getTarget() + "' without a resolved version"), null, null, null, null, (boolean)false, (int)62, null);
                            v21 = CollectionsKt.emptyList();
                        } else {
                            $i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 /* !! */  = SarifStorage.resolveLatestScans$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)componentInfo.getName(), (String)componentInfo.getVersion(), (boolean)false, (int)0, (int)12, null);
                            if ($i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 /* !! */  != null) {
                                var34_166 = (Iterable)$i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 /* !! */ ;
                                $i$f$filter = false;
                                var36_170 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (ResolvedScanRecord)element$iv$iv;
                                    $i$a$-filter-MosaifyCli$Scan$run$1$componentScans$1$previousScans$1 = false;
                                    if (!(it.getLogInfo().getTimestamp().compareTo(cacheCutoffTime) > 0)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                v21 = var43_184 = (List)destination$iv$iv;
                            } else {
                                v21 = previousScans = CollectionsKt.emptyList();
                            }
                        }
                        if (((Collection)previousScans).isEmpty() == false) {
                            Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var21_69 /* !! */ )), (Object)TextColors.green.invoke("Found (less than " + Scan.access$getTtl(var21_69 /* !! */ ) + " old) previous scan(s):"), null, null, null, null, (boolean)false, (int)62, null);
                            Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var21_69 /* !! */ )), (Widget)((Widget)TableDslKt.table((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$23$1(java.util.List dev.mosaify.core.model.scanner.ScanTarget com.github.ajalt.mordant.table.TableBuilder ), (Lcom/github/ajalt/mordant/table/TableBuilder;)Lkotlin/Unit;)((List)previousScans, (ScanTarget)target))), (boolean)false, (int)2, null);
                        }
                        v22 = $i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 /* !! */  = target.getType();
                        var43_183 = v22 == null ? -1 : run.WhenMappings.$EnumSwitchMapping$0[v22.ordinal()];
                        switch (var43_183) {
                            case 1: {
                                v23 = imageScanners;
                                break;
                            }
                            case 2: {
                                v23 = codeScanners;
                                break;
                            }
                            default: {
                                Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var21_69 /* !! */ )), (Object)TextColors.red.invoke("ERROR: Target type not supported: " + target.getType()), null, null, null, null, (boolean)false, (int)62, null);
                                throw new ProgramResult(1);
                            }
                        }
                        $i$a$-filter-MosaifyCli$Scan$run$1$scannerStatus$1$3$1 /* !! */  = v23;
                        $i$f$filter = false;
                        $this$filter$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Scanner)element$iv$iv;
                            $i$a$-filter-MosaifyCli$Scan$run$1$componentScans$1$2 = false;
                            $this$map$iv = previousScans;
                            $i$f$map = false;
                            var45_186 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var50_191 = (ResolvedScanRecord)item$iv$iv;
                                var51_192 = destination$iv$iv;
                                $i$a$-map-MosaifyCli$Scan$run$1$componentScans$1$2$1 = false;
                                var51_192.add(record.getRunInfo().getScanner());
                            }
                            if (!(((List)destination$iv$iv).contains(it.getName()) == false)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (Scanner)item$iv$iv;
                            var53_194 = destination$iv$iv;
                            $i$a$-map-MosaifyCli$Scan$run$1$componentScans$1$3 = false;
                            var54_195 = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends Run>>, Object>(var21_69 /* !! */ , (Scanner)scanner, target, (Map<String, String>)scannerParameters, componentInfo, storageMutex, null){
                                Object L$1;
                                int I$0;
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ Scan this$0;
                                final /* synthetic */ Scanner $scanner;
                                final /* synthetic */ ScanTarget $target;
                                final /* synthetic */ Map<String, String> $scannerParameters;
                                final /* synthetic */ ComponentInfo $componentInfo;
                                final /* synthetic */ Mutex $storageMutex;
                                {
                                    this.this$0 = $receiver;
                                    this.$scanner = $scanner;
                                    this.$target = $target;
                                    this.$scannerParameters = $scannerParameters;
                                    this.$componentInfo = $componentInfo;
                                    this.$storageMutex = $storageMutex;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = (CoroutineScope)this.L$0;
                                    var25_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var4_4 = $this$async;
                                            var5_5 /* !! */  = this.$scanner;
                                            var6_6 = this.$target;
                                            var7_7 = this.$scannerParameters;
                                            var8_8 = this.this$0;
                                            $this$invokeSuspend_u24lambda_u240 = var4_4;
                                            $i$a$-runCatching-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1 = 0;
                                            var11_13 = var7_7;
                                            var12_14 = var6_6;
                                            var13_15 /* !! */  = var5_5 /* !! */ ;
                                            var14_16 = CliFunctions.INSTANCE;
                                            $i$f$filter = false;
                                            var16_18 = $this$filter$iv;
                                            destination$iv$iv = new LinkedHashMap<K, V>();
                                            $i$f$filterTo = false;
                                            var19_21 = $this$filterTo$iv$iv.entrySet().iterator();
                                            while (var19_21.hasNext()) {
                                                it = element$iv$iv = var19_21.next();
                                                $i$a$-filter-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1$1 = false;
                                                if (!var5_5 /* !! */ .getParameters().keySet().contains(it.getKey())) continue;
                                                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                            }
                                            var23_25 = destination$iv$iv;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                                            this.I$0 = $i$a$-runCatching-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1;
                                            this.label = 1;
                                            v0 = CliFunctions.scanRetrying$default(var14_16, var13_15 /* !! */ , var12_14, var23_25, var5_5 /* !! */  instanceof ScannerJfrogXray != false || var5_5 /* !! */  instanceof ScannerDockerScout != false || var5_5 /* !! */  instanceof ScannerSnykOss != false && Scan.access$getSnykOssContainer((Scan)var8_8) == false, false, Scan.access$getRetries((Scan)var8_8), (Continuation)this, 8, null);
                                            ** if (v0 != var25_3) goto lbl40
lbl39:
                                            // 1 sources

                                            return var25_3;
lbl40:
                                            // 1 sources

                                            ** GOTO lbl49
                                        }
                                        case 1: {
                                            $i$a$-runCatching-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1 = this.I$0;
                                            $this$invokeSuspend_u24lambda_u240 = (CoroutineScope)this.L$1;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl49:
                                                // 2 sources

                                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)((Collection)v0));
                                            }
                                            catch (Throwable $i$a$-runCatching-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1) {
                                                $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$1));
                                            }
                                            var4_4 = $this$invokeSuspend_u24lambda_u240;
                                            var5_5 /* !! */  = this.this$0;
                                            var6_6 = this.$scanner;
                                            var7_7 = this.$target;
                                            v1 = Result.exceptionOrNull-impl((Object)var4_4);
                                            if (v1 != null) {
                                                it = var8_8 = v1;
                                                $i$a$-onFailure-MosaifyCli$Scan$run$1$componentScans$1$3$1$scannerRuns$2 = false;
                                                v2 = MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var5_5 /* !! */ ));
                                                v3 = TextColors.brightRed.plus(TextStyles.bold);
                                                v4 = var6_6.getName();
                                                v5 = it.getMessage();
                                                if (v5 == null) {
                                                    v5 = "<unknown error>";
                                                }
                                                Terminal.println$default((Terminal)v2, (Object)v3.invoke("Scanner failure: '" + v4 + "' with target '" + (ScanTarget)var7_7 + "': " + v5 + " "), null, null, null, null, (boolean)false, (int)62, null);
                                            }
                                            scannerRuns = (Collection)(Result.isFailure-impl((Object)var4_4) != false ? null : var4_4);
                                            if (scannerRuns != null) {
                                                CliFunctions.INSTANCE.printAnyErrors(scannerRuns);
                                                if (!CommonUtils.INSTANCE.hasErrors(scannerRuns)) {
                                                    var4_4 = this.$scanner;
                                                    var5_5 /* !! */  = this.$target;
                                                    var6_6 = this.$componentInfo;
                                                    var8_8 = var7_7 = new StringBuilder();
                                                    var24_27 = MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0));
                                                    $i$a$-buildString-MosaifyCli$Scan$run$1$componentScans$1$3$1$1 = false;
                                                    $this$invokeSuspend_u24lambda_u242.append("Storing a '" + var4_4.getName() + "' scan result for '" + var5_5 /* !! */ .getTarget() + "' ");
                                                    $this$invokeSuspend_u24lambda_u242.append("('" + var6_6.getName() + "' version '");
                                                    v6 = var6_6.getVersion();
                                                    if (v6 == null) {
                                                        v6 = TextColors.yellow.plus(TextStyles.italic).invoke("<unknown, will use timestamp instead>");
                                                    }
                                                    $this$invokeSuspend_u24lambda_u242.append(v6);
                                                    $this$invokeSuspend_u24lambda_u242.append("'");
                                                    if (((Collection)var6_6.getAliases()).isEmpty() == false) {
                                                        $this$invokeSuspend_u24lambda_u242.append(" ref: " + CollectionsKt.joinToString$default((Iterable)var6_6.getAliases(), null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2$0(dev.mosaify.core.model.metadata.BasicProjectInfo ), (Ldev/mosaify/core/model/metadata/BasicProjectInfo;)Ljava/lang/CharSequence;)(), (int)31, null));
                                                    }
                                                    $this$invokeSuspend_u24lambda_u242.append(")");
                                                    Terminal.println$default((Terminal)var24_27, (Object)var7_7.toString(), null, null, null, null, (boolean)false, (int)62, null);
                                                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$storageMutex, this.$componentInfo, (Collection<Run>)scannerRuns, null){
                                                        Object L$0;
                                                        Object L$1;
                                                        Object L$2;
                                                        int I$0;
                                                        int label;
                                                        final /* synthetic */ Mutex $storageMutex;
                                                        final /* synthetic */ ComponentInfo $componentInfo;
                                                        final /* synthetic */ Collection<Run> $scannerRuns;
                                                        {
                                                            this.$storageMutex = $storageMutex;
                                                            this.$componentInfo = $componentInfo;
                                                            this.$scannerRuns = $scannerRuns;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * WARNING - Removed try catching itself - possible behaviour change.
                                                         * Unable to fully structure code
                                                         */
                                                        public final Object invokeSuspend(Object $result) {
                                                            var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    var2_3 = this.$storageMutex;
                                                                    var4_4 = this.$componentInfo;
                                                                    var5_5 = this.$scannerRuns;
                                                                    owner$iv = null;
                                                                    $i$f$withLock = 0;
                                                                    this.L$0 = $this$withLock_u24default$iv;
                                                                    this.L$1 = var4_4;
                                                                    this.L$2 = var5_5;
                                                                    this.I$0 = $i$f$withLock;
                                                                    this.label = 1;
                                                                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                                                    if (v0 == var10_2) {
                                                                        return var10_2;
                                                                    }
                                                                    ** GOTO lbl27
                                                                }
                                                                case 1: {
                                                                    $i$f$withLock = this.I$0;
                                                                    var5_5 = (Collection<Run>)this.L$2;
                                                                    var4_4 = (ComponentInfo)this.L$1;
                                                                    owner$iv = null;
                                                                    $this$withLock_u24default$iv = (Mutex)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl27:
                                                                    // 2 sources

                                                                    try {
                                                                        $i$a$-withLock$default-MosaifyCli$Scan$run$1$componentScans$1$3$1$2$1 = false;
                                                                        SarifStorage.storeReport$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)var4_4.getName(), (String)var4_4.getVersion(), (Set)var4_4.getAliases(), null, var5_5, (int)8, null);
                                                                        var8_10 = Unit.INSTANCE;
                                                                    }
                                                                    finally {
                                                                        $this$withLock_u24default$iv.unlock(owner$iv);
                                                                    }
                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (int)1, null);
                                                }
                                            }
                                            return scannerRuns;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Collection<Run>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final CharSequence invokeSuspend$lambda$2$0(BasicProjectInfo it) {
                                    return "'" + it + "'";
                                }
                            }), (int)3, null);
                            var53_194.add(var54_195);
                        }
                        this.L$0 = $this$runBlocking;
                        this.L$1 = cacheCutoffTime;
                        this.L$2 = scannerParameters;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)abbrCounts);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)scannerStatus);
                        this.L$5 = SpillingKt.nullOutSpilledVariable(enabledScanners);
                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)imagesFromFile);
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)combinedImages);
                        this.L$8 = imageScanners;
                        this.L$9 = codeScanners;
                        this.L$10 = storageMutex;
                        this.L$11 = SpillingKt.nullOutSpilledVariable((Object)targetsFilter);
                        this.L$12 = SpillingKt.nullOutSpilledVariable((Object)combinedTargets);
                        this.L$13 = SpillingKt.nullOutSpilledVariable((Object)resolvedComponents);
                        this.L$14 = SpillingKt.nullOutSpilledVariable((Object)$this$associateWith$iv);
                        this.L$15 = var21_69 /* !! */ ;
                        this.L$16 = SpillingKt.nullOutSpilledVariable(result$iv);
                        this.L$17 = SpillingKt.nullOutSpilledVariable((Object)$this$associateWithTo$iv$iv);
                        this.L$18 = destination$iv$iv;
                        this.L$19 = var27_142;
                        this.L$20 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                        this.L$21 = SpillingKt.nullOutSpilledVariable((Object)target);
                        this.L$22 = SpillingKt.nullOutSpilledVariable((Object)componentInfo);
                        this.L$23 = previousScans;
                        this.L$24 = var56_163;
                        this.L$25 = var57_164;
                        this.J$0 = ttlDuration;
                        this.I$0 = componentCount;
                        this.I$1 = $i$f$associateWith;
                        this.I$2 = $i$f$associateWithTo;
                        this.I$3 = $i$a$-associateWith-MosaifyCli$Scan$run$1$componentScans$1;
                        this.label = 2;
                        v24 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)this);
                        if (v24 == var59_3) {
                            return var59_3;
                        }
                        ** GOTO lbl691
                    }
                    {
                        break;
                        case 2: {
                            $i$a$-associateWith-MosaifyCli$Scan$run$1$componentScans$1 = this.I$3;
                            $i$f$associateWithTo = this.I$2;
                            $i$f$associateWith = this.I$1;
                            componentCount = this.I$0;
                            ttlDuration = this.J$0;
                            var57_164 = this.L$25;
                            var56_163 = (Map)this.L$24;
                            previousScans = (List)this.L$23;
                            componentInfo = (ComponentInfo)this.L$22;
                            target = (ScanTarget)this.L$21;
                            element$iv$iv = this.L$20;
                            var27_142 = (Iterator<T>)this.L$19;
                            destination$iv$iv = (Map)this.L$18;
                            $this$associateWithTo$iv$iv = (Iterable)this.L$17;
                            result$iv = (LinkedHashMap<K, V>)this.L$16;
                            var21_69 /* !! */  = (Scan)this.L$15;
                            $this$associateWith$iv = (Iterable)this.L$14;
                            resolvedComponents = (Map)this.L$13;
                            combinedTargets = (List)this.L$12;
                            targetsFilter = (List)this.L$11;
                            storageMutex = (Mutex)this.L$10;
                            codeScanners = (List)this.L$9;
                            imageScanners = (List)this.L$8;
                            combinedImages = (List)this.L$7;
                            imagesFromFile = (List)this.L$6;
                            enabledScanners = (Set)this.L$5;
                            scannerStatus = (Map)this.L$4;
                            abbrCounts = (Map)this.L$3;
                            scannerParameters = (Map)this.L$2;
                            cacheCutoffTime = (Instant)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v24 = $result;
lbl691:
                            // 2 sources

                            $this$map$iv = previousScans;
                            var53_194 = CollectionsKt.flatten((Iterable)CollectionsKt.filterNotNull((Iterable)((Iterable)v24)));
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                scanner = (ResolvedScanRecord)item$iv$iv;
                                var54_195 = destination$iv$iv;
                                $i$a$-map-MosaifyCli$Scan$run$1$componentScans$1$4 = false;
                                var55_196 = it.getRun();
                                var54_195.add(var55_196);
                            }
                            var54_195 = (List)destination$iv$iv;
                            var58_165 /* !! */  = CollectionsKt.plus((Collection)var53_194, (Iterable)var54_195);
                            var56_163.put(var57_164, var58_165 /* !! */ );
                            ** GOTO lbl532
                        }
                    }
                    componentScans = destination$iv$iv;
                    v25 /* !! */  = var20_57 /* !! */  = Scan.access$getName(this.this$0);
                    if (v25 /* !! */  != null) {
                        var21_69 /* !! */  = v25 /* !! */ ;
                        var22_84 = this.this$0;
                        definedName /* !! */  = var21_69 /* !! */ ;
                        $i$a$-let-MosaifyCli$Scan$run$1$6 = false;
                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)var22_84)), (Object)"Storing project metadata", null, null, null, null, (boolean)false, (int)62, null);
                        SarifStorage.storeReport$default((SarifStorage)CliFunctions.INSTANCE.getSarifStorage$mosaify_cli(), (String)definedName /* !! */ , (String)Scan.access$getVersion(var22_84), null, (Map)MapsKt.toMap((Iterable)componentScans.keySet()), null, (int)20, null);
                        v26 = Unit.INSTANCE;
                    } else {
                        v26 = null;
                    }
                    if (CommonUtils.INSTANCE.hasErrors((Collection)CollectionsKt.flatten((Iterable)componentScans.values()))) {
                        Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.brightRed.plus(TextStyles.bold).invoke("There were errors during scanning"), null, null, null, null, (boolean)false, (int)62, null);
                        throw new ProgramResult(1);
                    }
                    Terminal.println$default((Terminal)MordantContextKt.getTerminal((BaseCliktCommand)((BaseCliktCommand)this.this$0)), (Object)TextColors.brightGreen.invoke("Done!"), null, null, null, null, (boolean)false, (int)62, null);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final CharSequence invokeSuspend$lambda$3$2$1(String it) {
                    return "  - " + it;
                }

                private static final Unit invokeSuspend$lambda$5(Map $scannerStatus, Map $abbrCounts, TableBuilder $this$table) {
                    $this$table.header(run.1::invokeSuspend$lambda$5$0);
                    $this$table.body(arg_0 -> run.1.invokeSuspend$lambda$5$1($scannerStatus, $abbrCounts, arg_0));
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$5$0(SectionBuilder $this$header) {
                    $this$header.setStyle(TextStyles.bold.getStyle());
                    Object[] objectArray = new Object[]{"Scanner", "Images", "Code", "Status", "Reason", "Supported Abbreviations"};
                    RowHolderBuilder.DefaultImpls.row$default((RowHolderBuilder)((RowHolderBuilder)$this$header), (Object[])objectArray, null, (int)2, null);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$5$1(Map $scannerStatus, Map $abbrCounts, SectionBuilder $this$body) {
                    Map<Scanner, Collection<String>> $this$forEach$iv = CliFunctions.INSTANCE.getAvailableScanners();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<Scanner, Collection<String>>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Scanner, Collection<String>> element$iv;
                        Map.Entry<Scanner, Collection<String>> entry = element$iv = iterator.next();
                        boolean bl = false;
                        Scanner scanner = entry.getKey();
                        Collection<String> abbr = entry.getValue();
                        $this$body.row(arg_0 -> run.1.invokeSuspend$lambda$5$1$0$0(scanner, $scannerStatus, abbr, $abbrCounts, arg_0));
                    }
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$5$1$0$0(Scanner $scanner, Map $scannerStatus, Collection $abbr, Map $abbrCounts, RowBuilder $this$row) {
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$scanner.getName(), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)($scanner.getSupportedTargets().contains(TargetType.CONTAINER_IMAGE) ? TextColors.green.invoke("Yes") : TextColors.gray.invoke("No")), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)($scanner.getSupportedTargets().contains(TargetType.DIRECTORY) ? TextColors.green.invoke("Yes") : TextColors.gray.invoke("No")), null, (int)2, null);
                    V v = $scannerStatus.get($scanner);
                    Intrinsics.checkNotNull(v);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)((Boolean)((Pair)v).getFirst() != false ? TextColors.green.invoke("Enabled") : TextColors.yellow.invoke("Disabled")), null, (int)2, null);
                    V v2 = $scannerStatus.get($scanner);
                    Intrinsics.checkNotNull(v2);
                    TextColors textColors = (Boolean)((Pair)v2).getFirst() != false ? TextColors.green : TextColors.yellow;
                    V v3 = $scannerStatus.get($scanner);
                    Intrinsics.checkNotNull(v3);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)textColors.invoke((String)((Pair)v3).getSecond()), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)TableDslKt.grid(arg_0 -> run.1.invokeSuspend$lambda$5$1$0$0$0($abbr, $abbrCounts, arg_0)), null, (int)2, null);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$5$1$0$0$0(Collection $abbr, Map $abbrCounts, GridBuilder $this$grid) {
                    $this$grid.row(arg_0 -> run.1.invokeSuspend$lambda$5$1$0$0$0$0($abbr, $abbrCounts, arg_0));
                    return Unit.INSTANCE;
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$5$1$0$0$0$0(Collection $abbr, Map $abbrCounts, RowBuilder $this$row) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = $abbr;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        V v = $abbrCounts.get(it);
                        Intrinsics.checkNotNull(v);
                        RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)(((Number)v).intValue() > 1 ? TextColors.brightYellow.invoke((String)it + "*") : it), null, (int)2, null);
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$19(List $combinedTargets, TableBuilder $this$table) {
                    $this$table.header(run.1::invokeSuspend$lambda$19$0);
                    $this$table.body(arg_0 -> run.1.invokeSuspend$lambda$19$1($combinedTargets, arg_0));
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$19$0(SectionBuilder $this$header) {
                    $this$header.setStyle(TextStyles.bold.getStyle());
                    $this$header.row(run.1::invokeSuspend$lambda$19$0$0);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$19$0$0(RowBuilder $this$row) {
                    RowBuilder.DefaultImpls.cells$default((RowBuilder)$this$row, (Object)"Targets", (Object)"Type", (Object[])new Object[0], null, (int)8, null);
                    return Unit.INSTANCE;
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$19$1(List $combinedTargets, SectionBuilder $this$body) {
                    void $this$mapTo$iv$iv;
                    Map $this$groupByTo$iv$iv;
                    Iterable $this$groupBy$iv = $combinedTargets;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        void $this$getOrPut$iv$iv$iv;
                        T element$iv$iv = iterator.next();
                        ScanTarget it = (ScanTarget)element$iv$iv;
                        boolean bl = false;
                        TargetType key$iv$iv = it.getType();
                        Map map = destination$iv$iv;
                        TargetType key$iv$iv$iv = key$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map $this$map$iv = destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$groupByTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                        Object object = destination$iv$iv;
                        boolean bl = false;
                        TargetType type = (TargetType)entry.getKey();
                        List list = (List)entry.getValue();
                        $this$body.row(arg_0 -> run.1.invokeSuspend$lambda$19$1$1$0(type, list, arg_0));
                        object.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$19$1$1$0(TargetType $type, List $list, RowBuilder $this$row) {
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)TableDslKt.grid(arg_0 -> run.1.invokeSuspend$lambda$19$1$1$0$0($list, arg_0)), null, (int)2, null);
                    Object object = $type;
                    if (object == null || (object = CliFunctions.INSTANCE.display((TargetType)object)) == null) {
                        object = TextStyles.bold.plus((TextStyle)TextColors.red).invoke("Unknown");
                    }
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)object, null, (int)2, null);
                    return Unit.INSTANCE;
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$19$1$1$0$0(List $list, GridBuilder $this$grid) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = $list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ScanTarget scanTarget = (ScanTarget)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        $this$grid.row(arg_0 -> run.1.invokeSuspend$lambda$19$1$1$0$0$0$0((ScanTarget)it, arg_0));
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$19$1$1$0$0$0$0(ScanTarget $it, RowBuilder $this$row) {
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$it.getTarget(), null, (int)2, null);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$20(ProgressLayoutScope $this$progressBarContextLayout) {
                    ProgressLayoutCellsKt.text$default((ProgressLayoutScope)$this$progressBarContextLayout, (String)"current", null, null, (int)6, null);
                    ProgressLayoutCellsKt.text$default((ProgressLayoutScope)$this$progressBarContextLayout, null, null, (int)0, run.1::invokeSuspend$lambda$20$0, (int)7, null);
                    ProgressLayoutCellsKt.text$default((ProgressLayoutScope)$this$progressBarContextLayout, (String)"pulled", null, null, (int)6, null);
                    ProgressLayoutCellsKt.completed$default((ProgressLayoutScope)$this$progressBarContextLayout, null, (boolean)false, (int)0, null, null, (int)0, (int)63, null);
                    ProgressLayoutCellsKt.text$default((ProgressLayoutScope)$this$progressBarContextLayout, (String)"progress", null, null, (int)6, null);
                    ProgressLayoutCellsKt.percentage$default((ProgressLayoutScope)$this$progressBarContextLayout, (int)0, null, null, (int)7, null);
                    ProgressLayoutCellsKt.text$default((ProgressLayoutScope)$this$progressBarContextLayout, (String)"spinner", null, null, (int)6, null);
                    ProgressLayoutCellsKt.spinner$default((ProgressLayoutScope)$this$progressBarContextLayout, (Spinner)Spinner.Companion.Lines$default((Spinner.Companion)Spinner.Companion, null, (int)0, (int)0, (int)7, null), null, (int)0, (int)6, null);
                    return Unit.INSTANCE;
                }

                private static final String invokeSuspend$lambda$20$0(ProgressState $this$text) {
                    return (String)$this$text.getContext();
                }

                private static final Unit invokeSuspend$lambda$23$1(List $previousScans, ScanTarget $target, TableBuilder $this$table) {
                    $this$table.header(run.1::invokeSuspend$lambda$23$1$0);
                    $this$table.body(arg_0 -> run.1.invokeSuspend$lambda$23$1$1($previousScans, $target, arg_0));
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$23$1$0(SectionBuilder $this$header) {
                    $this$header.setStyle(TextStyles.bold.getStyle());
                    $this$header.row(run.1::invokeSuspend$lambda$23$1$0$0);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$23$1$0$0(RowBuilder $this$row) {
                    Object[] objectArray = new Object[]{"Target", "Resolved Name", "Resolved Version"};
                    RowBuilder.DefaultImpls.cells$default((RowBuilder)$this$row, (Object)"Scanner", (Object)"Timestamp", (Object[])objectArray, null, (int)8, null);
                    return Unit.INSTANCE;
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$23$1$1(List $previousScans, ScanTarget $target, SectionBuilder $this$body) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = $previousScans;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ResolvedScanRecord resolvedScanRecord = (ResolvedScanRecord)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        $this$body.row(arg_0 -> run.1.invokeSuspend$lambda$23$1$1$0$0((ResolvedScanRecord)it, $target, arg_0));
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$23$1$1$0$0(ResolvedScanRecord $it, ScanTarget $target, RowBuilder $this$row) {
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$it.getRunInfo().getScanner(), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)dev.mosaify.core.util.Extensions.INSTANCE.display($it.getLogInfo().getTimestamp()), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$target.getTarget(), null, (int)2, null);
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)$it.getLogInfo().getName(), null, (int)2, null);
                    String string = $it.getLogInfo().getVersion();
                    if (string == null) {
                        string = "--";
                    }
                    RowBuilder.DefaultImpls.cell$default((RowBuilder)$this$row, (Object)string, null, (int)2, null);
                    return Unit.INSTANCE;
                }
            }));
        }

        public static final /* synthetic */ CommonOptions access$getCommonOptions(Scan $this) {
            return $this.getCommonOptions();
        }

        public static final /* synthetic */ String access$getTtl(Scan $this) {
            return $this.getTtl();
        }

        public static final /* synthetic */ List access$getFromFile(Scan $this) {
            return $this.getFromFile();
        }

        public static final /* synthetic */ List access$getImage(Scan $this) {
            return $this.getImage();
        }

        public static final /* synthetic */ List access$getCode(Scan $this) {
            return $this.getCode();
        }

        public static final /* synthetic */ String access$getName(Scan $this) {
            return $this.getName();
        }

        public static final /* synthetic */ List access$getFilter(Scan $this) {
            return $this.getFilter();
        }

        public static final /* synthetic */ boolean access$getDontPull(Scan $this) {
            return $this.getDontPull();
        }

        public static final /* synthetic */ List access$getEnable(Scan $this) {
            return $this.getEnable();
        }

        public static final /* synthetic */ List access$getOnly(Scan $this) {
            return $this.getOnly();
        }

        public static final /* synthetic */ List access$getDisable(Scan $this) {
            return $this.getDisable();
        }

        public static final /* synthetic */ int access$getRetries(Scan $this) {
            return $this.getRetries();
        }

        public static final /* synthetic */ boolean access$getSnykOssContainer(Scan $this) {
            return $this.getSnykOssContainer();
        }

        public static final /* synthetic */ String access$getVersion(Scan $this) {
            return $this.getVersion();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "image", "getImage()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "code", "getCode()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "name", "getName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "version", "getVersion()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "fromFile", "getFromFile()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "filter", "getFilter()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "jobs", "getJobs()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "enable", "getEnable()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "only", "getOnly()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "disable", "getDisable()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "ttl", "getTtl()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "dontPull", "getDontPull()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "retries", "getRetries()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "snykOssContainer", "getSnykOssContainer()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Scan.class, "commonOptions", "getCommonOptions()Ldev/mosaify/core/cli/CommonOptions;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Ldev/mosaify/core/cli/MosaifyCli$Scan$VerticalProgressBarMaker;", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarWidgetMaker;", "<init>", "()V", "build", "Lcom/github/ajalt/mordant/rendering/Widget;", "rows", "", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarMakerRow;", "mosaify-cli"})
        public static final class VerticalProgressBarMaker
        implements ProgressBarWidgetMaker {
            @NotNull
            public static final VerticalProgressBarMaker INSTANCE = new VerticalProgressBarMaker();

            private VerticalProgressBarMaker() {
            }

            @NotNull
            public Widget build(@NotNull List<? extends ProgressBarMakerRow<?>> rows) {
                Intrinsics.checkNotNullParameter(rows, (String)"rows");
                return DefinitionListKt.definitionList(arg_0 -> VerticalProgressBarMaker.build$lambda$0(rows, arg_0));
            }

            private static final Unit build$lambda$0(List $rows, DefinitionListBuilder $this$definitionList) {
                Intrinsics.checkNotNullParameter((Object)$this$definitionList, (String)"$this$definitionList");
                $this$definitionList.setInline(true);
                List widgets = MultiProgressBarWidgetMaker.INSTANCE.buildCells($rows);
                for (List list : CollectionsKt.windowed$default((Iterable)CollectionsKt.flatten((Iterable)widgets), (int)2, (int)2, (boolean)false, (int)4, null)) {
                    Widget term = (Widget)list.get(0);
                    Widget desc = (Widget)list.get(1);
                    $this$definitionList.entry(term, desc);
                }
                return Unit.INSTANCE;
            }
        }
    }
}

