/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.parser.jfrog.xray;

import dev.mosaify.core.model.Named;
import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueFlag;
import dev.mosaify.core.model.generic.IssueLocation;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.generic.ReportKt;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.MultiformatMessageString;
import dev.mosaify.core.model.sarif.ReportingDescriptor;
import dev.mosaify.core.model.sarif.Result;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import dev.mosaify.core.parser.jfrog.xray.model.Component;
import dev.mosaify.core.parser.jfrog.xray.model.Cve;
import dev.mosaify.core.parser.jfrog.xray.model.ExtendedInformation;
import dev.mosaify.core.parser.jfrog.xray.model.ImpactPath;
import dev.mosaify.core.parser.jfrog.xray.model.JfrogResearchSeverityReason;
import dev.mosaify.core.parser.jfrog.xray.model.JfrogXrayJsonResult;
import dev.mosaify.core.parser.jfrog.xray.model.Severity;
import dev.mosaify.core.parser.jfrog.xray.model.Vulnerability;
import dev.mosaify.core.parser.jfrog.xray.model.sarif.JfrogXraySarifPropertyBag;
import dev.mosaify.core.parser.jfrog.xray.model.serialization.JfrogXrayJsonResultListSerializer;
import dev.mosaify.core.parser.sarif.ParserSarifGeneric;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.Extensions;
import dev.mosaify.core.util.logging.SarifLogger;
import dev.mosaify.guesswork.GuessworkCommon;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J)\u0010\u0011\u001a\u0011\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0015\u00a2\u0006\u0002\b\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J)\u0010\u0018\u001a\u0011\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0015\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J)\u0010\u001b\u001a\u0011\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0015\u00a2\u0006\u0002\b\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00120(2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0(2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020)0(2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u000f\u00104\u001a\b\u0012\u0004\u0012\u00020)0\u0012H\u0096\u0001J\t\u00105\u001a\u00020)H\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00067"}, d2={"Ldev/mosaify/core/parser/jfrog/xray/ParserJfrogXray;", "Ldev/mosaify/core/model/report/ReportParser;", "Ldev/mosaify/core/model/Named;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "guessworkCommon", "Ldev/mosaify/guesswork/GuessworkCommon;", "getGuessworkCommon", "()Ldev/mosaify/guesswork/GuessworkCommon;", "parseToOriginal", "", "originalReport", "", "originalToGeneric", "", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "extraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "sarifToGeneric", "run", "Ldev/mosaify/core/model/sarif/Run;", "xrayResultToGeneric", "xrayJsonResult", "Ldev/mosaify/core/parser/jfrog/xray/model/JfrogXrayJsonResult;", "xrayCvssInfo", "Ldev/mosaify/core/model/generic/CvssInfo;", "cves", "", "Ldev/mosaify/core/parser/jfrog/xray/model/Cve;", "xrayIsDisputed", "", "xrayVulnerability", "Ldev/mosaify/core/parser/jfrog/xray/model/Vulnerability;", "xrayPaths", "", "", "xrayComponents", "Ldev/mosaify/core/model/generic/Component;", "xrayIsUpgradable", "xrayDescription", "xrayCvesToGeneric", "xrayCves", "xraySeverityToGeneric", "Ldev/mosaify/core/model/generic/IssueSeverity;", "xraySeverity", "Ldev/mosaify/core/parser/jfrog/xray/model/Severity;", "getAllNames", "getName", "Companion", "mosaify-parser-jfrog-xray"})
@SourceDebugExtension(value={"SMAP\nParserJfrogXray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserJfrogXray.kt\ndev/mosaify/core/parser/jfrog/xray/ParserJfrogXray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,288:1\n1740#2,3:289\n1374#2:292\n1460#2,5:293\n1563#2:298\n1634#2,2:299\n1869#2:303\n774#2:304\n865#2,2:305\n1563#2:307\n1634#2,3:308\n1563#2:311\n1634#2,3:312\n827#2:315\n855#2,2:316\n1870#2:318\n1636#2:319\n1563#2:320\n1634#2,3:321\n1563#2:324\n1634#2,3:325\n1969#2,14:328\n1374#2:345\n1460#2,2:346\n1563#2:348\n1634#2,3:349\n1462#2,3:352\n1563#2:359\n1634#2,3:360\n1869#2,2:377\n1617#2,9:381\n1869#2:390\n1870#2:392\n1626#2:393\n1#3:301\n1#3:374\n1#3:391\n335#4:302\n126#5:342\n153#5,2:343\n155#5:355\n126#5:356\n153#5,2:357\n155#5:363\n136#5,9:364\n216#5:373\n217#5:375\n145#5:376\n216#5,2:379\n*S KotlinDebug\n*F\n+ 1 ParserJfrogXray.kt\ndev/mosaify/core/parser/jfrog/xray/ParserJfrogXray\n*L\n64#1:289,3\n65#1:292\n65#1:293,5\n69#1:298\n69#1:299,2\n110#1:303\n111#1:304\n111#1:305,2\n112#1:307\n112#1:308,3\n114#1:311\n114#1:312,3\n115#1:315\n115#1:316,2\n110#1:318\n69#1:319\n161#1:320\n161#1:321,3\n199#1:324\n199#1:325,3\n200#1:328,14\n214#1:345\n214#1:346,2\n215#1:348\n215#1:349,3\n214#1:352,3\n224#1:359\n224#1:360,3\n250#1:377,2\n277#1:381,9\n277#1:390\n277#1:392\n277#1:393\n238#1:374\n277#1:391\n74#1:302\n213#1:342\n213#1:343,2\n213#1:355\n221#1:356\n221#1:357,2\n221#1:363\n238#1:364,9\n238#1:373\n238#1:375\n238#1:376\n261#1:379,2\n*E\n"})
public final class ParserJfrogXray
implements ReportParser,
Named {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ Companion $$delegate_0;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final GuessworkCommon guessworkCommon;
    @NotNull
    private static final List<String> scannerNames;

    public ParserJfrogXray(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.$$delegate_0 = Companion;
        this.logger = logger;
        this.guessworkCommon = new GuessworkCommon(this.logger);
    }

    public /* synthetic */ ParserJfrogXray(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger("Parser for '" + Companion.getName() + "'");
        }
        this(kLogger);
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final GuessworkCommon getGuessworkCommon() {
        return this.guessworkCommon;
    }

    @NotNull
    public Object parseToOriginal(@NotNull byte[] originalReport) {
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        return CommonUtils.INSTANCE.getDefaultJson().decodeFromString((DeserializationStrategy)JfrogXrayJsonResultListSerializer.INSTANCE, StringsKt.decodeToString((byte[])originalReport));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Issue> originalToGeneric(@NotNull Object originalReport, @Nullable RunExtraInfo extraInfo) {
        void $this$flatMapTo$iv$iv;
        Object object;
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
            if (!(originalReport instanceof Collection)) throw new IllegalArgumentException("Supplied report is not recognized");
            Iterable $this$all$iv = (Iterable)originalReport;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                object = $this$all$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = object.next();
                    boolean bl2 = false;
                    if (it instanceof JfrogXrayJsonResult) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) throw new IllegalArgumentException("Supplied report is not recognized");
        Iterable $this$flatMap$iv = (Iterable)originalReport;
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl3 = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type dev.mosaify.core.parser.jfrog.xray.model.JfrogXrayJsonResult");
            Iterable list$iv$iv = this.xrayResultToGeneric((JfrogXrayJsonResult)it, extraInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Issue> sarifToGeneric(@NotNull Run run, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        block38: {
            block35: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)run, (String)"run");
                List list = run.getResults();
                if (list == null) break block35;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Collection collection2;
                    CvssInfo cvssInfo;
                    Set set;
                    Object object;
                    Set set2;
                    IssueType issueType;
                    Set locations;
                    Set fixVersions;
                    Object object2;
                    Set identifiers;
                    IssueSeverity severity;
                    Double cvssScore;
                    ReportingDescriptor sarifRule;
                    void sarifResult;
                    RunExtraInfo runExtraInfo;
                    Collection collection3;
                    block37: {
                        block36: {
                            Object object3;
                            Object $this$sarifToGeneric_u24lambda_u240_u247_u240;
                            Object row;
                            Object element$iv2;
                            Object object4;
                            Object version;
                            Object object5;
                            IssueSeverity issueSeverity;
                            JfrogXraySarifPropertyBag propertyBag;
                            Object object6;
                            JfrogXraySarifPropertyBag jfrogXraySarifPropertyBag;
                            JsonObject jsonObject;
                            ReportingDescriptor it;
                            Result result = (Result)item$iv$iv;
                            collection3 = destination$iv$iv;
                            boolean bl = false;
                            RunExtraInfo runExtraInfo2 = extraInfo;
                            if (runExtraInfo2 == null) {
                                runExtraInfo2 = RunExtraInfo.Companion.fromPropertyBag(run.getProperties());
                            }
                            runExtraInfo = runExtraInfo2;
                            Set set3 = run.getTool().getDriver().getRules();
                            if (set3 != null) {
                                Object v3;
                                block34: {
                                    Iterable iterable2 = set3;
                                    for (Object t : iterable2) {
                                        it = (ReportingDescriptor)t;
                                        boolean bl2 = false;
                                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)sarifResult.getRuleId())) continue;
                                        v3 = t;
                                        break block34;
                                    }
                                    v3 = null;
                                }
                                v4 = v3;
                            } else {
                                v4 = sarifRule = null;
                            }
                            if (sarifRule != null && (jsonObject = sarifRule.getProperties()) != null) {
                                void $this$decodeFromJsonElement$iv;
                                JsonObject it2 = jsonObject;
                                boolean bl3 = false;
                                it = CommonUtils.INSTANCE.getDefaultJson();
                                JsonElement json$iv = (JsonElement)it2;
                                boolean $i$f$decodeFromJsonElement = false;
                                $this$decodeFromJsonElement$iv.getSerializersModule();
                                jfrogXraySarifPropertyBag = (JfrogXraySarifPropertyBag)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.getNullable(JfrogXraySarifPropertyBag.Companion.serializer()), json$iv);
                            } else {
                                jfrogXraySarifPropertyBag = null;
                            }
                            Double d = cvssScore = (object6 = (propertyBag = jfrogXraySarifPropertyBag)) != null && (object6 = ((JfrogXraySarifPropertyBag)object6).getSecuritySeverity()) != null ? StringsKt.toDoubleOrNull((String)object6) : null;
                            if (d != null) {
                                double it3 = ((Number)d).doubleValue();
                                boolean bl4 = false;
                                issueSeverity = IssueSeverity.Companion.fromCvssScore(it3);
                            } else {
                                issueSeverity = null;
                            }
                            severity = issueSeverity;
                            Object[] bl3 = new String[4];
                            bl3[0] = sarifResult.getRuleId();
                            bl3[1] = sarifResult.getMessage().getText();
                            ReportingDescriptor reportingDescriptor = sarifRule;
                            bl3[2] = reportingDescriptor != null ? reportingDescriptor.getId() : null;
                            ReportingDescriptor reportingDescriptor2 = sarifRule;
                            bl3[3] = reportingDescriptor2 != null && (reportingDescriptor2 = reportingDescriptor2.getShortDescription()) != null ? Extensions.INSTANCE.getPlainText((MultiformatMessageString)reportingDescriptor2) : null;
                            identifiers = IssueTaxonomy.Companion.extractKnownIds$default((IssueTaxonomy.Companion)IssueTaxonomy.Companion, (Collection)CollectionsKt.listOfNotNull((Object[])bl3), (boolean)false, (int)2, null);
                            if (identifiers.isEmpty()) {
                                this.logger.error(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), ParserJfrogXray::sarifToGeneric$lambda$0$3);
                            }
                            if ((object5 = sarifRule) != null && (object5 = object5.getShortDescription()) != null && (object5 = object5.getText()) != null) {
                                Object description = object5;
                                boolean bl5 = false;
                                object2 = new String[]{" "};
                                List descriptionSplit = StringsKt.split$default((CharSequence)((CharSequence)description), (String[])object2, (boolean)false, (int)0, (int)6, null);
                                if (!(descriptionSplit.size() == 3)) {
                                    boolean $i$a$-require-ParserJfrogXray$sarifToGeneric$1$componentId$1$22 = false;
                                    String $i$a$-require-ParserJfrogXray$sarifToGeneric$1$componentId$1$22 = "Unexpected xray sarifRule.shortDescription";
                                    throw new IllegalArgumentException($i$a$-require-ParserJfrogXray$sarifToGeneric$1$componentId$1$22.toString());
                                }
                                String component = (String)descriptionSplit.get(1);
                                version = (String)descriptionSplit.get(2);
                                object4 = component + ":" + (String)version;
                            } else {
                                object4 = null;
                            }
                            Set componentId = object4;
                            fixVersions = new LinkedHashSet();
                            locations = new LinkedHashSet();
                            Object object7 = sarifRule;
                            if (object7 != null && (object7 = object7.getHelp()) != null && (object7 = object7.getMarkdown()) != null) {
                                void $this$forEach$iv;
                                Object helpMarkdown = object7;
                                boolean bl6 = false;
                                version = new String[]{"\n"};
                                version = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)((CharSequence)helpMarkdown), (String[])version, (boolean)false, (int)0, (int)6, null), (int)2);
                                boolean $i$f$forEach = false;
                                for (Object element$iv2 : $this$forEach$iv) {
                                    void $this$filterNotTo$iv$iv;
                                    void $this$filterNot$iv;
                                    String it4;
                                    void $this$mapTo$iv$iv2;
                                    Collection collection4;
                                    Object item$iv$iv22;
                                    void $this$mapTo$iv$iv3;
                                    void $this$map$iv2;
                                    String it5;
                                    void $this$filterTo$iv$iv;
                                    row = (String)element$iv2;
                                    boolean bl7 = false;
                                    String[] stringArray = new String[]{"|"};
                                    Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((CharSequence)row), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                                    boolean $i$f$filter = false;
                                    Iterable iterable3 = $this$filter$iv;
                                    Object destination$iv$iv2 = new ArrayList();
                                    boolean $i$f$filterTo = false;
                                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                        it5 = (String)element$iv$iv;
                                        boolean bl8 = false;
                                        boolean bl9 = !StringsKt.isBlank((CharSequence)it5);
                                        if (!bl9) continue;
                                        destination$iv$iv2.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv2;
                                    boolean $i$f$map2 = false;
                                    $this$filterTo$iv$iv = $this$map$iv2;
                                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                    boolean $i$f$mapTo22 = false;
                                    for (Object item$iv$iv22 : $this$mapTo$iv$iv3) {
                                        it5 = (String)item$iv$iv22;
                                        collection4 = destination$iv$iv2;
                                        boolean bl10 = false;
                                        collection4.add(((Object)StringsKt.trim((CharSequence)it5)).toString());
                                    }
                                    List list2 = (List)destination$iv$iv2;
                                    String location = (String)list2.get(1);
                                    String versions = (String)list2.get(2);
                                    destination$iv$iv2 = new char[2];
                                    destination$iv$iv2[0] = 96;
                                    destination$iv$iv2[1] = 32;
                                    String parsedLocation = StringsKt.trim((String)location, (char[])destination$iv$iv2);
                                    String[] $i$f$mapTo22 = new String[]{","};
                                    Iterable $this$map$iv3 = StringsKt.split$default((CharSequence)versions, (String[])$i$f$mapTo22, (boolean)false, (int)0, (int)6, null);
                                    boolean $i$f$map3 = false;
                                    item$iv$iv22 = $this$map$iv3;
                                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                    boolean $i$f$mapTo3 = false;
                                    for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                                        String string = (String)item$iv$iv3;
                                        collection4 = destination$iv$iv3;
                                        boolean bl11 = false;
                                        char[] cArray = new char[]{' ', '[', ']'};
                                        collection4.add(StringsKt.trim((String)it4, (char[])cArray));
                                    }
                                    $this$map$iv3 = (List)destination$iv$iv3;
                                    boolean $i$f$filterNot = false;
                                    $this$mapTo$iv$iv2 = $this$filterNot$iv;
                                    destination$iv$iv3 = new ArrayList();
                                    boolean $i$f$filterNotTo = false;
                                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                                        it4 = (String)element$iv$iv;
                                        boolean bl12 = false;
                                        if (StringsKt.contains((CharSequence)it4, (CharSequence)"No fix available", (boolean)true)) continue;
                                        destination$iv$iv3.add(element$iv$iv);
                                    }
                                    List parsedFixVersions = (List)destination$iv$iv3;
                                    ((Collection)locations).add(new IssueLocation(this.guessworkCommon.attemptRelativePath(parsedLocation, extraInfo), null, 2, null));
                                    fixVersions.addAll(parsedFixVersions);
                                }
                                v15 = Unit.INSTANCE;
                            } else {
                                v15 = null;
                            }
                            if (componentId == null && !((Collection)fixVersions).isEmpty()) {
                                this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), ParserJfrogXray::sarifToGeneric$lambda$0$6);
                            }
                            issueType = IssueType.COMPONENT_VULNERABILITY;
                            set2 = SetsKt.setOf((Object)this.getName());
                            Object object8 = sarifRule;
                            if (object8 == null || (object8 = object8.getHelp()) == null || (object8 = object8.getText()) == null) {
                                object8 = object = (String)CollectionsKt.first((Iterable)identifiers);
                            }
                            if ((set = componentId) == null) break block36;
                            Set it6 = set;
                            boolean bl13 = false;
                            element$iv2 = this;
                            row = it6;
                            try {
                                $this$sarifToGeneric_u24lambda_u240_u247_u240 = element$iv2;
                                boolean bl14 = false;
                                $this$sarifToGeneric_u24lambda_u240_u247_u240 = kotlin.Result.constructor-impl((Object)CommonUtils.INSTANCE.normalizePurl(Companion.componentToPurlString("generic:" + (String)((Object)it6))));
                            }
                            catch (Throwable throwable) {
                                $this$sarifToGeneric_u24lambda_u240_u247_u240 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            Object object9 = row;
                            element$iv2 = $this$sarifToGeneric_u24lambda_u240_u247_u240;
                            String string = (String)(kotlin.Result.isFailure-impl((Object)element$iv2) ? null : element$iv2);
                            element$iv2 = fixVersions;
                            if (element$iv2.isEmpty()) {
                                String string2 = string;
                                row = object9;
                                boolean bl15 = false;
                                Object var38_59 = null;
                                object9 = row;
                                string = string2;
                                object3 = var38_59;
                            } else {
                                object3 = element$iv2;
                            }
                            Set set4 = (Set)object3;
                            String string3 = string;
                            Set set5 = object9;
                            Set set6 = SetsKt.setOf((Object)new dev.mosaify.core.model.generic.Component((String)((Object)set5), string3, set4));
                            set = set6;
                            if (set6 != null) break block37;
                        }
                        set = SetsKt.emptySet();
                    }
                    object2 = set;
                    Double d = cvssScore;
                    if (d != null) {
                        double it = ((Number)d).doubleValue();
                        boolean bl = false;
                        cvssInfo = new CvssInfo(it, null, 2, null);
                    } else {
                        cvssInfo = null;
                    }
                    CvssInfo cvssInfo2 = cvssInfo;
                    Set set7 = ParserSarifGeneric.INSTANCE.getReferences((Result)sarifResult, sarifRule);
                    Set set8 = SetsKt.setOfNotNull((Object)(!((Collection)fixVersions).isEmpty() ? IssueFlag.FIXABLE : null));
                    RunExtraInfo runExtraInfo3 = runExtraInfo;
                    Collection collection5 = SetsKt.setOfNotNull((Object)(runExtraInfo3 != null ? runExtraInfo3.getTarget() : null));
                    if (collection5.isEmpty()) {
                        boolean bl = false;
                        collection2 = null;
                    } else {
                        collection2 = collection5;
                    }
                    Set set9 = (Set)collection2;
                    collection3.add(new Issue((String)object, set2, null, null, issueType, severity, cvssInfo2, set9, null, identifiers, set7, set8, locations, (Set)object2, null, 16652, null));
                }
                collection = (List)destination$iv$iv;
                break block38;
            }
            collection = ReportKt.getEMPTY_REPORT();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Issue> xrayResultToGeneric(@NotNull JfrogXrayJsonResult xrayJsonResult, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)xrayJsonResult, (String)"xrayJsonResult");
        List<Vulnerability> list = xrayJsonResult.getVulnerabilities();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection collection2;
                void it;
                Vulnerability vulnerability = (Vulnerability)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                IssueSeverity issueSeverity = this.xraySeverityToGeneric(it.getSeverity());
                String string = it.getSummary();
                Set set = SetsKt.setOf((Object)this.getName());
                IssueType issueType = IssueType.COMPONENT_VULNERABILITY;
                Set set2 = SetsKt.plus((Set)SetsKt.setOf((Object)it.getIssueId()), (Iterable)this.xrayCvesToGeneric(it.getCves()));
                CvssInfo cvssInfo = this.xrayCvssInfo(it.getCves());
                String string2 = this.xrayDescription((Vulnerability)it);
                Collection<String> collection4 = it.getReferences();
                if (collection4 == null || (collection4 = CollectionsKt.toSet((Iterable)collection4)) == null) {
                    collection4 = SetsKt.emptySet();
                }
                Collection<String> collection5 = collection4;
                Set<dev.mosaify.core.model.generic.Component> set3 = this.xrayComponents((Vulnerability)it);
                Object object = new IssueFlag[]{this.xrayIsUpgradable((Vulnerability)it) ? IssueFlag.FIXABLE : null, this.xrayIsDisputed((Vulnerability)it) ? IssueFlag.DISPUTED : null};
                Set set4 = SetsKt.setOfNotNull((Object[])object);
                object = this.xrayPaths((Vulnerability)it);
                RunExtraInfo runExtraInfo = extraInfo;
                Collection collection6 = SetsKt.setOfNotNull((Object)(runExtraInfo != null ? runExtraInfo.getTarget() : null));
                if (collection6.isEmpty()) {
                    boolean bl2 = false;
                    collection2 = null;
                } else {
                    collection2 = collection6;
                }
                Set set5 = (Set)collection2;
                collection3.add(new Issue(string, set, null, string2, issueType, issueSeverity, cvssInfo, set5, null, set2, collection5, set4, null, set3, (Set)object, 4356, null));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = ReportKt.getEMPTY_REPORT();
        }
        return collection;
    }

    public static /* synthetic */ Collection xrayResultToGeneric$default(ParserJfrogXray parserJfrogXray, JfrogXrayJsonResult jfrogXrayJsonResult, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return parserJfrogXray.xrayResultToGeneric(jfrogXrayJsonResult, runExtraInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final CvssInfo xrayCvssInfo(List<Cve> cves) {
        CvssInfo cvssInfo;
        Object t;
        void $this$mapTo$iv$iv;
        if (cves == null) {
            return null;
        }
        Iterable $this$map$iv = cves;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Cve cve = (Cve)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getCvssV3Score();
            if (d == null) {
                d = it.getCvssV2Score();
            }
            if ((string = it.getCvssV3Vector()) == null) {
                string = it.getCvssV2Vector();
            }
            collection.add(TuplesKt.to((Object)d, (Object)string));
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            Pair it = (Pair)maxElem$iv;
            boolean bl = false;
            Double d = (Double)it.getFirst();
            double maxValue$iv = d != null ? d : 0.0;
            do {
                double v$iv;
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                $i$a$-maxByOrThrow-ParserJfrogXray$xrayCvssInfo$maxScoreCvssInfo$2 = false;
                Double d2 = (Double)it2.getFirst();
                double d3 = v$iv = d2 != null ? d2 : 0.0;
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        Pair maxScoreCvssInfo = (Pair)t;
        if (maxScoreCvssInfo.getFirst() != null) {
            Object object = maxScoreCvssInfo.getFirst();
            Intrinsics.checkNotNull((Object)object);
            cvssInfo = new CvssInfo(((Number)object).doubleValue(), (String)maxScoreCvssInfo.getSecond());
        } else {
            cvssInfo = null;
        }
        return cvssInfo;
    }

    private final boolean xrayIsDisputed(Vulnerability xrayVulnerability) {
        return StringsKt.startsWith((String)xrayVulnerability.getSummary(), (String)"** DISPUTED **", (boolean)true) || StringsKt.startsWith((String)xrayVulnerability.getSummary(), (String)"**DISPUTED**", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Collection<String>> xrayPaths(Vulnerability xrayVulnerability) {
        void $this$mapTo$iv$iv;
        Map<String, Component> $this$map$iv = xrayVulnerability.getComponents();
        boolean $i$f$map = false;
        Map<String, Component> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv;
            void component;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv = ((Component)component.getValue()).getImpactPaths();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                List path = (List)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv2 = path;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    ImpactPath impactPath = (ImpactPath)item$iv$iv2;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl3 = false;
                    collection2.add(it.getComponentId());
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            collection.add((List)destination$iv$iv2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Unable to fully structure code
     */
    private final Set<dev.mosaify.core.model.generic.Component> xrayComponents(Vulnerability xrayVulnerability) {
        $this$map$iv = xrayVulnerability.getComponents();
        $i$f$map = false;
        var4_4 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
        $i$f$mapTo = false;
        var7_7 = $this$mapTo$iv$iv.entrySet().iterator();
        while (var7_7.hasNext()) {
            var9_9 = item$iv$iv = var7_7.next();
            var26_30 = destination$iv$iv;
            $i$a$-map-ParserJfrogXray$xrayComponents$1 = false;
            var11_11 = ((Component)component.getValue()).getFixedVersions();
            if (var11_11 == null) ** GOTO lbl-1000
            var12_12 = var11_11;
            $i$f$map = false;
            var14_17 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_23 = (String)item$iv$iv;
                var20_24 = destination$iv$iv;
                $i$a$-map-ParserJfrogXray$xrayComponents$1$fixVersions$1 = false;
                var22_26 = new char[]{'[', ']'};
                var20_24.add(StringsKt.trim((String)it, (char[])var22_26));
            }
            $this$map$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if ($this$map$iv != null) {
                var13_16 = $this$map$iv;
                if (var13_16.isEmpty()) {
                    $i$a$-ifEmpty-ParserJfrogXray$xrayComponents$1$fixVersions$2 = false;
                    v0 = null;
                } else {
                    v0 = var13_16;
                }
                v1 = (Set)v0;
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            fixVersions = v1;
            var11_11 = this;
            var25_29 = (String)component.getKey();
            try {
                $this$xrayComponents_u24lambda_u240_u242 = (ParserJfrogXray)var11_11;
                $i$a$-runCatching-ParserJfrogXray$xrayComponents$1$1 = false;
                var23_27 = kotlin.Result.constructor-impl((Object)CommonUtils.INSTANCE.normalizePurl(ParserJfrogXray.Companion.componentToPurlString((String)component.getKey())));
            }
            catch (Throwable var12_14) {
                var23_27 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var12_14));
            }
            var11_11 = var23_27;
            var27_31 = fixVersions;
            var28_32 = (String)(kotlin.Result.isFailure-impl((Object)var11_11) != false ? null : var11_11);
            var29_33 = var25_29;
            var26_30.add(new dev.mosaify.core.model.generic.Component(var29_33, var28_32, var27_31));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean xrayIsUpgradable(Vulnerability xrayVulnerability) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, Component> $this$mapNotNull$iv = xrayVulnerability.getComponents();
        boolean $i$f$mapNotNull = false;
        Map<String, Component> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Boolean it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            List<String> list = ((Component)it.getValue()).getFixedVersions();
            if ((list != null ? Boolean.valueOf(!((Collection)list).isEmpty()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ((List)destination$iv$iv).contains(true);
    }

    private final String xrayDescription(Vulnerability xrayVulnerability) {
        Object object;
        Iterator<Object> iterator;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object object2;
        Object object3;
        Object it;
        Object description = null;
        Object object4 = xrayVulnerability.getExtendedInformation();
        if (object4 == null || (object4 = ((ExtendedInformation)object4).getShortDescription()) == null) {
            object4 = xrayVulnerability.getSummary();
        }
        description = object4;
        ExtendedInformation extendedInformation = xrayVulnerability.getExtendedInformation();
        List<String> references = xrayVulnerability.getReferences();
        Object object5 = extendedInformation;
        if (object5 != null && (object5 = ((ExtendedInformation)object5).getFullDescription()) != null) {
            it = object5;
            boolean bl = false;
            description = description + "\n\nFull description:\n" + (String)it;
        }
        if ((object3 = extendedInformation) != null && (object3 = ((ExtendedInformation)object3).getRemediation()) != null) {
            it = object3;
            boolean bl = false;
            description = description + "\n\nRemediation:\n" + (String)it;
        }
        boolean bl = (object2 = extendedInformation) != null && (object2 = ((ExtendedInformation)object2).getJfrogResearchSeverityReasons()) != null ? !((Collection)object2).isEmpty() : false;
        if (bl) {
            description = description + "\n\nJFrog Research:";
            $this$forEach$iv = extendedInformation.getJfrogResearchSeverityReasons();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                JfrogResearchSeverityReason it2 = (JfrogResearchSeverityReason)element$iv;
                boolean bl2 = false;
                description = description + "\n- " + Intrinsics.areEqual((Object)it2.isPositive(), (Object)true) + ": " + it2.getName();
                if (it2.getDescription() == null) continue;
                description = description + "\n\n    " + it2.getDescription() + "\n";
            }
        }
        if ((object = xrayVulnerability.getExtendedInformation()) != null && (object = ((ExtendedInformation)object).getJfrogResearchSeverity()) != null) {
            Object it3 = object;
            boolean bl3 = false;
            description = description + "\n\nJFrog Research Severity: " + (String)it3;
        }
        if (!xrayVulnerability.getComponents().isEmpty()) {
            description = description + "\n\nComponents:";
            $this$forEach$iv = xrayVulnerability.getComponents();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object6;
                Map.Entry element$iv;
                Map.Entry it4 = element$iv = (Map.Entry)iterator.next();
                boolean bl4 = false;
                Object k = it4.getKey();
                List<String> list = ((Component)it4.getValue()).getFixedVersions();
                boolean bl5 = list != null ? !((Collection)list).isEmpty() : false;
                if (bl5) {
                    List<String> list2 = ((Component)it4.getValue()).getFixedVersions();
                    Intrinsics.checkNotNull(list2);
                    object6 = "fix versions: " + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                } else {
                    object6 = "no fix versions";
                }
                description = description + "\n- " + k + " - " + (String)object6;
            }
        }
        List<String> list = references;
        boolean bl6 = list != null ? !((Collection)list).isEmpty() : false;
        if (bl6) {
            description = description + "\n\nReferences:\n" + CollectionsKt.joinToString$default((Iterable)references, (CharSequence)"\n", null, null, (int)0, null, ParserJfrogXray::xrayDescription$lambda$5, (int)30, null);
        }
        return description;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> xrayCvesToGeneric(List<Cve> xrayCves) {
        Collection<Cve> collection;
        block4: {
            block3: {
                void $this$mapNotNullTo$iv$iv;
                collection = xrayCves;
                if (collection == null) break block3;
                Iterable $this$mapNotNull$iv = collection;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Cve it = (Cve)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getCve() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (collection != null) break block4;
            }
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    private final IssueSeverity xraySeverityToGeneric(Severity xraySeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[xraySeverity.ordinal()]) {
            case 1 -> IssueSeverity.CRITICAL;
            case 2 -> IssueSeverity.HIGH;
            case 3 -> IssueSeverity.MEDIUM;
            case 4 -> IssueSeverity.LOW;
            case 5 -> IssueSeverity.LOW;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getName() {
        return this.$$delegate_0.getName();
    }

    @NotNull
    public Collection<String> getAllNames() {
        return this.$$delegate_0.getAllNames();
    }

    private static final Object sarifToGeneric$lambda$0$3() {
        return "Unexpected: could not find any identifiers in Xray SARIF report.";
    }

    private static final Object sarifToGeneric$lambda$0$6() {
        return "Component Id is null, but there are fix versions present.";
    }

    private static final CharSequence xrayDescription$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it;
    }

    public ParserJfrogXray() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"JFrog Xray", "JFrog Xray SCA", "JFrog Xray Scanner"};
        scannerNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Ldev/mosaify/core/parser/jfrog/xray/ParserJfrogXray$Companion;", "Ldev/mosaify/core/model/Named;", "<init>", "()V", "scannerNames", "", "", "getScannerNames", "()Ljava/util/List;", "getName", "getAllNames", "componentToPurlString", "componentKey", "mosaify-parser-jfrog-xray"})
    @SourceDebugExtension(value={"SMAP\nParserJfrogXray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserJfrogXray.kt\ndev/mosaify/core/parser/jfrog/xray/ParserJfrogXray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,288:1\n1#2:289\n827#3:290\n855#3:291\n856#3:294\n1069#4,2:292\n*S KotlinDebug\n*F\n+ 1 ParserJfrogXray.kt\ndev/mosaify/core/parser/jfrog/xray/ParserJfrogXray$Companion\n*L\n50#1:290\n50#1:291\n50#1:294\n50#1:292,2\n*E\n"})
    public static final class Companion
    implements Named {
        private Companion() {
        }

        @NotNull
        public final List<String> getScannerNames() {
            return scannerNames;
        }

        @NotNull
        public String getName() {
            return (String)CollectionsKt.first(this.getScannerNames());
        }

        @NotNull
        public List<String> getAllNames() {
            return this.getScannerNames();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String componentToPurlString(@NotNull String componentKey) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Intrinsics.checkNotNullParameter((Object)componentKey, (String)"componentKey");
            char[] cArray = new char[]{':'};
            List split = StringsKt.split$default((CharSequence)componentKey, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (!(split.size() > 2)) {
                boolean $i$a$-require-ParserJfrogXray$Companion$componentToPurlString$22 = false;
                String $i$a$-require-ParserJfrogXray$Companion$componentToPurlString$22 = "Xray returned short component_id: " + Companion;
                throw new IllegalArgumentException($i$a$-require-ParserJfrogXray$Companion$componentToPurlString$22.toString());
            }
            String type = (String)CollectionsKt.first((List)split);
            String version = (String)CollectionsKt.last((List)split);
            Object object = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)split, (int)1), (int)1);
            boolean $i$f$filterNot = false;
            void var8_9 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl;
                block3: {
                    String string = (String)element$iv$iv;
                    boolean bl2 = false;
                    CharSequence $this$all$iv = string;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char c = element$iv = $this$all$iv.charAt(i);
                        boolean bl3 = false;
                        if (Character.isDigit(c)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = new char[1];
            object[0] = 47;
            String nameWithNameSpace = StringsKt.trimStart((String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), (char[])object);
            return "pkg:" + type + "/" + nameWithNameSpace + "@" + version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.LOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

