/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.compress;

import dev.mosaify.core.util.compress.CompressUtils;
import dev.mosaify.core.util.platform.PlatformUtils;
import dev.mosaify.core.util.platform.TempPath;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\tH\u0000\u00a8\u0006\u0017"}, d2={"compressAndEncodeImpl", "", "contents", "", "decodeAndDecompressImpl", "compressedEncoded", "compressDirectoryImpl", "Ldev/mosaify/core/util/platform/TempPath;", "directory", "Lkotlinx/io/files/Path;", "unpackZipStream", "", "zipStream", "Ljava/io/InputStream;", "destinationDir", "unpackTgzStream", "tgzStream", "unZipToImpl", "zipFile", "unTgzToImpl", "tgzFile", "readGzTextImpl", "gzFile", "mosaify-util-compress"})
@SourceDebugExtension(value={"SMAP\nCompressUtils.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressUtils.jvm.kt\ndev/mosaify/core/util/compress/CompressUtils_jvmKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1321#2:143\n1322#2:145\n1#3:144\n*S KotlinDebug\n*F\n+ 1 CompressUtils.jvm.kt\ndev/mosaify/core/util/compress/CompressUtils_jvmKt\n*L\n48#1:143\n48#1:145\n*E\n"})
public final class CompressUtils_jvmKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String compressAndEncodeImpl(@NotNull byte[] contents) {
        String string;
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Closeable closeable = (Closeable)new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorOutputStream((OutputStream)byteArrayOutputStream);
            Throwable throwable2 = null;
            try {
                GzipCompressorOutputStream gzipCompressorOutputStream = (GzipCompressorOutputStream)closeable2;
                boolean bl2 = false;
                gzipCompressorOutputStream.write(contents);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string2 = new Base64().encodeToString(byteArrayOutputStream.toByteArray());
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] decodeAndDecompressImpl(@NotNull String compressedEncoded) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)compressedEncoded, (String)"compressedEncoded");
        byte[] byArray2 = new Base64().decode(compressedEncoded);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
        Object object = byArray2;
        object = (Closeable)new GzipCompressorInputStream((InputStream)new ByteArrayInputStream((byte[])object));
        Throwable throwable = null;
        try {
            GzipCompressorInputStream gzipCompressorInputStream = (GzipCompressorInputStream)object;
            boolean bl = false;
            byArray = gzipCompressorInputStream.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TempPath compressDirectoryImpl(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        TempPath tempFile = new TempPath(null, ".tgz", false, 5, null);
        File sourceDirectory = new File(FileSystemJvmKt.SystemFileSystem.resolve(directory).toString());
        Closeable closeable = SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)tempFile.getPath(), (boolean)false, (int)2, null)));
        Throwable throwable = null;
        try {
            OutputStream outputStream = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorOutputStream(outputStream);
            Throwable throwable2 = null;
            try {
                GzipCompressorOutputStream gzipCompressorOutputStream = (GzipCompressorOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = (Closeable)new TarArchiveOutputStream((OutputStream)gzipCompressorOutputStream);
                Throwable throwable3 = null;
                try {
                    TarArchiveOutputStream tarArchiveOutputStream = (TarArchiveOutputStream)closeable3;
                    boolean bl3 = false;
                    tarArchiveOutputStream.setLongFileMode(3);
                    Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)((Sequence)FilesKt.walk$default((File)sourceDirectory, null, (int)1, null)), arg_0 -> CompressUtils_jvmKt.compressDirectoryImpl$lambda$0$0$0$0(sourceDirectory, arg_0));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File file = (File)element$iv;
                        boolean bl4 = false;
                        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(file, FilesKt.toRelativeString((File)file, (File)sourceDirectory));
                        if (file.canExecute()) {
                            tarArchiveEntry.setMode(33261);
                        }
                        CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.compressDirectoryImpl$lambda$0$0$0$1$0(tarArchiveEntry));
                        tarArchiveOutputStream.putArchiveEntry(tarArchiveEntry);
                        if (tarArchiveEntry.isFile()) {
                            Closeable closeable4 = new FileInputStream(file);
                            Throwable throwable4 = null;
                            try {
                                FileInputStream it = (FileInputStream)closeable4;
                                boolean bl5 = false;
                                Long l = it.transferTo((OutputStream)tarArchiveOutputStream);
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                            }
                        } else {
                            CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.compressDirectoryImpl$lambda$0$0$0$1$2(tarArchiveEntry));
                        }
                        tarArchiveOutputStream.closeArchiveEntry();
                    }
                    CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(CompressUtils_jvmKt::compressDirectoryImpl$lambda$0$0$0$2);
                    tarArchiveOutputStream.finish();
                    CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.compressDirectoryImpl$lambda$0$0$0$3(tarArchiveOutputStream));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.compressDirectoryImpl$lambda$0$1(tempFile));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpackZipStream(@NotNull InputStream zipStream, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)zipStream, (String)"zipStream");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Closeable closeable = (Closeable)new ZipArchiveInputStream(zipStream);
        Throwable throwable = null;
        try {
            ZipArchiveEntry entry;
            ZipArchiveInputStream zipArchiveInputStream = (ZipArchiveInputStream)closeable;
            boolean bl = false;
            do {
                Object it;
                if ((entry = zipArchiveInputStream.getNextEntry()) == null) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String targetFileName = PlatformUtils.INSTANCE.fixFileName(string);
                if (!Intrinsics.areEqual((Object)entry.getName(), (Object)targetFileName)) {
                    CompressUtils.INSTANCE.getLogger$mosaify_util_compress().warn(() -> CompressUtils_jvmKt.unpackZipStream$lambda$0$0(entry, targetFileName));
                }
                Object object = new String[1];
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                object[0] = PlatformUtils.INSTANCE.fixFileName(string2);
                Path outputPath = PathsKt.Path((Path)destinationDir, (String[])object);
                CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.unpackZipStream$lambda$0$1(entry, outputPath));
                if (entry.isDirectory()) {
                    FileSystem.createDirectories$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)outputPath, (boolean)false, (int)2, null);
                    continue;
                }
                Path path = outputPath.getParent();
                if (path != null) {
                    it = path;
                    boolean bl2 = false;
                    FileSystem.createDirectories$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)it, (boolean)false, (int)2, null);
                }
                CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.unpackZipStream$lambda$0$3(outputPath));
                object = SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)outputPath, (boolean)false, (int)2, null)));
                Throwable throwable2 = null;
                try {
                    it = (OutputStream)object;
                    boolean bl3 = false;
                    Long l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)zipArchiveInputStream), (OutputStream)it, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            } while (entry != null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unpackTgzStream(@NotNull InputStream tgzStream, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)tgzStream, (String)"tgzStream");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Closeable closeable = (Closeable)new GzipCompressorInputStream(tgzStream);
        Throwable throwable = null;
        try {
            GzipCompressorInputStream gzipCompressorInputStream = (GzipCompressorInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveInputStream((InputStream)gzipCompressorInputStream);
            Throwable throwable2 = null;
            try {
                TarArchiveEntry entry;
                TarArchiveInputStream tarArchiveInputStream = (TarArchiveInputStream)closeable2;
                boolean bl2 = false;
                do {
                    Object it;
                    if ((entry = tarArchiveInputStream.getNextEntry()) == null) continue;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String targetFileName = PlatformUtils.INSTANCE.fixFileName(string);
                    if (!Intrinsics.areEqual((Object)entry.getName(), (Object)targetFileName)) {
                        CompressUtils.INSTANCE.getLogger$mosaify_util_compress().warn(() -> CompressUtils_jvmKt.unpackTgzStream$lambda$0$0$0(entry, targetFileName));
                    }
                    Object object = new String[1];
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    object[0] = PlatformUtils.INSTANCE.fixFileName(string2);
                    Path outputPath = PathsKt.Path((Path)destinationDir, (String[])object);
                    CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.unpackTgzStream$lambda$0$0$1(entry, outputPath));
                    if (entry.isDirectory()) {
                        FileSystem.createDirectories$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)outputPath, (boolean)false, (int)2, null);
                        continue;
                    }
                    Path path = outputPath.getParent();
                    if (path != null) {
                        it = path;
                        boolean bl3 = false;
                        FileSystem.createDirectories$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)it, (boolean)false, (int)2, null);
                    }
                    CompressUtils.INSTANCE.getLogger$mosaify_util_compress().trace(() -> CompressUtils_jvmKt.unpackTgzStream$lambda$0$0$3(outputPath));
                    object = SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)outputPath, (boolean)false, (int)2, null)));
                    Throwable throwable3 = null;
                    try {
                        it = (OutputStream)object;
                        boolean bl4 = false;
                        Long l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)tarArchiveInputStream), (OutputStream)it, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                    }
                } while (entry != null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unZipToImpl(@NotNull Path zipFile, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Closeable closeable = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(zipFile)));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            CompressUtils_jvmKt.unpackZipStream(it, destinationDir);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unTgzToImpl(@NotNull Path tgzFile, @NotNull Path destinationDir) {
        Intrinsics.checkNotNullParameter((Object)tgzFile, (String)"tgzFile");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Closeable closeable = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(tgzFile)));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            CompressUtils_jvmKt.unpackTgzStream(it, destinationDir);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String readGzTextImpl(@NotNull Path gzFile) {
        Intrinsics.checkNotNullParameter((Object)gzFile, (String)"gzFile");
        Closeable closeable = SourcesJvmKt.asInputStream((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(gzFile)));
        Throwable throwable = null;
        try {
            String string;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorInputStream(inputStream);
            Throwable throwable2 = null;
            try {
                GzipCompressorInputStream gzipCompressorInputStream = (GzipCompressorInputStream)closeable2;
                boolean bl2 = false;
                byte[] byArray = gzipCompressorInputStream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                string = StringsKt.decodeToString((byte[])byArray);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            String string2 = string;
            return string2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final boolean compressDirectoryImpl$lambda$0$0$0$0(File $sourceDirectory, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$sourceDirectory);
    }

    private static final Object compressDirectoryImpl$lambda$0$0$0$1$0(TarArchiveEntry $tarArchiveEntry) {
        return "Adding to tar: '" + $tarArchiveEntry.getName() + "'";
    }

    private static final Object compressDirectoryImpl$lambda$0$0$0$1$2(TarArchiveEntry $tarArchiveEntry) {
        return "'" + $tarArchiveEntry.getName() + "' is not a file";
    }

    private static final Object compressDirectoryImpl$lambda$0$0$0$2() {
        return "Finishing the archive stream";
    }

    private static final Object compressDirectoryImpl$lambda$0$0$0$3(TarArchiveOutputStream $tarArchiveOutputStream) {
        return "Archive stream bytes written: " + $tarArchiveOutputStream.getBytesWritten();
    }

    private static final Object compressDirectoryImpl$lambda$0$1(TempPath $tempFile) {
        return "Archive created as '" + $tempFile + "'";
    }

    private static final Object unpackZipStream$lambda$0$0(ZipArchiveEntry $entry, String $targetFileName) {
        return "Renamed '" + $entry.getName() + "' -> '" + $targetFileName + "' when unpacking to ensure filesystem compatibility";
    }

    private static final Object unpackZipStream$lambda$0$1(ZipArchiveEntry $entry, Path $outputPath) {
        return "Got '" + $entry.getName() + "' -> " + $outputPath + " (" + ($entry.isDirectory() ? "dir" : "file") + ")";
    }

    private static final Object unpackZipStream$lambda$0$3(Path $outputPath) {
        return "Writing '" + $outputPath + "'...";
    }

    private static final Object unpackTgzStream$lambda$0$0$0(TarArchiveEntry $entry, String $targetFileName) {
        return "Renamed '" + $entry.getName() + "' -> '" + $targetFileName + "' when unpacking to ensure filesystem compatibility";
    }

    private static final Object unpackTgzStream$lambda$0$0$1(TarArchiveEntry $entry, Path $outputPath) {
        return "Got '" + $entry.getName() + "' -> " + $outputPath + " (" + ($entry.isDirectory() ? "dir" : "file") + ")";
    }

    private static final Object unpackTgzStream$lambda$0$0$3(Path $outputPath) {
        return "Writing '" + $outputPath + "'...";
    }
}

