/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.compress;

import dev.mosaify.core.model.sarif.Artifact;
import dev.mosaify.core.model.sarif.ArtifactContent;
import dev.mosaify.core.model.sarif.ArtifactRoles;
import dev.mosaify.core.model.sarif.Message;
import dev.mosaify.core.model.taxonomy.Format;
import dev.mosaify.core.util.compress.CompressUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\b*\u00020\u0006J>\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/mosaify/core/util/compress/Extensions;", "", "<init>", "()V", "decompress", "", "Ldev/mosaify/core/model/sarif/Artifact;", "decompressText", "", "fromBytes", "Ldev/mosaify/core/model/sarif/Artifact$Companion;", "contents", "format", "Ldev/mosaify/core/model/taxonomy/Format;", "description", "roles", "", "Ldev/mosaify/core/model/sarif/ArtifactRoles;", "mosaify-util-compress"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ndev/mosaify/core/util/compress/Extensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();

    private Extensions() {
    }

    @NotNull
    public final byte[] decompress(@NotNull Artifact $this$decompress) {
        String binaryContents;
        Intrinsics.checkNotNullParameter((Object)$this$decompress, (String)"<this>");
        ArtifactContent artifactContent = $this$decompress.getContents();
        String string = binaryContents = artifactContent != null ? artifactContent.getBinary() : null;
        if (!Intrinsics.areEqual((Object)$this$decompress.getMimeType(), (Object)"application/gzip")) {
            boolean $i$a$-require-Extensions$decompress$32 = false;
            String $i$a$-require-Extensions$decompress$32 = "Artifact must be GZIP encoded";
            throw new IllegalArgumentException($i$a$-require-Extensions$decompress$32.toString());
        }
        if (!(binaryContents != null)) {
            boolean bl = false;
            String string2 = "Artifact contents must be stored in the 'binary' field";
            throw new IllegalArgumentException(string2.toString());
        }
        return CompressUtils.INSTANCE.decodeAndDecompress(binaryContents);
    }

    @NotNull
    public final String decompressText(@NotNull Artifact $this$decompressText) {
        Intrinsics.checkNotNullParameter((Object)$this$decompressText, (String)"<this>");
        return StringsKt.decodeToString((byte[])this.decompress($this$decompressText));
    }

    @Nullable
    public final Artifact fromBytes(@NotNull Artifact.Companion $this$fromBytes, @NotNull byte[] contents, @Nullable Format format, @Nullable String description, @Nullable Set<? extends ArtifactRoles> roles) {
        Artifact artifact;
        Intrinsics.checkNotNullParameter((Object)$this$fromBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (dev.mosaify.core.util.Extensions.INSTANCE.isBlank(contents)) {
            artifact = null;
        } else {
            Message message;
            Format format2 = format;
            String string = format2 != null ? format2.name() : null;
            ArtifactContent artifactContent = new ArtifactContent(null, CompressUtils.INSTANCE.compressAndEncode(contents), null, null, 13, null);
            String string2 = description;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                message = new Message(description, null, null, null, null, 30, null);
            } else {
                message = null;
            }
            Message message2 = message;
            artifact = new Artifact(message2, null, null, null, null, roles, "application/gzip", artifactContent, null, string, null, null, null, 7454, null);
        }
        return artifact;
    }

    public static /* synthetic */ Artifact fromBytes$default(Extensions extensions, Artifact.Companion companion, byte[] byArray, Format format, String string, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            format = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return extensions.fromBytes(companion, byArray, format, string, set);
    }
}

