/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.normalization;

import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueFlag;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\f\u001a\u00020\r*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/mosaify/core/util/normalization/Extensions;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "preProcessed", "", "Ldev/mosaify/core/model/generic/Issue;", "sortedByScannerIdRank", "sortedByDetections", "sortedBySeverity", "getTaxonomyRank", "", "scannerOnly", "", "mosaify-util-normalization"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ndev/mosaify/core/util/normalization/Extensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1#2:56\n1761#3,3:57\n1068#3:60\n774#3:61\n865#3,2:62\n774#3:64\n865#3,2:65\n2423#3,14:67\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ndev/mosaify/core/util/normalization/Extensions\n*L\n16#1:57,3\n31#1:60\n50#1:61\n50#1:62,2\n51#1:64\n51#1:65,2\n52#1:67,14\n*E\n"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(Extensions::logger$lambda$0);

    private Extensions() {
    }

    @NotNull
    public final Collection<Issue> preProcessed(@NotNull Collection<Issue> $this$preProcessed) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$preProcessed, (String)"<this>");
            if (!(!$this$preProcessed.isEmpty())) {
                boolean $i$a$-require-Extensions$preProcessed$22 = false;
                String $i$a$-require-Extensions$preProcessed$22 = "Cannot normalize an empty issue list.";
                throw new IllegalArgumentException($i$a$-require-Extensions$preProcessed$22.toString());
            }
            Iterable $this$any$iv = $this$preProcessed;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Issue it = (Issue)element$iv;
                    boolean bl2 = false;
                    if (!it.getFlags().contains(IssueFlag.NORMALIZED)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            logger.warn(Extensions::preProcessed$lambda$2);
        }
        return this.sortedByScannerIdRank(this.sortedBySeverity($this$preProcessed));
    }

    @NotNull
    public final Collection<Issue> sortedByScannerIdRank(@NotNull Collection<Issue> $this$sortedByScannerIdRank) {
        Intrinsics.checkNotNullParameter($this$sortedByScannerIdRank, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)$this$sortedByScannerIdRank, (arg_0, arg_1) -> Extensions.sortedByScannerIdRank$lambda$1(Extensions::sortedByScannerIdRank$lambda$0, arg_0, arg_1));
    }

    @NotNull
    public final Collection<Issue> sortedByDetections(@NotNull Collection<Issue> $this$sortedByDetections) {
        Intrinsics.checkNotNullParameter($this$sortedByDetections, (String)"<this>");
        Iterable $this$sortedByDescending$iv = $this$sortedByDetections;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Issue it = (Issue)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getDetectedBy().size());
                it = (Issue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDetectedBy().size()));
            }
        });
    }

    @NotNull
    public final Collection<Issue> sortedBySeverity(@NotNull Collection<Issue> $this$sortedBySeverity) {
        Intrinsics.checkNotNullParameter($this$sortedBySeverity, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)$this$sortedBySeverity, (arg_0, arg_1) -> Extensions.sortedBySeverity$lambda$1(Extensions::sortedBySeverity$lambda$0, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public final int getTaxonomyRank(@NotNull Issue $this$getTaxonomyRank, boolean scannerOnly) {
        Object v0;
        void $this$minByOrNull$iv;
        IssueTaxonomy it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getTaxonomyRank, (String)"<this>");
        Iterable iterable = IssueTaxonomy.Companion.fromIssueId$default((IssueTaxonomy.Companion)IssueTaxonomy.Companion, (Collection)$this$getTaxonomyRank.getIdentifiers(), (boolean)false, (int)2, null).values();
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IssueTaxonomy)element$iv$iv;
            boolean bl = false;
            if (!(!scannerOnly || it.isScanner())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IssueTaxonomy)element$iv$iv;
            boolean bl = false;
            if (!(it.getRank() >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                IssueTaxonomy it2 = (IssueTaxonomy)minElem$iv;
                boolean bl = false;
                int minValue$iv = it2.getRank();
                do {
                    Object e$iv = iterator$iv.next();
                    IssueTaxonomy it3 = (IssueTaxonomy)e$iv;
                    $i$a$-minByOrNull-Extensions$getTaxonomyRank$3 = false;
                    int v$iv = it3.getRank();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        IssueTaxonomy issueTaxonomy = v0;
        return issueTaxonomy != null ? issueTaxonomy.getRank() : Integer.MAX_VALUE;
    }

    public static /* synthetic */ int getTaxonomyRank$default(Extensions extensions, Issue issue, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return extensions.getTaxonomyRank(issue, bl);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object preProcessed$lambda$2() {
        return "Processing issues that were previously normalized.";
    }

    private static final int sortedByScannerIdRank$lambda$0(Issue first, Issue second) {
        Intrinsics.checkNotNull((Object)first);
        int n = INSTANCE.getTaxonomyRank(first, true);
        Intrinsics.checkNotNull((Object)second);
        return Intrinsics.compare((int)n, (int)INSTANCE.getTaxonomyRank(second, true));
    }

    private static final int sortedByScannerIdRank$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int sortedBySeverity$lambda$0(Issue first, Issue second) {
        double d;
        double d2;
        IssueSeverity issueSeverity = first.getSeverity();
        if (issueSeverity != null) {
            d2 = issueSeverity.toCvssScore();
        } else {
            CvssInfo cvssInfo = first.getCvssInfo();
            d2 = cvssInfo != null ? cvssInfo.getCvssScore() : 0.0;
        }
        double firstCriticality = d2;
        IssueSeverity issueSeverity2 = second.getSeverity();
        if (issueSeverity2 != null) {
            d = issueSeverity2.toCvssScore();
        } else {
            CvssInfo cvssInfo = second.getCvssInfo();
            d = cvssInfo != null ? cvssInfo.getCvssScore() : 0.0;
        }
        double secondCriticality = d;
        return Double.compare(secondCriticality, firstCriticality);
    }

    private static final int sortedBySeverity$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

