/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.config;

import com.charleskorn.kaml.Yaml;
import com.charleskorn.kaml.YamlList;
import com.charleskorn.kaml.YamlMap;
import com.charleskorn.kaml.YamlNode;
import com.charleskorn.kaml.YamlScalar;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.config.model.ProjectConfig;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/mosaify/core/util/config/ConfigFile;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "processYamlNode", "", "", "node", "Lcom/charleskorn/kaml/YamlNode;", "getAllScalarsYaml", "parseYamlImageList", "path", "Lkotlinx/io/files/Path;", "readImagesFromFile", "readProjectConfig", "Ldev/mosaify/core/util/config/model/ProjectConfig;", "mosaify-util-configfile"})
@SourceDebugExtension(value={"SMAP\nConfigFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigFile.kt\ndev/mosaify/core/util/config/ConfigFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1374#2:60\n1460#2,5:61\n774#2:66\n865#2,2:67\n1374#2:69\n1460#2,5:70\n1374#2:75\n1460#2,5:76\n1563#2:82\n1634#2,3:83\n827#2:86\n855#2,2:87\n774#2:89\n865#2,2:90\n1669#2,8:92\n1#3:81\n*S KotlinDebug\n*F\n+ 1 ConfigFile.kt\ndev/mosaify/core/util/config/ConfigFile\n*L\n19#1:60\n19#1:61,5\n21#1:66\n21#1:67,2\n26#1:69\n26#1:70,5\n27#1:75\n27#1:76,5\n49#1:82\n49#1:83,3\n50#1:86\n50#1:87,2\n51#1:89\n51#1:90,2\n52#1:92,8\n*E\n"})
public final class ConfigFile {
    @NotNull
    public static final ConfigFile INSTANCE = new ConfigFile();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ConfigFile::logger$lambda$0);

    private ConfigFile() {
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> processYamlNode(YamlNode node) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAllScalarsYaml(node);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("\\s");
            int n = 0;
            Iterable list$iv$iv = regex.split(charSequence, n);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!CommonUtils.INSTANCE.isContainerImageString(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getAllScalarsYaml(YamlNode node) {
        Collection collection;
        YamlNode yamlNode = node;
        if (yamlNode instanceof YamlScalar) {
            collection = CollectionsKt.listOf((Object)((YamlScalar)node).getContent());
        } else if (yamlNode instanceof YamlList) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((YamlList)node).getItems();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                YamlNode it = (YamlNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.getAllScalarsYaml(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else if (yamlNode instanceof YamlMap) {
            Iterable $this$flatMap$iv = SetsKt.plus(((YamlMap)node).getEntries().keySet(), (Iterable)((YamlMap)node).getEntries().values());
            boolean $i$f$flatMap = false;
            Iterable $this$flatMapTo$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                YamlNode it = (YamlNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.getAllScalarsYaml(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private final Collection<String> parseYamlImageList(Path path) {
        YamlNode it = Yaml.Companion.getDefault().parseToYamlNode(Utf8Kt.readString((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path))));
        boolean bl = false;
        return CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)INSTANCE.processYamlNode(it)));
    }

    @NotNull
    public final Collection<String> readImagesFromFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readImagesFromFile(PathsJvmKt.Path((String)path));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> readImagesFromFile(@NotNull Path path) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.endsWith((String)path.getName(), (String)".yaml", (boolean)true) || StringsKt.endsWith((String)path.getName(), (String)".yml", (boolean)true)) {
            Object object;
            Object $this$readImagesFromFile_u24lambda_u240;
            var2_2 = this;
            try {
                $this$readImagesFromFile_u24lambda_u240 = var2_2;
                boolean bl = false;
                $this$readImagesFromFile_u24lambda_u240 = Result.constructor-impl(super.parseYamlImageList(path));
            }
            catch (Throwable bl) {
                $this$readImagesFromFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            var2_2 = $this$readImagesFromFile_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)var2_2);
            if (throwable != null) {
                Object it2 = $this$readImagesFromFile_u24lambda_u240 = throwable;
                boolean bl = false;
                logger.warn((Throwable)it2, () -> ConfigFile.readImagesFromFile$lambda$1$0(path));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)var2_2);
            if (throwable2 == null) {
                object = var2_2;
            } else {
                Throwable it3 = throwable2;
                boolean bl = false;
                object = CollectionsKt.emptyList();
            }
            collection = (Collection)object;
        } else {
            var2_2 = new String[]{"\n"};
            collection = StringsKt.split$default((CharSequence)Utf8Kt.readString((Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(path))), (String[])var2_2, (boolean)false, (int)0, (int)6, null);
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (!CommonUtils.INSTANCE.isContainerImageString(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String it4 = (String)e$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it4.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @NotNull
    public final ProjectConfig readProjectConfig(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw new NotImplementedError(null, 1, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readImagesFromFile$lambda$1$0(Path $path) {
        return "Could not get image list from file " + $path;
    }
}

