/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.util.autoparser;

import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.SarifLog;
import dev.mosaify.core.model.scanner.ScanTarget;
import dev.mosaify.core.model.taxonomy.TargetType;
import dev.mosaify.core.parser.anchore.grype.ParserAnchoreGrype;
import dev.mosaify.core.parser.aquasecurity.trivy.ParserAquasecurityTrivy;
import dev.mosaify.core.parser.docker.scout.ParserDockerScout;
import dev.mosaify.core.parser.jfrog.xray.ParserJfrogXray;
import dev.mosaify.core.parser.sarif.ParserSarifGeneric;
import dev.mosaify.core.parser.semgrep.ParserSemgrep;
import dev.mosaify.core.parser.snyk.ParserSnyk;
import dev.mosaify.core.parser.snyk.ParserSnykCode;
import dev.mosaify.core.util.Extensions;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J)\u0010\n\u001a\u0011\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\r\u00a2\u0006\u0002\b\f2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J+\u0010\u0012\u001a\u0011\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\r\u00a2\u0006\u0002\b\f2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/mosaify/core/util/autoparser/AutoParser;", "", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "parsers", "", "Ldev/mosaify/core/model/report/ReportParser;", "getParsers", "autoParseToGeneric", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "reportBytes", "", "runExtraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "processSarif", "sarifLog", "Ldev/mosaify/core/model/sarif/SarifLog;", "extraInfo", "mosaify-util-autoparser"})
@SourceDebugExtension(value={"SMAP\nAutoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoParser.kt\ndev/mosaify/core/util/autoparser/AutoParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1#2:148\n1617#3,9:138\n1869#3:147\n1870#3:149\n1626#3:150\n1740#3,3:151\n774#3:154\n865#3,2:155\n1068#3:157\n1563#3:158\n1634#3,2:159\n1374#3:161\n1460#3,5:162\n1636#3:167\n1563#3:168\n1634#3,2:169\n774#3:171\n865#3,2:172\n1636#3:174\n*S KotlinDebug\n*F\n+ 1 AutoParser.kt\ndev/mosaify/core/util/autoparser/AutoParser\n*L\n59#1:148\n59#1:138,9\n59#1:147\n59#1:149\n59#1:150\n82#1:151,3\n95#1:154\n95#1:155,2\n95#1:157\n98#1:158\n98#1:159,2\n99#1:161\n99#1:162,5\n98#1:167\n114#1:168\n114#1:169,2\n116#1:171\n116#1:172,2\n114#1:174\n*E\n"})
public final class AutoParser {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Collection<ReportParser> parsers;

    public AutoParser(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        Object[] objectArray = new ReportParser[]{new ParserAnchoreGrype(this.logger), new ParserAquasecurityTrivy(this.logger), new ParserDockerScout(this.logger), new ParserJfrogXray(this.logger), new ParserSemgrep(this.logger), new ParserSnyk(this.logger), new ParserSnykCode(this.logger)};
        this.parsers = CollectionsKt.listOf((Object[])objectArray);
        if (this.parsers.isEmpty()) {
            throw new Error("Could not load any parsers");
        }
        LocalDateTime.Formats.INSTANCE.getISO();
        this.logger.debug(() -> AutoParser._init_$lambda$1(this));
    }

    public /* synthetic */ AutoParser(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger(AutoParser::_init_$lambda$0);
        }
        this(kLogger);
    }

    @NotNull
    public final Collection<ReportParser> getParsers() {
        return this.parsers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Issue> autoParseToGeneric(@NotNull byte[] reportBytes, @Nullable RunExtraInfo runExtraInfo) {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        Collection customReports;
        Object object;
        block15: {
            Iterator $this$mapNotNullTo$iv$iv;
            Object $this$autoParseToGeneric_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)reportBytes, (String)"reportBytes");
            Object object2 = this;
            try {
                $this$autoParseToGeneric_u24lambda_u240 = object2;
                boolean bl2 = false;
                $this$autoParseToGeneric_u24lambda_u240 = Result.constructor-impl((Object)dev.mosaify.core.parser.sarif.Extensions.INSTANCE.fromBytes(SarifLog.Companion, reportBytes));
            }
            catch (Throwable bl2) {
                $this$autoParseToGeneric_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$autoParseToGeneric_u24lambda_u240;
            SarifLog sarifReport = (SarifLog)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (sarifReport != null) {
                this.logger.info(() -> AutoParser.autoParseToGeneric$lambda$1(sarifReport));
                return this.processSarif(sarifReport, runExtraInfo);
            }
            this.logger.info(AutoParser::autoParseToGeneric$lambda$2);
            Iterable $this$mapNotNull$iv = this.parsers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Collection it$iv$iv;
                Object $this$autoParseToGeneric_u24lambda_u243_u240;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                ReportParser parser = (ReportParser)element$iv$iv;
                boolean bl4 = false;
                object = this;
                try {
                    $this$autoParseToGeneric_u24lambda_u243_u240 = object;
                    boolean bl5 = false;
                    Collection result = Extensions.INSTANCE.parseToGeneric(parser, reportBytes, runExtraInfo);
                    if (!result.isEmpty()) {
                        ((AutoParser)$this$autoParseToGeneric_u24lambda_u243_u240).logger.info(() -> AutoParser.autoParseToGeneric$lambda$3$0$0(parser, result, runExtraInfo));
                    }
                    $this$autoParseToGeneric_u24lambda_u243_u240 = Result.constructor-impl((Object)result);
                }
                catch (Throwable bl5) {
                    $this$autoParseToGeneric_u24lambda_u243_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                }
                object = $this$autoParseToGeneric_u24lambda_u243_u240;
                if ((Collection)(Result.isFailure-impl((Object)object) ? null : object) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            customReports = (List)destination$iv$iv;
            this.logger.info(AutoParser::autoParseToGeneric$lambda$4);
            Iterable $this$all$iv = customReports;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    Collection it = (Collection)element$iv2;
                    boolean bl7 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl) {
            this.logger.warn(() -> AutoParser.autoParseToGeneric$lambda$6(runExtraInfo));
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = customReports;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Collection it = (Collection)element$iv$iv;
            boolean bl8 = false;
            boolean bl9 = !it.isEmpty();
            if (!bl9) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List reportsWithData = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Collection it = (Collection)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.size());
                it = (Collection)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.size()));
            }
        });
        if (reportsWithData.size() > 1) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = reportsWithData;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$flatMapTo$iv$iv;
                void report;
                Collection bl8 = (Collection)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl10 = false;
                Iterable $this$flatMap$iv = (Iterable)report;
                boolean $i$f$flatMap = false;
                object = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Issue issue = (Issue)element$iv$iv;
                    boolean bl11 = false;
                    Iterable list$iv$iv = issue.getDetectedBy();
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                collection.add(TuplesKt.to((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (Object)report.size()));
            }
            List analysis = (List)destination$iv$iv2;
            throw new Error("Cannot choose the report type from: " + CollectionsKt.joinToString$default((Iterable)analysis, (CharSequence)", ", null, null, (int)0, null, AutoParser::autoParseToGeneric$lambda$10, (int)30, null));
        }
        return (Collection)CollectionsKt.first((List)reportsWithData);
    }

    public static /* synthetic */ Collection autoParseToGeneric$default(AutoParser autoParser, byte[] byArray, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return autoParser.autoParseToGeneric(byArray, runExtraInfo);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Collection<Issue> processSarif(SarifLog sarifLog, RunExtraInfo extraInfo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = sarifLog.getRuns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection collection;
            void run;
            void $this$filterTo$iv$iv;
            Run run2 = (Run)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.parsers;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ReportParser parser = (ReportParser)element$iv$iv;
                boolean bl2 = false;
                if (!Extensions.INSTANCE.supports(parser, (Run)run)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List activeParsers = (List)destination$iv$iv2;
            if (!((Collection)activeParsers).isEmpty()) {
                if (activeParsers.size() != 1) throw new Error("Detected more than one scanner using the same name(s): " + CollectionsKt.joinToString$default((Iterable)activeParsers, (CharSequence)", ", null, null, (int)0, null, AutoParser::processSarif$lambda$0$2, (int)30, null) + "'");
                ReportParser it = (ReportParser)CollectionsKt.first((List)activeParsers);
                boolean bl3 = false;
                this.logger.info(() -> AutoParser.processSarif$lambda$0$1$0(it, (Run)run));
                collection = it.sarifToGeneric((Run)run, extraInfo);
            } else {
                collection = ParserSarifGeneric.INSTANCE.sarifToGeneric((Run)run, extraInfo);
            }
            collection2.add(collection);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    static /* synthetic */ Collection processSarif$default(AutoParser autoParser, SarifLog sarifLog, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return autoParser.processSarif(sarifLog, runExtraInfo);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object _init_$lambda$1(AutoParser this$0) {
        return "Loaded " + this$0.parsers.size() + " parsers: " + CollectionsKt.joinToString$default((Iterable)this$0.parsers, null, null, null, (int)0, null, AutoParser::lambda$1$0, (int)31, null);
    }

    private static final CharSequence lambda$1$0(ReportParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it.getName() + "'";
    }

    /*
     * WARNING - void declaration
     */
    private static final Object autoParseToGeneric$lambda$1(SarifLog $sarifReport) {
        int n;
        Iterable iterable = $sarifReport.getRuns();
        int n2 = $sarifReport.getRuns().size();
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            Run run = (Run)t;
            n = n3;
            boolean bl = false;
            List list = it.getResults();
            int n4 = list != null ? list.size() : 0;
            n3 = n + n4;
        }
        n = n3;
        return "Detected SARIF report: '" + n2 + "' runs, '" + n + "' results";
    }

    private static final Object autoParseToGeneric$lambda$2() {
        return "Starting autoparser -- please ignore individual parser errors below this line";
    }

    private static final Object autoParseToGeneric$lambda$3$0$0(ReportParser $parser, Collection $result, RunExtraInfo $runExtraInfo) {
        StringBuilder stringBuilder;
        block3: {
            String string;
            StringBuilder $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240.append("Successfully parsed '" + $parser.getName() + "' report: " + $result.size() + " findings");
            RunExtraInfo runExtraInfo = $runExtraInfo;
            if (runExtraInfo == null) break block3;
            RunExtraInfo it = runExtraInfo;
            boolean bl2 = false;
            $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240.append(". Metadata - ");
            Object object = it.getTarget();
            if (object == null || (object = object.getTarget()) == null) {
                object = "unknown";
            }
            $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240.append("Target: '" + (String)object + "'");
            ScanTarget scanTarget = it.getTarget();
            if (scanTarget != null && (scanTarget = scanTarget.getType()) != null) {
                ScanTarget type = scanTarget;
                boolean bl3 = false;
                $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240.append(", Type: '" + (TargetType)type + "'");
            }
            if ((string = it.getScanner()) == null) {
                string = "unknown";
            }
            $this$autoParseToGeneric_u24lambda_u243_u240_u240_u240.append(", Scanner: '" + string + "' ");
        }
        return stringBuilder.toString();
    }

    private static final Object autoParseToGeneric$lambda$4() {
        return "Autoparser finished";
    }

    private static final Object autoParseToGeneric$lambda$6(RunExtraInfo $runExtraInfo) {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder $this$autoParseToGeneric_u24lambda_u246_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$autoParseToGeneric_u24lambda_u246_u240.append("No findings detected (or report not recognized). Metadata - ");
        Object object2 = $runExtraInfo;
        if (object2 == null || (object2 = object2.getTarget()) == null || (object2 = object2.getTarget()) == null) {
            object2 = "unknown";
        }
        $this$autoParseToGeneric_u24lambda_u246_u240.append("Target: '" + (String)object2 + "'");
        RunExtraInfo runExtraInfo = $runExtraInfo;
        if (runExtraInfo != null && (runExtraInfo = runExtraInfo.getTarget()) != null && (runExtraInfo = runExtraInfo.getType()) != null) {
            RunExtraInfo it = runExtraInfo;
            boolean bl2 = false;
            $this$autoParseToGeneric_u24lambda_u246_u240.append(", Type: '" + (TargetType)it + "'");
        }
        if ((object = $runExtraInfo) == null || (object = object.getScanner()) == null) {
            object = "unknown";
        }
        $this$autoParseToGeneric_u24lambda_u246_u240.append(", Scanner: '" + (String)object + "' ");
        return stringBuilder.toString();
    }

    private static final CharSequence autoParseToGeneric$lambda$10(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it.getFirst() + " (" + it.getSecond() + ")'";
    }

    private static final Object processSarif$lambda$0$1$0(ReportParser $it, Run $run) {
        return "Detected SARIF Run produced by '" + $it.getName() + "' ('" + $run.getTool().getDriver().getName() + "')";
    }

    private static final CharSequence processSarif$lambda$0$2(ReportParser it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    public AutoParser() {
        this(null, 1, null);
    }
}

