/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.mordant.internal.AnsiCodes;
import com.github.ajalt.mordant.internal.Chunk;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TxtStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0000\u001a \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a,\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"NEL", "", "LS", "parseText", "Lcom/github/ajalt/mordant/rendering/Lines;", "text", "", "defaultStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "parseAnsi", "", "Lcom/github/ajalt/mordant/internal/Chunk;", "splitWords", "chunk", "splitLines", "Lcom/github/ajalt/mordant/rendering/Line;", "words", "updateStyle", "existingStyle", "ansi", "updateStyleWithOsc", "updateStyleWithCsi", "getAnsiColor", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/Color;", "", "i", "codes", "mordant"})
@SourceDebugExtension(value={"SMAP\nParsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parsing.kt\ncom/github/ajalt/mordant/internal/ParsingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1368#2:277\n1454#2,5:278\n1611#2,9:284\n1863#2:293\n1864#2:295\n1620#2:296\n1#3:283\n1#3:294\n*S KotlinDebug\n*F\n+ 1 Parsing.kt\ncom/github/ajalt/mordant/internal/ParsingKt\n*L\n22#1:277\n22#1:278,5\n150#1:284,9\n150#1:293\n150#1:295\n150#1:296\n150#1:294\n*E\n"})
public final class ParsingKt {
    private static final char NEL = '\u0085';
    private static final char LS = '\u2028';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines parseText(@NotNull String text2, @NotNull TextStyle defaultStyle) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
        List<Chunk> parseAnsi = ParsingKt.parseAnsi(text2, defaultStyle);
        Iterable $this$flatMap$iv = parseAnsi;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ParsingKt.splitWords(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List words = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        List<Line> splitLines = ParsingKt.splitLines(words);
        return new Lines(splitLines);
    }

    private static final List<Chunk> parseAnsi(String text2, TextStyle defaultStyle) {
        List commands = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)ConstantsKt.getANSI_RE(), (CharSequence)text2, (int)0, (int)2, null));
        if (commands.isEmpty()) {
            return CollectionsKt.listOf((Object)new Chunk(text2, defaultStyle));
        }
        List parts = new ArrayList();
        int idxAfterLastCmd = 0;
        TextStyle style = defaultStyle;
        for (MatchResult command : commands) {
            if (command.getRange().getFirst() > idxAfterLastCmd) {
                Collection collection = parts;
                String string = text2.substring(idxAfterLastCmd, command.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(new Chunk(string, style));
            }
            idxAfterLastCmd = command.getRange().getLast() + 1;
            style = ParsingKt.updateStyle(style, defaultStyle, command.getValue());
        }
        if (idxAfterLastCmd < text2.length()) {
            Collection collection = parts;
            String string = text2.substring(idxAfterLastCmd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(new Chunk(string, style));
        }
        return parts;
    }

    private static final List<Chunk> splitWords(Chunk chunk) {
        int i;
        List chunks = new ArrayList();
        int start = 0;
        int chunkType = -1;
        String t = chunk.getText();
        for (i = 0; i < t.length(); ++i) {
            int type;
            char c = t.charAt(i);
            int n = c == '\r' ? 0 : (c == '\n' || c == '\t' || c == '\u0085' || c == '\u2028' ? 1 : (type = CharsKt.isWhitespace((char)c) ? 2 : 3));
            if (i == 0) {
                chunkType = type;
                continue;
            }
            if (type != 1 && chunkType == type) continue;
            Collection collection = chunks;
            String string = t.substring(start, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(Chunk.copy$default(chunk, string, null, 2, null));
            start = i;
            chunkType = type;
        }
        if (start != i) {
            Collection collection = chunks;
            String string = t.substring(start, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(Chunk.copy$default(chunk, string, null, 2, null));
        }
        return chunks;
    }

    private static final List<Line> splitLines(List<Chunk> words) {
        List lines;
        block4: {
            lines = new ArrayList();
            List line = new ArrayList();
            for (Chunk word : words) {
                if (StringsKt.endsWith$default((String)word.getText(), (String)"\n", (boolean)false, (int)2, null)) {
                    ((Collection)lines).add(new Line(line, word.getStyle()));
                    line = new ArrayList();
                    continue;
                }
                line.add(Span.Companion.word(word.getText(), word.getStyle()));
            }
            if (!((Collection)line).isEmpty()) {
                ((Collection)lines).add(new Line(line));
            }
            Chunk chunk = (Chunk)CollectionsKt.lastOrNull(words);
            if (chunk == null) break block4;
            Chunk it = chunk;
            boolean bl = false;
            if (StringsKt.endsWith$default((String)it.getText(), (String)"\n", (boolean)false, (int)2, null)) {
                lines.add(new Line(CollectionsKt.emptyList(), it.getStyle()));
            }
        }
        return lines;
    }

    @NotNull
    public static final TextStyle updateStyle(@NotNull TextStyle existingStyle, @NotNull TextStyle defaultStyle, @NotNull String ansi) {
        Intrinsics.checkNotNullParameter((Object)existingStyle, (String)"existingStyle");
        Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
        Intrinsics.checkNotNullParameter((Object)ansi, (String)"ansi");
        if (StringsKt.startsWith$default((String)ansi, (String)"\u001b]", (boolean)false, (int)2, null)) {
            return ParsingKt.updateStyleWithOsc(ansi, existingStyle, defaultStyle);
        }
        if (StringsKt.startsWith$default((String)ansi, (String)"\u001b[", (boolean)false, (int)2, null)) {
            return ParsingKt.updateStyleWithCsi(ansi, existingStyle, defaultStyle);
        }
        return existingStyle;
    }

    private static final TextStyle updateStyleWithOsc(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        String string;
        String id;
        String string2;
        if (!StringsKt.startsWith$default((String)ansi, (String)"\u001b]8", (boolean)false, (int)2, null)) {
            return existingStyle;
        }
        String string3 = ansi.substring(3, ansi.length() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String[] stringArray = new String[]{";"};
        List params = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (params.isEmpty()) {
            return existingStyle;
        }
        Object object = CollectionsKt.last((List)params);
        String it = (String)object;
        boolean bl = false;
        String hyperlink = (String)(!StringsKt.isBlank((CharSequence)it) ? object : null);
        if (hyperlink == null) {
            string2 = defaultStyle.getHyperlinkId();
        } else {
            Object v2;
            block6: {
                Iterable iterable = params;
                for (Object t : iterable) {
                    String it2 = (String)t;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)"id=", (boolean)false, (int)2, null)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            String string4 = v2;
            string2 = id = string4 != null ? StringsKt.drop((String)string4, (int)3) : null;
        }
        if ((string = hyperlink) == null) {
            string = defaultStyle.getHyperlink();
        }
        return TextStyleKt.copy$default(existingStyle, null, null, string, id, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextStyle updateStyleWithCsi(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        void $this$mapNotNullTo$iv$iv;
        if (!StringsKt.endsWith$default((String)ansi, (String)"m", (boolean)false, (int)2, null)) {
            return existingStyle;
        }
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)ansi.subSequence(2, ansi.length() - 1), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((((CharSequence)it).length() == 0 ? Integer.valueOf(0) : StringsKt.toIntOrNull((String)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        if (codes.isEmpty()) {
            return defaultStyle;
        }
        Color color = existingStyle.getColor();
        Color bgColor = existingStyle.getBgColor();
        Boolean bold = existingStyle.getBold();
        Boolean italic = existingStyle.getItalic();
        Boolean underline = existingStyle.getUnderline();
        Boolean dim = existingStyle.getDim();
        Boolean inverse = existingStyle.getInverse();
        Boolean strikethrough = existingStyle.getStrikethrough();
        for (int i = 0; i <= CollectionsKt.getLastIndex((List)codes); ++i) {
            int n;
            int consumed;
            Pair<Color, Integer> pair;
            int code;
            block47: {
                block46: {
                    int it;
                    block45: {
                        block44: {
                            code = ((Number)codes.get(i)).intValue();
                            if (code == 0) {
                                Boolean bl;
                                Boolean bl4;
                                Boolean bl5;
                                Boolean bl6;
                                Boolean bl7;
                                color = defaultStyle.getColor();
                                bgColor = defaultStyle.getBgColor();
                                Boolean bl8 = defaultStyle.getBold();
                                if (bl8 == null) {
                                    bl8 = bold = Boolean.valueOf(false);
                                }
                                if ((bl7 = defaultStyle.getItalic()) == null) {
                                    bl7 = italic = Boolean.valueOf(false);
                                }
                                if ((bl6 = defaultStyle.getUnderline()) == null) {
                                    bl6 = underline = Boolean.valueOf(false);
                                }
                                if ((bl5 = defaultStyle.getDim()) == null) {
                                    bl5 = dim = Boolean.valueOf(false);
                                }
                                if ((bl4 = defaultStyle.getInverse()) == null) {
                                    bl4 = inverse = Boolean.valueOf(false);
                                }
                                if ((bl = defaultStyle.getStrikethrough()) == null) {
                                    bl = false;
                                }
                                strikethrough = bl;
                                continue;
                            }
                            if (code == 22) {
                                Boolean bl;
                                Boolean bl9 = defaultStyle.getBold();
                                if (bl9 == null) {
                                    bl9 = bold = Boolean.valueOf(false);
                                }
                                if ((bl = defaultStyle.getDim()) == null) {
                                    bl = false;
                                }
                                dim = bl;
                                continue;
                            }
                            if (code == 23) {
                                Boolean bl = defaultStyle.getItalic();
                                if (bl == null) {
                                    bl = false;
                                }
                                italic = bl;
                                continue;
                            }
                            if (code == 24) {
                                Boolean bl = defaultStyle.getUnderline();
                                if (bl == null) {
                                    bl = false;
                                }
                                underline = bl;
                                continue;
                            }
                            if (code == 27) {
                                Boolean bl = defaultStyle.getInverse();
                                if (bl == null) {
                                    bl = false;
                                }
                                inverse = bl;
                                continue;
                            }
                            if (code == 29) {
                                Boolean bl = defaultStyle.getStrikethrough();
                                if (bl == null) {
                                    bl = false;
                                }
                                strikethrough = bl;
                                continue;
                            }
                            if (code == 39) {
                                color = defaultStyle.getColor();
                                continue;
                            }
                            if (code == 49) {
                                bgColor = defaultStyle.getBgColor();
                                continue;
                            }
                            pair = AnsiCodes.INSTANCE.getFg16Range();
                            it = pair.getFirst();
                            if (code <= pair.getLast() ? it <= code : false) break block44;
                            pair = AnsiCodes.INSTANCE.getFg16BrightRange();
                            it = pair.getFirst();
                            boolean bl = code <= pair.getLast() ? it <= code : false;
                            if (!bl) break block45;
                        }
                        color = (Color)new Ansi16(code);
                        continue;
                    }
                    pair = AnsiCodes.INSTANCE.getBg16Range();
                    it = pair.getFirst();
                    if (code <= pair.getLast() ? it <= code : false) break block46;
                    pair = AnsiCodes.INSTANCE.getBg16BrightRange();
                    it = pair.getFirst();
                    boolean bl = code <= pair.getLast() ? it <= code : false;
                    if (!bl) break block47;
                }
                bgColor = (Color)new Ansi16(code - 10);
                continue;
            }
            if (code == 38) {
                pair = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair.component1();
                consumed = ((Number)pair.component2()).intValue();
                if (c == null) break;
                color = c;
                i += consumed;
                continue;
            }
            if (code == 48) {
                pair = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair.component1();
                consumed = ((Number)pair.component2()).intValue();
                if (c == null) break;
                bgColor = c;
                i += consumed;
                continue;
            }
            if (code == 1) {
                bold = true;
                continue;
            }
            if (code == 3) {
                italic = true;
                continue;
            }
            if (code == 4) {
                underline = true;
                continue;
            }
            if (code == 2) {
                dim = true;
                continue;
            }
            if (code == 7) {
                inverse = true;
                continue;
            }
            if (code == 9) {
                strikethrough = true;
                continue;
            }
            if (code != 58) continue;
            if (i == CollectionsKt.getLastIndex((List)codes)) {
                n = 0;
            } else {
                Integer n2 = (Integer)CollectionsKt.getOrNull((List)codes, (int)(i + 1));
                int n3 = 5;
                if (n2 != null && n2 == n3) {
                    n = 1;
                } else {
                    Integer n4 = (Integer)CollectionsKt.getOrNull((List)codes, (int)(i + 1));
                    n3 = 2;
                    if (n4 == null || n4 != n3) break;
                    n = 3;
                }
            }
            i = i + n;
        }
        return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.getHyperlink(), existingStyle.getHyperlinkId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<Color, Integer> getAnsiColor(int i, List<Integer> codes) {
        Pair pair;
        switch (((Number)codes.get(i)).intValue()) {
            case 5: {
                if (i + 1 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        pair = TuplesKt.to((Object)new Ansi256(((Number)codes.get(i + 1)).intValue()), (Object)2);
                        return pair;
                    }
                }
                pair = TuplesKt.to(null, (Object)0);
                return pair;
            }
            case 2: {
                if (i + 3 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        n = ((Number)codes.get(i + 2)).intValue();
                        boolean bl2 = 0 <= n ? n < 256 : false;
                        if (bl2) {
                            n = ((Number)codes.get(i + 3)).intValue();
                            boolean bl3 = 0 <= n ? n < 256 : false;
                            if (bl3) {
                                pair = TuplesKt.to((Object)RGBColorSpace.DefaultImpls.from255$default((RGBColorSpace)((RGBColorSpace)RGB.Companion), (int)((Number)codes.get(i + 1)).intValue(), (int)((Number)codes.get(i + 2)).intValue(), (int)((Number)codes.get(i + 3)).intValue(), (int)0, (int)8, null), (Object)4);
                                return pair;
                            }
                        }
                    }
                }
                pair = TuplesKt.to(null, (Object)0);
                return pair;
            }
        }
        pair = TuplesKt.to(null, (Object)0);
        return pair;
    }
}

