/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.AnsiMovements;
import com.github.ajalt.mordant.terminal.CursorMovements;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\t2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\b\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/github/ajalt/mordant/terminal/PrintTerminalCursor;", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "<init>", "(Lcom/github/ajalt/mordant/terminal/Terminal;)V", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "show", "", "hide", "showOnExit", "", "move", "movements", "Lkotlin/Function1;", "Lcom/github/ajalt/mordant/terminal/CursorMovements;", "Lkotlin/ExtensionFunctionType;", "getMoves", "", "mordant"})
public abstract class PrintTerminalCursor
implements TerminalCursor {
    @NotNull
    private final Terminal terminal;

    public PrintTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
    }

    @NotNull
    protected final Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public void show() {
        Terminal.rawPrint$default(this.terminal, (CharSequence)"\u001b[?25h", false, 2, null);
    }

    @Override
    public void hide(boolean showOnExit) {
        Terminal.rawPrint$default(this.terminal, (CharSequence)"\u001b[?25l", false, 2, null);
    }

    @Override
    public void move(@NotNull Function1<? super CursorMovements, Unit> movements) {
        Intrinsics.checkNotNullParameter(movements, (String)"movements");
        Terminal.rawPrint$default(this.terminal, (CharSequence)this.getMoves(movements), false, 2, null);
    }

    @Override
    @NotNull
    public String getMoves(@NotNull Function1<? super CursorMovements, Unit> movements) {
        Intrinsics.checkNotNullParameter(movements, (String)"movements");
        AnsiMovements ansiMovements = new AnsiMovements();
        movements.invoke((Object)ansiMovements);
        return ansiMovements.getOutput();
    }
}

