/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.PATTERNS;
import com.github.ajalt.colormath.internal.CssColors;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABColorSpaces;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabColorSpaces;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZColorSpaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0007\u001a0\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0007\u001a*\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u00a8\u0006\u0019"}, d2={"parse", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/Color$Companion;", "color", "", "customColorSpaces", "", "Lcom/github/ajalt/colormath/ColorSpace;", "parseOrNull", "match", "Lkotlin/text/MatchResult;", "rgb", "hsl", "lab", "lch", "hwb", "oklab", "oklch", "number", "", "str", "percentOrNumber", "max", "alpha", "hue", "colormath"})
@SourceDebugExtension(value={"SMAP\nCssParse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssParse.kt\ncom/github/ajalt/colormath/CssParseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1#2:205\n295#3,2:206\n1567#3:208\n1598#3,4:209\n*S KotlinDebug\n*F\n+ 1 CssParse.kt\ncom/github/ajalt/colormath/CssParseKt\n*L\n106#1:206,2\n109#1:208\n109#1:209,4\n*E\n"})
public final class CssParseKt {
    @JvmOverloads
    @NotNull
    public static final Color parse(@NotNull Color.Companion $this$parse, @NotNull String color, @NotNull Map<String, ? extends ColorSpace<?>> customColorSpaces) {
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(customColorSpaces, (String)"customColorSpaces");
        Color color2 = CssParseKt.parseOrNull($this$parse, color, customColorSpaces);
        if (color2 == null) {
            throw new IllegalArgumentException("Invalid color: " + color);
        }
        return color2;
    }

    public static /* synthetic */ Color parse$default(Color.Companion companion, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return CssParseKt.parse(companion, string, map);
    }

    @JvmOverloads
    @Nullable
    public static final Color parseOrNull(@NotNull Color.Companion $this$parseOrNull, @NotNull String color, @NotNull Map<String, ? extends ColorSpace<?>> customColorSpaces) {
        Color color2;
        block31: {
            block33: {
                block32: {
                    Object object;
                    block30: {
                        Intrinsics.checkNotNullParameter((Object)$this$parseOrNull, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                        Intrinsics.checkNotNullParameter(customColorSpaces, (String)"customColorSpaces");
                        RGB keywordColor = CssColors.INSTANCE.getColorsByName().get(color);
                        RGB rGB = keywordColor;
                        if (rGB == null) break block30;
                        color2 = rGB;
                        break block31;
                    }
                    if (!StringsKt.startsWith$default((String)color, (String)"#", (boolean)false, (int)2, null)) break block32;
                    Object object2 = $this$parseOrNull;
                    try {
                        Color.Companion $this$parseOrNull_u24lambda_u240 = object2;
                        boolean bl = false;
                        object = Result.constructor-impl((Object)RGB.Companion.invoke(color));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    color2 = (Color)(Result.isFailure-impl((Object)object2) ? null : object2);
                    break block31;
                }
                color2 = PATTERNS.INSTANCE.getRGB_1().matchEntire((CharSequence)color);
                if (color2 == null) break block33;
                Color it = color2;
                boolean bl = false;
                Color color3 = CssParseKt.rgb((MatchResult)it);
                color2 = color3;
                if (color3 != null) break block31;
            }
            MatchResult matchResult = PATTERNS.INSTANCE.getRGB_2().matchEntire((CharSequence)color);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                color2 = CssParseKt.rgb(it);
            } else {
                Color color4;
                MatchResult matchResult2 = PATTERNS.INSTANCE.getHSL_1().matchEntire((CharSequence)color);
                if (matchResult2 != null) {
                    MatchResult it = matchResult2;
                    boolean bl = false;
                    color4 = CssParseKt.hsl(it);
                } else {
                    color4 = color2 = null;
                }
                if (color4 == null) {
                    Color color5;
                    MatchResult matchResult3 = PATTERNS.INSTANCE.getHSL_2().matchEntire((CharSequence)color);
                    if (matchResult3 != null) {
                        MatchResult it = matchResult3;
                        boolean bl = false;
                        color5 = CssParseKt.hsl(it);
                    } else {
                        color5 = color2 = null;
                    }
                    if (color5 == null) {
                        Color color6;
                        MatchResult matchResult4 = PATTERNS.INSTANCE.getLAB().matchEntire((CharSequence)color);
                        if (matchResult4 != null) {
                            MatchResult it = matchResult4;
                            boolean bl = false;
                            color6 = CssParseKt.lab(it);
                        } else {
                            color6 = color2 = null;
                        }
                        if (color6 == null) {
                            Color color7;
                            MatchResult matchResult5 = PATTERNS.INSTANCE.getLCH().matchEntire((CharSequence)color);
                            if (matchResult5 != null) {
                                MatchResult it = matchResult5;
                                boolean bl = false;
                                color7 = CssParseKt.lch(it);
                            } else {
                                color7 = color2 = null;
                            }
                            if (color7 == null) {
                                Color color8;
                                MatchResult matchResult6 = PATTERNS.INSTANCE.getHWB().matchEntire((CharSequence)color);
                                if (matchResult6 != null) {
                                    MatchResult it = matchResult6;
                                    boolean bl = false;
                                    color8 = CssParseKt.hwb(it);
                                } else {
                                    color8 = color2 = null;
                                }
                                if (color8 == null) {
                                    Color color9;
                                    MatchResult matchResult7 = PATTERNS.INSTANCE.getOKLAB().matchEntire((CharSequence)color);
                                    if (matchResult7 != null) {
                                        MatchResult it = matchResult7;
                                        boolean bl = false;
                                        color9 = CssParseKt.oklab(it);
                                    } else {
                                        color9 = color2 = null;
                                    }
                                    if (color9 == null) {
                                        Color color10;
                                        MatchResult matchResult8 = PATTERNS.INSTANCE.getOKLCH().matchEntire((CharSequence)color);
                                        if (matchResult8 != null) {
                                            MatchResult it = matchResult8;
                                            boolean bl = false;
                                            color10 = CssParseKt.oklch(it);
                                        } else {
                                            color10 = color2 = null;
                                        }
                                        if (color10 == null) {
                                            MatchResult matchResult9 = PATTERNS.INSTANCE.getCOLOR().matchEntire((CharSequence)color);
                                            if (matchResult9 != null) {
                                                MatchResult it = matchResult9;
                                                boolean bl = false;
                                                color2 = CssParseKt.color(it, customColorSpaces);
                                            } else {
                                                color2 = null;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return color2;
    }

    public static /* synthetic */ Color parseOrNull$default(Color.Companion companion, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return CssParseKt.parseOrNull(companion, string, map);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Color color(MatchResult match, Map<String, ? extends ColorSpace<?>> customColorSpaces) {
        block32: {
            block25: {
                block30: {
                    block28: {
                        block27: {
                            block31: {
                                block29: {
                                    block26: {
                                        name = (String)match.getGroupValues().get(1);
                                        switch (name.hashCode()) {
                                            case -914567506: {
                                                if (!name.equals("display-p3")) {
                                                    ** break;
                                                }
                                                break block26;
                                            }
                                            case 569081048: {
                                                if (name.equals("srgb-linear")) break;
                                                ** break;
                                            }
                                            case 1080714636: {
                                                if (!name.equals("rec2020")) {
                                                    ** break;
                                                }
                                                break block27;
                                            }
                                            case 119193: {
                                                if (!name.equals("xyz")) {
                                                    ** break;
                                                }
                                                break block28;
                                            }
                                            case -1590472757: {
                                                if (!name.equals("xyz-d50")) {
                                                    ** break;
                                                }
                                                break block28;
                                            }
                                            case 1873543360: {
                                                if (!name.equals("a98-rgb")) {
                                                    ** break;
                                                }
                                                break block29;
                                            }
                                            case -1590472721: {
                                                if (!name.equals("xyz-d65")) {
                                                    ** break;
                                                }
                                                break block30;
                                            }
                                            case 1691026085: {
                                                if (!name.equals("prophoto-rgb")) {
                                                    ** break;
                                                }
                                                break block31;
                                            }
                                            case 3538810: {
                                                if (!name.equals("srgb")) ** break;
                                                v0 = SRGB.INSTANCE;
                                                break block32;
                                            }
                                        }
                                        v0 = RGBColorSpaces.INSTANCE.getLinearSRGB();
                                        break block32;
                                    }
                                    v0 = RGBColorSpaces.INSTANCE.getDisplayP3();
                                    break block32;
                                }
                                v0 = RGBColorSpaces.INSTANCE.getAdobeRGB();
                                break block32;
                            }
                            v0 = RGBColorSpaces.INSTANCE.getROMM_RGB();
                            break block32;
                        }
                        v0 = RGBColorSpaces.INSTANCE.getBT2020();
                        break block32;
                    }
                    v0 = XYZColorSpaces.INSTANCE.getXYZ50();
                    break block32;
                }
                v0 = XYZColorSpaces.INSTANCE.getXYZ65();
                break block32;
lbl58:
                // 10 sources

                $this$firstOrNull$iv = customColorSpaces.entrySet();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-firstOrNull-CssParseKt$color$space$1 = false;
                    if (!Intrinsics.areEqual(it.getKey(), (Object)name)) continue;
                    v1 = element$iv;
                    break block25;
                }
                v1 = null;
            }
            v2 = v1;
            v0 = v2 != null ? (ColorSpace)v2.getValue() : null;
        }
        if (v0 == null) {
            return null;
        }
        space = v0;
        name = (CharSequence)match.getGroupValues().get(2);
        var5_19 = new Regex("\\s+");
        $this$firstOrNull$iv = 0;
        name = var5_19.split((CharSequence)name, $this$firstOrNull$iv);
        $i$f$mapIndexed = false;
        $this$firstOrNull$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        $i$f$mapIndexedTo = false;
        index$iv$iv = 0;
        for (E item$iv$iv : $this$mapIndexedTo$iv$iv) {
            if ((var12_21 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var13_22 = (String)item$iv$iv;
            var14_23 = var12_21;
            var16_25 = destination$iv$iv;
            $i$a$-mapIndexed-CssParseKt$color$values$1 = false;
            var16_25.add(Float.valueOf(CssParseKt.percentOrNumber((String)str, space.getComponents().get((int)i).getMax())));
        }
        values = (List)destination$iv$iv;
        var6_6 = space.getComponents().size();
        var7_8 = new float[var6_6];
        for (var5_20 = 0; var5_20 < var6_6; ++var5_20) {
            var8_10 = var5_20;
            v3 /* !! */  = var7_8;
            v4 = var8_10;
            var9_13 = values;
            v5 = 0 <= var8_10 ? var8_10 < var9_13.size() : false;
            if (v5) {
                v6 /* !! */  = var9_13.get(var8_10);
            } else {
                it = var8_10;
                var17_27 = v4;
                var16_25 = v3 /* !! */ ;
                $i$a$-getOrElse-CssParseKt$color$components$1$1 = false;
                var18_28 = Float.valueOf(0.0f);
                v3 /* !! */  = (float[])var16_25;
                v4 = var17_27;
                v6 /* !! */  = var18_28;
            }
            v3 /* !! */ [v4] = ((Number)v6 /* !! */ ).floatValue();
        }
        components = var7_8;
        components[ArraysKt.getLastIndex((float[])components)] = CssParseKt.alpha((String)match.getGroupValues().get(3));
        return space.create(components);
    }

    private static final Color rgb(MatchResult match) {
        float r = CssParseKt.percentOrNumber((String)match.getGroupValues().get(1), RGB.Companion.getComponents().get(0).getMax());
        float g = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), RGB.Companion.getComponents().get(1).getMax());
        float b = CssParseKt.percentOrNumber((String)match.getGroupValues().get(3), RGB.Companion.getComponents().get(2).getMax());
        float a = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return StringsKt.endsWith$default((String)((String)match.getGroupValues().get(1)), (String)"%", (boolean)false, (int)2, null) ? (Color)RGB.Companion.invoke(r, g, b, a) : (Color)RGB.Companion.invoke(r / 255.0f, g / 255.0f, b / 255.0f, a);
    }

    private static final Color hsl(MatchResult match) {
        float h = CssParseKt.hue((String)match.getGroupValues().get(1));
        float s = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), HSL.Companion.getComponents().get(1).getMax());
        float l = CssParseKt.percentOrNumber((String)match.getGroupValues().get(3), HSL.Companion.getComponents().get(2).getMax());
        float a = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return new HSL(h, s, l, a);
    }

    private static final Color lab(MatchResult match) {
        float l = CssParseKt.percentOrNumber((String)match.getGroupValues().get(1), LAB.Companion.getComponents().get(0).getMax());
        float a = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), LAB.Companion.getComponents().get(1).getMax());
        float b = CssParseKt.percentOrNumber((String)match.getGroupValues().get(3), LAB.Companion.getComponents().get(2).getMax());
        float alpha = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return LABColorSpaces.INSTANCE.getLAB50().invoke(l, a, b, alpha);
    }

    private static final Color lch(MatchResult match) {
        float l = CssParseKt.percentOrNumber((String)match.getGroupValues().get(1), LCHab.Companion.getComponents().get(0).getMax());
        float c = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), LCHab.Companion.getComponents().get(1).getMax());
        float h = CssParseKt.hue((String)match.getGroupValues().get(3));
        float a = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return LCHabColorSpaces.INSTANCE.getLCHab50().invoke(l, c, h, a);
    }

    private static final Color hwb(MatchResult match) {
        float h = CssParseKt.hue((String)match.getGroupValues().get(1));
        float w = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), HWB.Companion.getComponents().get(1).getMax());
        float b = CssParseKt.percentOrNumber((String)match.getGroupValues().get(3), HWB.Companion.getComponents().get(2).getMax());
        float a = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return new HWB(h, w, b, a);
    }

    private static final Color oklab(MatchResult match) {
        float l = CssParseKt.percentOrNumber((String)match.getGroupValues().get(1), Oklab.Companion.getComponents().get(0).getMax());
        float a = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), Oklab.Companion.getComponents().get(1).getMax());
        float b = CssParseKt.percentOrNumber((String)match.getGroupValues().get(3), Oklab.Companion.getComponents().get(2).getMax());
        float alpha = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return new Oklab(l, a, b, alpha);
    }

    private static final Color oklch(MatchResult match) {
        float l = CssParseKt.percentOrNumber((String)match.getGroupValues().get(1), Oklch.Companion.getComponents().get(0).getMax());
        float c = CssParseKt.percentOrNumber((String)match.getGroupValues().get(2), Oklch.Companion.getComponents().get(1).getMax());
        float h = CssParseKt.hue((String)match.getGroupValues().get(3));
        float a = CssParseKt.alpha((String)match.getGroupValues().get(4));
        return new Oklch(l, c, h, a);
    }

    private static final float number(String str) {
        return Intrinsics.areEqual((Object)str, (Object)"none") ? Float.NaN : Float.parseFloat(str);
    }

    private static final float percentOrNumber(String str, float max) {
        return StringsKt.endsWith$default((String)str, (String)"%", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.dropLast((String)str, (int)1)) * max / 100.0f : CssParseKt.number(str);
    }

    private static final float alpha(String str) {
        return RangesKt.coerceIn((float)(((CharSequence)str).length() == 0 ? 1.0f : CssParseKt.percentOrNumber(str, 1.0f)), (float)0.0f, (float)1.0f);
    }

    private static final float hue(String str) {
        return InternalMathKt.normalizeDeg(StringsKt.endsWith$default((String)str, (String)"deg", (boolean)false, (int)2, null) ? Float.parseFloat(StringsKt.dropLast((String)str, (int)3)) : (StringsKt.endsWith$default((String)str, (String)"grad", (boolean)false, (int)2, null) ? InternalMathKt.gradToDeg(Float.parseFloat(StringsKt.dropLast((String)str, (int)4))) : (StringsKt.endsWith$default((String)str, (String)"rad", (boolean)false, (int)2, null) ? InternalMathKt.radToDeg(Float.parseFloat(StringsKt.dropLast((String)str, (int)3))) : (StringsKt.endsWith$default((String)str, (String)"turn", (boolean)false, (int)2, null) ? InternalMathKt.turnToDeg(Float.parseFloat(StringsKt.dropLast((String)str, (int)4))) : CssParseKt.number(str)))));
    }

    @JvmOverloads
    @NotNull
    public static final Color parse(@NotNull Color.Companion $this$parse, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return CssParseKt.parse$default($this$parse, color, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public static final Color parseOrNull(@NotNull Color.Companion $this$parseOrNull, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)$this$parseOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return CssParseKt.parseOrNull$default($this$parseOrNull, color, null, 2, null);
    }
}

