/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J1\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/github/ajalt/colormath/model/Oklch;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/HueColor;", "l", "", "c", "h", "alpha", "<init>", "(FFFF)V", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getL", "()F", "getC", "getH", "getAlpha", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toOklab", "Lcom/github/ajalt/colormath/model/Oklab;", "toOklch", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nOklch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oklch.kt\ncom/github/ajalt/colormath/model/Oklch\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,50:1\n37#2,4:51\n135#3,12:55\n*S KotlinDebug\n*F\n+ 1 Oklch.kt\ncom/github/ajalt/colormath/model/Oklch\n*L\n45#1:51,4\n48#1:55,12\n*E\n"})
public final class Oklch
implements Color,
HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float c;
    private final float h;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components;

    public Oklch(float l, float c, float h, float alpha) {
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
    }

    public /* synthetic */ Oklch(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getL() {
        return this.l;
    }

    public final float getC() {
        return this.c;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public Oklch(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        Intrinsics.checkNotNullParameter((Object)alpha, (String)"alpha");
        this(l.floatValue(), c.floatValue(), h.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ Oklch(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<Oklch> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toOklab().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toOklab().toXYZ();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Oklab toOklab() {
        void b;
        void b$iv;
        void c$iv;
        float f = this.c;
        float h$iv = this.getH();
        boolean $i$f$fromPolarModel = false;
        float hDegrees$iv = Float.isNaN(h$iv) ? 0.0f : InternalMathKt.degToRad(h$iv);
        void a$iv = c$iv * (float)Math.cos(hDegrees$iv);
        void var7_7 = b$iv = c$iv * (float)Math.sin(hDegrees$iv);
        void a = a$iv;
        boolean bl = false;
        return new Oklab(this.l, (float)a, (float)b, this.getAlpha());
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.c, this.getH(), this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Oklch clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clampTrailingHue$iv;
        Color color2 = this;
        float f = this.l;
        float f2 = this.c;
        float f3 = this.getH();
        float alpha$iv = this.getAlpha();
        boolean $i$f$clampTrailingHue = false;
        List<ColorComponentInfo> list = $this$clampTrailingHue$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clampTrailingHue$iv;
                        return (Oklch)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn((float)alpha$iv, (float)0.0f, (float)1.0f);
        void var13_13 = v3$iv % (float)360;
        float f6 = RangesKt.coerceIn((float)v2$iv, (float)c2$iv.getMin(), (float)c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, (float)c1$iv.getMin(), (float)c1$iv.getMax());
        boolean bl5 = false;
        color = this.copy(p0, (float)p1, (float)p2, (float)p3);
        return (Oklch)color;
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.c;
    }

    public final float component3() {
        return this.h;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final Oklch copy(float l, float c, float h, float alpha) {
        return new Oklch(l, c, h, alpha);
    }

    public static /* synthetic */ Oklch copy$default(Oklch oklch, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = oklch.l;
        }
        if ((n & 2) != 0) {
            f2 = oklch.c;
        }
        if ((n & 4) != 0) {
            f3 = oklch.h;
        }
        if ((n & 8) != 0) {
            f4 = oklch.alpha;
        }
        return oklch.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Oklch(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.l);
        result = result * 31 + Float.hashCode(this.c);
        result = result * 31 + Float.hashCode(this.h);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Oklch)) {
            return false;
        }
        Oklch oklch = (Oklch)other;
        if (Float.compare(this.l, oklch.l) != 0) {
            return false;
        }
        if (Float.compare(this.c, oklch.c) != 0) {
            return false;
        }
        if (Float.compare(this.h, oklch.h) != 0) {
            return false;
        }
        return Float.compare(this.alpha, oklch.alpha) == 0;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    static {
        ColorComponentInfo[] colorComponentInfoArray = new ColorComponentInfo[]{new ColorComponentInfo("l", false, 0.0f, 1.0f), new ColorComponentInfo("c", false, 0.0f, 0.4f), new ColorComponentInfo("h", true, 0.0f, 360.0f)};
        components = ColorSpaceUtilsKt.componentInfoList(colorComponentInfoArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/colormath/model/Oklch$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/Oklch;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nOklch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oklch.kt\ncom/github/ajalt/colormath/model/Oklch$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n26#2:51\n15#2,13:52\n1#3:65\n*S KotlinDebug\n*F\n+ 1 Oklch.kt\ncom/github/ajalt/colormath/model/Oklch$Companion\n*L\n35#1:51\n35#1:52,13\n35#1:65\n*E\n"})
    public static final class Companion
    implements ColorSpace<Oklch> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "Oklch";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public Oklch convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return color.toOklch();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Oklch create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 < fArray.length) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (Oklch)((Color)new Oklch(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

