/*
 * Decompiled with CFR 0.152.
 */
package dev.mosaify.core.parser.snyk;

import dev.mosaify.core.model.Named;
import dev.mosaify.core.model.generic.Component;
import dev.mosaify.core.model.generic.CvssInfo;
import dev.mosaify.core.model.generic.Issue;
import dev.mosaify.core.model.generic.IssueFlag;
import dev.mosaify.core.model.generic.IssueSeverity;
import dev.mosaify.core.model.generic.IssueType;
import dev.mosaify.core.model.generic.ReportKt;
import dev.mosaify.core.model.metadata.RunExtraInfo;
import dev.mosaify.core.model.report.ReportParser;
import dev.mosaify.core.model.sarif.ReportingDescriptor;
import dev.mosaify.core.model.sarif.Result;
import dev.mosaify.core.model.sarif.Run;
import dev.mosaify.core.model.sarif.ToolComponent;
import dev.mosaify.core.model.scanner.ScanTarget;
import dev.mosaify.core.model.taxonomy.IssueTaxonomy;
import dev.mosaify.core.model.taxonomy.TargetType;
import dev.mosaify.core.parser.sarif.ParserSarifGeneric;
import dev.mosaify.core.parser.snyk.Utils;
import dev.mosaify.core.parser.snyk.model.Reference;
import dev.mosaify.core.parser.snyk.model.Severity;
import dev.mosaify.core.parser.snyk.model.SnykError;
import dev.mosaify.core.parser.snyk.model.SnykJsonResult;
import dev.mosaify.core.parser.snyk.model.Vulnerability;
import dev.mosaify.core.parser.snyk.model.sarif.SnykSarifPropertyBag;
import dev.mosaify.core.parser.snyk.model.serialization.SnykJsonResultListSerializer;
import dev.mosaify.core.util.CommonUtils;
import dev.mosaify.core.util.logging.SarifLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\r\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J)\u0010\u0014\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J&\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ0\u0010\u001c\u001a\u0011\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0011\u00a2\u0006\u0002\b\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&J\"\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010)0(2\u0006\u0010*\u001a\u00020\u001bJ\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eH\u0096\u0001J\t\u0010,\u001a\u00020\u001bH\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006."}, d2={"Ldev/mosaify/core/parser/snyk/ParserSnyk;", "Ldev/mosaify/core/model/report/ReportParser;", "Ldev/mosaify/core/model/Named;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "<init>", "(Lio/github/oshai/kotlinlogging/KLogger;)V", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "parseToOriginal", "", "originalReport", "", "originalToGeneric", "", "Ldev/mosaify/core/model/generic/Issue;", "Lkotlinx/serialization/Serializable;", "Ldev/mosaify/core/model/generic/GenericReport;", "extraInfo", "Ldev/mosaify/core/model/metadata/RunExtraInfo;", "sarifToGeneric", "run", "Ldev/mosaify/core/model/sarif/Run;", "snykVulnerabilityToGeneric", "snykVulnerability", "Ldev/mosaify/core/parser/snyk/model/Vulnerability;", "path", "", "snykJsonResultToGeneric", "snykJsonResult", "Ldev/mosaify/core/parser/snyk/model/SnykJsonResult;", "snykJsonResultToGeneric$mosaify_parser_snyk", "snykSeverityToGeneric", "Ldev/mosaify/core/model/generic/IssueSeverity;", "snykSeverity", "Ldev/mosaify/core/parser/snyk/model/Severity;", "detectSnykTool", "toolComponent", "Ldev/mosaify/core/model/sarif/ToolComponent;", "parseFullDescription", "Lkotlin/Pair;", "", "fullDescription", "getAllNames", "getName", "Companion", "mosaify-parser-snyk"})
@SourceDebugExtension(value={"SMAP\nParserSnyk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParserSnyk.kt\ndev/mosaify/core/parser/snyk/ParserSnyk\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,303:1\n222#2:304\n1740#3,3:305\n1374#3:308\n1460#3,5:309\n1563#3:314\n1634#3,2:315\n1617#3,9:319\n1869#3:328\n1870#3:330\n1626#3:331\n1636#3:332\n1563#3:337\n1634#3,3:338\n1563#3:341\n1634#3,3:342\n1563#3:345\n1634#3,2:346\n1563#3:348\n1634#3,3:349\n1636#3:352\n1#4:317\n1#4:329\n335#5:318\n126#6:333\n153#6,3:334\n*S KotlinDebug\n*F\n+ 1 ParserSnyk.kt\ndev/mosaify/core/parser/snyk/ParserSnyk\n*L\n58#1:304\n80#1:305,3\n80#1:308\n80#1:309,5\n92#1:314\n92#1:315,2\n111#1:319,9\n111#1:328\n111#1:330\n111#1:331\n92#1:332\n173#1:337\n173#1:338,3\n211#1:341\n211#1:342,3\n216#1:345\n216#1:346,2\n217#1:348\n217#1:349,3\n216#1:352\n111#1:329\n96#1:318\n166#1:333\n166#1:334,3\n*E\n"})
public final class ParserSnyk
implements ReportParser,
Named {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ Companion $$delegate_0;
    @NotNull
    private final KLogger logger;
    @NotNull
    private static final List<String> scannerNames;
    @NotNull
    private static final String SNYK_CONTAINER_NAME = "Snyk Container";
    @NotNull
    private static final String SNYK_OPEN_SOURCE_NAME = "Snyk Open Source";

    public ParserSnyk(@NotNull KLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.$$delegate_0 = Companion;
        this.logger = logger;
    }

    public /* synthetic */ ParserSnyk(KLogger kLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger("Parser for '" + CollectionsKt.first(scannerNames) + "'");
        }
        this(kLogger);
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object parseToOriginal(@NotNull byte[] originalReport) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
        String reportString = StringsKt.decodeToString((byte[])originalReport);
        boolean bl = false;
        try {
            object = CommonUtils.INSTANCE.getDefaultJson().decodeFromString((DeserializationStrategy)SnykJsonResultListSerializer.INSTANCE, reportString);
        }
        catch (SerializationException ex) {
            SnykError snykError;
            this.logger.debug(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), ParserSnyk::parseToOriginal$lambda$0$0);
            try {
                void this_$iv;
                Json json = CommonUtils.INSTANCE.getDefaultJson();
                String string$iv = reportString;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                SnykError snykError2 = (SnykError)this_$iv.decodeFromString((DeserializationStrategy)SnykError.Companion.serializer(), string$iv);
                this.logger.error(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ParserSnyk.parseToOriginal$lambda$0$1(snykError2));
                snykError = snykError2;
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException("Report not recognized", ex);
            }
            object = snykError;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Issue> originalToGeneric(@NotNull Object originalReport, @Nullable RunExtraInfo extraInfo) {
        void $this$flatMapTo$iv$iv;
        Object object;
        boolean bl;
        Collection collection;
        block5: {
            Intrinsics.checkNotNullParameter((Object)originalReport, (String)"originalReport");
            if (originalReport instanceof SnykError) {
                this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), ParserSnyk::originalToGeneric$lambda$0);
                collection = ReportKt.getEMPTY_REPORT();
                return collection;
            }
            if (!(originalReport instanceof Collection)) throw new IllegalArgumentException("Report not recognized");
            Iterable $this$all$iv = (Iterable)originalReport;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                object = $this$all$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = object.next();
                    boolean bl2 = false;
                    if (it instanceof SnykJsonResult) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) throw new IllegalArgumentException("Report not recognized");
        Iterable $this$flatMap$iv = (Iterable)originalReport;
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl3 = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type dev.mosaify.core.parser.snyk.model.SnykJsonResult");
            Iterable list$iv$iv = this.snykJsonResultToGeneric$mosaify_parser_snyk((SnykJsonResult)it, extraInfo);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Issue> sarifToGeneric(@NotNull Run run, @Nullable RunExtraInfo extraInfo) {
        Collection collection;
        block27: {
            block23: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)run, (String)"run");
                List list = run.getResults();
                if (list == null) break block23;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object object;
                    ReportingDescriptor reportingDescriptor;
                    ReportingDescriptor reportingDescriptor2;
                    IssueSeverity issueSeverity;
                    Set components;
                    Set identifiers;
                    Set references;
                    String ruleHelpMarkdownPlain;
                    String ruleFullDescription;
                    ReportingDescriptor sarifRule;
                    void sarifResult;
                    Collection collection2;
                    block24: {
                        Object object2;
                        Object object3;
                        String component;
                        block26: {
                            block25: {
                                void $this$mapNotNullTo$iv$iv;
                                String help;
                                String string;
                                SnykSarifPropertyBag snykSarifPropertyBag;
                                Object[] $this$decodeFromJsonElement$iv;
                                JsonObject jsonObject;
                                ReportingDescriptor it;
                                Result result = (Result)item$iv$iv;
                                collection2 = destination$iv$iv;
                                boolean bl = false;
                                Set set = run.getTool().getDriver().getRules();
                                if (set != null) {
                                    Object v2;
                                    block22: {
                                        Iterable iterable2 = set;
                                        for (Object t : iterable2) {
                                            it = (ReportingDescriptor)t;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)sarifResult.getRuleId())) continue;
                                            v2 = t;
                                            break block22;
                                        }
                                        v2 = null;
                                    }
                                    v3 = v2;
                                } else {
                                    v3 = sarifRule = null;
                                }
                                if (sarifRule != null && (jsonObject = sarifRule.getProperties()) != null) {
                                    JsonObject it2 = jsonObject;
                                    boolean bl3 = false;
                                    it = CommonUtils.INSTANCE.getDefaultJson();
                                    JsonElement json$iv = (JsonElement)it2;
                                    boolean $i$f$decodeFromJsonElement = false;
                                    $this$decodeFromJsonElement$iv.getSerializersModule();
                                    snykSarifPropertyBag = (SnykSarifPropertyBag)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.getNullable(SnykSarifPropertyBag.Companion.serializer()), json$iv);
                                } else {
                                    snykSarifPropertyBag = null;
                                }
                                SnykSarifPropertyBag propertyBag = snykSarifPropertyBag;
                                ReportingDescriptor reportingDescriptor3 = sarifRule;
                                String string2 = ruleFullDescription = reportingDescriptor3 != null && (reportingDescriptor3 = reportingDescriptor3.getFullDescription()) != null ? reportingDescriptor3.getText() : null;
                                Object object4 = sarifRule;
                                if (object4 != null && (object4 = object4.getHelp()) != null && (object4 = object4.getMarkdown()) != null) {
                                    Object it3 = object4;
                                    boolean bl4 = false;
                                    string = CommonUtils.markdownToPlainText$default((CommonUtils)CommonUtils.INSTANCE, (String)it3, null, (int)2, null);
                                } else {
                                    string = null;
                                }
                                ruleHelpMarkdownPlain = string;
                                references = CollectionsKt.toMutableSet((Iterable)ParserSarifGeneric.INSTANCE.getReferences((Result)sarifResult, sarifRule));
                                $this$decodeFromJsonElement$iv = new String[]{sarifResult.getRuleId()};
                                identifiers = SetsKt.mutableSetOf((Object[])$this$decodeFromJsonElement$iv);
                                components = new LinkedHashSet();
                                if (ruleFullDescription == null) break block24;
                                boolean bl5 = false;
                                issueSeverity = this.parseFullDescription(help);
                                component = (String)issueSeverity.component1();
                                Set ids = (Set)issueSeverity.component2();
                                if (ids != null) {
                                    Set it4;
                                    boolean bl6 = false;
                                    identifiers.addAll(it4);
                                }
                                if ((object3 = propertyBag) == null || (object3 = ((SnykSarifPropertyBag)object3).getTags()) == null) break block25;
                                Iterable $this$mapNotNull$iv = (Iterable)object3;
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable3 = $this$mapNotNull$iv;
                                Collection destination$iv$iv2 = new ArrayList();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    String it$iv$iv;
                                    Object element$iv$iv$iv;
                                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl7 = false;
                                    String tag = (String)element$iv$iv;
                                    boolean bl8 = false;
                                    if (CommonUtils.INSTANCE.detectPurlType(tag) == null) continue;
                                    boolean bl9 = false;
                                    destination$iv$iv2.add(it$iv$iv);
                                }
                                List purlTypes = (List)destination$iv$iv2;
                                boolean bl10 = false;
                                if (purlTypes.size() > 2) {
                                    this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ParserSnyk.sarifToGeneric$lambda$0$3$2$0(purlTypes));
                                }
                                String string3 = purlTypes.isEmpty() ? null : (String)CollectionsKt.last((List)purlTypes);
                                object3 = string3;
                                if (string3 != null) break block26;
                            }
                            object3 = "generic";
                        }
                        Object detectedType = object3;
                        String purl = "pkg:" + (String)detectedType + "/" + StringsKt.replace$default((String)component, (char)':', (char)'/', (boolean)false, (int)4, null);
                        Collection collection3 = components;
                        Object object5 = this;
                        String string = component;
                        try {
                            ParserSnyk $this$sarifToGeneric_u24lambda_u240_u243_u243 = object5;
                            boolean bl = false;
                            object2 = kotlin.Result.constructor-impl((Object)CommonUtils.INSTANCE.normalizePurl(purl));
                        }
                        catch (Throwable throwable) {
                            object2 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object5 = object2;
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 4;
                        Set set = null;
                        String string4 = (String)(kotlin.Result.isFailure-impl((Object)object5) ? null : object5);
                        String string5 = string;
                        collection3.add(new Component(string5, string4, set, n, defaultConstructorMarker));
                    }
                    if (sarifResult.getRuleId() != null) {
                        String it;
                        boolean bl = false;
                        if (StringsKt.startsWith((String)it, (String)"SNYK-", (boolean)true)) {
                            ((Collection)references).add("https://security.snyk.io/vuln/" + it);
                        }
                    }
                    if ((reportingDescriptor2 = sarifRule) != null && (reportingDescriptor2 = reportingDescriptor2.getProperties()) != null) {
                        ReportingDescriptor it = reportingDescriptor2;
                        boolean bl = false;
                        identifiers.addAll(IssueTaxonomy.Companion.processJsonObjectForIds((JsonObject)it));
                    }
                    IssueType issueType = IssueType.COMPONENT_VULNERABILITY;
                    Set set = SetsKt.setOf((Object)this.detectSnykTool(run.getTool().getDriver()));
                    String string = ruleFullDescription;
                    if (string == null && ((reportingDescriptor = sarifRule) != null && (reportingDescriptor = reportingDescriptor.getShortDescription()) != null ? reportingDescriptor.getText() : (string = null)) == null && (string = sarifResult.getRuleId()) == null) {
                        object = "Failed to get Snyk SARIF Summary";
                        throw new NotImplementedError("An operation is not implemented: " + (String)object);
                    }
                    String string6 = string;
                    issueSeverity = ParserSarifGeneric.INSTANCE.sarifLevelToSeverity(sarifResult.getLevel());
                    Set set2 = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)identifiers));
                    object = ParserSarifGeneric.INSTANCE.getLocations((Result)sarifResult, extraInfo);
                    collection2.add(new Issue(string6, set, null, ruleHelpMarkdownPlain, issueType, issueSeverity, null, null, null, set2, references, null, (Set)object, components, null, 18884, null));
                }
                collection = (List)destination$iv$iv;
                break block27;
            }
            collection = ReportKt.getEMPTY_REPORT();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Issue snykVulnerabilityToGeneric(@NotNull Vulnerability snykVulnerability, @Nullable RunExtraInfo extraInfo, @Nullable String path) {
        Collection collection;
        Object object;
        void it;
        IssueFlag issueFlag;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)snykVulnerability, (String)"snykVulnerability");
        Double cvssScore = snykVulnerability.getCvssScore();
        List<String> fixedIn = snykVulnerability.getFixedIn();
        String purl = Utils.INSTANCE.toPurlString(snykVulnerability);
        IssueSeverity issueSeverity = this.snykSeverityToGeneric(snykVulnerability.getSeverity());
        String string = purl + " - " + snykVulnerability.getTitle();
        Object object4 = extraInfo;
        if (object4 == null || (object4 = object4.getScanner()) == null) {
            object4 = this.detectSnykTool(snykVulnerability);
        }
        Set set = SetsKt.setOf((Object)object4);
        IssueType issueType = IssueType.COMPONENT_VULNERABILITY;
        CvssInfo cvssInfo = snykVulnerability.getIdentifiers();
        Object[] objectArray = SetsKt.setOf((Object)snykVulnerability.getId());
        boolean $i$f$map = false;
        Set set2 = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        Object object5 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (object5.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = object5.next();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Set)it2.getValue());
        }
        Set set3 = SetsKt.plus((Set)objectArray, (Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        cvssInfo = cvssScore != null ? new CvssInfo(cvssScore.doubleValue(), snykVulnerability.getCVSSv3()) : null;
        String string2 = CommonUtils.markdownToPlainText$default((CommonUtils)CommonUtils.INSTANCE, (String)snykVulnerability.getDescription(), null, (int)2, null);
        destination$iv$iv = snykVulnerability.getReferences();
        objectArray = SetsKt.setOf((Object)("https://security.snyk.io/vuln/" + snykVulnerability.getId()));
        boolean $i$f$map2 = false;
        object5 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void reference;
            Reference reference2 = (Reference)item$iv$iv;
            collection2 = destination$iv$iv22;
            boolean bl = false;
            collection2.add(reference.getUrl());
        }
        set2 = SetsKt.plus((Set)objectArray, (Iterable)((List)destination$iv$iv22));
        Object[] objectArray2 = object3 = new IssueFlag[2];
        int n = 0;
        Boolean bl = snykVulnerability.isUpgradable();
        if (bl != null) {
            void it3;
            $i$f$mapTo2 = bl;
            int n2 = n;
            objectArray = objectArray2;
            boolean bl2 = false;
            object2 = it3 != false ? IssueFlag.FIXABLE : null;
            objectArray2 = objectArray;
            n = n2;
            issueFlag = object2;
        } else {
            issueFlag = null;
        }
        objectArray2[n] = issueFlag;
        boolean destination$iv$iv22 = snykVulnerability.isDisputed();
        int n3 = 1;
        objectArray = object3;
        boolean bl3 = false;
        objectArray[n3] = object2 = it != false ? IssueFlag.DISPUTED : null;
        Set set4 = SetsKt.setOfNotNull((Object[])object3);
        object5 = this;
        object2 = purl;
        try {
            ParserSnyk $this$snykVulnerabilityToGeneric_u24lambda_u244 = (ParserSnyk)object5;
            boolean bl4 = false;
            object = kotlin.Result.constructor-impl((Object)CommonUtils.INSTANCE.normalizePurl(purl));
        }
        catch (Throwable throwable) {
            object = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object5 = object;
        String string3 = (String)(kotlin.Result.isFailure-impl((Object)object5) ? null : object5);
        object5 = fixedIn;
        Set set5 = !(object5 == null || object5.isEmpty()) ? CollectionsKt.toSet((Iterable)fixedIn) : null;
        String string4 = string3;
        Object object6 = object2;
        object3 = SetsKt.setOf((Object)new Component((String)object6, string4, set5));
        object5 = SetsKt.setOfNotNull(snykVulnerability.getFrom());
        RunExtraInfo runExtraInfo = extraInfo;
        Collection collection3 = SetsKt.setOfNotNull((Object)(runExtraInfo != null ? runExtraInfo.getTarget() : null));
        if (collection3.isEmpty()) {
            boolean bl5 = false;
            collection = null;
        } else {
            collection = collection3;
        }
        object = (Set)collection;
        return new Issue(string, set, null, string2, issueType, issueSeverity, cvssInfo, (Set)object, null, set3, set2, set4, null, (Set)object3, (Set)object5, 4356, null);
    }

    public static /* synthetic */ Issue snykVulnerabilityToGeneric$default(ParserSnyk parserSnyk, Vulnerability vulnerability, RunExtraInfo runExtraInfo, String string, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return parserSnyk.snykVulnerabilityToGeneric(vulnerability, runExtraInfo, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Issue> snykJsonResultToGeneric$mosaify_parser_snyk(@NotNull SnykJsonResult snykJsonResult, @Nullable RunExtraInfo extraInfo) {
        List list;
        List snykContainerIssues;
        block9: {
            block8: {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)snykJsonResult, (String)"snykJsonResult");
                Object object = extraInfo;
                if (object == null || (object = object.getScanner()) == null) {
                    object = this.detectSnykTool(snykJsonResult);
                }
                Object scanner = object;
                ScanTarget target = new ScanTarget(snykJsonResult.getPath(), StringsKt.startsWith((String)snykJsonResult.getProjectName(), (String)"docker-image|", (boolean)true) ? TargetType.CONTAINER_IMAGE : TargetType.DIRECTORY);
                RunExtraInfo runExtraInfo = extraInfo;
                if (runExtraInfo == null || (runExtraInfo = RunExtraInfo.copy$default((RunExtraInfo)runExtraInfo, null, (String)scanner, null, (int)5, null)) == null) {
                    runExtraInfo = new RunExtraInfo(target, (String)scanner, null, 4, null);
                }
                RunExtraInfo extraInfoUpdated = runExtraInfo;
                Iterable $this$map$iv = snykJsonResult.getVulnerabilities();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Vulnerability vulnerability = (Vulnerability)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.snykVulnerabilityToGeneric((Vulnerability)it, extraInfoUpdated, snykJsonResult.getPath()));
                }
                snykContainerIssues = (List)destination$iv$iv;
                list = snykJsonResult.getApplications();
                if (list == null) break block8;
                Iterable $this$map$iv2 = list;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv3;
                    void snykApp;
                    SnykJsonResult snykJsonResult2 = (SnykJsonResult)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    Iterable $this$map$iv3 = snykApp.getVulnerabilities();
                    boolean $i$f$map3 = false;
                    Iterable iterable3 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                        void it;
                        Vulnerability vulnerability = (Vulnerability)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl2 = false;
                        collection2.add(this.snykVulnerabilityToGeneric((Vulnerability)it, extraInfoUpdated, snykApp.getPath()));
                    }
                    collection.add((List)destination$iv$iv3);
                }
                list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
                if (list != null) break block9;
            }
            list = CollectionsKt.emptyList();
        }
        List snykOpenSourceIssues = list;
        return CollectionsKt.plus((Collection)snykContainerIssues, (Iterable)snykOpenSourceIssues);
    }

    public static /* synthetic */ Collection snykJsonResultToGeneric$mosaify_parser_snyk$default(ParserSnyk parserSnyk, SnykJsonResult snykJsonResult, RunExtraInfo runExtraInfo, int n, Object object) {
        if ((n & 2) != 0) {
            runExtraInfo = null;
        }
        return parserSnyk.snykJsonResultToGeneric$mosaify_parser_snyk(snykJsonResult, runExtraInfo);
    }

    @NotNull
    public final IssueSeverity snykSeverityToGeneric(@NotNull Severity snykSeverity) {
        Intrinsics.checkNotNullParameter((Object)((Object)snykSeverity), (String)"snykSeverity");
        return switch (WhenMappings.$EnumSwitchMapping$0[snykSeverity.ordinal()]) {
            case 1 -> IssueSeverity.CRITICAL;
            case 2 -> IssueSeverity.HIGH;
            case 3 -> IssueSeverity.MEDIUM;
            case 4 -> IssueSeverity.LOW;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String detectSnykTool(@NotNull Vulnerability snykVulnerability) {
        Intrinsics.checkNotNullParameter((Object)snykVulnerability, (String)"snykVulnerability");
        this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), ParserSnyk::detectSnykTool$lambda$0);
        return Intrinsics.areEqual((Object)snykVulnerability.getLanguage(), (Object)"linux") ? SNYK_CONTAINER_NAME : (StringsKt.startsWith((String)snykVulnerability.getPackageManager(), (String)"debian", (boolean)true) ? SNYK_CONTAINER_NAME : (StringsKt.startsWith((String)snykVulnerability.getPackageManager(), (String)"ubuntu", (boolean)true) ? SNYK_CONTAINER_NAME : (StringsKt.startsWith((String)snykVulnerability.getPackageManager(), (String)"alpine", (boolean)true) ? SNYK_CONTAINER_NAME : (StringsKt.startsWith((String)snykVulnerability.getPackageManager(), (String)"rhel", (boolean)true) ? SNYK_CONTAINER_NAME : (StringsKt.contentEquals((CharSequence)snykVulnerability.getPackageManager(), (CharSequence)"upstream", (boolean)true) ? SNYK_CONTAINER_NAME : SNYK_OPEN_SOURCE_NAME)))));
    }

    @NotNull
    public final String detectSnykTool(@NotNull SnykJsonResult snykJsonResult) {
        Intrinsics.checkNotNullParameter((Object)snykJsonResult, (String)"snykJsonResult");
        return snykJsonResult.getDocker() != null || snykJsonResult.getApplications() != null || StringsKt.startsWith((String)snykJsonResult.getProjectName(), (String)"docker-image|", (boolean)true) ? SNYK_CONTAINER_NAME : SNYK_OPEN_SOURCE_NAME;
    }

    @NotNull
    public final String detectSnykTool(@NotNull ToolComponent toolComponent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)toolComponent, (String)"toolComponent");
        String string2 = toolComponent.getName().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String string3 = string2;
        String string4 = SNYK_CONTAINER_NAME.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        if (Intrinsics.areEqual((Object)string3, (Object)string4)) {
            string = SNYK_CONTAINER_NAME;
        } else {
            String string5 = SNYK_OPEN_SOURCE_NAME.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)string3, (Object)string5)) {
                string = SNYK_OPEN_SOURCE_NAME;
            } else {
                this.logger.warn(null, SarifLogger.Marker.INSTANCE.getEXECUTION(), () -> ParserSnyk.detectSnykTool$lambda$1(this, toolComponent));
                string = toolComponent.getName();
            }
        }
        return string;
    }

    @NotNull
    public final Pair<String, Set<String>> parseFullDescription(@NotNull String fullDescription) {
        String[] stringArray;
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)fullDescription, (String)"fullDescription");
        String[] stringArray2 = new String[]{" "};
        List spaceSplit = StringsKt.split$default((CharSequence)fullDescription, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (!(spaceSplit.size() <= 2)) {
            boolean bl = false;
            String string2 = "Unexpected `fullDescription`: '" + fullDescription + "' (more than 2 parts split by space)";
            throw new IllegalArgumentException(string2.toString());
        }
        if (spaceSplit.size() > 1) {
            char[] cArray = new char[]{'(', ')'};
            string = StringsKt.trim((String)((String)CollectionsKt.first((List)spaceSplit)), (char[])cArray);
        } else {
            string = null;
        }
        String cvestring = string;
        return TuplesKt.to((Object)CollectionsKt.last((List)spaceSplit), (object = cvestring) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null);
    }

    @NotNull
    public String getName() {
        return this.$$delegate_0.getName();
    }

    @NotNull
    public Collection<String> getAllNames() {
        return this.$$delegate_0.getAllNames();
    }

    private static final Object parseToOriginal$lambda$0$0() {
        return "Didn't recognize Snyk report, checking if that's an error";
    }

    private static final Object parseToOriginal$lambda$0$1(SnykError $snykError) {
        return "Snyk error: " + $snykError.getError();
    }

    private static final Object originalToGeneric$lambda$0() {
        return "Processing Snyk Error into Generic. Returning 0 vulnerabilities";
    }

    private static final Object sarifToGeneric$lambda$0$3$2$0(List $purlTypes) {
        return "Detected more than 1 possible purl type: '" + CollectionsKt.joinToString$default((Iterable)$purlTypes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "', returning '" + CollectionsKt.last((List)$purlTypes) + "'";
    }

    private static final Object detectSnykTool$lambda$0() {
        return "Unexpected call to `detectSnykTool(snykVulnerability: Vulnerability)` - please create a support ticket and add the report sample for us to add a new feature";
    }

    private static final Object detectSnykTool$lambda$1(ParserSnyk this$0, ToolComponent $toolComponent) {
        return "Unexpected '" + this$0.getName() + "' SARIF name: '" + $toolComponent.getName() + "'. Will use it instead of '" + this$0.getName() + "'";
    }

    public ParserSnyk() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"Snyk", SNYK_OPEN_SOURCE_NAME, SNYK_CONTAINER_NAME};
        scannerNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/mosaify/core/parser/snyk/ParserSnyk$Companion;", "Ldev/mosaify/core/model/Named;", "<init>", "()V", "scannerNames", "", "", "getScannerNames", "()Ljava/util/List;", "SNYK_CONTAINER_NAME", "SNYK_OPEN_SOURCE_NAME", "getName", "getAllNames", "mosaify-parser-snyk"})
    public static final class Companion
    implements Named {
        private Companion() {
        }

        @NotNull
        public final List<String> getScannerNames() {
            return scannerNames;
        }

        @NotNull
        public String getName() {
            return (String)CollectionsKt.first(this.getScannerNames());
        }

        @NotNull
        public List<String> getAllNames() {
            return this.getScannerNames();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.LOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

