/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.internal.Shingle;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/aallam/similarity/Jaccard;", "", "k", "", "(I)V", "distance", "", "first", "", "second", "similarity", "string-similarity"})
public final class Jaccard {
    private final int k;

    public Jaccard(int k) {
        this.k = k;
    }

    public /* synthetic */ Jaccard(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    public final double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        Map<String, Integer> p1 = Shingle.Companion.profile(first, this.k);
        Map<String, Integer> p2 = Shingle.Companion.profile(second, this.k);
        Set union = SetsKt.plus(p1.keySet(), (Iterable)p2.keySet());
        int inter = p1.keySet().size() + p2.keySet().size() - union.size();
        return (double)inter / (double)union.size();
    }

    public final double distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return 1.0 - this.similarity(first, second);
    }

    public Jaccard() {
        this(0, 1, null);
    }
}

