/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.Match;
import com.aallam.similarity.StringMatchInfo;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00142\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/aallam/similarity/JaroWinkler;", "", "threshold", "", "(D)V", "commonPrefix", "", "min", "", "max", "computeStringMatch", "Lcom/aallam/similarity/StringMatchInfo;", "distance", "first", "second", "matchStrings", "Lcom/aallam/similarity/Match;", "similarity", "transpositions", "ms1", "", "ms2", "fill", "", "flags", "", "indexes", "", "Companion", "string-similarity"})
@SourceDebugExtension(value={"SMAP\nJaroWinkler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaroWinkler.kt\ncom/aallam/similarity/JaroWinkler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class JaroWinkler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double threshold;
    private static final double JW_SCALING_FACTOR = 0.1;

    public JaroWinkler(double threshold) {
        this.threshold = threshold;
    }

    public /* synthetic */ JaroWinkler(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.7;
        }
        this(d);
    }

    public final double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        Match match = this.matchStrings(first, second);
        float m = match.component1();
        int t = match.component2();
        int l = match.component3();
        double p = match.component4();
        if (m == 0.0f) {
            return 0.0;
        }
        double sj = (double)(m / (float)first.length() + m / (float)second.length() + (m - (float)t) / m) / 3.0;
        return sj > this.threshold ? sj + p * (double)l * (1.0 - sj) : sj;
    }

    public final double distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return 1.0 - this.similarity(first, second);
    }

    private final Match matchStrings(String first, String second) {
        char[] cArray;
        String min = (String)((Object)ComparisonsKt.minOf((Comparable)((Comparable)((Object)first)), (Comparable)((Comparable)((Object)second))));
        String max = (String)((Object)ComparisonsKt.maxOf((Comparable)((Comparable)((Object)first)), (Comparable)((Comparable)((Object)second))));
        StringMatchInfo stringMatchInfo = this.computeStringMatch(max, min);
        int[] matchIndexes = stringMatchInfo.component1();
        boolean[] matchFlags = stringMatchInfo.component2();
        int matches = stringMatchInfo.component3();
        char[] $this$matchStrings_u24lambda_u240 = cArray = new char[matches];
        boolean bl = false;
        this.fill($this$matchStrings_u24lambda_u240, min, matchIndexes);
        char[] ms1 = cArray;
        char[] $this$matchStrings_u24lambda_u241 = $this$matchStrings_u24lambda_u240 = new char[matches];
        boolean bl2 = false;
        this.fill($this$matchStrings_u24lambda_u241, max, matchFlags);
        char[] ms2 = $this$matchStrings_u24lambda_u240;
        int transpositions = this.transpositions(ms1, ms2);
        int prefix = this.commonPrefix(min, max);
        double scaling = Math.min(0.1, 1.0 / (double)max.length());
        return new Match(matches, transpositions, prefix, scaling);
    }

    private final StringMatchInfo computeStringMatch(String max, String min) {
        int n;
        int range = Math.max(max.length() / 2 - 1, 0);
        int n2 = 0;
        int n3 = min.length();
        int[] nArray = new int[n3];
        while (n2 < n3) {
            n = n2++;
            nArray[n] = -1;
        }
        int[] matchIndexes = nArray;
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        n = min.length();
        block1: for (int i = 0; i < n; ++i) {
            char c = min.charAt(i);
            int xn = Math.min(i + range + 1, max.length());
            for (int xi = Math.max(i - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c != max.charAt(xi)) continue;
                matchIndexes[i] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block1;
            }
        }
        return new StringMatchInfo(matchIndexes, matchFlags, matches);
    }

    private final void fill(char[] $this$fill, String max, boolean[] flags) {
        int si = 0;
        int n = max.length();
        for (int i = 0; i < n; ++i) {
            if (!flags[i]) continue;
            $this$fill[si] = max.charAt(i);
            ++si;
        }
    }

    private final void fill(char[] $this$fill, String min, int[] indexes) {
        int si = 0;
        int n = min.length();
        for (int i = 0; i < n; ++i) {
            if (indexes[i] == -1) continue;
            $this$fill[si] = min.charAt(i);
            ++si;
        }
    }

    private final int commonPrefix(String min, String max) {
        int prefix = 0;
        int n = min.length();
        for (int mi = 0; mi < n && min.charAt(mi) == max.charAt(mi); ++mi) {
            ++prefix;
        }
        return prefix;
    }

    private final int transpositions(char[] ms1, char[] ms2) {
        int transpositions = 0;
        int n = ms1.length;
        for (int mi = 0; mi < n; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        return transpositions / 2;
    }

    public JaroWinkler() {
        this(0.0, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/aallam/similarity/JaroWinkler$Companion;", "", "()V", "JW_SCALING_FACTOR", "", "string-similarity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

