/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.Levenshtein;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/aallam/similarity/NormalizedLevenshtein;", "", "()V", "levenshtein", "Lcom/aallam/similarity/Levenshtein;", "distance", "", "first", "", "second", "similarity", "lhs", "rhs", "string-similarity"})
public final class NormalizedLevenshtein {
    @NotNull
    private final Levenshtein levenshtein = new Levenshtein();

    public final double distance(@NotNull CharSequence first, @NotNull CharSequence second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        int maxLength = Math.max(first.length(), second.length());
        if (maxLength == 0) {
            return 0.0;
        }
        return (double)Levenshtein.distance$default(this.levenshtein, first, second, 0, 4, null) / (double)maxLength;
    }

    public final double similarity(@NotNull CharSequence lhs, @NotNull CharSequence rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        return 1.0 - this.distance(lhs, rhs);
    }
}

