/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/aallam/similarity/OptimalStringAlignment;", "", "()V", "distance", "", "first", "", "second", "string-similarity"})
public final class OptimalStringAlignment {
    public final int distance(@NotNull String first, @NotNull String second) {
        int j;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0;
        }
        int n = first.length();
        int m = second.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n2 = 0;
        int n3 = n + 2;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[m + 2];
        }
        int[][] distanceMatrix = nArrayArray;
        int i = 0;
        if (i <= n) {
            while (true) {
                distanceMatrix[i][0] = i;
                if (i == n) break;
                ++i;
            }
        }
        if ((j = 0) <= m) {
            while (true) {
                distanceMatrix[0][j] = j;
                if (j == m) break;
                ++j;
            }
        }
        if ((i = 1) <= n) {
            while (true) {
                int j2;
                if ((j2 = 1) <= m) {
                    while (true) {
                        int cost = first.charAt(i - 1) == second.charAt(j2 - 1) ? 0 : 1;
                        int substitution = distanceMatrix[i - 1][j2 - 1] + cost;
                        int insertion = distanceMatrix[i][j2 - 1] + 1;
                        int deletion = distanceMatrix[i - 1][j2] + 1;
                        distanceMatrix[i][j2] = Math.min(substitution, Math.min(insertion, deletion));
                        if (i > 1 && j2 > 1 && first.charAt(i - 1) == second.charAt(j2 - 2) && first.charAt(i - 2) == second.charAt(j2 - 1)) {
                            distanceMatrix[i][j2] = Math.min(distanceMatrix[i][j2], distanceMatrix[i - 2][j2 - 2] + cost);
                        }
                        if (j2 == m) break;
                        ++j2;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return distanceMatrix[n][m];
    }
}

