/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.internal.Shingle;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/aallam/similarity/SorensenDice;", "", "k", "", "(I)V", "getK", "()I", "distance", "", "first", "", "second", "similarity", "string-similarity"})
public final class SorensenDice {
    private final int k;

    public SorensenDice(int k) {
        this.k = k;
    }

    public /* synthetic */ SorensenDice(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    public final int getK() {
        return this.k;
    }

    public final double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        Map<String, Integer> profile1 = Shingle.Companion.profile(first, this.k);
        Map<String, Integer> profile2 = Shingle.Companion.profile(second, this.k);
        Set intersect = CollectionsKt.intersect((Iterable)profile1.keySet(), (Iterable)profile2.keySet());
        return 2.0 * (double)intersect.size() / (double)(profile1.size() + profile2.size());
    }

    public final double distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return 1.0 - this.similarity(first, second);
    }

    public SorensenDice() {
        this(0, 1, null);
    }
}

