/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.similarity;

import com.aallam.similarity.OperationsWeights;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/aallam/similarity/WeightedLevenshtein;", "", "weights", "Lcom/aallam/similarity/OperationsWeights;", "(Lcom/aallam/similarity/OperationsWeights;)V", "distance", "", "first", "", "second", "limit", "string-similarity"})
@SourceDebugExtension(value={"SMAP\nWeightedLevenshtein.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedLevenshtein.kt\ncom/aallam/similarity/WeightedLevenshtein\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,99:1\n1183#2,3:100\n*S KotlinDebug\n*F\n+ 1 WeightedLevenshtein.kt\ncom/aallam/similarity/WeightedLevenshtein\n*L\n24#1:100,3\n*E\n"})
public final class WeightedLevenshtein {
    @NotNull
    private final OperationsWeights weights;

    public WeightedLevenshtein(@NotNull OperationsWeights weights) {
        Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
        this.weights = weights;
    }

    /*
     * WARNING - void declaration
     */
    public final double distance(@NotNull CharSequence first, @NotNull CharSequence second, double limit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0.0;
        }
        if (first.length() == 0) {
            return second.length();
        }
        if (second.length() == 0) {
            return first.length();
        }
        double[] cost = null;
        cost = new double[first.length() + 1];
        double[] newCost = new double[first.length() + 1];
        CharSequence $this$forEachIndexed$iv = first;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            cost[i2 + 1] = cost[i2] + this.weights.insertion((char)char_);
        }
        int i = 1;
        int n = second.length();
        if (i <= n) {
            while (true) {
                char secondChar = second.charAt(i - 1);
                double deletionCost = this.weights.deletion(secondChar);
                newCost[0] = cost[0] + deletionCost;
                double minCost = newCost[0];
                int j = 1;
                int n2 = first.length();
                if (j <= n2) {
                    while (true) {
                        char firstChar;
                        double edit = (firstChar = first.charAt(j - 1)) == secondChar ? 0.0 : this.weights.substitution(firstChar, secondChar);
                        double replace = cost[j - 1] + edit;
                        double insert = cost[j] + this.weights.insertion(secondChar);
                        double delete = newCost[j - 1] + this.weights.deletion(firstChar);
                        newCost[j] = Math.min(insert, Math.min(delete, replace));
                        minCost = Math.min(minCost, newCost[j]);
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (minCost >= limit) {
                    return limit;
                }
                double[] swap = cost;
                cost = newCost;
                newCost = swap;
                if (i == n) break;
                ++i;
            }
        }
        return ArraysKt.last((double[])cost);
    }

    public static /* synthetic */ double distance$default(WeightedLevenshtein weightedLevenshtein, CharSequence charSequence, CharSequence charSequence2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = Double.MAX_VALUE;
        }
        return weightedLevenshtein.distance(charSequence, charSequence2, d);
    }
}

