/*
 * Decompiled with CFR 0.152.
 */
package io.konform.validation.types;

import io.konform.validation.Invalid;
import io.konform.validation.Valid;
import io.konform.validation.Validation;
import io.konform.validation.ValidationBuilder;
import io.konform.validation.ValidationResult;
import io.konform.validation.path.PathSegment;
import io.konform.validation.path.ValidationPath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BF\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012#\u0010\b\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R+\u0010\b\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/konform/validation/types/DynamicCallableValidation;", "T", "R", "Lio/konform/validation/Validation;", "path", "Lio/konform/validation/path/ValidationPath;", "callable", "Lkotlin/Function1;", "builder", "Lkotlin/Function2;", "Lio/konform/validation/ValidationBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/konform/validation/path/ValidationPath;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "validate", "Lio/konform/validation/ValidationResult;", "value", "(Ljava/lang/Object;)Lio/konform/validation/ValidationResult;", "konform"})
public final class DynamicCallableValidation<T, R>
implements Validation<T> {
    @NotNull
    private final ValidationPath path;
    @NotNull
    private final Function1<T, R> callable;
    @NotNull
    private final Function2<ValidationBuilder<R>, T, Unit> builder;

    public DynamicCallableValidation(@NotNull ValidationPath path, @NotNull Function1<? super T, ? extends R> callable, @NotNull Function2<? super ValidationBuilder<R>, ? super T, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.path = path;
        this.callable = callable;
        this.builder = builder;
    }

    @Override
    @NotNull
    public ValidationResult<T> validate(T value) {
        ValidationResult validationResult;
        ValidationBuilder validationBuilder;
        ValidationBuilder it = validationBuilder = new ValidationBuilder();
        boolean bl = false;
        this.builder.invoke(it, value);
        Validation<Object> validation = validationBuilder.build();
        Object toValidate = this.callable.invoke(value);
        ValidationResult<Object> callableResult = validation.invoke(toValidate);
        if (callableResult instanceof Valid) {
            validationResult = new Valid<T>(value);
        } else if (callableResult instanceof Invalid) {
            validationResult = ((Invalid)callableResult).prependPath(this.path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validationResult;
    }

    @Override
    @NotNull
    public ValidationResult<T> invoke(T value) {
        return Validation.DefaultImpls.invoke(this, value);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull ValidationPath path) {
        return Validation.DefaultImpls.prependPath(this, path);
    }

    @Override
    @NotNull
    public Validation<T> prependPath(@NotNull PathSegment pathSegment) {
        return Validation.DefaultImpls.prependPath(this, pathSegment);
    }
}

