@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem
@rem SPDX-License-Identifier: Apache-2.0
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  mosaify-cli startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and MOSAIFY_CLI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH. 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME% 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\mosaify-cli-0.1.0-SNAPSHOT.jar;%APP_HOME%\lib\mosaify-exporter-generic-jvm.jar;%APP_HOME%\lib\mosaify-exporter-sarif-jvm.jar;%APP_HOME%\lib\mosaify-guesswork-environment-jvm.jar;%APP_HOME%\lib\mosaify-guesswork-snykossrunner-jvm.jar;%APP_HOME%\lib\mosaify-scanner-anchore-grype-jvm.jar;%APP_HOME%\lib\mosaify-scanner-aquasecurity-trivy-jvm.jar;%APP_HOME%\lib\mosaify-scanner-docker-scout-jvm.jar;%APP_HOME%\lib\mosaify-scanner-jfrog-xray-jvm.jar;%APP_HOME%\lib\mosaify-scanner-semgrep-jvm.jar;%APP_HOME%\lib\mosaify-scanner-snyk-code-jvm.jar;%APP_HOME%\lib\mosaify-scanner-snyk-container-jvm.jar;%APP_HOME%\lib\mosaify-util-normalization-jvm.jar;%APP_HOME%\lib\mosaify-util-autoparser-jvm.jar;%APP_HOME%\lib\mosaify-guesswork-bomscanner-jvm.jar;%APP_HOME%\lib\mosaify-scanner-snyk-oss-jvm.jar;%APP_HOME%\lib\mosaify-util-container-jvm.jar;%APP_HOME%\lib\mosaify-util-compress-jvm.jar;%APP_HOME%\lib\mosaify-util-configfile-jvm.jar;%APP_HOME%\lib\mosaify-util-storage-jvm.jar;%APP_HOME%\lib\mosaify-parser-anchore-grype-jvm.jar;%APP_HOME%\lib\mosaify-parser-aquasecurity-trivy-jvm.jar;%APP_HOME%\lib\mosaify-parser-docker-scout-jvm.jar;%APP_HOME%\lib\mosaify-parser-jfrog-xray-jvm.jar;%APP_HOME%\lib\mosaify-parser-semgrep-jvm.jar;%APP_HOME%\lib\mosaify-parser-snyk-jvm.jar;%APP_HOME%\lib\mosaify-parser-sarif-generic-jvm.jar;%APP_HOME%\lib\mosaify-guesswork-common-jvm.jar;%APP_HOME%\lib\mosaify-util-platform-jvm.jar;%APP_HOME%\lib\mosaify-util-common-jvm.jar;%APP_HOME%\lib\kotlinx-html-jvm-0.12.0.jar;%APP_HOME%\lib\clikt-mordant-jvm.jar;%APP_HOME%\lib\mordant-coroutines-jvm.jar;%APP_HOME%\lib\mosaify-model-jvm.jar;%APP_HOME%\lib\kaml-jvm-0.94.0.jar;%APP_HOME%\lib\packageurl-basic-jvm-0.2.1.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.10.2.jar;%APP_HOME%\lib\kotlinx-datetime-jvm-0.7.1-0.6.x-compat.jar;%APP_HOME%\lib\kotlinx-io-core-jvm-0.8.0.jar;%APP_HOME%\lib\kotlinx-serialization-core-jvm-1.9.0.jar;%APP_HOME%\lib\kotlinx-serialization-json-jvm-1.9.0.jar;%APP_HOME%\lib\kotlin-logging-jvm-7.0.13.jar;%APP_HOME%\lib\markdown-jvm-0.7.3.jar;%APP_HOME%\lib\clikt-jvm.jar;%APP_HOME%\lib\mordant-omnibus-jvm.jar;%APP_HOME%\lib\mordant-jvm-jna-jvm.jar;%APP_HOME%\lib\mordant-jvm-ffm-jvm.jar;%APP_HOME%\lib\mordant-jvm-graal-ffi-jvm.jar;%APP_HOME%\lib\mordant-jvm.jar;%APP_HOME%\lib\string-similarity-jvm.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.8.10.jar;%APP_HOME%\lib\snakeyaml-engine-kmp-jvm-3.2.0.jar;%APP_HOME%\lib\okio-jvm-3.16.0.jar;%APP_HOME%\lib\konform-jvm-0.11.1.jar;%APP_HOME%\lib\urlencoder-lib-jvm-1.6.0.jar;%APP_HOME%\lib\kotlinx-io-bytestring-jvm-0.8.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.8.10.jar;%APP_HOME%\lib\colormath-jvm.jar;%APP_HOME%\lib\kotlin-stdlib-2.2.21.jar;%APP_HOME%\lib\org.eclipse.jgit-7.3.0.202506031305-r.jar;%APP_HOME%\lib\annotations-23.0.0.jar;%APP_HOME%\lib\commons-csv-1.14.1.jar;%APP_HOME%\lib\docker-java-core-3.6.0.jar;%APP_HOME%\lib\commons-compress-1.28.0.jar;%APP_HOME%\lib\JavaEWAH-1.2.3.jar;%APP_HOME%\lib\logback-classic-1.5.21.jar;%APP_HOME%\lib\docker-java-api-3.6.0.jar;%APP_HOME%\lib\docker-java-transport-httpclient5-3.6.0.jar;%APP_HOME%\lib\httpclient5-5.5.jar;%APP_HOME%\lib\slf4j-api-2.0.17.jar;%APP_HOME%\lib\commons-codec-1.19.0.jar;%APP_HOME%\lib\commons-io-2.20.0.jar;%APP_HOME%\lib\commons-lang3-3.18.0.jar;%APP_HOME%\lib\logback-core-1.5.21.jar;%APP_HOME%\lib\docker-java-transport-3.6.0.jar;%APP_HOME%\lib\jackson-annotations-2.19.2.jar;%APP_HOME%\lib\jackson-core-2.19.2.jar;%APP_HOME%\lib\jackson-databind-2.19.2.jar;%APP_HOME%\lib\guava-33.4.8-jre.jar;%APP_HOME%\lib\bcpkix-jdk18on-1.81.jar;%APP_HOME%\lib\jna-5.17.0.jar;%APP_HOME%\lib\failureaccess-1.0.3.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jspecify-1.0.0.jar;%APP_HOME%\lib\error_prone_annotations-2.36.0.jar;%APP_HOME%\lib\j2objc-annotations-3.0.0.jar;%APP_HOME%\lib\bcutil-jdk18on-1.81.jar;%APP_HOME%\lib\httpcore5-h2-5.3.4.jar;%APP_HOME%\lib\httpcore5-5.3.4.jar;%APP_HOME%\lib\bcprov-jdk18on-1.81.jar


@rem Execute mosaify-cli
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %MOSAIFY_CLI_OPTS%  -classpath "%CLASSPATH%" dev.mosaify.core.cli.CliKt %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable MOSAIFY_CLI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%MOSAIFY_CLI_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
